# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/type/v3/hash_policy.proto, envoy/type/v3/http.proto, envoy/type/v3/http_status.proto, envoy/type/v3/percent.proto, envoy/type/v3/range.proto, envoy/type/v3/ratelimit_unit.proto, envoy/type/v3/semantic_version.proto, envoy/type/v3/token_bucket.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


class FractionalPercentDenominatorType(betterproto.Enum):
    HUNDRED = 0
    TEN_THOUSAND = 1
    MILLION = 2


class CodecClientType(betterproto.Enum):
    HTTP1 = 0
    HTTP2 = 1
    # [#not-implemented-hide:] QUIC implementation is not production ready yet.
    # Use this enum with caution to prevent accidental execution of QUIC code.
    # I.e. `!= HTTP2` is no longer sufficient to distinguish HTTP1 and HTTP2
    # traffic.
    HTTP3 = 2


class StatusCode(betterproto.Enum):
    """
    HTTP response codes supported in Envoy. For more details:
    https://www.iana.org/assignments/http-status-codes/http-status-codes.xhtml
    """

    # Empty - This code not part of the HTTP status code specification, but it is
    # needed for proto `enum` type.
    Empty = 0
    Continue = 100
    OK = 200
    Created = 201
    Accepted = 202
    NonAuthoritativeInformation = 203
    NoContent = 204
    ResetContent = 205
    PartialContent = 206
    MultiStatus = 207
    AlreadyReported = 208
    IMUsed = 226
    MultipleChoices = 300
    MovedPermanently = 301
    Found = 302
    SeeOther = 303
    NotModified = 304
    UseProxy = 305
    TemporaryRedirect = 307
    PermanentRedirect = 308
    BadRequest = 400
    Unauthorized = 401
    PaymentRequired = 402
    Forbidden = 403
    NotFound = 404
    MethodNotAllowed = 405
    NotAcceptable = 406
    ProxyAuthenticationRequired = 407
    RequestTimeout = 408
    Conflict = 409
    Gone = 410
    LengthRequired = 411
    PreconditionFailed = 412
    PayloadTooLarge = 413
    URITooLong = 414
    UnsupportedMediaType = 415
    RangeNotSatisfiable = 416
    ExpectationFailed = 417
    MisdirectedRequest = 421
    UnprocessableEntity = 422
    Locked = 423
    FailedDependency = 424
    UpgradeRequired = 426
    PreconditionRequired = 428
    TooManyRequests = 429
    RequestHeaderFieldsTooLarge = 431
    InternalServerError = 500
    NotImplemented = 501
    BadGateway = 502
    ServiceUnavailable = 503
    GatewayTimeout = 504
    HTTPVersionNotSupported = 505
    VariantAlsoNegotiates = 506
    InsufficientStorage = 507
    LoopDetected = 508
    NotExtended = 510
    NetworkAuthenticationRequired = 511


class RateLimitUnit(betterproto.Enum):
    """Identifies the unit of of time for rate limit."""

    # The time unit is not known.
    UNKNOWN = 0
    # The time unit representing a second.
    SECOND = 1
    # The time unit representing a minute.
    MINUTE = 2
    # The time unit representing an hour.
    HOUR = 3
    # The time unit representing a day.
    DAY = 4


@dataclass(eq=False, repr=False)
class Int64Range(betterproto.Message):
    """
    Specifies the int64 start and end of the range using half-open interval
    semantics [start, end).
    """

    # start of the range (inclusive)
    start: int = betterproto.int64_field(1)
    # end of the range (exclusive)
    end: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class Int32Range(betterproto.Message):
    """
    Specifies the int32 start and end of the range using half-open interval
    semantics [start, end).
    """

    # start of the range (inclusive)
    start: int = betterproto.int32_field(1)
    # end of the range (exclusive)
    end: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class DoubleRange(betterproto.Message):
    """
    Specifies the double start and end of the range using half-open interval
    semantics [start, end).
    """

    # start of the range (inclusive)
    start: float = betterproto.double_field(1)
    # end of the range (exclusive)
    end: float = betterproto.double_field(2)


@dataclass(eq=False, repr=False)
class HashPolicy(betterproto.Message):
    """Specifies the hash policy"""

    source_ip: "HashPolicySourceIp" = betterproto.message_field(
        1, group="policy_specifier"
    )


@dataclass(eq=False, repr=False)
class HashPolicySourceIp(betterproto.Message):
    """
    The source IP will be used to compute the hash used by hash-based load
    balancing algorithms.
    """

    pass


@dataclass(eq=False, repr=False)
class Percent(betterproto.Message):
    """Identifies a percentage, in the range [0.0, 100.0]."""

    value: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class FractionalPercent(betterproto.Message):
    """
    A fractional percentage is used in cases in which for performance reasons
    performing floating point to integer conversions during randomness
    calculations is undesirable. The message includes both a numerator and
    denominator that together determine the final fractional value. *
    **Example**: 1/100 = 1%. * **Example**: 3/10000 = 0.03%.
    """

    # Specifies the numerator. Defaults to 0.
    numerator: int = betterproto.uint32_field(1)
    # Specifies the denominator. If the denominator specified is less than the
    # numerator, the final fractional percentage is capped at 1 (100%).
    denominator: "FractionalPercentDenominatorType" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class SemanticVersion(betterproto.Message):
    """
    Envoy uses SemVer (https://semver.org/). Major/minor versions indicate
    expected behaviors and APIs, the patch version field is used only for
    security fixes and can be generally ignored.
    """

    major_number: int = betterproto.uint32_field(1)
    minor_number: int = betterproto.uint32_field(2)
    patch: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class HttpStatus(betterproto.Message):
    """HTTP status."""

    # Supplies HTTP response code.
    code: "StatusCode" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class TokenBucket(betterproto.Message):
    """Configures a token bucket, typically used for rate limiting."""

    # The maximum tokens that the bucket can hold. This is also the number of
    # tokens that the bucket initially contains.
    max_tokens: int = betterproto.uint32_field(1)
    # The number of tokens added to the bucket during each fill interval. If not
    # specified, defaults to a single token.
    tokens_per_fill: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    # The fill interval that tokens are added to the bucket. During each fill
    # interval `tokens_per_fill` are added to the bucket. The bucket will never
    # contain more than `max_tokens` tokens.
    fill_interval: timedelta = betterproto.message_field(3)
