# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/tap/v2alpha/common.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


class OutputSinkFormat(betterproto.Enum):
    JSON_BODY_AS_BYTES = 0
    JSON_BODY_AS_STRING = 1
    PROTO_BINARY = 2
    PROTO_BINARY_LENGTH_DELIMITED = 3
    PROTO_TEXT = 4


@dataclass(eq=False, repr=False)
class TapConfig(betterproto.Message):
    """Tap configuration."""

    # The match configuration. If the configuration matches the data source being
    # tapped, a tap will occur, with the result written to the configured output.
    match_config: "MatchPredicate" = betterproto.message_field(1)
    # The tap output configuration. If a match configuration matches a data
    # source being tapped, a tap will occur and the data will be written to the
    # configured output.
    output_config: "OutputConfig" = betterproto.message_field(2)
    # [#not-implemented-hide:] Specify if Tap matching is enabled. The % of
    # requests\connections for which the tap matching is enabled. When not
    # enabled, the request\connection will not be recorded. .. note::   This
    # field defaults to 100/:ref:`HUNDRED
    # <envoy_api_enum_type.FractionalPercent.DenominatorType>`.
    tap_enabled: "___api_v2_core__.RuntimeFractionalPercent" = (
        betterproto.message_field(3)
    )


@dataclass(eq=False, repr=False)
class MatchPredicate(betterproto.Message):
    """
    Tap match configuration. This is a recursive structure which allows complex
    nested match configurations to be built using various logical operators.
    [#next-free-field: 9]
    """

    # A set that describes a logical OR. If any member of the set matches, the
    # match configuration matches.
    or_match: "MatchPredicateMatchSet" = betterproto.message_field(1, group="rule")
    # A set that describes a logical AND. If all members of the set match, the
    # match configuration matches.
    and_match: "MatchPredicateMatchSet" = betterproto.message_field(2, group="rule")
    # A negation match. The match configuration will match if the negated match
    # condition matches.
    not_match: "MatchPredicate" = betterproto.message_field(3, group="rule")
    # The match configuration will always match.
    any_match: bool = betterproto.bool_field(4, group="rule")
    # HTTP request headers match configuration.
    http_request_headers_match: "HttpHeadersMatch" = betterproto.message_field(
        5, group="rule"
    )
    # HTTP request trailers match configuration.
    http_request_trailers_match: "HttpHeadersMatch" = betterproto.message_field(
        6, group="rule"
    )
    # HTTP response headers match configuration.
    http_response_headers_match: "HttpHeadersMatch" = betterproto.message_field(
        7, group="rule"
    )
    # HTTP response trailers match configuration.
    http_response_trailers_match: "HttpHeadersMatch" = betterproto.message_field(
        8, group="rule"
    )


@dataclass(eq=False, repr=False)
class MatchPredicateMatchSet(betterproto.Message):
    """A set of match configurations used for logical operations."""

    # The list of rules that make up the set.
    rules: List["MatchPredicate"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class HttpHeadersMatch(betterproto.Message):
    """HTTP headers match configuration."""

    # HTTP headers to match.
    headers: List["___api_v2_route__.HeaderMatcher"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class OutputConfig(betterproto.Message):
    """Tap output configuration."""

    # Output sinks for tap data. Currently a single sink is allowed in the list.
    # Once multiple sink types are supported this constraint will be relaxed.
    sinks: List["OutputSink"] = betterproto.message_field(1)
    # For buffered tapping, the maximum amount of received body that will be
    # buffered prior to truncation. If truncation occurs, the :ref:`truncated
    # <envoy_api_field_data.tap.v2alpha.Body.truncated>` field will be set. If
    # not specified, the default is 1KiB.
    max_buffered_rx_bytes: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    # For buffered tapping, the maximum amount of transmitted body that will be
    # buffered prior to truncation. If truncation occurs, the :ref:`truncated
    # <envoy_api_field_data.tap.v2alpha.Body.truncated>` field will be set. If
    # not specified, the default is 1KiB.
    max_buffered_tx_bytes: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    # Indicates whether taps produce a single buffered message per tap, or
    # multiple streamed messages per tap in the emitted :ref:`TraceWrapper
    # <envoy_api_msg_data.tap.v2alpha.TraceWrapper>` messages. Note that streamed
    # tapping does not mean that no buffering takes place. Buffering may be
    # required if data is processed before a match can be determined. See the
    # HTTP tap filter :ref:`streaming <config_http_filters_tap_streaming>`
    # documentation for more information.
    streaming: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class OutputSink(betterproto.Message):
    """Tap output sink configuration."""

    # Sink output format.
    format: "OutputSinkFormat" = betterproto.enum_field(1)
    # Tap output will be streamed out the :http:post:`/tap` admin endpoint. ..
    # attention::   It is only allowed to specify the streaming admin output sink
    # if the tap is being   configured from the :http:post:`/tap` admin endpoint.
    # Thus, if an extension has   been configured to receive tap configuration
    # from some other source (e.g., static   file, XDS, etc.) configuring the
    # streaming admin output type will fail.
    streaming_admin: "StreamingAdminSink" = betterproto.message_field(
        2, group="output_sink_type"
    )
    # Tap output will be written to a file per tap sink.
    file_per_tap: "FilePerTapSink" = betterproto.message_field(
        3, group="output_sink_type"
    )
    # [#not-implemented-hide:] GrpcService to stream data to. The format argument
    # must be PROTO_BINARY.
    streaming_grpc: "StreamingGrpcSink" = betterproto.message_field(
        4, group="output_sink_type"
    )


@dataclass(eq=False, repr=False)
class StreamingAdminSink(betterproto.Message):
    """Streaming admin sink configuration."""

    pass


@dataclass(eq=False, repr=False)
class FilePerTapSink(betterproto.Message):
    """
    The file per tap sink outputs a discrete file for every tapped stream.
    """

    # Path prefix. The output file will be of the form <path_prefix>_<id>.pb,
    # where <id> is an identifier distinguishing the recorded trace for stream
    # instances (the Envoy connection ID, HTTP stream ID, etc.).
    path_prefix: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class StreamingGrpcSink(betterproto.Message):
    """
    [#not-implemented-hide:] Streaming gRPC sink configuration sends the taps
    to an external gRPC server.
    """

    # Opaque identifier, that will be sent back to the streaming grpc server.
    tap_id: str = betterproto.string_field(1)
    # The gRPC server that hosts the Tap Sink Service.
    grpc_service: "___api_v2_core__.GrpcService" = betterproto.message_field(2)


from ....api.v2 import core as ___api_v2_core__
from ....api.v2 import route as ___api_v2_route__
