# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/data/dns/v3/dns_table.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


@dataclass(eq=False, repr=False)
class DnsTable(betterproto.Message):
    """
    This message contains the configuration for the DNS Filter if populated
    from the control plane
    """

    # Control how many times Envoy makes an attempt to forward a query to an
    # external DNS server
    external_retry_count: int = betterproto.uint32_field(1)
    # Fully qualified domain names for which Envoy will respond to DNS queries.
    # By leaving this list empty, Envoy will forward all queries to external
    # resolvers
    virtual_domains: List["DnsTableDnsVirtualDomain"] = betterproto.message_field(2)
    # This field serves to help Envoy determine whether it can authoritatively
    # answer a query for a name matching a suffix in this list. If the query name
    # does not match a suffix in this list, Envoy will forward the query to an
    # upstream DNS server
    known_suffixes: List[
        "___type_matcher_v3__.StringMatcher"
    ] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class DnsTableAddressList(betterproto.Message):
    """
    This message contains a list of IP addresses returned for a query for a
    known name
    """

    # This field contains a well formed IP address that is returned in the answer
    # for a name query. The address field can be an IPv4 or IPv6 address. Address
    # family detection is done automatically when Envoy parses the string. Since
    # this field is repeated, Envoy will return as many entries from this list in
    # the DNS response while keeping the response under 512 bytes
    address: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DnsTableDnsServiceProtocol(betterproto.Message):
    """Specify the service protocol using a numeric or string value"""

    # Specify the protocol number for the service. Envoy will try to resolve the
    # number to the protocol name. For example, 6 will resolve to "tcp". Refer
    # to: https://www.iana.org/assignments/protocol-numbers/protocol-
    # numbers.xhtml for protocol names and numbers
    number: int = betterproto.uint32_field(1, group="protocol_config")
    # Specify the protocol name for the service.
    name: str = betterproto.string_field(2, group="protocol_config")


@dataclass(eq=False, repr=False)
class DnsTableDnsServiceTarget(betterproto.Message):
    """Specify the target for a given DNS service [#next-free-field: 6]"""

    # Use a resolvable hostname as the endpoint for a service.
    host_name: str = betterproto.string_field(1, group="endpoint_type")
    # Use a cluster name as the endpoint for a service.
    cluster_name: str = betterproto.string_field(2, group="endpoint_type")
    # The priority of the service record target
    priority: int = betterproto.uint32_field(3)
    # The weight of the service record target
    weight: int = betterproto.uint32_field(4)
    # The port to which the service is bound. This value is optional if the
    # target is a cluster. Setting port to zero in this case makes the filter use
    # the port value from the cluster host
    port: int = betterproto.uint32_field(5)


@dataclass(eq=False, repr=False)
class DnsTableDnsService(betterproto.Message):
    """
    This message defines a service selection record returned for a service
    query in a domain
    """

    # The name of the service without the protocol or domain name
    service_name: str = betterproto.string_field(1)
    # The service protocol. This can be specified as a string or the numeric
    # value of the protocol
    protocol: "DnsTableDnsServiceProtocol" = betterproto.message_field(2)
    # The service entry time to live. This is independent from the DNS Answer
    # record TTL
    ttl: timedelta = betterproto.message_field(3)
    # The list of targets hosting the service
    targets: List["DnsTableDnsServiceTarget"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class DnsTableDnsServiceList(betterproto.Message):
    """Define a list of service records for a given service"""

    services: List["DnsTableDnsService"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DnsTableDnsEndpoint(betterproto.Message):
    # Define a list of addresses to return for the specified endpoint
    address_list: "DnsTableAddressList" = betterproto.message_field(
        1, group="endpoint_config"
    )
    # Define a cluster whose addresses are returned for the specified endpoint
    cluster_name: str = betterproto.string_field(2, group="endpoint_config")
    # Define a DNS Service List for the specified endpoint
    service_list: "DnsTableDnsServiceList" = betterproto.message_field(
        3, group="endpoint_config"
    )


@dataclass(eq=False, repr=False)
class DnsTableDnsVirtualDomain(betterproto.Message):
    # A domain name for which Envoy will respond to query requests
    name: str = betterproto.string_field(1)
    # The configuration containing the method to determine the address of this
    # endpoint
    endpoint: "DnsTableDnsEndpoint" = betterproto.message_field(2)
    # Sets the TTL in DNS answers from Envoy returned to the client. The default
    # TTL is 300s
    answer_ttl: timedelta = betterproto.message_field(3)


from ....type.matcher import v3 as ___type_matcher_v3__
