# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/common/dynamic_forward_proxy/v2alpha/dns_cache.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


@dataclass(eq=False, repr=False)
class DnsCacheConfig(betterproto.Message):
    """
    Configuration for the dynamic forward proxy DNS cache. See the
    :ref:`architecture overview <arch_overview_http_dynamic_forward_proxy>` for
    more information. [#next-free-field: 7]
    """

    # The name of the cache. Multiple named caches allow independent dynamic
    # forward proxy configurations to operate within a single Envoy process using
    # different configurations. All configurations with the same name *must*
    # otherwise have the same settings when referenced from different
    # configuration components. Configuration will fail to load if this is not
    # the case.
    name: str = betterproto.string_field(1)
    # The DNS lookup family to use during resolution.
    # [#comment:TODO(mattklein123): Figure out how to support IPv4/IPv6 "happy
    # eyeballs" mode. The way this might work is a new lookup family which
    # returns both IPv4 and IPv6 addresses, and then configures a host to have a
    # primary and fall back address. With this, we could very likely build a
    # "happy eyeballs" connection pool which would race the primary / fall back
    # address and return the one that wins. This same method could potentially
    # also be used for QUIC to TCP fall back.]
    dns_lookup_family: "____api_v2__.ClusterDnsLookupFamily" = betterproto.enum_field(2)
    # The DNS refresh rate for currently cached DNS hosts. If not specified
    # defaults to 60s. .. note:  The returned DNS TTL is not currently used to
    # alter the refresh rate. This feature will be  added in a future change. ..
    # note: The refresh rate is rounded to the closest millisecond, and must be
    # at least 1ms.
    dns_refresh_rate: timedelta = betterproto.message_field(3)
    # The TTL for hosts that are unused. Hosts that have not been used in the
    # configured time interval will be purged. If not specified defaults to 5m.
    # .. note:   The TTL is only checked at the time of DNS refresh, as specified
    # by *dns_refresh_rate*. This   means that if the configured TTL is shorter
    # than the refresh rate the host may not be removed   immediately.  .. note:
    # The TTL has no relation to DNS TTL and is only used to control Envoy's
    # resource usage.
    host_ttl: timedelta = betterproto.message_field(4)
    # The maximum number of hosts that the cache will hold. If not specified
    # defaults to 1024. .. note:   The implementation is approximate and enforced
    # independently on each worker thread, thus   it is possible for the maximum
    # hosts in the cache to go slightly above the configured   value depending on
    # timing. This is similar to how other circuit breakers work.
    max_hosts: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    # If the DNS failure refresh rate is specified, this is used as the cache's
    # DNS refresh rate when DNS requests are failing. If this setting is not
    # specified, the failure refresh rate defaults to the dns_refresh_rate.
    dns_failure_refresh_rate: "____api_v2__.ClusterRefreshRate" = (
        betterproto.message_field(6)
    )


from .....api import v2 as ____api_v2__
