# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/cluster/v4alpha/circuit_breaker.proto, envoy/config/cluster/v4alpha/cluster.proto, envoy/config/cluster/v4alpha/filter.proto, envoy/config/cluster/v4alpha/outlier_detection.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


class ClusterDiscoveryType(betterproto.Enum):
    STATIC = 0
    STRICT_DNS = 1
    LOGICAL_DNS = 2
    EDS = 3
    ORIGINAL_DST = 4


class ClusterLbPolicy(betterproto.Enum):
    ROUND_ROBIN = 0
    LEAST_REQUEST = 1
    RING_HASH = 2
    RANDOM = 3
    MAGLEV = 5
    CLUSTER_PROVIDED = 6
    LOAD_BALANCING_POLICY_CONFIG = 7


class ClusterDnsLookupFamily(betterproto.Enum):
    AUTO = 0
    V4_ONLY = 1
    V6_ONLY = 2


class ClusterClusterProtocolSelection(betterproto.Enum):
    USE_CONFIGURED_PROTOCOL = 0
    USE_DOWNSTREAM_PROTOCOL = 1


class ClusterLbSubsetConfigLbSubsetFallbackPolicy(betterproto.Enum):
    NO_FALLBACK = 0
    ANY_ENDPOINT = 1
    DEFAULT_SUBSET = 2


class ClusterLbSubsetConfigLbSubsetSelectorLbSubsetSelectorFallbackPolicy(
    betterproto.Enum
):
    NOT_DEFINED = 0
    NO_FALLBACK = 1
    ANY_ENDPOINT = 2
    DEFAULT_SUBSET = 3
    KEYS_SUBSET = 4


class ClusterRingHashLbConfigHashFunction(betterproto.Enum):
    XX_HASH = 0
    MURMUR_HASH_2 = 1


@dataclass(eq=False, repr=False)
class CircuitBreakers(betterproto.Message):
    """
    :ref:`Circuit breaking<arch_overview_circuit_break>` settings can be
    specified individually for each defined priority.
    """

    # If multiple :ref:`Thresholds<envoy_api_msg_config.cluster.v4alpha.CircuitBr
    # eakers.Thresholds>` are defined with the same
    # :ref:`RoutingPriority<envoy_api_enum_config.core.v4alpha.RoutingPriority>`,
    # the first one in the list is used. If no Thresholds is defined for a given
    # :ref:`RoutingPriority<envoy_api_enum_config.core.v4alpha.RoutingPriority>`,
    # the default values are used.
    thresholds: List["CircuitBreakersThresholds"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CircuitBreakersThresholds(betterproto.Message):
    """
    A Thresholds defines CircuitBreaker settings for a
    :ref:`RoutingPriority<envoy_api_enum_config.core.v4alpha.RoutingPriority>`.
    [#next-free-field: 9]
    """

    # The
    # :ref:`RoutingPriority<envoy_api_enum_config.core.v4alpha.RoutingPriority>`
    # the specified CircuitBreaker settings apply to.
    priority: "__core_v4_alpha__.RoutingPriority" = betterproto.enum_field(1)
    # The maximum number of connections that Envoy will make to the upstream
    # cluster. If not specified, the default is 1024.
    max_connections: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    # The maximum number of pending requests that Envoy will allow to the
    # upstream cluster. If not specified, the default is 1024.
    max_pending_requests: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    # The maximum number of parallel requests that Envoy will make to the
    # upstream cluster. If not specified, the default is 1024.
    max_requests: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    # The maximum number of parallel retries that Envoy will allow to the
    # upstream cluster. If not specified, the default is 3.
    max_retries: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    # Specifies a limit on concurrent retries in relation to the number of active
    # requests. This parameter is optional. .. note::    If this field is set,
    # the retry budget will override any configured retry circuit    breaker.
    retry_budget: "CircuitBreakersThresholdsRetryBudget" = betterproto.message_field(8)
    # If track_remaining is true, then stats will be published that expose the
    # number of resources remaining until the circuit breakers open. If not
    # specified, the default is false. .. note::    If a retry budget is used in
    # lieu of the max_retries circuit breaker,    the remaining retry resources
    # remaining will not be tracked.
    track_remaining: bool = betterproto.bool_field(6)
    # The maximum number of connection pools per cluster that Envoy will
    # concurrently support at once. If not specified, the default is unlimited.
    # Set this for clusters which create a large number of connection pools. See
    # :ref:`Circuit Breaking
    # <arch_overview_circuit_break_cluster_maximum_connection_pools>` for more
    # details.
    max_connection_pools: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )


@dataclass(eq=False, repr=False)
class CircuitBreakersThresholdsRetryBudget(betterproto.Message):
    # Specifies the limit on concurrent retries as a percentage of the sum of
    # active requests and active pending requests. For example, if there are 100
    # active requests and the budget_percent is set to 25, there may be 25 active
    # retries. This parameter is optional. Defaults to 20%.
    budget_percent: "___type_v3__.Percent" = betterproto.message_field(1)
    # Specifies the minimum retry concurrency allowed for the retry budget. The
    # limit on the number of active retries may never go below this number. This
    # parameter is optional. Defaults to 3.
    min_retry_concurrency: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )


@dataclass(eq=False, repr=False)
class Filter(betterproto.Message):
    # The name of the filter to instantiate. The name must match a
    # :ref:`supported filter <config_network_filters>`.
    name: str = betterproto.string_field(1)
    # Filter specific configuration which depends on the filter being
    # instantiated. See the supported filters for further documentation.
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class OutlierDetection(betterproto.Message):
    """
    See the :ref:`architecture overview <arch_overview_outlier_detection>` for
    more information on outlier detection. [#next-free-field: 21]
    """

    # The number of consecutive 5xx responses or local origin errors that are
    # mapped to 5xx error codes before a consecutive 5xx ejection occurs.
    # Defaults to 5.
    consecutive_5_xx: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    # The time interval between ejection analysis sweeps. This can result in both
    # new ejections as well as hosts being returned to service. Defaults to
    # 10000ms or 10s.
    interval: timedelta = betterproto.message_field(2)
    # The base time that a host is ejected for. The real time is equal to the
    # base time multiplied by the number of times the host has been ejected.
    # Defaults to 30000ms or 30s.
    base_ejection_time: timedelta = betterproto.message_field(3)
    # The maximum % of an upstream cluster that can be ejected due to outlier
    # detection. Defaults to 10% but will eject at least one host regardless of
    # the value.
    max_ejection_percent: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through consecutive 5xx. This setting can be used to disable
    # ejection or to ramp it up slowly. Defaults to 100.
    enforcing_consecutive_5_xx: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through success rate statistics. This setting can be used to
    # disable ejection or to ramp it up slowly. Defaults to 100.
    enforcing_success_rate: Optional[int] = betterproto.message_field(
        6, wraps=betterproto.TYPE_UINT32
    )
    # The number of hosts in a cluster that must have enough request volume to
    # detect success rate outliers. If the number of hosts is less than this
    # setting, outlier detection via success rate statistics is not performed for
    # any host in the cluster. Defaults to 5.
    success_rate_minimum_hosts: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )
    # The minimum number of total requests that must be collected in one interval
    # (as defined by the interval duration above) to include this host in success
    # rate based outlier detection. If the volume is lower than this setting,
    # outlier detection via success rate statistics is not performed for that
    # host. Defaults to 100.
    success_rate_request_volume: Optional[int] = betterproto.message_field(
        8, wraps=betterproto.TYPE_UINT32
    )
    # This factor is used to determine the ejection threshold for success rate
    # outlier ejection. The ejection threshold is the difference between the mean
    # success rate, and the product of this factor and the standard deviation of
    # the mean success rate: mean - (stdev * success_rate_stdev_factor). This
    # factor is divided by a thousand to get a double. That is, if the desired
    # factor is 1.9, the runtime value should be 1900. Defaults to 1900.
    success_rate_stdev_factor: Optional[int] = betterproto.message_field(
        9, wraps=betterproto.TYPE_UINT32
    )
    # The number of consecutive gateway failures (502, 503, 504 status codes)
    # before a consecutive gateway failure ejection occurs. Defaults to 5.
    consecutive_gateway_failure: Optional[int] = betterproto.message_field(
        10, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through consecutive gateway failures. This setting can be used to
    # disable ejection or to ramp it up slowly. Defaults to 0.
    enforcing_consecutive_gateway_failure: Optional[int] = betterproto.message_field(
        11, wraps=betterproto.TYPE_UINT32
    )
    # Determines whether to distinguish local origin failures from external
    # errors. If set to true the following configuration parameters are taken
    # into account: :ref:`consecutive_local_origin_failure<envoy_api_field_config
    # .cluster.v4alpha.OutlierDetection.consecutive_local_origin_failure>`, :ref:
    # `enforcing_consecutive_local_origin_failure<envoy_api_field_config.cluster.
    # v4alpha.OutlierDetection.enforcing_consecutive_local_origin_failure>` and :
    # ref:`enforcing_local_origin_success_rate<envoy_api_field_config.cluster.v4a
    # lpha.OutlierDetection.enforcing_local_origin_success_rate>`. Defaults to
    # false.
    split_external_local_origin_errors: bool = betterproto.bool_field(12)
    # The number of consecutive locally originated failures before ejection
    # occurs. Defaults to 5. Parameter takes effect only when :ref:`split_externa
    # l_local_origin_errors<envoy_api_field_config.cluster.v4alpha.OutlierDetecti
    # on.split_external_local_origin_errors>` is set to true.
    consecutive_local_origin_failure: Optional[int] = betterproto.message_field(
        13, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through consecutive locally originated failures. This setting can
    # be used to disable ejection or to ramp it up slowly. Defaults to 100.
    # Parameter takes effect only when :ref:`split_external_local_origin_errors<e
    # nvoy_api_field_config.cluster.v4alpha.OutlierDetection.split_external_local
    # _origin_errors>` is set to true.
    enforcing_consecutive_local_origin_failure: Optional[
        int
    ] = betterproto.message_field(14, wraps=betterproto.TYPE_UINT32)
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through success rate statistics for locally originated errors.
    # This setting can be used to disable ejection or to ramp it up slowly.
    # Defaults to 100. Parameter takes effect only when :ref:`split_external_loca
    # l_origin_errors<envoy_api_field_config.cluster.v4alpha.OutlierDetection.spl
    # it_external_local_origin_errors>` is set to true.
    enforcing_local_origin_success_rate: Optional[int] = betterproto.message_field(
        15, wraps=betterproto.TYPE_UINT32
    )
    # The failure percentage to use when determining failure percentage-based
    # outlier detection. If the failure percentage of a given host is greater
    # than or equal to this value, it will be ejected. Defaults to 85.
    failure_percentage_threshold: Optional[int] = betterproto.message_field(
        16, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through failure percentage statistics. This setting can be used to
    # disable ejection or to ramp it up slowly. Defaults to 0. [#next-major-
    # version: setting this without setting failure_percentage_threshold should
    # be invalid in v4.]
    enforcing_failure_percentage: Optional[int] = betterproto.message_field(
        17, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through local-origin failure percentage statistics. This setting
    # can be used to disable ejection or to ramp it up slowly. Defaults to 0.
    enforcing_failure_percentage_local_origin: Optional[
        int
    ] = betterproto.message_field(18, wraps=betterproto.TYPE_UINT32)
    # The minimum number of hosts in a cluster in order to perform failure
    # percentage-based ejection. If the total number of hosts in the cluster is
    # less than this value, failure percentage-based ejection will not be
    # performed. Defaults to 5.
    failure_percentage_minimum_hosts: Optional[int] = betterproto.message_field(
        19, wraps=betterproto.TYPE_UINT32
    )
    # The minimum number of total requests that must be collected in one interval
    # (as defined by the interval duration above) to perform failure percentage-
    # based ejection for this host. If the volume is lower than this setting,
    # failure percentage-based ejection will not be performed for this host.
    # Defaults to 50.
    failure_percentage_request_volume: Optional[int] = betterproto.message_field(
        20, wraps=betterproto.TYPE_UINT32
    )


@dataclass(eq=False, repr=False)
class ClusterCollection(betterproto.Message):
    """
    Cluster list collections. Entries are *Cluster* resources or references.
    [#not-implemented-hide:]
    """

    entries: "____udpa_core_v1__.CollectionEntry" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Cluster(betterproto.Message):
    """Configuration for a single upstream cluster. [#next-free-field: 53]"""

    # Configuration to use different transport sockets for different endpoints.
    # The entry of *envoy.transport_socket_match* in the
    # :ref:`LbEndpoint.Metadata
    # <envoy_api_field_config.endpoint.v3.LbEndpoint.metadata>` is used to match
    # against the transport sockets as they appear in the list. The first
    # :ref:`match
    # <envoy_api_msg_config.cluster.v4alpha.Cluster.TransportSocketMatch>` is
    # used. For example, with the following match .. code-block:: yaml
    # transport_socket_matches:  - name: "enableMTLS"    match:      acceptMTLS:
    # true    transport_socket:      name: envoy.transport_sockets.tls
    # config: { ... } # tls socket configuration  - name: "defaultToPlaintext"
    # match: {}    transport_socket:      name:
    # envoy.transport_sockets.raw_buffer Connections to the endpoints whose
    # metadata value under *envoy.transport_socket_match* having
    # "acceptMTLS"/"true" key/value pair use the "enableMTLS" socket
    # configuration. If a :ref:`socket match
    # <envoy_api_msg_config.cluster.v4alpha.Cluster.TransportSocketMatch>` with
    # empty match criteria is provided, that always match any endpoint. For
    # example, the "defaultToPlaintext" socket match in case above. If an
    # endpoint metadata's value under *envoy.transport_socket_match* does not
    # match any *TransportSocketMatch*, socket configuration fallbacks to use the
    # *tls_context* or *transport_socket* specified in this cluster. This field
    # allows gradual and flexible transport socket configuration changes. The
    # metadata of endpoints in EDS can indicate transport socket capabilities.
    # For example, an endpoint's metadata can have two key value pairs as
    # "acceptMTLS": "true", "acceptPlaintext": "true". While some other
    # endpoints, only accepting plaintext traffic has "acceptPlaintext": "true"
    # metadata information. Then the xDS server can configure the CDS to a
    # client, Envoy A, to send mutual TLS traffic for endpoints with
    # "acceptMTLS": "true", by adding a corresponding *TransportSocketMatch* in
    # this field. Other client Envoys receive CDS without
    # *transport_socket_match* set, and still send plain text traffic to the same
    # cluster. This field can be used to specify custom transport socket
    # configurations for health checks by adding matching key/value pairs in a
    # health check's :ref:`transport socket match criteria <envoy_api_field_confi
    # g.core.v4alpha.HealthCheck.transport_socket_match_criteria>` field.
    # [#comment:TODO(incfly): add a detailed architecture doc on intended usage.]
    transport_socket_matches: List[
        "ClusterTransportSocketMatch"
    ] = betterproto.message_field(43)
    # Supplies the name of the cluster which must be unique across all clusters.
    # The cluster name is used when emitting :ref:`statistics
    # <config_cluster_manager_cluster_stats>` if :ref:`alt_stat_name
    # <envoy_api_field_config.cluster.v4alpha.Cluster.alt_stat_name>` is not
    # provided. Any ``:`` in the cluster name will be converted to ``_`` when
    # emitting statistics.
    name: str = betterproto.string_field(1)
    # An optional alternative to the cluster name to be used while emitting
    # stats. Any ``:`` in the name will be converted to ``_`` when emitting
    # statistics. This should not be confused with :ref:`Router Filter Header
    # <config_http_filters_router_x-envoy-upstream-alt-stat-name>`.
    alt_stat_name: str = betterproto.string_field(28)
    # The :ref:`service discovery type <arch_overview_service_discovery_types>`
    # to use for resolving the cluster.
    type: "ClusterDiscoveryType" = betterproto.enum_field(
        2, group="cluster_discovery_type"
    )
    # The custom cluster type.
    cluster_type: "ClusterCustomClusterType" = betterproto.message_field(
        38, group="cluster_discovery_type"
    )
    # Configuration to use for EDS updates for the Cluster.
    eds_cluster_config: "ClusterEdsClusterConfig" = betterproto.message_field(3)
    # The timeout for new network connections to hosts in the cluster.
    connect_timeout: timedelta = betterproto.message_field(4)
    # Soft limit on size of the cluster’s connections read and write buffers. If
    # unspecified, an implementation defined default is applied (1MiB).
    per_connection_buffer_limit_bytes: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    # The :ref:`load balancer type <arch_overview_load_balancing_types>` to use
    # when picking a host in the cluster. [#comment:TODO: Remove enum constraint
    # :ref:`LOAD_BALANCING_POLICY_CONFIG<envoy_api_enum_value_config.cluster.v4al
    # pha.Cluster.LbPolicy.LOAD_BALANCING_POLICY_CONFIG>` when implemented.]
    lb_policy: "ClusterLbPolicy" = betterproto.enum_field(6)
    # Setting this is required for specifying members of :ref:`STATIC<envoy_api_e
    # num_value_config.cluster.v4alpha.Cluster.DiscoveryType.STATIC>`, :ref:`STRI
    # CT_DNS<envoy_api_enum_value_config.cluster.v4alpha.Cluster.DiscoveryType.ST
    # RICT_DNS>` or :ref:`LOGICAL_DNS<envoy_api_enum_value_config.cluster.v4alpha
    # .Cluster.DiscoveryType.LOGICAL_DNS>` clusters. This field supersedes the
    # *hosts* field in the v2 API. .. attention::   Setting this allows non-EDS
    # cluster types to contain embedded EDS equivalent   :ref:`endpoint
    # assignments<envoy_api_msg_config.endpoint.v3.ClusterLoadAssignment>`.
    load_assignment: "__endpoint_v3__.ClusterLoadAssignment" = (
        betterproto.message_field(33)
    )
    # Optional :ref:`active health checking <arch_overview_health_checking>`
    # configuration for the cluster. If no configuration is specified no health
    # checking will be done and all cluster members will be considered healthy at
    # all times.
    health_checks: List["__core_v4_alpha__.HealthCheck"] = betterproto.message_field(8)
    # Optional maximum requests for a single upstream connection. This parameter
    # is respected by both the HTTP/1.1 and HTTP/2 connection pool
    # implementations. If not specified, there is no limit. Setting this
    # parameter to 1 will effectively disable keep alive.
    max_requests_per_connection: Optional[int] = betterproto.message_field(
        9, wraps=betterproto.TYPE_UINT32
    )
    # Optional :ref:`circuit breaking <arch_overview_circuit_break>` for the
    # cluster.
    circuit_breakers: "CircuitBreakers" = betterproto.message_field(10)
    # HTTP protocol options that are applied only to upstream HTTP connections.
    # These options apply to all HTTP versions.
    upstream_http_protocol_options: "__core_v4_alpha__.UpstreamHttpProtocolOptions" = (
        betterproto.message_field(46)
    )
    # Additional options when handling HTTP requests upstream. These options will
    # be applicable to both HTTP1 and HTTP2 requests.
    common_http_protocol_options: "__core_v4_alpha__.HttpProtocolOptions" = (
        betterproto.message_field(29)
    )
    # Additional options when handling HTTP1 requests.
    http_protocol_options: "__core_v4_alpha__.Http1ProtocolOptions" = (
        betterproto.message_field(13)
    )
    # Even if default HTTP2 protocol options are desired, this field must be set
    # so that Envoy will assume that the upstream supports HTTP/2 when making new
    # HTTP connection pool connections. Currently, Envoy only supports prior
    # knowledge for upstream connections. Even if TLS is used with ALPN,
    # `http2_protocol_options` must be specified. As an aside this allows HTTP/2
    # connections to happen over plain text.
    http2_protocol_options: "__core_v4_alpha__.Http2ProtocolOptions" = (
        betterproto.message_field(14)
    )
    # The extension_protocol_options field is used to provide extension-specific
    # protocol options for upstream connections. The key should match the
    # extension filter name, such as "envoy.filters.network.thrift_proxy". See
    # the extension's documentation for details on specific options.
    typed_extension_protocol_options: Dict[
        str, "betterproto_lib_google_protobuf.Any"
    ] = betterproto.map_field(36, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    # If the DNS refresh rate is specified and the cluster type is either :ref:`S
    # TRICT_DNS<envoy_api_enum_value_config.cluster.v4alpha.Cluster.DiscoveryType
    # .STRICT_DNS>`, or :ref:`LOGICAL_DNS<envoy_api_enum_value_config.cluster.v4a
    # lpha.Cluster.DiscoveryType.LOGICAL_DNS>`, this value is used as the
    # cluster’s DNS refresh rate. The value configured must be at least 1ms. If
    # this setting is not specified, the value defaults to 5000ms. For cluster
    # types other than :ref:`STRICT_DNS<envoy_api_enum_value_config.cluster.v4alp
    # ha.Cluster.DiscoveryType.STRICT_DNS>` and :ref:`LOGICAL_DNS<envoy_api_enum_
    # value_config.cluster.v4alpha.Cluster.DiscoveryType.LOGICAL_DNS>` this
    # setting is ignored.
    dns_refresh_rate: timedelta = betterproto.message_field(16)
    # If the DNS failure refresh rate is specified and the cluster type is either
    # :ref:`STRICT_DNS<envoy_api_enum_value_config.cluster.v4alpha.Cluster.Discov
    # eryType.STRICT_DNS>`, or :ref:`LOGICAL_DNS<envoy_api_enum_value_config.clus
    # ter.v4alpha.Cluster.DiscoveryType.LOGICAL_DNS>`, this is used as the
    # cluster’s DNS refresh rate when requests are failing. If this setting is
    # not specified, the failure refresh rate defaults to the DNS refresh rate.
    # For cluster types other than :ref:`STRICT_DNS<envoy_api_enum_value_config.c
    # luster.v4alpha.Cluster.DiscoveryType.STRICT_DNS>` and :ref:`LOGICAL_DNS<env
    # oy_api_enum_value_config.cluster.v4alpha.Cluster.DiscoveryType.LOGICAL_DNS>
    # ` this setting is ignored.
    dns_failure_refresh_rate: "ClusterRefreshRate" = betterproto.message_field(44)
    # Optional configuration for setting cluster's DNS refresh rate. If the value
    # is set to true, cluster's DNS refresh rate will be set to resource record's
    # TTL which comes from DNS resolution.
    respect_dns_ttl: bool = betterproto.bool_field(39)
    # The DNS IP address resolution policy. If this setting is not specified, the
    # value defaults to :ref:`AUTO<envoy_api_enum_value_config.cluster.v4alpha.Cl
    # uster.DnsLookupFamily.AUTO>`.
    dns_lookup_family: "ClusterDnsLookupFamily" = betterproto.enum_field(17)
    # If DNS resolvers are specified and the cluster type is either :ref:`STRICT_
    # DNS<envoy_api_enum_value_config.cluster.v4alpha.Cluster.DiscoveryType.STRIC
    # T_DNS>`, or :ref:`LOGICAL_DNS<envoy_api_enum_value_config.cluster.v4alpha.C
    # luster.DiscoveryType.LOGICAL_DNS>`, this value is used to specify the
    # cluster’s dns resolvers. If this setting is not specified, the value
    # defaults to the default resolver, which uses /etc/resolv.conf for
    # configuration. For cluster types other than :ref:`STRICT_DNS<envoy_api_enum
    # _value_config.cluster.v4alpha.Cluster.DiscoveryType.STRICT_DNS>` and :ref:`
    # LOGICAL_DNS<envoy_api_enum_value_config.cluster.v4alpha.Cluster.DiscoveryTy
    # pe.LOGICAL_DNS>` this setting is ignored. Setting this value causes failure
    # if the ``envoy.restart_features.use_apple_api_for_dns_lookups`` runtime
    # value is true during server startup. Apple's API only allows overriding DNS
    # resolvers via system settings.
    dns_resolvers: List["__core_v4_alpha__.Address"] = betterproto.message_field(18)
    # [#next-major-version: Reconcile DNS options in a single message.] Always
    # use TCP queries instead of UDP queries for DNS lookups. Setting this value
    # causes failure if the
    # ``envoy.restart_features.use_apple_api_for_dns_lookups`` runtime value is
    # true during server startup. Apple' API only uses UDP for DNS resolution.
    use_tcp_for_dns_lookups: bool = betterproto.bool_field(45)
    # If specified, outlier detection will be enabled for this upstream cluster.
    # Each of the configuration values can be overridden via :ref:`runtime values
    # <config_cluster_manager_cluster_runtime_outlier_detection>`.
    outlier_detection: "OutlierDetection" = betterproto.message_field(19)
    # The interval for removing stale hosts from a cluster type :ref:`ORIGINAL_DS
    # T<envoy_api_enum_value_config.cluster.v4alpha.Cluster.DiscoveryType.ORIGINA
    # L_DST>`. Hosts are considered stale if they have not been used as upstream
    # destinations during this interval. New hosts are added to original
    # destination clusters on demand as new connections are redirected to Envoy,
    # causing the number of hosts in the cluster to grow over time. Hosts that
    # are not stale (they are actively used as destinations) are kept in the
    # cluster, which allows connections to them remain open, saving the latency
    # that would otherwise be spent on opening new connections. If this setting
    # is not specified, the value defaults to 5000ms. For cluster types other
    # than :ref:`ORIGINAL_DST<envoy_api_enum_value_config.cluster.v4alpha.Cluster
    # .DiscoveryType.ORIGINAL_DST>` this setting is ignored.
    cleanup_interval: timedelta = betterproto.message_field(20)
    # Optional configuration used to bind newly established upstream connections.
    # This overrides any bind_config specified in the bootstrap proto. If the
    # address and port are empty, no bind will be performed.
    upstream_bind_config: "__core_v4_alpha__.BindConfig" = betterproto.message_field(21)
    # Configuration for load balancing subsetting.
    lb_subset_config: "ClusterLbSubsetConfig" = betterproto.message_field(22)
    # Optional configuration for the Ring Hash load balancing policy.
    ring_hash_lb_config: "ClusterRingHashLbConfig" = betterproto.message_field(
        23, group="lb_config"
    )
    # Optional configuration for the Maglev load balancing policy.
    maglev_lb_config: "ClusterMaglevLbConfig" = betterproto.message_field(
        52, group="lb_config"
    )
    # Optional configuration for the Original Destination load balancing policy.
    original_dst_lb_config: "ClusterOriginalDstLbConfig" = betterproto.message_field(
        34, group="lb_config"
    )
    # Optional configuration for the LeastRequest load balancing policy.
    least_request_lb_config: "ClusterLeastRequestLbConfig" = betterproto.message_field(
        37, group="lb_config"
    )
    # Common configuration for all load balancer implementations.
    common_lb_config: "ClusterCommonLbConfig" = betterproto.message_field(27)
    # Optional custom transport socket implementation to use for upstream
    # connections. To setup TLS, set a transport socket with name `tls` and
    # :ref:`UpstreamTlsContexts <envoy_api_msg_extensions.transport_sockets.tls.v
    # 4alpha.UpstreamTlsContext>` in the `typed_config`. If no transport socket
    # configuration is specified, new connections will be set up with plaintext.
    transport_socket: "__core_v4_alpha__.TransportSocket" = betterproto.message_field(
        24
    )
    # The Metadata field can be used to provide additional information about the
    # cluster. It can be used for stats, logging, and varying filter behavior.
    # Fields should use reverse DNS notation to denote which entity within Envoy
    # will need the information. For instance, if the metadata is intended for
    # the Router filter, the filter name should be specified as
    # *envoy.filters.http.router*.
    metadata: "__core_v4_alpha__.Metadata" = betterproto.message_field(25)
    # Determines how Envoy selects the protocol used to speak to upstream hosts.
    protocol_selection: "ClusterClusterProtocolSelection" = betterproto.enum_field(26)
    # Optional options for upstream connections.
    upstream_connection_options: "UpstreamConnectionOptions" = (
        betterproto.message_field(30)
    )
    # If an upstream host becomes unhealthy (as determined by the configured
    # health checks or outlier detection), immediately close all connections to
    # the failed host. .. note::   This is currently only supported for
    # connections created by tcp_proxy. .. note::   The current implementation of
    # this feature closes all connections immediately when   the unhealthy status
    # is detected. If there are a large number of connections open   to an
    # upstream host that becomes unhealthy, Envoy may spend a substantial amount
    # of   time exclusively closing these connections, and not processing any
    # other traffic.
    close_connections_on_host_health_failure: bool = betterproto.bool_field(31)
    # If set to true, Envoy will ignore the health value of a host when
    # processing its removal from service discovery. This means that if active
    # health checking is used, Envoy will *not* wait for the endpoint to go
    # unhealthy before removing it.
    ignore_health_on_host_removal: bool = betterproto.bool_field(32)
    # An (optional) network filter chain, listed in the order the filters should
    # be applied. The chain will be applied to all outgoing connections that
    # Envoy makes to the upstream servers of this cluster.
    filters: List["Filter"] = betterproto.message_field(40)
    # [#not-implemented-hide:] New mechanism for LB policy configuration. Used
    # only if the
    # :ref:`lb_policy<envoy_api_field_config.cluster.v4alpha.Cluster.lb_policy>`
    # field has the value :ref:`LOAD_BALANCING_POLICY_CONFIG<envoy_api_enum_value
    # _config.cluster.v4alpha.Cluster.LbPolicy.LOAD_BALANCING_POLICY_CONFIG>`.
    load_balancing_policy: "LoadBalancingPolicy" = betterproto.message_field(41)
    # [#not-implemented-hide:] If present, tells the client where to send load
    # reports via LRS. If not present, the client will fall back to a client-side
    # default, which may be either (a) don't send any load reports or (b) send
    # load reports for all clusters to a single default server (which may be
    # configured in the bootstrap file). Note that if multiple clusters point to
    # the same LRS server, the client may choose to create a separate stream for
    # each cluster or it may choose to coalesce the data for multiple clusters
    # onto a single stream. Either way, the client must make sure to send the
    # data for any given cluster on no more than one stream. [#next-major-
    # version: In the v3 API, we should consider restructuring this somehow,
    # maybe by allowing LRS to go on the ADS stream, or maybe by moving some of
    # the negotiation from the LRS stream here.]
    lrs_server: "__core_v4_alpha__.ConfigSource" = betterproto.message_field(42)
    # Optional customization and configuration of upstream connection pool, and
    # upstream type. Currently this field only applies for HTTP traffic but is
    # designed for eventual use for custom TCP upstreams. For HTTP traffic, Envoy
    # will generally take downstream HTTP and send it upstream as upstream HTTP,
    # using the http connection pool and the codec from `http2_protocol_options`
    # For routes where CONNECT termination is configured, Envoy will take
    # downstream CONNECT requests and forward the CONNECT payload upstream over
    # raw TCP using the tcp connection pool. The default pool used is the generic
    # connection pool which creates the HTTP upstream for most HTTP requests, and
    # the TCP upstream if CONNECT termination is configured. If users desire
    # custom connection pool or upstream behavior, for example terminating
    # CONNECT only if a custom filter indicates it is appropriate, the custom
    # factories can be registered and configured here.
    upstream_config: "__core_v4_alpha__.TypedExtensionConfig" = (
        betterproto.message_field(48)
    )
    # Configuration to track optional cluster stats.
    track_cluster_stats: "TrackClusterStats" = betterproto.message_field(49)
    # [#not-implemented-hide:] Prefetch configuration for this cluster.
    prefetch_policy: "ClusterPrefetchPolicy" = betterproto.message_field(50)
    # If `connection_pool_per_downstream_connection` is true, the cluster will
    # use a separate connection pool for every downstream connection
    connection_pool_per_downstream_connection: bool = betterproto.bool_field(51)


@dataclass(eq=False, repr=False)
class ClusterTransportSocketMatch(betterproto.Message):
    """
    TransportSocketMatch specifies what transport socket config will be used
    when the match conditions are satisfied.
    """

    # The name of the match, used in stats generation.
    name: str = betterproto.string_field(1)
    # Optional endpoint metadata match criteria. The connection to the endpoint
    # with metadata matching what is set in this field will use the transport
    # socket configuration specified here. The endpoint's metadata entry in
    # *envoy.transport_socket_match* is used to match against the values
    # specified in this field.
    match: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)
    # The configuration of the transport socket.
    transport_socket: "__core_v4_alpha__.TransportSocket" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ClusterCustomClusterType(betterproto.Message):
    """Extended cluster type."""

    # The type of the cluster to instantiate. The name must match a supported
    # cluster type.
    name: str = betterproto.string_field(1)
    # Cluster specific configuration which depends on the cluster being
    # instantiated. See the supported cluster for further documentation.
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ClusterEdsClusterConfig(betterproto.Message):
    """Only valid when discovery type is EDS."""

    # Configuration for the source of EDS updates for this Cluster.
    eds_config: "__core_v4_alpha__.ConfigSource" = betterproto.message_field(1)
    # Optional alternative to cluster name to present to EDS. This does not have
    # the same restrictions as cluster name, i.e. it may be arbitrary length.
    service_name: str = betterproto.string_field(2, group="name_specifier")
    # Resource locator for EDS. This is mutually exclusive to *service_name*.
    # [#not-implemented-hide:]
    eds_resource_locator: "____udpa_core_v1__.ResourceLocator" = (
        betterproto.message_field(3, group="name_specifier")
    )


@dataclass(eq=False, repr=False)
class ClusterLbSubsetConfig(betterproto.Message):
    """
    Optionally divide the endpoints in this cluster into subsets defined by
    endpoint metadata and selected by route and weighted cluster metadata.
    [#next-free-field: 8]
    """

    # The behavior used when no endpoint subset matches the selected route's
    # metadata. The value defaults to :ref:`NO_FALLBACK<envoy_api_enum_value_conf
    # ig.cluster.v4alpha.Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBAC
    # K>`.
    fallback_policy: "ClusterLbSubsetConfigLbSubsetFallbackPolicy" = (
        betterproto.enum_field(1)
    )
    # Specifies the default subset of endpoints used during fallback if
    # fallback_policy is :ref:`DEFAULT_SUBSET<envoy_api_enum_value_config.cluster
    # .v4alpha.Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.DEFAULT_SUBSET>`.
    # Each field in default_subset is compared to the matching
    # LbEndpoint.Metadata under the *envoy.lb* namespace. It is valid for no
    # hosts to match, in which case the behavior is the same as a fallback_policy
    # of :ref:`NO_FALLBACK<envoy_api_enum_value_config.cluster.v4alpha.Cluster.Lb
    # SubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
    default_subset: "betterproto_lib_google_protobuf.Struct" = (
        betterproto.message_field(2)
    )
    # For each entry, LbEndpoint.Metadata's *envoy.lb* namespace is traversed and
    # a subset is created for each unique combination of key and value. For
    # example: .. code-block:: json   { "subset_selectors": [       { "keys": [
    # "version" ] },       { "keys": [ "stage", "hardware_type" ] }   ]} A subset
    # is matched when the metadata from the selected route and weighted cluster
    # contains the same keys and values as the subset's metadata. The same host
    # may appear in multiple subsets.
    subset_selectors: List[
        "ClusterLbSubsetConfigLbSubsetSelector"
    ] = betterproto.message_field(3)
    # If true, routing to subsets will take into account the localities and
    # locality weights of the endpoints when making the routing decision. There
    # are some potential pitfalls associated with enabling this feature, as the
    # resulting traffic split after applying both a subset match and locality
    # weights might be undesirable. Consider for example a situation in which you
    # have 50/50 split across two localities X/Y which have 100 hosts each
    # without subsetting. If the subset LB results in X having only 1 host
    # selected but Y having 100, then a lot more load is being dumped on the
    # single host in X than originally anticipated in the load balancing
    # assignment delivered via EDS.
    locality_weight_aware: bool = betterproto.bool_field(4)
    # When used with locality_weight_aware, scales the weight of each locality by
    # the ratio of hosts in the subset vs hosts in the original subset. This aims
    # to even out the load going to an individual locality if said locality is
    # disproportionately affected by the subset predicate.
    scale_locality_weight: bool = betterproto.bool_field(5)
    # If true, when a fallback policy is configured and its corresponding subset
    # fails to find a host this will cause any host to be selected instead. This
    # is useful when using the default subset as the fallback policy, given the
    # default subset might become empty. With this option enabled, if that
    # happens the LB will attempt to select a host from the entire cluster.
    panic_mode_any: bool = betterproto.bool_field(6)
    # If true, metadata specified for a metadata key will be matched against the
    # corresponding endpoint metadata if the endpoint metadata matches the value
    # exactly OR it is a list value and any of the elements in the list matches
    # the criteria.
    list_as_any: bool = betterproto.bool_field(7)


@dataclass(eq=False, repr=False)
class ClusterLbSubsetConfigLbSubsetSelector(betterproto.Message):
    """Specifications for subsets."""

    # List of keys to match with the weighted cluster metadata.
    keys: List[str] = betterproto.string_field(1)
    # Selects a mode of operation in which each subset has only one host. This
    # mode uses the same rules for choosing a host, but updating hosts is faster,
    # especially for large numbers of hosts. If a match is found to a host, that
    # host will be used regardless of priority levels, unless the host is
    # unhealthy. Currently, this mode is only supported if `subset_selectors` has
    # only one entry, and `keys` contains only one entry. When this mode is
    # enabled, configurations that contain more than one host with the same
    # metadata value for the single key in `keys` will use only one of the hosts
    # with the given key; no requests will be routed to the others. The cluster
    # gauge :ref:`lb_subsets_single_host_per_subset_duplicate<config_cluster_mana
    # ger_cluster_stats_subset_lb>` indicates how many duplicates are present in
    # the current configuration.
    single_host_per_subset: bool = betterproto.bool_field(4)
    # The behavior used when no endpoint subset matches the selected route's
    # metadata.
    fallback_policy: "ClusterLbSubsetConfigLbSubsetSelectorLbSubsetSelectorFallbackPolicy" = betterproto.enum_field(
        2
    )
    # Subset of :ref:`keys<envoy_api_field_config.cluster.v4alpha.Cluster.LbSubse
    # tConfig.LbSubsetSelector.keys>` used by :ref:`KEYS_SUBSET<envoy_api_enum_va
    # lue_config.cluster.v4alpha.Cluster.LbSubsetConfig.LbSubsetSelector.LbSubset
    # SelectorFallbackPolicy.KEYS_SUBSET>` fallback policy. It has to be a non
    # empty list if KEYS_SUBSET fallback policy is selected. For any other
    # fallback policy the parameter is not used and should not be set. Only
    # values also present in :ref:`keys<envoy_api_field_config.cluster.v4alpha.Cl
    # uster.LbSubsetConfig.LbSubsetSelector.keys>` are allowed, but
    # `fallback_keys_subset` cannot be equal to `keys`.
    fallback_keys_subset: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ClusterLeastRequestLbConfig(betterproto.Message):
    """Specific configuration for the LeastRequest load balancing policy."""

    # The number of random healthy hosts from which the host with the fewest
    # active requests will be chosen. Defaults to 2 so that we perform two-choice
    # selection if the field is not set.
    choice_count: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    # The following formula is used to calculate the dynamic weights when hosts
    # have different load balancing weights: `weight = load_balancing_weight /
    # (active_requests + 1)^active_request_bias` The larger the active request
    # bias is, the more aggressively active requests will lower the effective
    # weight when all host weights are not equal. `active_request_bias` must be
    # greater than or equal to 0.0. When `active_request_bias == 0.0` the Least
    # Request Load Balancer doesn't consider the number of active requests at the
    # time it picks a host and behaves like the Round Robin Load Balancer. When
    # `active_request_bias > 0.0` the Least Request Load Balancer scales the load
    # balancing weight by the number of active requests at the time it does a
    # pick. The value is cached for performance reasons and refreshed whenever
    # one of the Load Balancer's host sets changes, e.g., whenever there is a
    # host membership update or a host load balancing weight change. .. note::
    # This setting only takes effect if all host weights are not equal.
    active_request_bias: "__core_v4_alpha__.RuntimeDouble" = betterproto.message_field(
        2
    )


@dataclass(eq=False, repr=False)
class ClusterRingHashLbConfig(betterproto.Message):
    """
    Specific configuration for the
    :ref:`RingHash<arch_overview_load_balancing_types_ring_hash>` load
    balancing policy.
    """

    # Minimum hash ring size. The larger the ring is (that is, the more hashes
    # there are for each provided host) the better the request distribution will
    # reflect the desired weights. Defaults to 1024 entries, and limited to 8M
    # entries. See also :ref:`maximum_ring_size<envoy_api_field_config.cluster.v4
    # alpha.Cluster.RingHashLbConfig.maximum_ring_size>`.
    minimum_ring_size: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT64
    )
    # The hash function used to hash hosts onto the ketama ring. The value
    # defaults to :ref:`XX_HASH<envoy_api_enum_value_config.cluster.v4alpha.Clust
    # er.RingHashLbConfig.HashFunction.XX_HASH>`.
    hash_function: "ClusterRingHashLbConfigHashFunction" = betterproto.enum_field(3)
    # Maximum hash ring size. Defaults to 8M entries, and limited to 8M entries,
    # but can be lowered to further constrain resource use. See also :ref:`minimu
    # m_ring_size<envoy_api_field_config.cluster.v4alpha.Cluster.RingHashLbConfig
    # .minimum_ring_size>`.
    maximum_ring_size: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT64
    )


@dataclass(eq=False, repr=False)
class ClusterMaglevLbConfig(betterproto.Message):
    """
    Specific configuration for the
    :ref:`Maglev<arch_overview_load_balancing_types_maglev>` load balancing
    policy.
    """

    # The table size for Maglev hashing. The Maglev aims for ‘minimal disruption’
    # rather than an absolute guarantee. Minimal disruption means that when the
    # set of upstreams changes, a connection will likely be sent to the same
    # upstream as it was before. Increasing the table size reduces the amount of
    # disruption. The table size must be prime number. If it is not specified,
    # the default is 65537.
    table_size: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT64
    )


@dataclass(eq=False, repr=False)
class ClusterOriginalDstLbConfig(betterproto.Message):
    """
    Specific configuration for the :ref:`Original Destination
    <arch_overview_load_balancing_types_original_destination>` load balancing
    policy.
    """

    # When true, :ref:`x-envoy-original-dst-host <config_http_conn_man_headers_x-
    # envoy-original-dst-host>` can be used to override destination address. ..
    # attention::   This header isn't sanitized by default, so enabling this
    # feature allows HTTP clients to   route traffic to arbitrary hosts and/or
    # ports, which may have serious security   consequences.
    use_http_header: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfig(betterproto.Message):
    """
    Common configuration for all load balancer implementations. [#next-free-
    field: 8]
    """

    # Configures the :ref:`healthy panic threshold
    # <arch_overview_load_balancing_panic_threshold>`. If not specified, the
    # default is 50%. To disable panic mode, set to 0%. .. note::   The specified
    # percent will be truncated to the nearest 1%.
    healthy_panic_threshold: "___type_v3__.Percent" = betterproto.message_field(1)
    zone_aware_lb_config: "ClusterCommonLbConfigZoneAwareLbConfig" = (
        betterproto.message_field(2, group="locality_config_specifier")
    )
    locality_weighted_lb_config: "ClusterCommonLbConfigLocalityWeightedLbConfig" = (
        betterproto.message_field(3, group="locality_config_specifier")
    )
    # If set, all health check/weight/metadata updates that happen within this
    # duration will be merged and delivered in one shot when the duration
    # expires. The start of the duration is when the first update happens. This
    # is useful for big clusters, with potentially noisy deploys that might
    # trigger excessive CPU usage due to a constant stream of healthcheck state
    # changes or metadata updates. The first set of updates to be seen apply
    # immediately (e.g.: a new cluster). Please always keep in mind that the use
    # of sandbox technologies may change this behavior. If this is not set, we
    # default to a merge window of 1000ms. To disable it, set the merge window to
    # 0. Note: merging does not apply to cluster membership changes (e.g.:
    # adds/removes); this is because merging those updates isn't currently safe.
    # See https://github.com/envoyproxy/envoy/pull/3941.
    update_merge_window: timedelta = betterproto.message_field(4)
    # If set to true, Envoy will not consider new hosts when computing load
    # balancing weights until they have been health checked for the first time.
    # This will have no effect unless active health checking is also configured.
    # Ignoring a host means that for any load balancing calculations that adjust
    # weights based on the ratio of eligible hosts and total hosts (priority
    # spillover, locality weighting and panic mode) Envoy will exclude these
    # hosts in the denominator. For example, with hosts in two priorities P0 and
    # P1, where P0 looks like {healthy, unhealthy (new), unhealthy (new)} and
    # where P1 looks like {healthy, healthy} all traffic will still hit P0, as 1
    # / (3 - 2) = 1. Enabling this will allow scaling up the number of hosts for
    # a given cluster without entering panic mode or triggering priority
    # spillover, assuming the hosts pass the first health check. If panic mode is
    # triggered, new hosts are still eligible for traffic; they simply do not
    # contribute to the calculation when deciding whether panic mode is enabled
    # or not.
    ignore_new_hosts_until_first_hc: bool = betterproto.bool_field(5)
    # If set to `true`, the cluster manager will drain all existing connections
    # to upstream hosts whenever hosts are added or removed from the cluster.
    close_connections_on_host_set_change: bool = betterproto.bool_field(6)
    # Common Configuration for all consistent hashing load balancers (MaglevLb,
    # RingHashLb, etc.)
    consistent_hashing_lb_config: "ClusterCommonLbConfigConsistentHashingLbConfig" = (
        betterproto.message_field(7)
    )


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigZoneAwareLbConfig(betterproto.Message):
    """
    Configuration for :ref:`zone aware routing
    <arch_overview_load_balancing_zone_aware_routing>`.
    """

    # Configures percentage of requests that will be considered for zone aware
    # routing if zone aware routing is configured. If not specified, the default
    # is 100%. * :ref:`runtime values
    # <config_cluster_manager_cluster_runtime_zone_routing>`. * :ref:`Zone aware
    # routing support <arch_overview_load_balancing_zone_aware_routing>`.
    routing_enabled: "___type_v3__.Percent" = betterproto.message_field(1)
    # Configures minimum upstream cluster size required for zone aware routing If
    # upstream cluster size is less than specified, zone aware routing is not
    # performed even if zone aware routing is configured. If not specified, the
    # default is 6. * :ref:`runtime values
    # <config_cluster_manager_cluster_runtime_zone_routing>`. * :ref:`Zone aware
    # routing support <arch_overview_load_balancing_zone_aware_routing>`.
    min_cluster_size: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT64
    )
    # If set to true, Envoy will not consider any hosts when the cluster is in
    # :ref:`panic mode<arch_overview_load_balancing_panic_threshold>`. Instead,
    # the cluster will fail all requests as if all hosts are unhealthy. This can
    # help avoid potentially overwhelming a failing service.
    fail_traffic_on_panic: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigLocalityWeightedLbConfig(betterproto.Message):
    """
    Configuration for :ref:`locality weighted load balancing
    <arch_overview_load_balancing_locality_weighted_lb>`
    """

    pass


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigConsistentHashingLbConfig(betterproto.Message):
    """
    Common Configuration for all consistent hashing load balancers (MaglevLb,
    RingHashLb, etc.)
    """

    # If set to `true`, the cluster will use hostname instead of the resolved
    # address as the key to consistently hash to an upstream host. Only valid for
    # StrictDNS clusters with hostnames which resolve to a single IP address.
    use_hostname_for_hashing: bool = betterproto.bool_field(1)
    # Configures percentage of average cluster load to bound per upstream host.
    # For example, with a value of 150 no upstream host will get a load more than
    # 1.5 times the average load of all the hosts in the cluster. If not
    # specified, the load is not bounded for any upstream host. Typical value for
    # this parameter is between 120 and 200. Minimum is 100. Applies to both Ring
    # Hash and Maglev load balancers. This is implemented based on the method
    # described in the paper https://arxiv.org/abs/1608.01350. For the specified
    # `hash_balance_factor`, requests to any upstream host are capped at
    # `hash_balance_factor/100` times the average number of requests across the
    # cluster. When a request arrives for an upstream host that is currently
    # serving at its max capacity, linear probing is used to identify an eligible
    # host. Further, the linear probe is implemented using a random jump in hosts
    # ring/table to identify the eligible host (this technique is as described in
    # the paper https://arxiv.org/abs/1908.08762 - the random jump avoids the
    # cascading overflow effect when choosing the next host in the ring/table).
    # If weights are specified on the hosts, they are respected. This is an O(N)
    # algorithm, unlike other load balancers. Using a lower `hash_balance_factor`
    # results in more hosts being probed, so use a higher value if you require
    # better performance.
    hash_balance_factor: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )


@dataclass(eq=False, repr=False)
class ClusterRefreshRate(betterproto.Message):
    # Specifies the base interval between refreshes. This parameter is required
    # and must be greater than zero and less than :ref:`max_interval
    # <envoy_api_field_config.cluster.v4alpha.Cluster.RefreshRate.max_interval>`.
    base_interval: timedelta = betterproto.message_field(1)
    # Specifies the maximum interval between refreshes. This parameter is
    # optional, but must be greater than or equal to the :ref:`base_interval
    # <envoy_api_field_config.cluster.v4alpha.Cluster.RefreshRate.base_interval>`
    # if set. The default is 10 times the :ref:`base_interval <envoy_api_field_co
    # nfig.cluster.v4alpha.Cluster.RefreshRate.base_interval>`.
    max_interval: timedelta = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ClusterPrefetchPolicy(betterproto.Message):
    """[#not-implemented-hide:]"""

    # Indicates how many streams (rounded up) can be anticipated per-upstream for
    # each incoming stream. This is useful for high-QPS or latency-sensitive
    # services. Prefetching will only be done if the upstream is healthy. For
    # example if this is 2, for an incoming HTTP/1.1 stream, 2 connections will
    # be established, one for the new incoming stream, and one for a presumed
    # follow-up stream. For HTTP/2, only one connection would be established by
    # default as one connection can serve both the original and presumed follow-
    # up stream. In steady state for non-multiplexed connections a value of 1.5
    # would mean if there were 100 active streams, there would be 100 connections
    # in use, and 50 connections prefetched. This might be a useful value for
    # something like short lived single-use connections, for example proxying
    # HTTP/1.1 if keep-alive were false and each stream resulted in connection
    # termination. It would likely be overkill for long lived connections, such
    # as TCP proxying SMTP or regular HTTP/1.1 with keep-alive. For long lived
    # traffic, a value of 1.05 would be more reasonable, where for every 100
    # connections, 5 prefetched connections would be in the queue in case of
    # unexpected disconnects where the connection could not be reused. If this
    # value is not set, or set explicitly to one, Envoy will fetch as many
    # connections as needed to serve streams in flight. This means in steady
    # state if a connection is torn down, a subsequent streams will pay an
    # upstream-rtt latency penalty waiting for streams to be prefetched. This is
    # limited somewhat arbitrarily to 3 because prefetching connections too
    # aggressively can harm latency more than the prefetching helps.
    per_upstream_prefetch_ratio: Optional[float] = betterproto.message_field(
        1, wraps=betterproto.TYPE_DOUBLE
    )
    # Indicates how many many streams (rounded up) can be anticipated across a
    # cluster for each stream, useful for low QPS services. This is currently
    # supported for a subset of deterministic non-hash-based load-balancing
    # algorithms (weighted round robin, random). Unlike
    # per_upstream_prefetch_ratio this prefetches across the upstream instances
    # in a cluster, doing best effort predictions of what upstream would be
    # picked next and pre-establishing a connection. For example if prefetching
    # is set to 2 for a round robin HTTP/2 cluster, on the first incoming stream,
    # 2 connections will be prefetched - one to the first upstream for this
    # cluster, one to the second on the assumption there will be a follow-up
    # stream. Prefetching will be limited to one prefetch per configured upstream
    # in the cluster. If this value is not set, or set explicitly to one, Envoy
    # will fetch as many connections as needed to serve streams in flight, so
    # during warm up and in steady state if a connection is closed (and
    # per_upstream_prefetch_ratio is not set), there will be a latency hit for
    # connection establishment. If both this and prefetch_ratio are set, Envoy
    # will make sure both predicted needs are met, basically prefetching
    # max(predictive-prefetch, per-upstream-prefetch), for each upstream.
    # TODO(alyssawilk) per LB docs and LB overview docs when unhiding.
    predictive_prefetch_ratio: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )


@dataclass(eq=False, repr=False)
class LoadBalancingPolicy(betterproto.Message):
    """
    [#not-implemented-hide:] Extensible load balancing policy configuration.
    Every LB policy defined via this mechanism will be identified via a unique
    name using reverse DNS notation. If the policy needs configuration
    parameters, it must define a message for its own configuration, which will
    be stored in the config field. The name of the policy will tell clients
    which type of message they should expect to see in the config field. Note
    that there are cases where it is useful to be able to independently select
    LB policies for choosing a locality and for choosing an endpoint within
    that locality. For example, a given deployment may always use the same
    policy to choose the locality, but for choosing the endpoint within the
    locality, some clusters may use weighted-round-robin, while others may use
    some sort of session-based balancing. This can be accomplished via
    hierarchical LB policies, where the parent LB policy creates a child LB
    policy for each locality. For each request, the parent chooses the locality
    and then delegates to the child policy for that locality to choose the
    endpoint within the locality. To facilitate this, the config message for
    the top-level LB policy may include a field of type LoadBalancingPolicy
    that specifies the child policy.
    """

    # Each client will iterate over the list in order and stop at the first
    # policy that it supports. This provides a mechanism for starting to use new
    # LB policies that are not yet supported by all clients.
    policies: List["LoadBalancingPolicyPolicy"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class LoadBalancingPolicyPolicy(betterproto.Message):
    # Required. The name of the LB policy.
    name: str = betterproto.string_field(1)
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class UpstreamBindConfig(betterproto.Message):
    """
    An extensible structure containing the address Envoy should bind to when
    establishing upstream connections.
    """

    # The address Envoy should bind to when establishing upstream connections.
    source_address: "__core_v4_alpha__.Address" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpstreamConnectionOptions(betterproto.Message):
    # If set then set SO_KEEPALIVE on the socket to enable TCP Keepalives.
    tcp_keepalive: "__core_v4_alpha__.TcpKeepalive" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class TrackClusterStats(betterproto.Message):
    # If timeout_budgets is true, the :ref:`timeout budget histograms
    # <config_cluster_manager_cluster_stats_timeout_budgets>` will be published
    # for each request. These show what percentage of a request's per try and
    # global timeout was used. A value of 0 would indicate that none of the
    # timeout was used or that the timeout was infinite. A value of 100 would
    # indicate that the request took the entirety of the timeout given to it.
    timeout_budgets: bool = betterproto.bool_field(1)
    # If request_response_sizes is true, then the :ref:`histograms
    # <config_cluster_manager_cluster_stats_request_response_sizes>`  tracking
    # header and body sizes of requests and responses will be published.
    request_response_sizes: bool = betterproto.bool_field(2)


from .....udpa.core import v1 as ____udpa_core_v1__
from ....type import v3 as ___type_v3__
from ...core import v4alpha as __core_v4_alpha__
from ...endpoint import v3 as __endpoint_v3__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
