# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/api/v2/cluster/circuit_breaker.proto, envoy/api/v2/cluster/filter.proto, envoy/api/v2/cluster/outlier_detection.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


@dataclass(eq=False, repr=False)
class CircuitBreakers(betterproto.Message):
    """
    :ref:`Circuit breaking<arch_overview_circuit_break>` settings can be
    specified individually for each defined priority.
    """

    # If multiple
    # :ref:`Thresholds<envoy_api_msg_cluster.CircuitBreakers.Thresholds>` are
    # defined with the same
    # :ref:`RoutingPriority<envoy_api_enum_core.RoutingPriority>`, the first one
    # in the list is used. If no Thresholds is defined for a given
    # :ref:`RoutingPriority<envoy_api_enum_core.RoutingPriority>`, the default
    # values are used.
    thresholds: List["CircuitBreakersThresholds"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CircuitBreakersThresholds(betterproto.Message):
    """
    A Thresholds defines CircuitBreaker settings for a
    :ref:`RoutingPriority<envoy_api_enum_core.RoutingPriority>`. [#next-free-
    field: 9]
    """

    # The :ref:`RoutingPriority<envoy_api_enum_core.RoutingPriority>` the
    # specified CircuitBreaker settings apply to.
    priority: "_core__.RoutingPriority" = betterproto.enum_field(1)
    # The maximum number of connections that Envoy will make to the upstream
    # cluster. If not specified, the default is 1024.
    max_connections: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    # The maximum number of pending requests that Envoy will allow to the
    # upstream cluster. If not specified, the default is 1024.
    max_pending_requests: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    # The maximum number of parallel requests that Envoy will make to the
    # upstream cluster. If not specified, the default is 1024.
    max_requests: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    # The maximum number of parallel retries that Envoy will allow to the
    # upstream cluster. If not specified, the default is 3.
    max_retries: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    # Specifies a limit on concurrent retries in relation to the number of active
    # requests. This parameter is optional. .. note::    If this field is set,
    # the retry budget will override any configured retry circuit    breaker.
    retry_budget: "CircuitBreakersThresholdsRetryBudget" = betterproto.message_field(8)
    # If track_remaining is true, then stats will be published that expose the
    # number of resources remaining until the circuit breakers open. If not
    # specified, the default is false. .. note::    If a retry budget is used in
    # lieu of the max_retries circuit breaker,    the remaining retry resources
    # remaining will not be tracked.
    track_remaining: bool = betterproto.bool_field(6)
    # The maximum number of connection pools per cluster that Envoy will
    # concurrently support at once. If not specified, the default is unlimited.
    # Set this for clusters which create a large number of connection pools. See
    # :ref:`Circuit Breaking
    # <arch_overview_circuit_break_cluster_maximum_connection_pools>` for more
    # details.
    max_connection_pools: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )


@dataclass(eq=False, repr=False)
class CircuitBreakersThresholdsRetryBudget(betterproto.Message):
    # Specifies the limit on concurrent retries as a percentage of the sum of
    # active requests and active pending requests. For example, if there are 100
    # active requests and the budget_percent is set to 25, there may be 25 active
    # retries. This parameter is optional. Defaults to 20%.
    budget_percent: "___type__.Percent" = betterproto.message_field(1)
    # Specifies the minimum retry concurrency allowed for the retry budget. The
    # limit on the number of active retries may never go below this number. This
    # parameter is optional. Defaults to 3.
    min_retry_concurrency: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )


@dataclass(eq=False, repr=False)
class Filter(betterproto.Message):
    # The name of the filter to instantiate. The name must match a
    # :ref:`supported filter <config_network_filters>`.
    name: str = betterproto.string_field(1)
    # Filter specific configuration which depends on the filter being
    # instantiated. See the supported filters for further documentation.
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class OutlierDetection(betterproto.Message):
    """
    See the :ref:`architecture overview <arch_overview_outlier_detection>` for
    more information on outlier detection. [#next-free-field: 21]
    """

    # The number of consecutive 5xx responses or local origin errors that are
    # mapped to 5xx error codes before a consecutive 5xx ejection occurs.
    # Defaults to 5.
    consecutive_5_xx: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    # The time interval between ejection analysis sweeps. This can result in both
    # new ejections as well as hosts being returned to service. Defaults to
    # 10000ms or 10s.
    interval: timedelta = betterproto.message_field(2)
    # The base time that a host is ejected for. The real time is equal to the
    # base time multiplied by the number of times the host has been ejected.
    # Defaults to 30000ms or 30s.
    base_ejection_time: timedelta = betterproto.message_field(3)
    # The maximum % of an upstream cluster that can be ejected due to outlier
    # detection. Defaults to 10% but will eject at least one host regardless of
    # the value.
    max_ejection_percent: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through consecutive 5xx. This setting can be used to disable
    # ejection or to ramp it up slowly. Defaults to 100.
    enforcing_consecutive_5_xx: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through success rate statistics. This setting can be used to
    # disable ejection or to ramp it up slowly. Defaults to 100.
    enforcing_success_rate: Optional[int] = betterproto.message_field(
        6, wraps=betterproto.TYPE_UINT32
    )
    # The number of hosts in a cluster that must have enough request volume to
    # detect success rate outliers. If the number of hosts is less than this
    # setting, outlier detection via success rate statistics is not performed for
    # any host in the cluster. Defaults to 5.
    success_rate_minimum_hosts: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )
    # The minimum number of total requests that must be collected in one interval
    # (as defined by the interval duration above) to include this host in success
    # rate based outlier detection. If the volume is lower than this setting,
    # outlier detection via success rate statistics is not performed for that
    # host. Defaults to 100.
    success_rate_request_volume: Optional[int] = betterproto.message_field(
        8, wraps=betterproto.TYPE_UINT32
    )
    # This factor is used to determine the ejection threshold for success rate
    # outlier ejection. The ejection threshold is the difference between the mean
    # success rate, and the product of this factor and the standard deviation of
    # the mean success rate: mean - (stdev * success_rate_stdev_factor). This
    # factor is divided by a thousand to get a double. That is, if the desired
    # factor is 1.9, the runtime value should be 1900. Defaults to 1900.
    success_rate_stdev_factor: Optional[int] = betterproto.message_field(
        9, wraps=betterproto.TYPE_UINT32
    )
    # The number of consecutive gateway failures (502, 503, 504 status codes)
    # before a consecutive gateway failure ejection occurs. Defaults to 5.
    consecutive_gateway_failure: Optional[int] = betterproto.message_field(
        10, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through consecutive gateway failures. This setting can be used to
    # disable ejection or to ramp it up slowly. Defaults to 0.
    enforcing_consecutive_gateway_failure: Optional[int] = betterproto.message_field(
        11, wraps=betterproto.TYPE_UINT32
    )
    # Determines whether to distinguish local origin failures from external
    # errors. If set to true the following configuration parameters are taken
    # into account: :ref:`consecutive_local_origin_failure<envoy_api_field_cluste
    # r.OutlierDetection.consecutive_local_origin_failure>`, :ref:`enforcing_cons
    # ecutive_local_origin_failure<envoy_api_field_cluster.OutlierDetection.enfor
    # cing_consecutive_local_origin_failure>` and :ref:`enforcing_local_origin_su
    # ccess_rate<envoy_api_field_cluster.OutlierDetection.enforcing_local_origin_
    # success_rate>`. Defaults to false.
    split_external_local_origin_errors: bool = betterproto.bool_field(12)
    # The number of consecutive locally originated failures before ejection
    # occurs. Defaults to 5. Parameter takes effect only when :ref:`split_externa
    # l_local_origin_errors<envoy_api_field_cluster.OutlierDetection.split_extern
    # al_local_origin_errors>` is set to true.
    consecutive_local_origin_failure: Optional[int] = betterproto.message_field(
        13, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through consecutive locally originated failures. This setting can
    # be used to disable ejection or to ramp it up slowly. Defaults to 100.
    # Parameter takes effect only when :ref:`split_external_local_origin_errors<e
    # nvoy_api_field_cluster.OutlierDetection.split_external_local_origin_errors>
    # ` is set to true.
    enforcing_consecutive_local_origin_failure: Optional[
        int
    ] = betterproto.message_field(14, wraps=betterproto.TYPE_UINT32)
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through success rate statistics for locally originated errors.
    # This setting can be used to disable ejection or to ramp it up slowly.
    # Defaults to 100. Parameter takes effect only when :ref:`split_external_loca
    # l_origin_errors<envoy_api_field_cluster.OutlierDetection.split_external_loc
    # al_origin_errors>` is set to true.
    enforcing_local_origin_success_rate: Optional[int] = betterproto.message_field(
        15, wraps=betterproto.TYPE_UINT32
    )
    # The failure percentage to use when determining failure percentage-based
    # outlier detection. If the failure percentage of a given host is greater
    # than or equal to this value, it will be ejected. Defaults to 85.
    failure_percentage_threshold: Optional[int] = betterproto.message_field(
        16, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through failure percentage statistics. This setting can be used to
    # disable ejection or to ramp it up slowly. Defaults to 0. [#next-major-
    # version: setting this without setting failure_percentage_threshold should
    # be invalid in v4.]
    enforcing_failure_percentage: Optional[int] = betterproto.message_field(
        17, wraps=betterproto.TYPE_UINT32
    )
    # The % chance that a host will be actually ejected when an outlier status is
    # detected through local-origin failure percentage statistics. This setting
    # can be used to disable ejection or to ramp it up slowly. Defaults to 0.
    enforcing_failure_percentage_local_origin: Optional[
        int
    ] = betterproto.message_field(18, wraps=betterproto.TYPE_UINT32)
    # The minimum number of hosts in a cluster in order to perform failure
    # percentage-based ejection. If the total number of hosts in the cluster is
    # less than this value, failure percentage-based ejection will not be
    # performed. Defaults to 5.
    failure_percentage_minimum_hosts: Optional[int] = betterproto.message_field(
        19, wraps=betterproto.TYPE_UINT32
    )
    # The minimum number of total requests that must be collected in one interval
    # (as defined by the interval duration above) to perform failure percentage-
    # based ejection for this host. If the volume is lower than this setting,
    # failure percentage-based ejection will not be performed for this host.
    # Defaults to 50.
    failure_percentage_request_volume: Optional[int] = betterproto.message_field(
        20, wraps=betterproto.TYPE_UINT32
    )


from .. import core as _core__
from .... import type as ___type__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
