# Monopyly

This is a package designed to help manage personal finances. 
The current functionality is fairly limited, with only the ability to track credit card history.
Eventually the app will provide a full set of features including purchase history, bank deposits and withdrawals, and investment profiles. 

The app is designed to be run at a small scale. 
Information is stored in a local SQLite database and accessed using a frontend served by Flask. 
While the development version is hosted on the builtin Flask server, a more robust solution will be adopted if the app moves online.
Despite its small scale, the app can support multiple users on any given instance.


## Installation

The _Monopyly_ app is registered on the [Python Package Index (PyPI)](https://pypi.org/project/monopyly) for easy installation. 
To install the app, simply run

```
pip install monopyly
```

The package requires a recent version of Python (3.7+). 


## Getting started

Once the package is properly installed, run the app from the command line:

```
monopyly
```

This will open to an empty homepage with a welcome message.

<img src="img/homepage.png" alt="user homepage" width="800px">

To use the app, register a new profile and then log in using your newly created credentials.
A successful login will return you to the homepage, now with several different feature panels.

<img src="img/homepage-user.png" alt="user homepage" width="800px">

Your username should now appear at the top right of the screen, and the 'Log In' button will be replaced with a 'Log Out' button.


## Features


### Credit Card Transactions

_Monopyly_ provides an accounting system for a user's credit card transactions.
To use this feature, begin by navigating to the 'Manage accounts' page.
From there, the app will allow you to add credit cards and associate each with an account.
If an account does not already exist for the card you are trying to add, a card can be added to a new account.
This account will be associated with a specific bank, and will track all of the cards for that account (cards are ID'd by the last four digits of the credit card number).
Additionally, each account must also be initialized with the date when the account issues statements and the date when those statements are due.

After creating a card, you will be redirected to a page displaying the account details, including all cards for that account.

<img src="img/account-details.png" alt="account details" width="800px">

Head on back to the homepage and click the 'Create a new transaction' link. 
You will move to a page where you can enter credit card transaction information.
The interface for adding a transaction provides some convenient automatic features.
For example, if the form registers that you're inputting a transaction for a credit card account with only one active card, then the form will infer the card number to save you some typing.
Likewise, given the date of the transaction and a known credit card, the form will infer the date of the statement to which the transaction belongs.
(Of course, you may manually override this inferred statement date if you desire.)

From the transaction form, transactions can be classified using a heirarchical tagging system.
When a transaction is tagged, the app automatically applies the tag to the transaction along with all parent tags of the selected tag.
These tags can generally be seen and managed from the 'Manage transaction tags' link off the app homepage.

Since each transaction may consist of multiple components—each with it's own subtotal, notes, and tags—transactions can be split into subtransactions.
Click the 'Add subtransaction' button on the transaction form to add a subtransaction.

Once the transaction information has been successfully entered and submitted, the transaction will appear on the full transaction history page.
From here, clicking the '+' icon on the right side of a transaction's row will drop down a more detailed summary of the transaction.

<img src="img/transactions.png" alt="transaction history" width="800px">

Card balances are also visible by visiting the pages for individual statements. A full history of statements for each card is available off the homepage. 
Each statement's page gives the statement's balance, transactions, and due date. 
Payments can be made directly from a statement's page.

<img src="img/statement-details.png" alt="statement details" width="800px">


## License

This project is licensed under the GNU General Public License, Version 3.
It is fully open-source, and while you are more than welcome to fork, add, modify, etc. it is required that you also keep those changes and additions open-source.


## Changes

Changes between versions are tracked in the [changelog](CHANGELOG.md).
