# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from eth.v1alpha1 import attestation_pb2 as eth_dot_v1alpha1_dot_attestation__pb2
from eth.v1alpha1 import beacon_block_pb2 as eth_dot_v1alpha1_dot_beacon__block__pb2
from eth.v1alpha1 import validator_pb2 as eth_dot_v1alpha1_dot_validator__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class BeaconNodeValidatorStub(object):
    """Beacon node validator API

    The beacon node validator API enables a validator to connect
    and perform its obligations on the Ethereum 2.0 phase 0 beacon chain.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetDuties = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/GetDuties',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.DutiesRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.DutiesResponse.FromString,
                )
        self.StreamDuties = channel.unary_stream(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/StreamDuties',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.DutiesRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.DutiesResponse.FromString,
                )
        self.DomainData = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/DomainData',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.DomainRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.DomainResponse.FromString,
                )
        self.WaitForChainStart = channel.unary_stream(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/WaitForChainStart',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ChainStartResponse.FromString,
                )
        self.WaitForActivation = channel.unary_stream(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/WaitForActivation',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorActivationRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorActivationResponse.FromString,
                )
        self.ValidatorIndex = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/ValidatorIndex',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorIndexRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorIndexResponse.FromString,
                )
        self.ValidatorStatus = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/ValidatorStatus',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorStatusRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorStatusResponse.FromString,
                )
        self.MultipleValidatorStatus = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/MultipleValidatorStatus',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.MultipleValidatorStatusRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.MultipleValidatorStatusResponse.FromString,
                )
        self.GetBlock = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/GetBlock',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.BlockRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__block__pb2.BeaconBlock.FromString,
                )
        self.ProposeBlock = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/ProposeBlock',
                request_serializer=eth_dot_v1alpha1_dot_beacon__block__pb2.SignedBeaconBlock.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ProposeResponse.FromString,
                )
        self.GetAttestationData = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/GetAttestationData',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.AttestationDataRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_attestation__pb2.AttestationData.FromString,
                )
        self.ProposeAttestation = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/ProposeAttestation',
                request_serializer=eth_dot_v1alpha1_dot_attestation__pb2.Attestation.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.AttestResponse.FromString,
                )
        self.SubmitAggregateSelectionProof = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/SubmitAggregateSelectionProof',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.AggregateSelectionRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.AggregateSelectionResponse.FromString,
                )
        self.SubmitSignedAggregateSelectionProof = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/SubmitSignedAggregateSelectionProof',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.SignedAggregateSubmitRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.SignedAggregateSubmitResponse.FromString,
                )
        self.ProposeExit = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/ProposeExit',
                request_serializer=eth_dot_v1alpha1_dot_beacon__block__pb2.SignedVoluntaryExit.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ProposeExitResponse.FromString,
                )
        self.SubscribeCommitteeSubnets = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconNodeValidator/SubscribeCommitteeSubnets',
                request_serializer=eth_dot_v1alpha1_dot_validator__pb2.CommitteeSubnetsSubscribeRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )


class BeaconNodeValidatorServicer(object):
    """Beacon node validator API

    The beacon node validator API enables a validator to connect
    and perform its obligations on the Ethereum 2.0 phase 0 beacon chain.
    """

    def GetDuties(self, request, context):
        """Retrieves validator duties for the requested validators.

        The duties consist of:
        Proposer - the validator that creates a beacon chain block.
        Attester — a validator that is part of a committee that needs to sign off on a beacon chain
        block while simultaneously creating a cross link to a recent shard block on a particular shard chain.
        The server returns a list of duties which are the actions should be performed by validators for a given epoch.
        Validator duties should be polled every epoch, but due to chain reorg of >MIN_SEED_LOOKAHEAD could occur,
        the validator duties could chain. For complete safety, it is recommended to poll at every slot to ensure
        validator is fully aware of any sudden chain reorg.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamDuties(self, request, context):
        """Stream validator duties for the requested validators.

        The duties consist of:
        Proposer - the validator that creates a beacon chain block.
        Attester — a validator that is part of a committee that needs to sign off on a beacon chain
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DomainData(self, request, context):
        """DomainData fetches the current BLS signature domain version information from the
        running beacon node's state. This information is used when validators sign
        blocks and attestations appropriately based on their duty.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def WaitForChainStart(self, request, context):
        """WaitForChainStart queries the logs of the Validator Deposit Contract on the Ethereum
        proof-of-work chain to verify the beacon chain has started its runtime and
        validators are ready to begin their responsibilities.

        If the chain has not yet started, this endpoint starts a server-side stream which updates
        the client when the beacon chain is ready.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def WaitForActivation(self, request, context):
        """WaitForActivation checks if a validator public key exists in the active validator
        registry of the current beacon state. If the validator is NOT yet active, it starts a
        server-side stream which updates the client whenever the validator becomes active in
        the beacon node's state.

        The input to this endpoint is a list of validator public keys, and the corresponding
        stream will respond until at least a single corresponding validator to those
        keys is activated.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ValidatorIndex(self, request, context):
        """ValidatorIndex retrieves a validator's index location in the beacon state's
        validator registry looking up whether the validator exists based on its
        public key. This method returns NOT_FOUND if no index is found for the public key
        specified in the request.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ValidatorStatus(self, request, context):
        """ValidatorStatus returns a validator's status based on the current epoch.
        The request can specify either a validator's public key or validator index.

        The status response can be one of the following:
        	DEPOSITED - validator's deposit has been recognized by Ethereum 1, not yet recognized by Ethereum 2.
        	PENDING - validator is in Ethereum 2's activation queue.
        	ACTIVE - validator is active.
        	EXITING - validator has initiated an an exit request, or has dropped below the ejection balance and is being kicked out.
        	EXITED - validator is no longer validating.
        	SLASHING - validator has been kicked out due to meeting a slashing condition.
        	UNKNOWN_STATUS - validator does not have a known status in the network.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MultipleValidatorStatus(self, request, context):
        """MultipleValidatorStatus returns a list of validator statuses on the current epoch.
        The request can specify a list of validator public keys.

        Returns a list of ValidatorStatusResponses.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetBlock(self, request, context):
        """Retrieves the latest valid beacon block to be proposed on the beacon chain.

        The server returns a new beacon block, without proposer signature, that can be
        proposed on the beacon chain. The block should be filled with all the necessary
        data for proposer to sign.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ProposeBlock(self, request, context):
        """Sends the newly signed beacon block to beacon node.

        The validator sends the newly signed beacon block to the beacon node so the beacon block can
        be included in the beacon chain. The beacon node is expected to validate and process the
        beacon block into its state.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetAttestationData(self, request, context):
        """Retrieves the latest valid attestation data to be attested on the beacon chain.

        The server returns the latest valid data which represents the correct vote
        for the head of the beacon chain,
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ProposeAttestation(self, request, context):
        """Sends the newly signed attestation to beacon node.

        The validator sends the newly signed attestation to the beacon node for the attestation to
        be included in the beacon chain. The beacon node is expected to validate and publish attestation on
        appropriate committee subnet.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitAggregateSelectionProof(self, request, context):
        """Submit selection proof to the beacon node to aggregate all matching wire attestations with the same data root.
        the beacon node responses with an aggregate and proof object back to validator to sign over.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitSignedAggregateSelectionProof(self, request, context):
        """Submit a signed aggregate and proof object, the beacon node will broadcast the
        signed aggregated attestation and proof object.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ProposeExit(self, request, context):
        """Propose to leave the list of active validators.

        The beacon node is expected to validate the request and make it available for inclusion in
        the next proposed block.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubscribeCommitteeSubnets(self, request, context):
        """Subscribe to particular committee ID subnets given validator's duty.

        The beacon node is expected to subscribe to the committee ID subnet given by the request. With this,
        beacon node serving attesters can find persistent peers on the subnet to publish attestation,
        and beacon node serving aggregator can join the subnet.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_BeaconNodeValidatorServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetDuties': grpc.unary_unary_rpc_method_handler(
                    servicer.GetDuties,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.DutiesRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.DutiesResponse.SerializeToString,
            ),
            'StreamDuties': grpc.unary_stream_rpc_method_handler(
                    servicer.StreamDuties,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.DutiesRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.DutiesResponse.SerializeToString,
            ),
            'DomainData': grpc.unary_unary_rpc_method_handler(
                    servicer.DomainData,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.DomainRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.DomainResponse.SerializeToString,
            ),
            'WaitForChainStart': grpc.unary_stream_rpc_method_handler(
                    servicer.WaitForChainStart,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.ChainStartResponse.SerializeToString,
            ),
            'WaitForActivation': grpc.unary_stream_rpc_method_handler(
                    servicer.WaitForActivation,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorActivationRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorActivationResponse.SerializeToString,
            ),
            'ValidatorIndex': grpc.unary_unary_rpc_method_handler(
                    servicer.ValidatorIndex,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorIndexRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorIndexResponse.SerializeToString,
            ),
            'ValidatorStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.ValidatorStatus,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorStatusRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorStatusResponse.SerializeToString,
            ),
            'MultipleValidatorStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.MultipleValidatorStatus,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.MultipleValidatorStatusRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.MultipleValidatorStatusResponse.SerializeToString,
            ),
            'GetBlock': grpc.unary_unary_rpc_method_handler(
                    servicer.GetBlock,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.BlockRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__block__pb2.BeaconBlock.SerializeToString,
            ),
            'ProposeBlock': grpc.unary_unary_rpc_method_handler(
                    servicer.ProposeBlock,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__block__pb2.SignedBeaconBlock.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.ProposeResponse.SerializeToString,
            ),
            'GetAttestationData': grpc.unary_unary_rpc_method_handler(
                    servicer.GetAttestationData,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.AttestationDataRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_attestation__pb2.AttestationData.SerializeToString,
            ),
            'ProposeAttestation': grpc.unary_unary_rpc_method_handler(
                    servicer.ProposeAttestation,
                    request_deserializer=eth_dot_v1alpha1_dot_attestation__pb2.Attestation.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.AttestResponse.SerializeToString,
            ),
            'SubmitAggregateSelectionProof': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitAggregateSelectionProof,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.AggregateSelectionRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.AggregateSelectionResponse.SerializeToString,
            ),
            'SubmitSignedAggregateSelectionProof': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitSignedAggregateSelectionProof,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.SignedAggregateSubmitRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.SignedAggregateSubmitResponse.SerializeToString,
            ),
            'ProposeExit': grpc.unary_unary_rpc_method_handler(
                    servicer.ProposeExit,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__block__pb2.SignedVoluntaryExit.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.ProposeExitResponse.SerializeToString,
            ),
            'SubscribeCommitteeSubnets': grpc.unary_unary_rpc_method_handler(
                    servicer.SubscribeCommitteeSubnets,
                    request_deserializer=eth_dot_v1alpha1_dot_validator__pb2.CommitteeSubnetsSubscribeRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'ethereum.eth.v1alpha1.BeaconNodeValidator', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class BeaconNodeValidator(object):
    """Beacon node validator API

    The beacon node validator API enables a validator to connect
    and perform its obligations on the Ethereum 2.0 phase 0 beacon chain.
    """

    @staticmethod
    def GetDuties(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/GetDuties',
            eth_dot_v1alpha1_dot_validator__pb2.DutiesRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.DutiesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def StreamDuties(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/StreamDuties',
            eth_dot_v1alpha1_dot_validator__pb2.DutiesRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.DutiesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DomainData(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/DomainData',
            eth_dot_v1alpha1_dot_validator__pb2.DomainRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.DomainResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def WaitForChainStart(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/WaitForChainStart',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.ChainStartResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def WaitForActivation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/WaitForActivation',
            eth_dot_v1alpha1_dot_validator__pb2.ValidatorActivationRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.ValidatorActivationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ValidatorIndex(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/ValidatorIndex',
            eth_dot_v1alpha1_dot_validator__pb2.ValidatorIndexRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.ValidatorIndexResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ValidatorStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/ValidatorStatus',
            eth_dot_v1alpha1_dot_validator__pb2.ValidatorStatusRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.ValidatorStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def MultipleValidatorStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/MultipleValidatorStatus',
            eth_dot_v1alpha1_dot_validator__pb2.MultipleValidatorStatusRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.MultipleValidatorStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetBlock(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/GetBlock',
            eth_dot_v1alpha1_dot_validator__pb2.BlockRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__block__pb2.BeaconBlock.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ProposeBlock(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/ProposeBlock',
            eth_dot_v1alpha1_dot_beacon__block__pb2.SignedBeaconBlock.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.ProposeResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetAttestationData(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/GetAttestationData',
            eth_dot_v1alpha1_dot_validator__pb2.AttestationDataRequest.SerializeToString,
            eth_dot_v1alpha1_dot_attestation__pb2.AttestationData.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ProposeAttestation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/ProposeAttestation',
            eth_dot_v1alpha1_dot_attestation__pb2.Attestation.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.AttestResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitAggregateSelectionProof(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/SubmitAggregateSelectionProof',
            eth_dot_v1alpha1_dot_validator__pb2.AggregateSelectionRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.AggregateSelectionResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitSignedAggregateSelectionProof(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/SubmitSignedAggregateSelectionProof',
            eth_dot_v1alpha1_dot_validator__pb2.SignedAggregateSubmitRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.SignedAggregateSubmitResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ProposeExit(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/ProposeExit',
            eth_dot_v1alpha1_dot_beacon__block__pb2.SignedVoluntaryExit.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.ProposeExitResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubscribeCommitteeSubnets(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconNodeValidator/SubscribeCommitteeSubnets',
            eth_dot_v1alpha1_dot_validator__pb2.CommitteeSubnetsSubscribeRequest.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
