# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from eth.v1alpha1 import attestation_pb2 as eth_dot_v1alpha1_dot_attestation__pb2
from eth.v1alpha1 import beacon_block_pb2 as eth_dot_v1alpha1_dot_beacon__block__pb2
from eth.v1alpha1 import beacon_chain_pb2 as eth_dot_v1alpha1_dot_beacon__chain__pb2
from eth.v1alpha1 import validator_pb2 as eth_dot_v1alpha1_dot_validator__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class BeaconChainStub(object):
    """Beacon chain API

    The beacon chain API can be used to access data relevant to the Ethereum 2.0
    phase 0 beacon chain.
    TODO(preston): Batch requests?
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.ListAttestations = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/ListAttestations',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListAttestationsRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListAttestationsResponse.FromString,
                )
        self.ListIndexedAttestations = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/ListIndexedAttestations',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListIndexedAttestationsRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListIndexedAttestationsResponse.FromString,
                )
        self.StreamAttestations = channel.unary_stream(
                '/ethereum.eth.v1alpha1.BeaconChain/StreamAttestations',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_attestation__pb2.Attestation.FromString,
                )
        self.StreamIndexedAttestations = channel.unary_stream(
                '/ethereum.eth.v1alpha1.BeaconChain/StreamIndexedAttestations',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__block__pb2.IndexedAttestation.FromString,
                )
        self.AttestationPool = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/AttestationPool',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.AttestationPoolRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.AttestationPoolResponse.FromString,
                )
        self.ListBlocks = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/ListBlocks',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListBlocksRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListBlocksResponse.FromString,
                )
        self.StreamBlocks = channel.unary_stream(
                '/ethereum.eth.v1alpha1.BeaconChain/StreamBlocks',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__block__pb2.SignedBeaconBlock.FromString,
                )
        self.StreamChainHead = channel.unary_stream(
                '/ethereum.eth.v1alpha1.BeaconChain/StreamChainHead',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ChainHead.FromString,
                )
        self.GetChainHead = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetChainHead',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ChainHead.FromString,
                )
        self.GetWeakSubjectivityCheckpoint = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetWeakSubjectivityCheckpoint',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.WeakSubjectivityCheckpoint.FromString,
                )
        self.ListBeaconCommittees = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/ListBeaconCommittees',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListCommitteesRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.BeaconCommittees.FromString,
                )
        self.ListValidatorBalances = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/ListValidatorBalances',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorBalancesRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorBalances.FromString,
                )
        self.ListValidators = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/ListValidators',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorsRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.Validators.FromString,
                )
        self.GetValidator = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetValidator',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.Validator.FromString,
                )
        self.GetValidatorActiveSetChanges = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetValidatorActiveSetChanges',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorActiveSetChangesRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ActiveSetChanges.FromString,
                )
        self.GetValidatorQueue = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetValidatorQueue',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorQueue.FromString,
                )
        self.GetValidatorPerformance = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetValidatorPerformance',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorPerformanceRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorPerformanceResponse.FromString,
                )
        self.ListValidatorAssignments = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/ListValidatorAssignments',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorAssignmentsRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorAssignments.FromString,
                )
        self.GetValidatorParticipation = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetValidatorParticipation',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorParticipationRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorParticipationResponse.FromString,
                )
        self.GetBeaconConfig = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetBeaconConfig',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.BeaconConfig.FromString,
                )
        self.StreamValidatorsInfo = channel.stream_stream(
                '/ethereum.eth.v1alpha1.BeaconChain/StreamValidatorsInfo',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorChangeSet.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorInfo.FromString,
                )
        self.SubmitAttesterSlashing = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/SubmitAttesterSlashing',
                request_serializer=eth_dot_v1alpha1_dot_beacon__block__pb2.AttesterSlashing.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.SubmitSlashingResponse.FromString,
                )
        self.SubmitProposerSlashing = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/SubmitProposerSlashing',
                request_serializer=eth_dot_v1alpha1_dot_beacon__block__pb2.ProposerSlashing.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.SubmitSlashingResponse.FromString,
                )
        self.GetIndividualVotes = channel.unary_unary(
                '/ethereum.eth.v1alpha1.BeaconChain/GetIndividualVotes',
                request_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.IndividualVotesRequest.SerializeToString,
                response_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.IndividualVotesRespond.FromString,
                )


class BeaconChainServicer(object):
    """Beacon chain API

    The beacon chain API can be used to access data relevant to the Ethereum 2.0
    phase 0 beacon chain.
    TODO(preston): Batch requests?
    """

    def ListAttestations(self, request, context):
        """Retrieve attestations by block root, slot, or epoch.

        The server may return an empty list when no attestations match the given
        filter criteria. This RPC should not return NOT_FOUND. Only one filter
        criteria should be used. This endpoint allows for retrieval of genesis
        information via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListIndexedAttestations(self, request, context):
        """Retrieve indexed attestations by block root, slot, or epoch.

        The server may return an empty list when no indexed attestations match the given
        filter criteria. This RPC should not return NOT_FOUND. Only one filter
        criteria should be used. This endpoint allows for retrieval of genesis
        information via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamAttestations(self, request, context):
        """Server-side stream of attestations as they are received by
        the beacon chain node.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamIndexedAttestations(self, request, context):
        """Server-side stream of indexed attestations as they are received by
        the beacon chain node.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def AttestationPool(self, request, context):
        """Retrieve attestations from pool.

        The server returns a list of attestations that have been seen but not
        yet processed. Pool attestations eventually expire as the slot
        advances, so an attestation missing from this request does not imply
        that it was included in a block. The attestation may have expired.
        Refer to the ethereum 2.0 specification for more details on how
        attestations are processed and when they are no longer valid.
        https://github.com/ethereum/eth2.0-specs/blob/dev/specs/core/0_beacon-chain.md#attestations
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListBlocks(self, request, context):
        """Retrieve blocks by root, slot, or epoch.

        The server may return multiple blocks in the case that a slot or epoch is
        provided as the filter criteria. The server may return an empty list when
        no blocks in their database match the filter criteria. This RPC should
        not return NOT_FOUND. Only one filter criteria should be used. This endpoint
        allows for retrieval of genesis information via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamBlocks(self, request, context):
        """Server-side stream of all signed blocks as they are received by
        the beacon chain node.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamChainHead(self, request, context):
        """Server-side stream of information about the head of the beacon chain
        from the view of the beacon chain node.

        This includes the head block slot and root as well as information about
        the most recent finalized and justified slots.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetChainHead(self, request, context):
        """Retrieve information about the head of the beacon chain from the view of
        the beacon chain node.

        This includes the head block slot and root as well as information about
        the most recent finalized and justified slots.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetWeakSubjectivityCheckpoint(self, request, context):
        """Retrieve information about the weak subjectivity of the beacon chain from the view of
        the beacon chain node.

        This includes the weak subjectivity block root, state root and epoch number.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListBeaconCommittees(self, request, context):
        """Retrieve the beacon chain committees for a given epoch.

        If no filter criteria is specified, the response returns
        all beacon committees for the current epoch. The results are paginated by default.
        This endpoint allows for retrieval of genesis information via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListValidatorBalances(self, request, context):
        """Retrieve validator balances for a given set of public keys at a specific
        epoch in time. This endpoint allows for retrieval of genesis information
        via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListValidators(self, request, context):
        """Retrieve the current validator registry.

        The request may include an optional historical epoch to retrieve a
        specific validator set in time. This endpoint allows for retrieval of genesis
        information via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetValidator(self, request, context):
        """Retrieve information about a specific validator in the registry.

        This request may query by validator index or public key.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetValidatorActiveSetChanges(self, request, context):
        """Retrieve the active set changes for a given epoch.

        This data includes any activations, voluntary exits, and involuntary
        ejections. This endpoint allows for retrieval of genesis
        information via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetValidatorQueue(self, request, context):
        """Retrieve the current validator queue information.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetValidatorPerformance(self, request, context):
        """GetValidatorPerformance reports a validator's latest balance along with other important
        metrics on rewards and penalties throughout its lifecycle in the beacon chain.
        The request takes in a list of validator public keys and returns a performance report
        for all of them respectively.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListValidatorAssignments(self, request, context):
        """Retrieve the validator assignments for a given epoch.

        This request may specify optional validator indices or public keys to
        filter validator assignments. This endpoint allows for retrieval of genesis
        information via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetValidatorParticipation(self, request, context):
        """Retrieve the validator participation information for a given epoch.

        This method returns information about the global participation of
        validator attestations. This endpoint allows for retrieval of genesis
        information via a boolean query filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetBeaconConfig(self, request, context):
        """Retrieve the current configuration parameters of the beacon chain.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamValidatorsInfo(self, request_iterator, context):
        """Server-side stream of validator information at each epoch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitAttesterSlashing(self, request, context):
        """Submit an attester slashing object to the beacon node.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitProposerSlashing(self, request, context):
        """Submit a proposer slashing object to the beacon node.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetIndividualVotes(self, request, context):
        """Returns a list of validators individual vote status of a given epoch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_BeaconChainServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'ListAttestations': grpc.unary_unary_rpc_method_handler(
                    servicer.ListAttestations,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListAttestationsRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListAttestationsResponse.SerializeToString,
            ),
            'ListIndexedAttestations': grpc.unary_unary_rpc_method_handler(
                    servicer.ListIndexedAttestations,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListIndexedAttestationsRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListIndexedAttestationsResponse.SerializeToString,
            ),
            'StreamAttestations': grpc.unary_stream_rpc_method_handler(
                    servicer.StreamAttestations,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_attestation__pb2.Attestation.SerializeToString,
            ),
            'StreamIndexedAttestations': grpc.unary_stream_rpc_method_handler(
                    servicer.StreamIndexedAttestations,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__block__pb2.IndexedAttestation.SerializeToString,
            ),
            'AttestationPool': grpc.unary_unary_rpc_method_handler(
                    servicer.AttestationPool,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.AttestationPoolRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.AttestationPoolResponse.SerializeToString,
            ),
            'ListBlocks': grpc.unary_unary_rpc_method_handler(
                    servicer.ListBlocks,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListBlocksRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListBlocksResponse.SerializeToString,
            ),
            'StreamBlocks': grpc.unary_stream_rpc_method_handler(
                    servicer.StreamBlocks,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__block__pb2.SignedBeaconBlock.SerializeToString,
            ),
            'StreamChainHead': grpc.unary_stream_rpc_method_handler(
                    servicer.StreamChainHead,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ChainHead.SerializeToString,
            ),
            'GetChainHead': grpc.unary_unary_rpc_method_handler(
                    servicer.GetChainHead,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ChainHead.SerializeToString,
            ),
            'GetWeakSubjectivityCheckpoint': grpc.unary_unary_rpc_method_handler(
                    servicer.GetWeakSubjectivityCheckpoint,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.WeakSubjectivityCheckpoint.SerializeToString,
            ),
            'ListBeaconCommittees': grpc.unary_unary_rpc_method_handler(
                    servicer.ListBeaconCommittees,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListCommitteesRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.BeaconCommittees.SerializeToString,
            ),
            'ListValidatorBalances': grpc.unary_unary_rpc_method_handler(
                    servicer.ListValidatorBalances,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorBalancesRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorBalances.SerializeToString,
            ),
            'ListValidators': grpc.unary_unary_rpc_method_handler(
                    servicer.ListValidators,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorsRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.Validators.SerializeToString,
            ),
            'GetValidator': grpc.unary_unary_rpc_method_handler(
                    servicer.GetValidator,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.Validator.SerializeToString,
            ),
            'GetValidatorActiveSetChanges': grpc.unary_unary_rpc_method_handler(
                    servicer.GetValidatorActiveSetChanges,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorActiveSetChangesRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ActiveSetChanges.SerializeToString,
            ),
            'GetValidatorQueue': grpc.unary_unary_rpc_method_handler(
                    servicer.GetValidatorQueue,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorQueue.SerializeToString,
            ),
            'GetValidatorPerformance': grpc.unary_unary_rpc_method_handler(
                    servicer.GetValidatorPerformance,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorPerformanceRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorPerformanceResponse.SerializeToString,
            ),
            'ListValidatorAssignments': grpc.unary_unary_rpc_method_handler(
                    servicer.ListValidatorAssignments,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorAssignmentsRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorAssignments.SerializeToString,
            ),
            'GetValidatorParticipation': grpc.unary_unary_rpc_method_handler(
                    servicer.GetValidatorParticipation,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorParticipationRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorParticipationResponse.SerializeToString,
            ),
            'GetBeaconConfig': grpc.unary_unary_rpc_method_handler(
                    servicer.GetBeaconConfig,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.BeaconConfig.SerializeToString,
            ),
            'StreamValidatorsInfo': grpc.stream_stream_rpc_method_handler(
                    servicer.StreamValidatorsInfo,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorChangeSet.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_validator__pb2.ValidatorInfo.SerializeToString,
            ),
            'SubmitAttesterSlashing': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitAttesterSlashing,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__block__pb2.AttesterSlashing.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.SubmitSlashingResponse.SerializeToString,
            ),
            'SubmitProposerSlashing': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitProposerSlashing,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__block__pb2.ProposerSlashing.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.SubmitSlashingResponse.SerializeToString,
            ),
            'GetIndividualVotes': grpc.unary_unary_rpc_method_handler(
                    servicer.GetIndividualVotes,
                    request_deserializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.IndividualVotesRequest.FromString,
                    response_serializer=eth_dot_v1alpha1_dot_beacon__chain__pb2.IndividualVotesRespond.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'ethereum.eth.v1alpha1.BeaconChain', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class BeaconChain(object):
    """Beacon chain API

    The beacon chain API can be used to access data relevant to the Ethereum 2.0
    phase 0 beacon chain.
    TODO(preston): Batch requests?
    """

    @staticmethod
    def ListAttestations(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/ListAttestations',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListAttestationsRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListAttestationsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListIndexedAttestations(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/ListIndexedAttestations',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListIndexedAttestationsRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListIndexedAttestationsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def StreamAttestations(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/ethereum.eth.v1alpha1.BeaconChain/StreamAttestations',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_attestation__pb2.Attestation.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def StreamIndexedAttestations(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/ethereum.eth.v1alpha1.BeaconChain/StreamIndexedAttestations',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__block__pb2.IndexedAttestation.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def AttestationPool(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/AttestationPool',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.AttestationPoolRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.AttestationPoolResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListBlocks(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/ListBlocks',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListBlocksRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListBlocksResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def StreamBlocks(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/ethereum.eth.v1alpha1.BeaconChain/StreamBlocks',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__block__pb2.SignedBeaconBlock.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def StreamChainHead(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/ethereum.eth.v1alpha1.BeaconChain/StreamChainHead',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ChainHead.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetChainHead(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetChainHead',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ChainHead.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetWeakSubjectivityCheckpoint(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetWeakSubjectivityCheckpoint',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.WeakSubjectivityCheckpoint.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListBeaconCommittees(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/ListBeaconCommittees',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListCommitteesRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.BeaconCommittees.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListValidatorBalances(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/ListValidatorBalances',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorBalancesRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorBalances.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListValidators(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/ListValidators',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorsRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.Validators.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetValidator(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetValidator',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorRequest.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.Validator.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetValidatorActiveSetChanges(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetValidatorActiveSetChanges',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorActiveSetChangesRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ActiveSetChanges.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetValidatorQueue(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetValidatorQueue',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorQueue.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetValidatorPerformance(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetValidatorPerformance',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorPerformanceRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorPerformanceResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListValidatorAssignments(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/ListValidatorAssignments',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ListValidatorAssignmentsRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorAssignments.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetValidatorParticipation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetValidatorParticipation',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.GetValidatorParticipationRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorParticipationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetBeaconConfig(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetBeaconConfig',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.BeaconConfig.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def StreamValidatorsInfo(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(request_iterator, target, '/ethereum.eth.v1alpha1.BeaconChain/StreamValidatorsInfo',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.ValidatorChangeSet.SerializeToString,
            eth_dot_v1alpha1_dot_validator__pb2.ValidatorInfo.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitAttesterSlashing(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/SubmitAttesterSlashing',
            eth_dot_v1alpha1_dot_beacon__block__pb2.AttesterSlashing.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.SubmitSlashingResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitProposerSlashing(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/SubmitProposerSlashing',
            eth_dot_v1alpha1_dot_beacon__block__pb2.ProposerSlashing.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.SubmitSlashingResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetIndividualVotes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1alpha1.BeaconChain/GetIndividualVotes',
            eth_dot_v1alpha1_dot_beacon__chain__pb2.IndividualVotesRequest.SerializeToString,
            eth_dot_v1alpha1_dot_beacon__chain__pb2.IndividualVotesRespond.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
