# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from eth.v1 import validator_service_pb2 as eth_dot_v1_dot_validator__service__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class BeaconValidatorStub(object):
    """Beacon chain validator API

    The beacon chain validator API is a set of endpoints to be used by validators for performing their roles.

    This service is defined in the upstream eth2.0-apis repository (eth2.0-APIs/apis/validator).
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetAttesterDuties = channel.unary_unary(
                '/ethereum.eth.v1.BeaconValidator/GetAttesterDuties',
                request_serializer=eth_dot_v1_dot_validator__service__pb2.AttesterDutiesRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_validator__service__pb2.AttesterDutiesResponse.FromString,
                )
        self.GetProposerDuties = channel.unary_unary(
                '/ethereum.eth.v1.BeaconValidator/GetProposerDuties',
                request_serializer=eth_dot_v1_dot_validator__service__pb2.ProposerDutiesRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_validator__service__pb2.ProposerDutiesResponse.FromString,
                )
        self.GetBlock = channel.unary_unary(
                '/ethereum.eth.v1.BeaconValidator/GetBlock',
                request_serializer=eth_dot_v1_dot_validator__service__pb2.ProposerBlockRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_validator__service__pb2.ProposerBlockResponse.FromString,
                )
        self.GetAttestationData = channel.unary_unary(
                '/ethereum.eth.v1.BeaconValidator/GetAttestationData',
                request_serializer=eth_dot_v1_dot_validator__service__pb2.AttestationDataRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_validator__service__pb2.AttestationDataResponse.FromString,
                )
        self.GetAggregateAttestation = channel.unary_unary(
                '/ethereum.eth.v1.BeaconValidator/GetAggregateAttestation',
                request_serializer=eth_dot_v1_dot_validator__service__pb2.AggregateAttestationRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_validator__service__pb2.AttestationResponse.FromString,
                )
        self.SubmitAggregateAndProofs = channel.unary_unary(
                '/ethereum.eth.v1.BeaconValidator/SubmitAggregateAndProofs',
                request_serializer=eth_dot_v1_dot_validator__service__pb2.AggregateAndProofsSubmit.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.SubmitBeaconCommitteeSubscription = channel.unary_unary(
                '/ethereum.eth.v1.BeaconValidator/SubmitBeaconCommitteeSubscription',
                request_serializer=eth_dot_v1_dot_validator__service__pb2.BeaconCommitteeSubscribeSubmit.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )


class BeaconValidatorServicer(object):
    """Beacon chain validator API

    The beacon chain validator API is a set of endpoints to be used by validators for performing their roles.

    This service is defined in the upstream eth2.0-apis repository (eth2.0-APIs/apis/validator).
    """

    def GetAttesterDuties(self, request, context):
        """GetAttesterDuties requests the beacon node to provide a set of attestation duties, which should be performed
        by validators, for a particular epoch. Duties should only need to be checked once per epoch, however
        a chain reorganization (of > MIN_SEED_LOOKAHEAD epochs) could occur, resulting in a change of duties.
        For full safety, you should monitor chain reorganization events.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetProposerDuties(self, request, context):
        """GetProposerDuties requests beacon node to provide all validators that are scheduled to
        propose a block in the given epoch
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetBlock(self, request, context):
        """GetBlock requests the beacon node to produce a valid unsigned beacon block,
        which can then be signed by a proposer and submitted.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetAttestationData(self, request, context):
        """GetAttestationData requests that the beacon node provides the attestation data for
        the requested committee index and slot based on the nodes current head.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetAggregateAttestation(self, request, context):
        """GetAggregateAttestation aggregates all attestations matching the given attestation data root and slot,
        returning the aggregated result.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitAggregateAndProofs(self, request, context):
        """SubmitAggregateAndProofs verifies given aggregate and proofs and publishes them on appropriate gossipsub topic.

        Response usage:
        - 200: Successful response

        - 400: Invalid request syntax.

        - 500: Beacon node internal error.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitBeaconCommitteeSubscription(self, request, context):
        """SubmitBeaconCommitteeSubscription requests the beacon node to search using discv5 for peers related to
        the provided subnet information and replaces current peers with those ones if necessary.

        If validator is_aggregator, beacon node must:
        - announce subnet topic subscription on gossipsub.
        - aggregate attestations received on that subnet.

        Response usage:
        - 200: Slot signature is valid and beacon node has prepared the attestation subnet.
        Note that, we cannot be certain Beacon node will find peers for that subnet for various reasons.

        - 500: Beacon node internal error.

        - 503: Beacon node is currently syncing, try again later.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_BeaconValidatorServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetAttesterDuties': grpc.unary_unary_rpc_method_handler(
                    servicer.GetAttesterDuties,
                    request_deserializer=eth_dot_v1_dot_validator__service__pb2.AttesterDutiesRequest.FromString,
                    response_serializer=eth_dot_v1_dot_validator__service__pb2.AttesterDutiesResponse.SerializeToString,
            ),
            'GetProposerDuties': grpc.unary_unary_rpc_method_handler(
                    servicer.GetProposerDuties,
                    request_deserializer=eth_dot_v1_dot_validator__service__pb2.ProposerDutiesRequest.FromString,
                    response_serializer=eth_dot_v1_dot_validator__service__pb2.ProposerDutiesResponse.SerializeToString,
            ),
            'GetBlock': grpc.unary_unary_rpc_method_handler(
                    servicer.GetBlock,
                    request_deserializer=eth_dot_v1_dot_validator__service__pb2.ProposerBlockRequest.FromString,
                    response_serializer=eth_dot_v1_dot_validator__service__pb2.ProposerBlockResponse.SerializeToString,
            ),
            'GetAttestationData': grpc.unary_unary_rpc_method_handler(
                    servicer.GetAttestationData,
                    request_deserializer=eth_dot_v1_dot_validator__service__pb2.AttestationDataRequest.FromString,
                    response_serializer=eth_dot_v1_dot_validator__service__pb2.AttestationDataResponse.SerializeToString,
            ),
            'GetAggregateAttestation': grpc.unary_unary_rpc_method_handler(
                    servicer.GetAggregateAttestation,
                    request_deserializer=eth_dot_v1_dot_validator__service__pb2.AggregateAttestationRequest.FromString,
                    response_serializer=eth_dot_v1_dot_validator__service__pb2.AttestationResponse.SerializeToString,
            ),
            'SubmitAggregateAndProofs': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitAggregateAndProofs,
                    request_deserializer=eth_dot_v1_dot_validator__service__pb2.AggregateAndProofsSubmit.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'SubmitBeaconCommitteeSubscription': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitBeaconCommitteeSubscription,
                    request_deserializer=eth_dot_v1_dot_validator__service__pb2.BeaconCommitteeSubscribeSubmit.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'ethereum.eth.v1.BeaconValidator', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class BeaconValidator(object):
    """Beacon chain validator API

    The beacon chain validator API is a set of endpoints to be used by validators for performing their roles.

    This service is defined in the upstream eth2.0-apis repository (eth2.0-APIs/apis/validator).
    """

    @staticmethod
    def GetAttesterDuties(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconValidator/GetAttesterDuties',
            eth_dot_v1_dot_validator__service__pb2.AttesterDutiesRequest.SerializeToString,
            eth_dot_v1_dot_validator__service__pb2.AttesterDutiesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetProposerDuties(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconValidator/GetProposerDuties',
            eth_dot_v1_dot_validator__service__pb2.ProposerDutiesRequest.SerializeToString,
            eth_dot_v1_dot_validator__service__pb2.ProposerDutiesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetBlock(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconValidator/GetBlock',
            eth_dot_v1_dot_validator__service__pb2.ProposerBlockRequest.SerializeToString,
            eth_dot_v1_dot_validator__service__pb2.ProposerBlockResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetAttestationData(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconValidator/GetAttestationData',
            eth_dot_v1_dot_validator__service__pb2.AttestationDataRequest.SerializeToString,
            eth_dot_v1_dot_validator__service__pb2.AttestationDataResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetAggregateAttestation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconValidator/GetAggregateAttestation',
            eth_dot_v1_dot_validator__service__pb2.AggregateAttestationRequest.SerializeToString,
            eth_dot_v1_dot_validator__service__pb2.AttestationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitAggregateAndProofs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconValidator/SubmitAggregateAndProofs',
            eth_dot_v1_dot_validator__service__pb2.AggregateAndProofsSubmit.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitBeaconCommitteeSubscription(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconValidator/SubmitBeaconCommitteeSubscription',
            eth_dot_v1_dot_validator__service__pb2.BeaconCommitteeSubscribeSubmit.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
