# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from eth.v1 import node_pb2 as eth_dot_v1_dot_node__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class BeaconNodeStub(object):
    """Beacon chain node API

    The beacon chain node API is a set of endpoints to query node information.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetIdentity = channel.unary_unary(
                '/ethereum.eth.v1.BeaconNode/GetIdentity',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_node__pb2.IdentityResponse.FromString,
                )
        self.GetPeer = channel.unary_unary(
                '/ethereum.eth.v1.BeaconNode/GetPeer',
                request_serializer=eth_dot_v1_dot_node__pb2.PeerRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_node__pb2.PeerResponse.FromString,
                )
        self.ListPeers = channel.unary_unary(
                '/ethereum.eth.v1.BeaconNode/ListPeers',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_node__pb2.PeersResponse.FromString,
                )
        self.GetVersion = channel.unary_unary(
                '/ethereum.eth.v1.BeaconNode/GetVersion',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_node__pb2.VersionResponse.FromString,
                )
        self.GetSyncStatus = channel.unary_unary(
                '/ethereum.eth.v1.BeaconNode/GetSyncStatus',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_node__pb2.SyncingResponse.FromString,
                )
        self.GetHealth = channel.unary_unary(
                '/ethereum.eth.v1.BeaconNode/GetHealth',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )


class BeaconNodeServicer(object):
    """Beacon chain node API

    The beacon chain node API is a set of endpoints to query node information.
    """

    def GetIdentity(self, request, context):
        """GetIdentity retrieves data about the node's network presence.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetPeer(self, request, context):
        """GetPeer retrieves data about the given peer.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListPeers(self, request, context):
        """ListPeers retrieves data about the node's network peers.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetVersion(self, request, context):
        """GetVersion requests that the beacon node identify information about its implementation in a
        format similar to a HTTP User-Agent field.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetSyncStatus(self, request, context):
        """GetSyncStatus requests the beacon node to describe if it's currently syncing or not, and
        if it is, what block it is up to.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetHealth(self, request, context):
        """GetHealth returns node health status in http status codes. Useful for load balancers.
        Response Usage:
        "200":
        description: Node is ready
        "206":
        description: Node is syncing but can serve incomplete data
        "503":
        description: Node not initialized or having issues
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_BeaconNodeServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetIdentity': grpc.unary_unary_rpc_method_handler(
                    servicer.GetIdentity,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_node__pb2.IdentityResponse.SerializeToString,
            ),
            'GetPeer': grpc.unary_unary_rpc_method_handler(
                    servicer.GetPeer,
                    request_deserializer=eth_dot_v1_dot_node__pb2.PeerRequest.FromString,
                    response_serializer=eth_dot_v1_dot_node__pb2.PeerResponse.SerializeToString,
            ),
            'ListPeers': grpc.unary_unary_rpc_method_handler(
                    servicer.ListPeers,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_node__pb2.PeersResponse.SerializeToString,
            ),
            'GetVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.GetVersion,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_node__pb2.VersionResponse.SerializeToString,
            ),
            'GetSyncStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.GetSyncStatus,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_node__pb2.SyncingResponse.SerializeToString,
            ),
            'GetHealth': grpc.unary_unary_rpc_method_handler(
                    servicer.GetHealth,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'ethereum.eth.v1.BeaconNode', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class BeaconNode(object):
    """Beacon chain node API

    The beacon chain node API is a set of endpoints to query node information.
    """

    @staticmethod
    def GetIdentity(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconNode/GetIdentity',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_node__pb2.IdentityResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetPeer(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconNode/GetPeer',
            eth_dot_v1_dot_node__pb2.PeerRequest.SerializeToString,
            eth_dot_v1_dot_node__pb2.PeerResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListPeers(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconNode/ListPeers',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_node__pb2.PeersResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconNode/GetVersion',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_node__pb2.VersionResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetSyncStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconNode/GetSyncStatus',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_node__pb2.SyncingResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetHealth(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconNode/GetHealth',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
