# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from eth.v1 import attestation_pb2 as eth_dot_v1_dot_attestation__pb2
from eth.v1 import beacon_block_pb2 as eth_dot_v1_dot_beacon__block__pb2
from eth.v1 import beacon_chain_service_pb2 as eth_dot_v1_dot_beacon__chain__service__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class BeaconChainStub(object):
    """Beacon Chain API

    The config API endpoints can be used to query the beacon chain state and information. Such as spec, current fork,
    blocks, and the validator spec.

    This service is defined in the upstream eth2.0-apis repository (eth2.0-APIs/apis/).
    Beacon state API related endpoints.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetGenesis = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetGenesis',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.GenesisResponse.FromString,
                )
        self.GetStateRoot = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetStateRoot',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateRootResponse.FromString,
                )
        self.GetStateFork = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetStateFork',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateForkResponse.FromString,
                )
        self.GetFinalityCheckpoints = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetFinalityCheckpoints',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateFinalityCheckpointResponse.FromString,
                )
        self.GetValidator = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetValidator',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorResponse.FromString,
                )
        self.ListValidators = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListValidators',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorsRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorsResponse.FromString,
                )
        self.ListValidatorBalances = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListValidatorBalances',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.ValidatorBalancesRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.ValidatorBalancesResponse.FromString,
                )
        self.ListCommittees = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListCommittees',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateCommitteesRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateCommitteesResponse.FromString,
                )
        self.GetBlockHeader = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetBlockHeader',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeaderResponse.FromString,
                )
        self.ListBlockHeaders = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListBlockHeaders',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeadersRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeadersResponse.FromString,
                )
        self.SubmitBlock = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/SubmitBlock',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BeaconBlockContainer.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.GetBlock = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetBlock',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockResponse.FromString,
                )
        self.GetBlockRoot = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetBlockRoot',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRootResponse.FromString,
                )
        self.ListBlockAttestations = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListBlockAttestations',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockAttestationsResponse.FromString,
                )
        self.ListPoolAttestations = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListPoolAttestations',
                request_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.AttestationsPoolRequest.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.AttestationsPoolResponse.FromString,
                )
        self.SubmitAttestation = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/SubmitAttestation',
                request_serializer=eth_dot_v1_dot_attestation__pb2.Attestation.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.ListPoolAttesterSlashings = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListPoolAttesterSlashings',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.AttesterSlashingsPoolResponse.FromString,
                )
        self.SubmitAttesterSlashing = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/SubmitAttesterSlashing',
                request_serializer=eth_dot_v1_dot_beacon__block__pb2.AttesterSlashing.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.ListPoolProposerSlashings = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListPoolProposerSlashings',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.ProposerSlashingPoolResponse.FromString,
                )
        self.SubmitProposerSlashing = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/SubmitProposerSlashing',
                request_serializer=eth_dot_v1_dot_beacon__block__pb2.ProposerSlashing.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.ListPoolVoluntaryExits = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/ListPoolVoluntaryExits',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.VoluntaryExitsPoolResponse.FromString,
                )
        self.SubmitVoluntaryExit = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/SubmitVoluntaryExit',
                request_serializer=eth_dot_v1_dot_beacon__block__pb2.SignedVoluntaryExit.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.GetForkSchedule = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetForkSchedule',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.ForkScheduleResponse.FromString,
                )
        self.GetSpec = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetSpec',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.SpecResponse.FromString,
                )
        self.GetDepositContract = channel.unary_unary(
                '/ethereum.eth.v1.BeaconChain/GetDepositContract',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.DepositContractResponse.FromString,
                )


class BeaconChainServicer(object):
    """Beacon Chain API

    The config API endpoints can be used to query the beacon chain state and information. Such as spec, current fork,
    blocks, and the validator spec.

    This service is defined in the upstream eth2.0-apis repository (eth2.0-APIs/apis/).
    Beacon state API related endpoints.
    """

    def GetGenesis(self, request, context):
        """GetGenesis retrieves details of the chain's genesis which can be used to identify chain.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetStateRoot(self, request, context):
        """GetStateRoot calculates HashTreeRoot for state with given 'stateId'. If stateId is root, same value will be returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetStateFork(self, request, context):
        """GetStateFork returns Fork object for state with given 'stateId'.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFinalityCheckpoints(self, request, context):
        """GetFinalityCheckpoints returns finality checkpoints for state with given 'stateId'. In case finality is
        not yet achieved, checkpoint should return epoch 0 and ZERO_HASH as root.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetValidator(self, request, context):
        """GetValidator returns a validator specified by state and id or public key along with status and balance.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListValidators(self, request, context):
        """ListValidators returns a filterable list of validators with their balance, status and index.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListValidatorBalances(self, request, context):
        """ListValidators returns a filterable list of validator balances.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListCommittees(self, request, context):
        """ListCommittees retrieves the committees for the given state at the given epoch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetBlockHeader(self, request, context):
        """Beacon blocks API related endpoints.

        GetBlockHeader retrieves block header for given block id.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListBlockHeaders(self, request, context):
        """ListBlockHeaders retrieves block headers matching given query. By default it will fetch current head slot blocks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitBlock(self, request, context):
        """SubmitBlock instructs the beacon node to broadcast a newly signed beacon block to the beacon network, to be
        included in the beacon chain. The beacon node is not required to validate the signed BeaconBlock, and a successful
        response (20X) only indicates that the broadcast has been successful. The beacon node is expected to integrate the
        new block into its state, and therefore validate the block internally, however blocks which fail the validation are
        still broadcast but a different status code is returned (202).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetBlock(self, request, context):
        """GetBlock retrieves block details for given block id.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetBlockRoot(self, request, context):
        """GetBlockRoot retrieves hashTreeRoot of BeaconBlock/BeaconBlockHeader.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListBlockAttestations(self, request, context):
        """ListBlockAttestations retrieves attestation included in requested block.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListPoolAttestations(self, request, context):
        """Beacon pools API related endpoints.

        ListPoolAttestations retrieves attestations known by the node but
        not necessarily incorporated into any block.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitAttestation(self, request, context):
        """SubmitAttestation submits Attestation object to node. If attestation passes all validation
        constraints, node MUST publish attestation on appropriate subnet.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListPoolAttesterSlashings(self, request, context):
        """ListPoolAttesterSlashings retrieves attester slashings known by the node but
        not necessarily incorporated into any block.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitAttesterSlashing(self, request, context):
        """SubmitAttesterSlashing submits AttesterSlashing object to node's pool and
        if passes validation node MUST broadcast it to network.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListPoolProposerSlashings(self, request, context):
        """ListPoolProposerSlashings retrieves proposer slashings known by the node
        but not necessarily incorporated into any block.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitProposerSlashing(self, request, context):
        """SubmitProposerSlashing submits AttesterSlashing object to node's pool and if
        passes validation node MUST broadcast it to network.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListPoolVoluntaryExits(self, request, context):
        """ListPoolVoluntaryExits retrieves voluntary exits known by the node but
        not necessarily incorporated into any block.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubmitVoluntaryExit(self, request, context):
        """SubmitVoluntaryExit submits SignedVoluntaryExit object to node's pool
        and if passes validation node MUST broadcast it to network.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetForkSchedule(self, request, context):
        """Beacon config API related endpoints.

        GetForkSchedule retrieve all scheduled upcoming forks this node is aware of.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetSpec(self, request, context):
        """Spec retrieves specification configuration (without Phase 1 params) used on this node. Specification params list
        Values are returned with following format:
        - any value starting with 0x in the spec is returned as a hex string
        - all other values are returned as number
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetDepositContract(self, request, context):
        """GetDepositContract retrieves deposit contract address and genesis fork version.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_BeaconChainServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetGenesis': grpc.unary_unary_rpc_method_handler(
                    servicer.GetGenesis,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.GenesisResponse.SerializeToString,
            ),
            'GetStateRoot': grpc.unary_unary_rpc_method_handler(
                    servicer.GetStateRoot,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateRootResponse.SerializeToString,
            ),
            'GetStateFork': grpc.unary_unary_rpc_method_handler(
                    servicer.GetStateFork,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateForkResponse.SerializeToString,
            ),
            'GetFinalityCheckpoints': grpc.unary_unary_rpc_method_handler(
                    servicer.GetFinalityCheckpoints,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateFinalityCheckpointResponse.SerializeToString,
            ),
            'GetValidator': grpc.unary_unary_rpc_method_handler(
                    servicer.GetValidator,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorResponse.SerializeToString,
            ),
            'ListValidators': grpc.unary_unary_rpc_method_handler(
                    servicer.ListValidators,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorsRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorsResponse.SerializeToString,
            ),
            'ListValidatorBalances': grpc.unary_unary_rpc_method_handler(
                    servicer.ListValidatorBalances,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.ValidatorBalancesRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.ValidatorBalancesResponse.SerializeToString,
            ),
            'ListCommittees': grpc.unary_unary_rpc_method_handler(
                    servicer.ListCommittees,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateCommitteesRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.StateCommitteesResponse.SerializeToString,
            ),
            'GetBlockHeader': grpc.unary_unary_rpc_method_handler(
                    servicer.GetBlockHeader,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeaderResponse.SerializeToString,
            ),
            'ListBlockHeaders': grpc.unary_unary_rpc_method_handler(
                    servicer.ListBlockHeaders,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeadersRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeadersResponse.SerializeToString,
            ),
            'SubmitBlock': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitBlock,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BeaconBlockContainer.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'GetBlock': grpc.unary_unary_rpc_method_handler(
                    servicer.GetBlock,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockResponse.SerializeToString,
            ),
            'GetBlockRoot': grpc.unary_unary_rpc_method_handler(
                    servicer.GetBlockRoot,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRootResponse.SerializeToString,
            ),
            'ListBlockAttestations': grpc.unary_unary_rpc_method_handler(
                    servicer.ListBlockAttestations,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.BlockAttestationsResponse.SerializeToString,
            ),
            'ListPoolAttestations': grpc.unary_unary_rpc_method_handler(
                    servicer.ListPoolAttestations,
                    request_deserializer=eth_dot_v1_dot_beacon__chain__service__pb2.AttestationsPoolRequest.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.AttestationsPoolResponse.SerializeToString,
            ),
            'SubmitAttestation': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitAttestation,
                    request_deserializer=eth_dot_v1_dot_attestation__pb2.Attestation.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'ListPoolAttesterSlashings': grpc.unary_unary_rpc_method_handler(
                    servicer.ListPoolAttesterSlashings,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.AttesterSlashingsPoolResponse.SerializeToString,
            ),
            'SubmitAttesterSlashing': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitAttesterSlashing,
                    request_deserializer=eth_dot_v1_dot_beacon__block__pb2.AttesterSlashing.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'ListPoolProposerSlashings': grpc.unary_unary_rpc_method_handler(
                    servicer.ListPoolProposerSlashings,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.ProposerSlashingPoolResponse.SerializeToString,
            ),
            'SubmitProposerSlashing': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitProposerSlashing,
                    request_deserializer=eth_dot_v1_dot_beacon__block__pb2.ProposerSlashing.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'ListPoolVoluntaryExits': grpc.unary_unary_rpc_method_handler(
                    servicer.ListPoolVoluntaryExits,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.VoluntaryExitsPoolResponse.SerializeToString,
            ),
            'SubmitVoluntaryExit': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitVoluntaryExit,
                    request_deserializer=eth_dot_v1_dot_beacon__block__pb2.SignedVoluntaryExit.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'GetForkSchedule': grpc.unary_unary_rpc_method_handler(
                    servicer.GetForkSchedule,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.ForkScheduleResponse.SerializeToString,
            ),
            'GetSpec': grpc.unary_unary_rpc_method_handler(
                    servicer.GetSpec,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.SpecResponse.SerializeToString,
            ),
            'GetDepositContract': grpc.unary_unary_rpc_method_handler(
                    servicer.GetDepositContract,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=eth_dot_v1_dot_beacon__chain__service__pb2.DepositContractResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'ethereum.eth.v1.BeaconChain', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class BeaconChain(object):
    """Beacon Chain API

    The config API endpoints can be used to query the beacon chain state and information. Such as spec, current fork,
    blocks, and the validator spec.

    This service is defined in the upstream eth2.0-apis repository (eth2.0-APIs/apis/).
    Beacon state API related endpoints.
    """

    @staticmethod
    def GetGenesis(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetGenesis',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.GenesisResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetStateRoot(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetStateRoot',
            eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.StateRootResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetStateFork(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetStateFork',
            eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.StateForkResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetFinalityCheckpoints(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetFinalityCheckpoints',
            eth_dot_v1_dot_beacon__chain__service__pb2.StateRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.StateFinalityCheckpointResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetValidator(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetValidator',
            eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListValidators(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListValidators',
            eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorsRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.StateValidatorsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListValidatorBalances(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListValidatorBalances',
            eth_dot_v1_dot_beacon__chain__service__pb2.ValidatorBalancesRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.ValidatorBalancesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListCommittees(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListCommittees',
            eth_dot_v1_dot_beacon__chain__service__pb2.StateCommitteesRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.StateCommitteesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetBlockHeader(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetBlockHeader',
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeaderResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListBlockHeaders(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListBlockHeaders',
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeadersRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockHeadersResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitBlock(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/SubmitBlock',
            eth_dot_v1_dot_beacon__chain__service__pb2.BeaconBlockContainer.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetBlock(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetBlock',
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetBlockRoot(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetBlockRoot',
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockRootResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListBlockAttestations(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListBlockAttestations',
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.BlockAttestationsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListPoolAttestations(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListPoolAttestations',
            eth_dot_v1_dot_beacon__chain__service__pb2.AttestationsPoolRequest.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.AttestationsPoolResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitAttestation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/SubmitAttestation',
            eth_dot_v1_dot_attestation__pb2.Attestation.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListPoolAttesterSlashings(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListPoolAttesterSlashings',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.AttesterSlashingsPoolResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitAttesterSlashing(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/SubmitAttesterSlashing',
            eth_dot_v1_dot_beacon__block__pb2.AttesterSlashing.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListPoolProposerSlashings(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListPoolProposerSlashings',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.ProposerSlashingPoolResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitProposerSlashing(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/SubmitProposerSlashing',
            eth_dot_v1_dot_beacon__block__pb2.ProposerSlashing.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListPoolVoluntaryExits(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/ListPoolVoluntaryExits',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.VoluntaryExitsPoolResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubmitVoluntaryExit(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/SubmitVoluntaryExit',
            eth_dot_v1_dot_beacon__block__pb2.SignedVoluntaryExit.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetForkSchedule(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetForkSchedule',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.ForkScheduleResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetSpec(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetSpec',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.SpecResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetDepositContract(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ethereum.eth.v1.BeaconChain/GetDepositContract',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            eth_dot_v1_dot_beacon__chain__service__pb2.DepositContractResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
