from mars_patcher.rom import Game

MF_TILESET_ALT_PAL_ROWS = {
    0x46F134: 0xD,  # 08
    0x4CCCC0: 0xD,  # 09, 40
    0x407E9C: 0xB,  # 0B, 1E
    0x498808: 0xA,  # 0E
    0x46E6F4: 0xD,  # 12
    0x46DCB4: 0xD,  # 13
    0x406B5C: 0xD,  # 19
    0x46E2F4: 0xD,  # 1B
    0x4CC5C0: 0xD,  # 1F
    0x4CC780: 0xD,  # 20
    0x4F21F8: 0xD,  # 21
    0x4F23B8: 0xD,  # 22
    0x4F27B8: 0xC,  # 28
    0x498AC8: 0xB,  # 29
    0x4F2A58: 0xC,  # 2A
    0x5352F0: 0xC,  # 2B, 2F
    0x510868: 0xD,  # 30
    0x510A28: 0xD,  # 31
    0x5355D0: 0xD,  # 34
    0x46E4B4: 0xC,  # 38
    0x46E8B4: 0xD,  # 3D
    0x54D53C: 0xB,  # 3E
    0x40719C: 0xC,  # 43
    0x46E134: 0xC,  # 46
    0x4060DC: 0xD,  # 48
    0x46EF74: 0xD,  # 54
    0x535950: 0xC,  # 56
    0x407CDC: 0xD,  # 57
    0x498648: 0xD,  # 58
    0x535B10: 0xD,  # 5B
    0x4078DC: 0xD,  # 5E
}


# Animated palettes not included here are used for multiple tileset palettes
TILESET_ANIM_PALS = {
    0x40769C: 0x01,  # Navigation room
    0x407A9C: 0x02,  # Save room
    0x406F5C: 0x03,  # Recharge room
    0x405E9C: 0x04,  # Data room
    # 0x05 Docking bay
    0x46EA74: 0x07,  # Operations deck
    # 0x08 Main elevator top/bottom
    0x46BCD4: 0x09,  # Sector 1 elevator
    0x46BF94: 0x0A,  # Sector 2 elevator
    0x46C254: 0x0B,  # Sector 3 elevator
    0x46C514: 0x0C,  # Sector 4 elevator
    0x46C7D4: 0x0D,  # Sector 5 elevator
    0x46CA94: 0x0E,  # Sector 6 elevator
    0x4F27B8: 0x0F,  # Sector 3 glowing BG3
    0x4F2A58: 0x10,  # Meltdown alarm
    0x498AC8: 0x11,  # Stabilizer rooms
    0x54D0DC: 0x12,  # Sector 6 glowing BG3
    0x406D1C: 0x13,  # Security room
    # 0x14 Electrified water
    0x46DE74: 0x15,  # Near quarantine bay
    0x4F2578: 0x16,  # Boiler control room
    0x4F1D38: 0x17,  # Main boiler
    0x46ECB4: 0x18,  # Operations deck (SA-X fight)
    0x4F1F98: 0x19,  # Main boiler
    0x46E4B4: 0x1A,  # Auxiliary power
    0x46B814: 0x1B,  # Reactor silo
    # 0x1C Restricted lab alarm
    0x46AF14: 0x1D,  # Operations room
    0x40719C: 0x1E,  # Sector 2 flashing panels 1
    0x40741C: 0x1F,  # Sector 2 flashing panels 2
    0x46D554: 0x20,  # Restricted lab
}


EXCLUDED_ENEMIES = {
    Game.MF: {
        0x11,  # SA-X (elevator)
        0x1D,  # Area banner
        0x21,  # Message box
        0x8C,  # SA-X (TRO 1)
        0x8D,  # SA-X (NOC)
        0xA0,  # SA-X (ARC)
        0xBC,  # SA-X (lab)
        0xC0,  # SA-X (boss)
        0xC1,  # SA-X monster
        0xC9,  # SA-X (Omega cutscene)
        0xCD,  # SA-X (TRO 2)
    },
    Game.ZM: {
        0x10,  # Unused
        0x11,  # Item banner
        0x8A,  # Crocomire
    },
}

ENEMY_GROUPS = {
    Game.MF: {
        "Zebesian": [0x14, 0x73, 0xA2, 0xB3, 0xB4],
        "Zeela": [0x31, 0xA3],
        "Sciser": [0x3C, 0x8B],
        "BeamCoreX": [0x56, 0x57, 0x58, 0x59],
        "Zoro": [0x5A, 0x63, 0x89, 0x8A],
        "FakeTank": [0xAD, 0xAE],
    },
    Game.ZM: {
        "Ripper": [0x16, 0x17, 0x71],
        "Zeb": [0x18, 0x19],
        "Skree": [0x1F, 0x20],
        "ChozoStatue": [
            0x22,
            0x23,
            0x24,
            0x25,
            0x26,
            0x27,
            0x28,
            0x29,
            0x2A,
            0x2B,
            0x2C,
            0x2D,
            0x2E,
            0x2F,
            0x30,
            0x31,
            0x58,
            0x59,
            0x94,
        ],
        "Viola": [0x34, 0x68, 0x69],
        "GerutaTangleVine": [0x36, 0x37, 0xB7, 0xB8, 0xB9, 0xBA],
        "Reo": [0x3F, 0x40],
        "Imago": [0x4D, 0x4F, 0x70, 0x7F, 0x86, 0x8B],
        "SpacePirate": [0x51, 0x52, 0x53, 0x54, 0x55, 0xB6, 0xC6, 0xC7],
        "Gamet": [0x56, 0x57, 0x9D, 0x9E],
        "Zebbo": [0x5B, 0x5C, 0xA1, 0xA2],
        "Rinka": [0x66, 0x7C, 0xA5, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD],
        "Geega": [0x7A, 0x7B, 0x9F, 0xA0],
        "ElevatorStatue": [0x95, 0x96],
        "UnknownItemBlocks": [0xAA, 0xAB, 0xAC],
    },
}

NETTORI_EXTRA_PALS = [
    (0x36A480, 1),  # Medium health palette
    (0x36A4A0, 1),  # Low health palette
    (0x36A4C0, 3),  # Animated palette
]
