# -*- coding: utf-8 -*-
"""
Seigr Toolset Crypto (STC) - Setup Configuration
Post-classical cryptographic engine with entropy-regenerative architecture
"""

from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="seigr-toolset-crypto",
    version="0.2.1",
    author="Sergi Saldaña-Massó - Seigr Lab",
    author_email="sergism@gmail.com",
    description="Post-classical cryptographic engine with entropy amplification and multi-path hashing",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Seigr-lab/SeigrToolsetCrypto",
    project_urls={
        "Homepage": "https://github.com/Seigr-lab/SeigrToolsetCrypto",
        "Documentation": "https://github.com/Seigr-lab/SeigrToolsetCrypto#readme",
        "Source": "https://github.com/Seigr-lab/SeigrToolsetCrypto",
        "Sponsor": "https://github.com/sponsors/Seigr-lab",
        "Changelog": "https://github.com/Seigr-lab/SeigrToolsetCrypto/blob/main/CHANGELOG.md",
    },
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Security :: Cryptography",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "License :: Other/Proprietary License",
        "Operating System :: OS Independent",
        "Environment :: Console",
    ],
    keywords="cryptography, seigr, entropy, regenerative, post-classical, toolset",
    python_requires=">=3.9",
    install_requires=[
        "numpy>=1.24.0",
    ],
    entry_points={
        "console_scripts": [
            "stc=seigrtc.interfaces.cli.stc_cli:main",
        ],
    },
    include_package_data=True,
)
