"""
seigrtc

Compatibility wrapper package that exposes the STC library under a
compact top-level namespace (`seigrtc`) to avoid import collisions in
host projects that use generic package names.

This module imports the existing top-level packages (`interfaces`,
`core`, `utils`) and re-exports them under the `seigrtc` namespace.

Usage:
    from seigrtc.interfaces.api import stc_api

The wrapper is intentionally thin and does not duplicate implementation
code; it only re-exports the underlying modules for a safer top-level
import name.
"""

from typing import Any

try:
    import interfaces as _interfaces
    import core as _core
    import utils as _utils
except Exception:
    _interfaces = None
    _core = None
    _utils = None

interfaces = _interfaces
core = _core
utils = _utils

try:
    stc_api = _interfaces.api.stc_api if _interfaces is not None else None
except Exception:
    stc_api = None

__all__ = ["interfaces", "core", "utils", "stc_api"]
