# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WorkPlanConfigurationViolationMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkPlanConfigurationViolationMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'arguments': 'list[WorkPlanValidationMessageArgument]',
            'severity': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'arguments': 'arguments',
            'severity': 'severity'
        }

        self._type = None
        self._arguments = None
        self._severity = None

    @property
    def type(self):
        """
        Gets the type of this WorkPlanConfigurationViolationMessage.
        Type of configuration violation message for this work plan

        :return: The type of this WorkPlanConfigurationViolationMessage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this WorkPlanConfigurationViolationMessage.
        Type of configuration violation message for this work plan

        :param type: The type of this WorkPlanConfigurationViolationMessage.
        :type: str
        """
        allowed_values = ["ActivitiesOverlap", "ActivityEndGreaterThanShiftStop", "ActivityPaidTimeGreaterThanShiftPaidTime", "ActivityStartBeforeShiftStart", "ActivityStartGreaterThanEqualToShiftStop", "ActivityStartIncrementMinutesNotDivisibleByScheduleIntervalMinutes", "DailyExactPaidMinutes", "DailyMaxTotalLessThanWeeklyMin", "DailyMaxTotalLessThanWeeklyMinWithOptional", "DailyMaxTotalLessThanWeeklyMinWithoutOptional", "DailyMinTotalGreaterThanWeeklyMax", "DailyMinTotalGreaterThanWeeklyMaxWithOptional", "DailyMinTotalGreaterThanWeeklyMaxWithoutOptional", "DailyRequiredDaysGreaterThanWeeklyMaxDays", "DailyShiftHasNoDaysSelected", "DailyShiftMaxPossibilitiesViolated", "EarliestShiftStopIsTooLate", "ExactPaidTimeNotDivisibleByGranularity", "MaxConsecutiveWorkingDaysNoMoreThanDoubleMaxWorkingDaysPerWeek", "MaxDaysOffPerPlanningPeriodNotCorrect", "MaxPaidTimeIsMoreThanShiftLength", "MaxPaidTimeNotDivisibleByGranularity", "MaxPaidTimePerPlanningPeriod", "MaxShifts", "MinPaidTimeNotDivisibleByGranularity", "MinPaidTimePerPlanningPeriod", "NoShifts", "PaidTimeGreaterThanMaxWorkTime", "PaidTimeLessThanMinWorkTime", "PaidTimeNotMetByShiftStartStop", "ShiftDaysSelectMoreThanMinWorkingDays", "ShiftStopEarlierThanStart", "ShiftVarianceCannotBeMet", "WeeklyExactPaidMinutes"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def arguments(self):
        """
        Gets the arguments of this WorkPlanConfigurationViolationMessage.
        Arguments of the message that provide information about the misconfigured value or the threshold that is exceeded by the misconfigured value

        :return: The arguments of this WorkPlanConfigurationViolationMessage.
        :rtype: list[WorkPlanValidationMessageArgument]
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """
        Sets the arguments of this WorkPlanConfigurationViolationMessage.
        Arguments of the message that provide information about the misconfigured value or the threshold that is exceeded by the misconfigured value

        :param arguments: The arguments of this WorkPlanConfigurationViolationMessage.
        :type: list[WorkPlanValidationMessageArgument]
        """
        

        self._arguments = arguments

    @property
    def severity(self):
        """
        Gets the severity of this WorkPlanConfigurationViolationMessage.
        Severity of the message. A message with Error severity indicates the scheduler won't be able to produce schedules and thus the work plan is invalid.

        :return: The severity of this WorkPlanConfigurationViolationMessage.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this WorkPlanConfigurationViolationMessage.
        Severity of the message. A message with Error severity indicates the scheduler won't be able to produce schedules and thus the work plan is invalid.

        :param severity: The severity of this WorkPlanConfigurationViolationMessage.
        :type: str
        """
        allowed_values = ["Information", "Warning", "Error"]
        if severity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for severity -> " + severity)
            self._severity = "outdated_sdk_version"
        else:
            self._severity = severity

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

