# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WfmScheduleReference(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WfmScheduleReference - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'business_unit': 'WfmBusinessUnitReference',
            'week_date': 'date',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'business_unit': 'businessUnit',
            'week_date': 'weekDate',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._business_unit = None
        self._week_date = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this WfmScheduleReference.
        The ID of the WFM schedule

        :return: The id of this WfmScheduleReference.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WfmScheduleReference.
        The ID of the WFM schedule

        :param id: The id of this WfmScheduleReference.
        :type: str
        """
        

        self._id = id

    @property
    def business_unit(self):
        """
        Gets the business_unit of this WfmScheduleReference.
        A reference to a Workforce Management Business Unit

        :return: The business_unit of this WfmScheduleReference.
        :rtype: WfmBusinessUnitReference
        """
        return self._business_unit

    @business_unit.setter
    def business_unit(self, business_unit):
        """
        Sets the business_unit of this WfmScheduleReference.
        A reference to a Workforce Management Business Unit

        :param business_unit: The business_unit of this WfmScheduleReference.
        :type: WfmBusinessUnitReference
        """
        

        self._business_unit = business_unit

    @property
    def week_date(self):
        """
        Gets the week_date of this WfmScheduleReference.
        The start week date for this schedule. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The week_date of this WfmScheduleReference.
        :rtype: date
        """
        return self._week_date

    @week_date.setter
    def week_date(self, week_date):
        """
        Sets the week_date of this WfmScheduleReference.
        The start week date for this schedule. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param week_date: The week_date of this WfmScheduleReference.
        :type: date
        """
        

        self._week_date = week_date

    @property
    def self_uri(self):
        """
        Gets the self_uri of this WfmScheduleReference.
        The URI for this object

        :return: The self_uri of this WfmScheduleReference.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this WfmScheduleReference.
        The URI for this object

        :param self_uri: The self_uri of this WfmScheduleReference.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

