# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UserScheduleContainer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserScheduleContainer - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'management_unit_time_zone': 'str',
            'published_schedules': 'list[WeekScheduleReference]',
            'user_schedules': 'dict(str, UserSchedule)'
        }

        self.attribute_map = {
            'management_unit_time_zone': 'managementUnitTimeZone',
            'published_schedules': 'publishedSchedules',
            'user_schedules': 'userSchedules'
        }

        self._management_unit_time_zone = None
        self._published_schedules = None
        self._user_schedules = None

    @property
    def management_unit_time_zone(self):
        """
        Gets the management_unit_time_zone of this UserScheduleContainer.
        The reference time zone used for the management unit

        :return: The management_unit_time_zone of this UserScheduleContainer.
        :rtype: str
        """
        return self._management_unit_time_zone

    @management_unit_time_zone.setter
    def management_unit_time_zone(self, management_unit_time_zone):
        """
        Sets the management_unit_time_zone of this UserScheduleContainer.
        The reference time zone used for the management unit

        :param management_unit_time_zone: The management_unit_time_zone of this UserScheduleContainer.
        :type: str
        """
        

        self._management_unit_time_zone = management_unit_time_zone

    @property
    def published_schedules(self):
        """
        Gets the published_schedules of this UserScheduleContainer.
        References to all published week schedules overlapping the start/end date query parameters

        :return: The published_schedules of this UserScheduleContainer.
        :rtype: list[WeekScheduleReference]
        """
        return self._published_schedules

    @published_schedules.setter
    def published_schedules(self, published_schedules):
        """
        Sets the published_schedules of this UserScheduleContainer.
        References to all published week schedules overlapping the start/end date query parameters

        :param published_schedules: The published_schedules of this UserScheduleContainer.
        :type: list[WeekScheduleReference]
        """
        

        self._published_schedules = published_schedules

    @property
    def user_schedules(self):
        """
        Gets the user_schedules of this UserScheduleContainer.
        Map of user id to user schedule

        :return: The user_schedules of this UserScheduleContainer.
        :rtype: dict(str, UserSchedule)
        """
        return self._user_schedules

    @user_schedules.setter
    def user_schedules(self, user_schedules):
        """
        Sets the user_schedules of this UserScheduleContainer.
        Map of user id to user schedule

        :param user_schedules: The user_schedules of this UserScheduleContainer.
        :type: dict(str, UserSchedule)
        """
        

        self._user_schedules = user_schedules

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

