# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class RecordingSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        RecordingSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'max_simultaneous_streams': 'int',
            'max_configurable_screen_recording_streams': 'int',
            'regional_recording_storage_enabled': 'bool'
        }

        self.attribute_map = {
            'max_simultaneous_streams': 'maxSimultaneousStreams',
            'max_configurable_screen_recording_streams': 'maxConfigurableScreenRecordingStreams',
            'regional_recording_storage_enabled': 'regionalRecordingStorageEnabled'
        }

        self._max_simultaneous_streams = None
        self._max_configurable_screen_recording_streams = None
        self._regional_recording_storage_enabled = None

    @property
    def max_simultaneous_streams(self):
        """
        Gets the max_simultaneous_streams of this RecordingSettings.
        Maximum number of simultaneous screen recording streams

        :return: The max_simultaneous_streams of this RecordingSettings.
        :rtype: int
        """
        return self._max_simultaneous_streams

    @max_simultaneous_streams.setter
    def max_simultaneous_streams(self, max_simultaneous_streams):
        """
        Sets the max_simultaneous_streams of this RecordingSettings.
        Maximum number of simultaneous screen recording streams

        :param max_simultaneous_streams: The max_simultaneous_streams of this RecordingSettings.
        :type: int
        """
        

        self._max_simultaneous_streams = max_simultaneous_streams

    @property
    def max_configurable_screen_recording_streams(self):
        """
        Gets the max_configurable_screen_recording_streams of this RecordingSettings.
        Upper limit that maxSimultaneousStreams can be configured

        :return: The max_configurable_screen_recording_streams of this RecordingSettings.
        :rtype: int
        """
        return self._max_configurable_screen_recording_streams

    @max_configurable_screen_recording_streams.setter
    def max_configurable_screen_recording_streams(self, max_configurable_screen_recording_streams):
        """
        Sets the max_configurable_screen_recording_streams of this RecordingSettings.
        Upper limit that maxSimultaneousStreams can be configured

        :param max_configurable_screen_recording_streams: The max_configurable_screen_recording_streams of this RecordingSettings.
        :type: int
        """
        

        self._max_configurable_screen_recording_streams = max_configurable_screen_recording_streams

    @property
    def regional_recording_storage_enabled(self):
        """
        Gets the regional_recording_storage_enabled of this RecordingSettings.
        Store call recordings in the region where they are intended to be recorded, otherwise in the organization's home region

        :return: The regional_recording_storage_enabled of this RecordingSettings.
        :rtype: bool
        """
        return self._regional_recording_storage_enabled

    @regional_recording_storage_enabled.setter
    def regional_recording_storage_enabled(self, regional_recording_storage_enabled):
        """
        Sets the regional_recording_storage_enabled of this RecordingSettings.
        Store call recordings in the region where they are intended to be recorded, otherwise in the organization's home region

        :param regional_recording_storage_enabled: The regional_recording_storage_enabled of this RecordingSettings.
        :type: bool
        """
        

        self._regional_recording_storage_enabled = regional_recording_storage_enabled

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

