# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class KnowledgeTraining(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KnowledgeTraining - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_triggered': 'datetime',
            'date_completed': 'datetime',
            'status': 'str',
            'language_code': 'str',
            'knowledge_base': 'KnowledgeBase',
            'error_message': 'str',
            'knowledge_documents_state': 'str',
            'date_promoted': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'date_triggered': 'dateTriggered',
            'date_completed': 'dateCompleted',
            'status': 'status',
            'language_code': 'languageCode',
            'knowledge_base': 'knowledgeBase',
            'error_message': 'errorMessage',
            'knowledge_documents_state': 'knowledgeDocumentsState',
            'date_promoted': 'datePromoted',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._date_triggered = None
        self._date_completed = None
        self._status = None
        self._language_code = None
        self._knowledge_base = None
        self._error_message = None
        self._knowledge_documents_state = None
        self._date_promoted = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this KnowledgeTraining.
        The globally unique identifier for the object.

        :return: The id of this KnowledgeTraining.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KnowledgeTraining.
        The globally unique identifier for the object.

        :param id: The id of this KnowledgeTraining.
        :type: str
        """
        

        self._id = id

    @property
    def date_triggered(self):
        """
        Gets the date_triggered of this KnowledgeTraining.
        Trigger date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_triggered of this KnowledgeTraining.
        :rtype: datetime
        """
        return self._date_triggered

    @date_triggered.setter
    def date_triggered(self, date_triggered):
        """
        Sets the date_triggered of this KnowledgeTraining.
        Trigger date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_triggered: The date_triggered of this KnowledgeTraining.
        :type: datetime
        """
        

        self._date_triggered = date_triggered

    @property
    def date_completed(self):
        """
        Gets the date_completed of this KnowledgeTraining.
        Training completed date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_completed of this KnowledgeTraining.
        :rtype: datetime
        """
        return self._date_completed

    @date_completed.setter
    def date_completed(self, date_completed):
        """
        Sets the date_completed of this KnowledgeTraining.
        Training completed date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_completed: The date_completed of this KnowledgeTraining.
        :type: datetime
        """
        

        self._date_completed = date_completed

    @property
    def status(self):
        """
        Gets the status of this KnowledgeTraining.
        Training status.

        :return: The status of this KnowledgeTraining.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this KnowledgeTraining.
        Training status.

        :param status: The status of this KnowledgeTraining.
        :type: str
        """
        allowed_values = ["Queued", "InProgress", "Succeeded", "Failed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def language_code(self):
        """
        Gets the language_code of this KnowledgeTraining.
        Language of the documents that are trained.

        :return: The language_code of this KnowledgeTraining.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """
        Sets the language_code of this KnowledgeTraining.
        Language of the documents that are trained.

        :param language_code: The language_code of this KnowledgeTraining.
        :type: str
        """
        

        self._language_code = language_code

    @property
    def knowledge_base(self):
        """
        Gets the knowledge_base of this KnowledgeTraining.
        Knowledge Base that the training belongs to.

        :return: The knowledge_base of this KnowledgeTraining.
        :rtype: KnowledgeBase
        """
        return self._knowledge_base

    @knowledge_base.setter
    def knowledge_base(self, knowledge_base):
        """
        Sets the knowledge_base of this KnowledgeTraining.
        Knowledge Base that the training belongs to.

        :param knowledge_base: The knowledge_base of this KnowledgeTraining.
        :type: KnowledgeBase
        """
        

        self._knowledge_base = knowledge_base

    @property
    def error_message(self):
        """
        Gets the error_message of this KnowledgeTraining.
        Any error message during the Training or Promote action.

        :return: The error_message of this KnowledgeTraining.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this KnowledgeTraining.
        Any error message during the Training or Promote action.

        :param error_message: The error_message of this KnowledgeTraining.
        :type: str
        """
        

        self._error_message = error_message

    @property
    def knowledge_documents_state(self):
        """
        Gets the knowledge_documents_state of this KnowledgeTraining.
        State of the Trained Documents, which can be one of these Draft, Active, Discarded, Archived.

        :return: The knowledge_documents_state of this KnowledgeTraining.
        :rtype: str
        """
        return self._knowledge_documents_state

    @knowledge_documents_state.setter
    def knowledge_documents_state(self, knowledge_documents_state):
        """
        Sets the knowledge_documents_state of this KnowledgeTraining.
        State of the Trained Documents, which can be one of these Draft, Active, Discarded, Archived.

        :param knowledge_documents_state: The knowledge_documents_state of this KnowledgeTraining.
        :type: str
        """
        allowed_values = ["Draft", "Active", "Discarded", "Archived"]
        if knowledge_documents_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for knowledge_documents_state -> " + knowledge_documents_state)
            self._knowledge_documents_state = "outdated_sdk_version"
        else:
            self._knowledge_documents_state = knowledge_documents_state

    @property
    def date_promoted(self):
        """
        Gets the date_promoted of this KnowledgeTraining.
        Trained Documents Promoted date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_promoted of this KnowledgeTraining.
        :rtype: datetime
        """
        return self._date_promoted

    @date_promoted.setter
    def date_promoted(self, date_promoted):
        """
        Sets the date_promoted of this KnowledgeTraining.
        Trained Documents Promoted date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_promoted: The date_promoted of this KnowledgeTraining.
        :type: datetime
        """
        

        self._date_promoted = date_promoted

    @property
    def self_uri(self):
        """
        Gets the self_uri of this KnowledgeTraining.
        The URI for this object

        :return: The self_uri of this KnowledgeTraining.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this KnowledgeTraining.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeTraining.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

