# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class FlowExecutionLaunchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowExecutionLaunchRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'flow_id': 'str',
            'flow_version': 'str',
            'input_data': 'dict(str, object)',
            'name': 'str'
        }

        self.attribute_map = {
            'flow_id': 'flowId',
            'flow_version': 'flowVersion',
            'input_data': 'inputData',
            'name': 'name'
        }

        self._flow_id = None
        self._flow_version = None
        self._input_data = None
        self._name = None

    @property
    def flow_id(self):
        """
        Gets the flow_id of this FlowExecutionLaunchRequest.
        ID of the flow to launch.

        :return: The flow_id of this FlowExecutionLaunchRequest.
        :rtype: str
        """
        return self._flow_id

    @flow_id.setter
    def flow_id(self, flow_id):
        """
        Sets the flow_id of this FlowExecutionLaunchRequest.
        ID of the flow to launch.

        :param flow_id: The flow_id of this FlowExecutionLaunchRequest.
        :type: str
        """
        

        self._flow_id = flow_id

    @property
    def flow_version(self):
        """
        Gets the flow_version of this FlowExecutionLaunchRequest.
        The version of the flow to launch. Omit this value (or supply null/empty) to use the latest published version.

        :return: The flow_version of this FlowExecutionLaunchRequest.
        :rtype: str
        """
        return self._flow_version

    @flow_version.setter
    def flow_version(self, flow_version):
        """
        Sets the flow_version of this FlowExecutionLaunchRequest.
        The version of the flow to launch. Omit this value (or supply null/empty) to use the latest published version.

        :param flow_version: The flow_version of this FlowExecutionLaunchRequest.
        :type: str
        """
        

        self._flow_version = flow_version

    @property
    def input_data(self):
        """
        Gets the input_data of this FlowExecutionLaunchRequest.
        Input values to the flow. Valid values are defined by a flow's input JSON schema.

        :return: The input_data of this FlowExecutionLaunchRequest.
        :rtype: dict(str, object)
        """
        return self._input_data

    @input_data.setter
    def input_data(self, input_data):
        """
        Sets the input_data of this FlowExecutionLaunchRequest.
        Input values to the flow. Valid values are defined by a flow's input JSON schema.

        :param input_data: The input_data of this FlowExecutionLaunchRequest.
        :type: dict(str, object)
        """
        

        self._input_data = input_data

    @property
    def name(self):
        """
        Gets the name of this FlowExecutionLaunchRequest.
        A displayable name to assign to the new flow execution

        :return: The name of this FlowExecutionLaunchRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FlowExecutionLaunchRequest.
        A displayable name to assign to the new flow execution

        :param name: The name of this FlowExecutionLaunchRequest.
        :type: str
        """
        

        self._name = name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

