# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DomainPermission(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DomainPermission - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'domain': 'str',
            'entity_type': 'str',
            'action': 'str',
            'label': 'str',
            'allows_conditions': 'bool',
            'division_aware': 'bool'
        }

        self.attribute_map = {
            'domain': 'domain',
            'entity_type': 'entityType',
            'action': 'action',
            'label': 'label',
            'allows_conditions': 'allowsConditions',
            'division_aware': 'divisionAware'
        }

        self._domain = None
        self._entity_type = None
        self._action = None
        self._label = None
        self._allows_conditions = None
        self._division_aware = None

    @property
    def domain(self):
        """
        Gets the domain of this DomainPermission.


        :return: The domain of this DomainPermission.
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """
        Sets the domain of this DomainPermission.


        :param domain: The domain of this DomainPermission.
        :type: str
        """
        

        self._domain = domain

    @property
    def entity_type(self):
        """
        Gets the entity_type of this DomainPermission.


        :return: The entity_type of this DomainPermission.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this DomainPermission.


        :param entity_type: The entity_type of this DomainPermission.
        :type: str
        """
        

        self._entity_type = entity_type

    @property
    def action(self):
        """
        Gets the action of this DomainPermission.


        :return: The action of this DomainPermission.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this DomainPermission.


        :param action: The action of this DomainPermission.
        :type: str
        """
        

        self._action = action

    @property
    def label(self):
        """
        Gets the label of this DomainPermission.


        :return: The label of this DomainPermission.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this DomainPermission.


        :param label: The label of this DomainPermission.
        :type: str
        """
        

        self._label = label

    @property
    def allows_conditions(self):
        """
        Gets the allows_conditions of this DomainPermission.


        :return: The allows_conditions of this DomainPermission.
        :rtype: bool
        """
        return self._allows_conditions

    @allows_conditions.setter
    def allows_conditions(self, allows_conditions):
        """
        Sets the allows_conditions of this DomainPermission.


        :param allows_conditions: The allows_conditions of this DomainPermission.
        :type: bool
        """
        

        self._allows_conditions = allows_conditions

    @property
    def division_aware(self):
        """
        Gets the division_aware of this DomainPermission.


        :return: The division_aware of this DomainPermission.
        :rtype: bool
        """
        return self._division_aware

    @division_aware.setter
    def division_aware(self, division_aware):
        """
        Sets the division_aware of this DomainPermission.


        :param division_aware: The division_aware of this DomainPermission.
        :type: bool
        """
        

        self._division_aware = division_aware

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

