# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DocumentUpdate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DocumentUpdate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'change_number': 'int',
            'name': 'str',
            'read': 'bool',
            'add_tags': 'list[str]',
            'remove_tags': 'list[str]',
            'add_tag_ids': 'list[str]',
            'remove_tag_ids': 'list[str]',
            'update_attributes': 'list[DocumentAttribute]',
            'remove_attributes': 'list[str]'
        }

        self.attribute_map = {
            'change_number': 'changeNumber',
            'name': 'name',
            'read': 'read',
            'add_tags': 'addTags',
            'remove_tags': 'removeTags',
            'add_tag_ids': 'addTagIds',
            'remove_tag_ids': 'removeTagIds',
            'update_attributes': 'updateAttributes',
            'remove_attributes': 'removeAttributes'
        }

        self._change_number = None
        self._name = None
        self._read = None
        self._add_tags = None
        self._remove_tags = None
        self._add_tag_ids = None
        self._remove_tag_ids = None
        self._update_attributes = None
        self._remove_attributes = None

    @property
    def change_number(self):
        """
        Gets the change_number of this DocumentUpdate.


        :return: The change_number of this DocumentUpdate.
        :rtype: int
        """
        return self._change_number

    @change_number.setter
    def change_number(self, change_number):
        """
        Sets the change_number of this DocumentUpdate.


        :param change_number: The change_number of this DocumentUpdate.
        :type: int
        """
        

        self._change_number = change_number

    @property
    def name(self):
        """
        Gets the name of this DocumentUpdate.
        The name of the document

        :return: The name of this DocumentUpdate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DocumentUpdate.
        The name of the document

        :param name: The name of this DocumentUpdate.
        :type: str
        """
        

        self._name = name

    @property
    def read(self):
        """
        Gets the read of this DocumentUpdate.


        :return: The read of this DocumentUpdate.
        :rtype: bool
        """
        return self._read

    @read.setter
    def read(self, read):
        """
        Sets the read of this DocumentUpdate.


        :param read: The read of this DocumentUpdate.
        :type: bool
        """
        

        self._read = read

    @property
    def add_tags(self):
        """
        Gets the add_tags of this DocumentUpdate.


        :return: The add_tags of this DocumentUpdate.
        :rtype: list[str]
        """
        return self._add_tags

    @add_tags.setter
    def add_tags(self, add_tags):
        """
        Sets the add_tags of this DocumentUpdate.


        :param add_tags: The add_tags of this DocumentUpdate.
        :type: list[str]
        """
        

        self._add_tags = add_tags

    @property
    def remove_tags(self):
        """
        Gets the remove_tags of this DocumentUpdate.


        :return: The remove_tags of this DocumentUpdate.
        :rtype: list[str]
        """
        return self._remove_tags

    @remove_tags.setter
    def remove_tags(self, remove_tags):
        """
        Sets the remove_tags of this DocumentUpdate.


        :param remove_tags: The remove_tags of this DocumentUpdate.
        :type: list[str]
        """
        

        self._remove_tags = remove_tags

    @property
    def add_tag_ids(self):
        """
        Gets the add_tag_ids of this DocumentUpdate.


        :return: The add_tag_ids of this DocumentUpdate.
        :rtype: list[str]
        """
        return self._add_tag_ids

    @add_tag_ids.setter
    def add_tag_ids(self, add_tag_ids):
        """
        Sets the add_tag_ids of this DocumentUpdate.


        :param add_tag_ids: The add_tag_ids of this DocumentUpdate.
        :type: list[str]
        """
        

        self._add_tag_ids = add_tag_ids

    @property
    def remove_tag_ids(self):
        """
        Gets the remove_tag_ids of this DocumentUpdate.


        :return: The remove_tag_ids of this DocumentUpdate.
        :rtype: list[str]
        """
        return self._remove_tag_ids

    @remove_tag_ids.setter
    def remove_tag_ids(self, remove_tag_ids):
        """
        Sets the remove_tag_ids of this DocumentUpdate.


        :param remove_tag_ids: The remove_tag_ids of this DocumentUpdate.
        :type: list[str]
        """
        

        self._remove_tag_ids = remove_tag_ids

    @property
    def update_attributes(self):
        """
        Gets the update_attributes of this DocumentUpdate.


        :return: The update_attributes of this DocumentUpdate.
        :rtype: list[DocumentAttribute]
        """
        return self._update_attributes

    @update_attributes.setter
    def update_attributes(self, update_attributes):
        """
        Sets the update_attributes of this DocumentUpdate.


        :param update_attributes: The update_attributes of this DocumentUpdate.
        :type: list[DocumentAttribute]
        """
        

        self._update_attributes = update_attributes

    @property
    def remove_attributes(self):
        """
        Gets the remove_attributes of this DocumentUpdate.


        :return: The remove_attributes of this DocumentUpdate.
        :rtype: list[str]
        """
        return self._remove_attributes

    @remove_attributes.setter
    def remove_attributes(self, remove_attributes):
        """
        Sets the remove_attributes of this DocumentUpdate.


        :param remove_attributes: The remove_attributes of this DocumentUpdate.
        :type: list[str]
        """
        

        self._remove_attributes = remove_attributes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

