# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DialerAuditRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DialerAuditRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'query_phrase': 'str',
            'query_fields': 'list[str]',
            'facets': 'list[AuditFacet]',
            'filters': 'list[AuditFilter]'
        }

        self.attribute_map = {
            'query_phrase': 'queryPhrase',
            'query_fields': 'queryFields',
            'facets': 'facets',
            'filters': 'filters'
        }

        self._query_phrase = None
        self._query_fields = None
        self._facets = None
        self._filters = None

    @property
    def query_phrase(self):
        """
        Gets the query_phrase of this DialerAuditRequest.
        The word or words to search for.

        :return: The query_phrase of this DialerAuditRequest.
        :rtype: str
        """
        return self._query_phrase

    @query_phrase.setter
    def query_phrase(self, query_phrase):
        """
        Sets the query_phrase of this DialerAuditRequest.
        The word or words to search for.

        :param query_phrase: The query_phrase of this DialerAuditRequest.
        :type: str
        """
        

        self._query_phrase = query_phrase

    @property
    def query_fields(self):
        """
        Gets the query_fields of this DialerAuditRequest.
        The fields in which to search for the queryPhrase.

        :return: The query_fields of this DialerAuditRequest.
        :rtype: list[str]
        """
        return self._query_fields

    @query_fields.setter
    def query_fields(self, query_fields):
        """
        Sets the query_fields of this DialerAuditRequest.
        The fields in which to search for the queryPhrase.

        :param query_fields: The query_fields of this DialerAuditRequest.
        :type: list[str]
        """
        

        self._query_fields = query_fields

    @property
    def facets(self):
        """
        Gets the facets of this DialerAuditRequest.
        The fields to facet on.

        :return: The facets of this DialerAuditRequest.
        :rtype: list[AuditFacet]
        """
        return self._facets

    @facets.setter
    def facets(self, facets):
        """
        Sets the facets of this DialerAuditRequest.
        The fields to facet on.

        :param facets: The facets of this DialerAuditRequest.
        :type: list[AuditFacet]
        """
        

        self._facets = facets

    @property
    def filters(self):
        """
        Gets the filters of this DialerAuditRequest.
        The fields to filter on.

        :return: The filters of this DialerAuditRequest.
        :rtype: list[AuditFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this DialerAuditRequest.
        The fields to filter on.

        :param filters: The filters of this DialerAuditRequest.
        :type: list[AuditFilter]
        """
        

        self._filters = filters

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

