# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ContentActions(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ContentActions - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'url': 'str',
            'url_target': 'str',
            'textback': 'str'
        }

        self.attribute_map = {
            'url': 'url',
            'url_target': 'urlTarget',
            'textback': 'textback'
        }

        self._url = None
        self._url_target = None
        self._textback = None

    @property
    def url(self):
        """
        Gets the url of this ContentActions.
        A URL of a web page to direct the user to.

        :return: The url of this ContentActions.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this ContentActions.
        A URL of a web page to direct the user to.

        :param url: The url of this ContentActions.
        :type: str
        """
        

        self._url = url

    @property
    def url_target(self):
        """
        Gets the url_target of this ContentActions.
        The target window in which to open the URL. If empty will open a blank page or tab.

        :return: The url_target of this ContentActions.
        :rtype: str
        """
        return self._url_target

    @url_target.setter
    def url_target(self, url_target):
        """
        Sets the url_target of this ContentActions.
        The target window in which to open the URL. If empty will open a blank page or tab.

        :param url_target: The url_target of this ContentActions.
        :type: str
        """
        

        self._url_target = url_target

    @property
    def textback(self):
        """
        Gets the textback of this ContentActions.
        Text to be returned as the payload from a ButtonResponse when a button is clicked. The textback and title are a combination which will have to be unique across each card and carousel in order to determine which button was clicked in that card or carousel.

        :return: The textback of this ContentActions.
        :rtype: str
        """
        return self._textback

    @textback.setter
    def textback(self, textback):
        """
        Sets the textback of this ContentActions.
        Text to be returned as the payload from a ButtonResponse when a button is clicked. The textback and title are a combination which will have to be unique across each card and carousel in order to determine which button was clicked in that card or carousel.

        :param textback: The textback of this ContentActions.
        :type: str
        """
        

        self._textback = textback

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

