# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ConditionalGroupRoutingRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ConditionalGroupRoutingRule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'queue': 'DomainEntityRef',
            'metric': 'str',
            'operator': 'str',
            'condition_value': 'float',
            'groups': 'list[MemberGroup]',
            'wait_seconds': 'int'
        }

        self.attribute_map = {
            'queue': 'queue',
            'metric': 'metric',
            'operator': 'operator',
            'condition_value': 'conditionValue',
            'groups': 'groups',
            'wait_seconds': 'waitSeconds'
        }

        self._queue = None
        self._metric = None
        self._operator = None
        self._condition_value = None
        self._groups = None
        self._wait_seconds = None

    @property
    def queue(self):
        """
        Gets the queue of this ConditionalGroupRoutingRule.
        The queue being evaluated for this rule.  For rule 1, this is always the current queue.

        :return: The queue of this ConditionalGroupRoutingRule.
        :rtype: DomainEntityRef
        """
        return self._queue

    @queue.setter
    def queue(self, queue):
        """
        Sets the queue of this ConditionalGroupRoutingRule.
        The queue being evaluated for this rule.  For rule 1, this is always the current queue.

        :param queue: The queue of this ConditionalGroupRoutingRule.
        :type: DomainEntityRef
        """
        

        self._queue = queue

    @property
    def metric(self):
        """
        Gets the metric of this ConditionalGroupRoutingRule.
        The queue metric being evaluated

        :return: The metric of this ConditionalGroupRoutingRule.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric):
        """
        Sets the metric of this ConditionalGroupRoutingRule.
        The queue metric being evaluated

        :param metric: The metric of this ConditionalGroupRoutingRule.
        :type: str
        """
        allowed_values = ["EstimatedWaitTime"]
        if metric.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric -> " + metric)
            self._metric = "outdated_sdk_version"
        else:
            self._metric = metric

    @property
    def operator(self):
        """
        Gets the operator of this ConditionalGroupRoutingRule.
        The operator that compares the actual value against the condition value

        :return: The operator of this ConditionalGroupRoutingRule.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this ConditionalGroupRoutingRule.
        The operator that compares the actual value against the condition value

        :param operator: The operator of this ConditionalGroupRoutingRule.
        :type: str
        """
        allowed_values = ["GreaterThan", "GreaterThanOrEqualTo", "LessThan", "LessThanOrEqualTo"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def condition_value(self):
        """
        Gets the condition_value of this ConditionalGroupRoutingRule.
        The limit value, beyond which a rule evaluates as true

        :return: The condition_value of this ConditionalGroupRoutingRule.
        :rtype: float
        """
        return self._condition_value

    @condition_value.setter
    def condition_value(self, condition_value):
        """
        Sets the condition_value of this ConditionalGroupRoutingRule.
        The limit value, beyond which a rule evaluates as true

        :param condition_value: The condition_value of this ConditionalGroupRoutingRule.
        :type: float
        """
        

        self._condition_value = condition_value

    @property
    def groups(self):
        """
        Gets the groups of this ConditionalGroupRoutingRule.
        The group(s) to activate if the rule evaluates as true

        :return: The groups of this ConditionalGroupRoutingRule.
        :rtype: list[MemberGroup]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this ConditionalGroupRoutingRule.
        The group(s) to activate if the rule evaluates as true

        :param groups: The groups of this ConditionalGroupRoutingRule.
        :type: list[MemberGroup]
        """
        

        self._groups = groups

    @property
    def wait_seconds(self):
        """
        Gets the wait_seconds of this ConditionalGroupRoutingRule.
        The number of seconds to wait in this rule, if it evaluates as true, before evaluating the next rule

        :return: The wait_seconds of this ConditionalGroupRoutingRule.
        :rtype: int
        """
        return self._wait_seconds

    @wait_seconds.setter
    def wait_seconds(self, wait_seconds):
        """
        Sets the wait_seconds of this ConditionalGroupRoutingRule.
        The number of seconds to wait in this rule, if it evaluates as true, before evaluating the next rule

        :param wait_seconds: The wait_seconds of this ConditionalGroupRoutingRule.
        :type: int
        """
        

        self._wait_seconds = wait_seconds

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

