# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AnalyticsUserDetailsQueryResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AnalyticsUserDetailsQueryResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_details': 'list[AnalyticsUserDetail]',
            'aggregations': 'list[AggregationResult]',
            'total_hits': 'int'
        }

        self.attribute_map = {
            'user_details': 'userDetails',
            'aggregations': 'aggregations',
            'total_hits': 'totalHits'
        }

        self._user_details = None
        self._aggregations = None
        self._total_hits = None

    @property
    def user_details(self):
        """
        Gets the user_details of this AnalyticsUserDetailsQueryResponse.


        :return: The user_details of this AnalyticsUserDetailsQueryResponse.
        :rtype: list[AnalyticsUserDetail]
        """
        return self._user_details

    @user_details.setter
    def user_details(self, user_details):
        """
        Sets the user_details of this AnalyticsUserDetailsQueryResponse.


        :param user_details: The user_details of this AnalyticsUserDetailsQueryResponse.
        :type: list[AnalyticsUserDetail]
        """
        

        self._user_details = user_details

    @property
    def aggregations(self):
        """
        Gets the aggregations of this AnalyticsUserDetailsQueryResponse.


        :return: The aggregations of this AnalyticsUserDetailsQueryResponse.
        :rtype: list[AggregationResult]
        """
        return self._aggregations

    @aggregations.setter
    def aggregations(self, aggregations):
        """
        Sets the aggregations of this AnalyticsUserDetailsQueryResponse.


        :param aggregations: The aggregations of this AnalyticsUserDetailsQueryResponse.
        :type: list[AggregationResult]
        """
        

        self._aggregations = aggregations

    @property
    def total_hits(self):
        """
        Gets the total_hits of this AnalyticsUserDetailsQueryResponse.


        :return: The total_hits of this AnalyticsUserDetailsQueryResponse.
        :rtype: int
        """
        return self._total_hits

    @total_hits.setter
    def total_hits(self, total_hits):
        """
        Sets the total_hits of this AnalyticsUserDetailsQueryResponse.


        :param total_hits: The total_hits of this AnalyticsUserDetailsQueryResponse.
        :type: int
        """
        

        self._total_hits = total_hits

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

