"""Add Task table

Revision ID: 131eb148fd57
Revises: 1eb0259b6faf
Create Date: 2019-05-06 18:53:30.357780

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '131eb148fd57'
down_revision = '5279ea22b197'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'tasks', sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=True), sa.Column('host', sa.String(length=40), nullable=False),
        sa.Column('pid', sa.Integer(), nullable=True),
        sa.Column(
            'status',
            sa.Enum('not_running', 'running', 'terminated', 'unsynchronized', name='taskstatus'),
            nullable=False), sa.Column('command', sa.String(length=400), nullable=False),
        sa.Column('spawn_at', sa.DateTime(), nullable=True), sa.Column('terminate_at', sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'), sa.PrimaryKeyConstraint('id'))
    naming_convention = {
        "fk": "fk_%(table_name)s_%(column_0_name)s_%(referred_table_name)s",
    }

    with op.batch_alter_table("reservations", naming_convention=naming_convention) as batch_op:
        batch_op.drop_constraint("fk_reservations_user_id_users", type_="foreignkey")
        batch_op.create_foreign_key('reservations', 'users', ['user_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'reservations', type_='foreignkey')
    op.create_foreign_key(None, 'reservations', 'users', ['user_id'], ['id'])
    op.drop_table('tasks')
    # ### end Alembic commands ###
