# SmarTool - Smart Util Tool for Python

## 简介

SmarTool是一个小而全的Python工具类库，类似Java的[Hutool][1]。

## 安装

`pip install SmarTool`

## 使用

### 1. Retry - 重试工具

```python
import random
import requests
from SmarTool import retry

# 默认重试5次，每次间隔2秒，所以异常都重试
@retry
def div1(a, b):
    return a / random.choice([0, 1, b])
div1(2, 1)

# 重试10次，每次间隔1秒，仅在出现ZeroDivisionError时重试
@retry(times=10, delay=1, catch_error=ZeroDivisionError)
def div2(a, b):
    return a / random.choice([0, 1, b])
div2(2, 1)

# 在出现TypeError时不重试直接抛出异常
@retry(ignore_error=TypeError)
def div3(a, b):
    return a / random.choice([0, 1, b])
div3(2)

# 出现指定的多个异常时重试
@retry(catch_error=[requests.exceptions.ConnectionError, requests.exceptions.ConnectTimeout])
def get():
    return requests.get("https://xxx.com").json()
get()
```


[1]: https://github.com/dromara/hutool
