# coding: utf-8

"""
    EdgeGallery MEC Service Management API

    The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI  # noqa: E501

    OpenAPI spec version: 2.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from edgegallery_sdk_mep.api_client import ApiClient


class AppSubscriptionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def applications_subscription_delete(self, app_instance_id, subscription_id, **kwargs):  # noqa: E501
        """applications_subscription_delete  # noqa: E501

        This method deletes a mecSrvMgmtSubscription. This method is typically used in \"Unsubscribing from service availability event notifications\" procedure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.applications_subscription_delete(app_instance_id, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str subscription_id: Represents a subscription to the notifications from the MEC platform. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.applications_subscription_delete_with_http_info(app_instance_id, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.applications_subscription_delete_with_http_info(app_instance_id, subscription_id, **kwargs)  # noqa: E501
            return data

    def applications_subscription_delete_with_http_info(self, app_instance_id, subscription_id, **kwargs):  # noqa: E501
        """applications_subscription_delete  # noqa: E501

        This method deletes a mecSrvMgmtSubscription. This method is typically used in \"Unsubscribing from service availability event notifications\" procedure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.applications_subscription_delete_with_http_info(app_instance_id, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str subscription_id: Represents a subscription to the notifications from the MEC platform. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['app_instance_id', 'subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method applications_subscription_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `applications_subscription_delete`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `applications_subscription_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/problem+json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/subscriptions/{subscriptionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def applications_subscription_get(self, app_instance_id, subscription_id, **kwargs):  # noqa: E501
        """applications_subscription_get  # noqa: E501

        The GET method requests information about a subscription for this requestor. Upon success, the response contains entity body with the subscription for the requestor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.applications_subscription_get(app_instance_id, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str subscription_id: Represents a subscription to the notifications from the MEC platform. (required)
        :return: SerAvailabilityNotificationSubscription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.applications_subscription_get_with_http_info(app_instance_id, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.applications_subscription_get_with_http_info(app_instance_id, subscription_id, **kwargs)  # noqa: E501
            return data

    def applications_subscription_get_with_http_info(self, app_instance_id, subscription_id, **kwargs):  # noqa: E501
        """applications_subscription_get  # noqa: E501

        The GET method requests information about a subscription for this requestor. Upon success, the response contains entity body with the subscription for the requestor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.applications_subscription_get_with_http_info(app_instance_id, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str subscription_id: Represents a subscription to the notifications from the MEC platform. (required)
        :return: SerAvailabilityNotificationSubscription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['app_instance_id', 'subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method applications_subscription_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `applications_subscription_get`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `applications_subscription_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/subscriptions/{subscriptionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SerAvailabilityNotificationSubscription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def applications_subscriptions_get(self, app_instance_id, **kwargs):  # noqa: E501
        """applications_subscriptions_get  # noqa: E501

        The GET method may be used to request information about all subscriptions for this requestor. Upon success, the response contains entity body with all the subscriptions for the requestor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.applications_subscriptions_get(app_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :return: MecServiceMgmtApiSubscriptionLinkList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.applications_subscriptions_get_with_http_info(app_instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.applications_subscriptions_get_with_http_info(app_instance_id, **kwargs)  # noqa: E501
            return data

    def applications_subscriptions_get_with_http_info(self, app_instance_id, **kwargs):  # noqa: E501
        """applications_subscriptions_get  # noqa: E501

        The GET method may be used to request information about all subscriptions for this requestor. Upon success, the response contains entity body with all the subscriptions for the requestor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.applications_subscriptions_get_with_http_info(app_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :return: MecServiceMgmtApiSubscriptionLinkList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['app_instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method applications_subscriptions_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `applications_subscriptions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MecServiceMgmtApiSubscriptionLinkList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def applications_subscriptions_post(self, body, app_instance_id, **kwargs):  # noqa: E501
        """applications_subscriptions_post  # noqa: E501

        The POST method may be used to create a new subscription. One example use case is to create a new subscription to the MEC service availability notifications. Upon success, the response contains entity body describing the created subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.applications_subscriptions_post(body, app_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SerAvailabilityNotificationSubscription body: Entity body in the request contains a subscription to the MEC application termination notifications that is to be created. (required)
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :return: SerAvailabilityNotificationSubscription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.applications_subscriptions_post_with_http_info(body, app_instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.applications_subscriptions_post_with_http_info(body, app_instance_id, **kwargs)  # noqa: E501
            return data

    def applications_subscriptions_post_with_http_info(self, body, app_instance_id, **kwargs):  # noqa: E501
        """applications_subscriptions_post  # noqa: E501

        The POST method may be used to create a new subscription. One example use case is to create a new subscription to the MEC service availability notifications. Upon success, the response contains entity body describing the created subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.applications_subscriptions_post_with_http_info(body, app_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SerAvailabilityNotificationSubscription body: Entity body in the request contains a subscription to the MEC application termination notifications that is to be created. (required)
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :return: SerAvailabilityNotificationSubscription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'app_instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method applications_subscriptions_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `applications_subscriptions_post`")  # noqa: E501
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `applications_subscriptions_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/subscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SerAvailabilityNotificationSubscription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
