# -*- coding: utf-8 -*-

# Copyright: (c) 2022, Daniel Schmidt <danischm@cisco.com>

import logging
import os
from typing import Any, Dict

import ruamel.yaml

from iac_test import util

logger = logging.getLogger(__name__)


def load_yaml_files(path: str) -> Dict[str, Any]:
    """Load all yaml files from a provided directory."""

    def _load_file(file_path: str, data: Dict[str, Any]) -> None:
        with open(file_path, "r") as file:
            if ".yaml" in file_path or ".yml" in file_path:
                data_yaml = file.read()
                yaml = ruamel.yaml.YAML(typ="safe")
                dict = yaml.load(data_yaml)
                util.merge_dict_list(dict, data)

    result: Dict[str, Any] = {}
    if os.path.isfile(path):
        _load_file(path, result)
    else:
        for dir, subdir, files in os.walk(path):
            for filename in files:
                try:
                    _load_file(dir + os.path.sep + filename, result)
                except:  # noqa: E722
                    logger.warning("Could not load file: {}".format(filename))
    return result
