#!/usr/bin/env python3
#_*_ coding:utf-8 _*_
from src.diPwm import diPWM


def test_length():
    L = [[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]]

    A = diPWM(L)
  
    assert A.length == 5

def test_alphabet_size():
    L = [[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]]

    A = diPWM(L)

    assert A.alphabet_size == 4

def test_LAM():
    L = [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25]]

    A = diPWM(L)

    assert A.LAM == [{'A': 28, 'C': 32, 'G': 36, 'T': 40}, {'A': 25, 'C': 25, 'G': 25, 'T': 25}, {'A': 25, 'C': 25, 'G': 25, 'T': 25}, {'A': 25, 'C': 25, 'G': 25, 'T': 25}, {'A': 13, 'C': 17, 'G': 21, 'T': 25}]




def test_min():
    L = [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25]]

    A = diPWM(L)
    assert A.min == 10

def test_max():
    L = [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25]]

    A = diPWM(L)
    
    assert A.max == 40

