import { aws_ec2 as ec2 } from 'aws-cdk-lib';
/**
 * Properties to configure `NatAsgProvider`.
 */
export interface NatAsgProviderProps {
    /**
     * The EC2 instance type of the NAT instances.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2.InstanceType.html
     *
     * @defaultValue t2.micro
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * The allowed traffic directions through the NAT instances.
     *
     * If you set this to a value other than
     * `ec2.NatTrafficDirection.INBOUND_AND_OUTBOUND`, you must
     * configure the security group for the NAT instances either by providing
     * a fully configured security group through the `securityGroup` property
     * or by using the `NatAsgProvider` object's `securityGroup` or
     * `connections` properties after passing the `NatAsgProvider` object to a
     * `Vpc` object.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2.NatTrafficDirection.html
     *
     * @defaultValue `aws-cdk-lib.aws_ec2.NatTrafficDirection.INBOUND_AND_OUTBOUND`
     */
    readonly trafficDirection?: ec2.NatTrafficDirection;
    /**
     * The name of the SSH key pair granting access to the NAT instances.
     *
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
     */
    readonly keyPair?: string;
    /**
     * The security group associated with the NAT instances.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2.ISecurityGroup.html
     *
     * @defaultValue A security group will be created.
     */
    readonly securityGroup?: ec2.ISecurityGroup;
}
/**
 * `NatAsgProvider` is a NAT provider that places each NAT instance in its own
 * auto scaling group to improve fault tolerance and availability.
 *
 * `NatAsgProvider` extends `NatProvider`:
 * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2.NatProvider.html
 */
export declare class NatAsgProvider extends ec2.NatProvider implements ec2.IConnectable {
    private readonly props;
    private netIfIds;
    private conns?;
    private sg?;
    /**
     *
     * @param props Configuration properties.
     */
    constructor(props: NatAsgProviderProps);
    configureNat(opts: ec2.ConfigureNatOptions): void;
    configureSubnet(subnet: ec2.PrivateSubnet): void;
    get configuredGateways(): ec2.GatewayConfig[];
    /**
     * The network connections associated with the security group of the NAT instances.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2.Connections.html
     */
    get connections(): ec2.Connections;
    /**
     * The security group associated with the NAT instances.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2.ISecurityGroup.html
     */
    get securityGroup(): ec2.ISecurityGroup;
}
