# Sui DeepBook Python SDK
Python DeepBook Client SDK for Sui blockchain - built by community with [pysui](https://github.com/FrankC01/pysui/)

## Python Sui DeepBook SDK Parameters
```py
from deepbookpy.utils.normalizer import normalize_sui_object_id

CLOCK = normalize_sui_object_id("0x6")
DEEPBOOK_PACKAGE_ID = normalize_sui_object_id("dee9")

```
## Install deepbookpy
`pip install deepbookpy`

`poetry add deepbookpy`

## Versions
[deepbookpy v1](https://github.com/andreidev1/deepbookpy/tree/clob_v1_module) - compatible with the first CLOB module version

[deepbookpy v2](https://github.com/andreidev1/deepbookpy/tree/clob_v2_module) - compatible with second CLOB module version

deepbookpy v3 (current) - compatible with third CLOB module version

## Documentation ( WIP )
Check out latest deepbookpy [documentation](https://deepbookpy.readthedocs.io/en/latest/) release 

## Official DeepBook Resources

[Official Deepbook Sui Website](https://sui-deepbook.com/)

[Official Deepbook Sui Documentation](https://docs.sui-deepbook.com/)

## DeepBook Mainnet Packages

[DeepBook Mainnet Package](https://suivision.xyz/package/0x2c8d603bc51326b8c13cef9dd07031a408a48dddb541963357661df5d3204809)

[DeepBook Mainnet Registry Package](https://suivision.xyz/package/0xaf16199a2dff736e9f07a845f23c5da6df6f756eddb631aed9d24a93efc4549d)

[DeepBook Mainnet Treasury Package](https://suivision.xyz/package/0x032abf8948dda67a271bcc18e776dbbcfb0d58c8d288a700ff0d5521e57a1ffe)


## DeepBook Testnet Packages

[DeepBook Testnet Package](https://testnet.suivision.xyz/package/0xcbf4748a965d469ea3a36cf0ccc5743b96c2d0ae6dee0762ed3eca65fac07f7e)

[DeepBook Testnet Registry Package](https://testnet.suivision.xyz/package/0x98dace830ebebd44b7a3331c00750bf758f8a4b17a27380f5bb3fbe68cb984a7)

[DeepBook Testnet Treasury Package](https://testnet.suivision.xyz/package/0x69fffdae0075f8f71f4fa793549c11079266910e8905169845af1f5d00e09dcb)

## Ask A Question

Join Our Coummunity [discord](https://discord.gg/CUTen9zu5h)
