# crc-pulp_npm-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 20251204.4
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_npm
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_npm
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import pulpcore.client.pulp_npm
from pulpcore.client.pulp_npm.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://env-ephemeral-wwwdq2.apps.crc-eph.r9lp.p1.openshiftapps.com
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_npm.Configuration(
    host = "https://env-ephemeral-wwwdq2.apps.crc-eph.r9lp.p1.openshiftapps.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_npm.Configuration(
    username = os.environ["USERNAME"],
    password = os.environ["PASSWORD"]
)

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_npm.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_npm.ContentPackagesApi(api_client)
    pulp_domain = 'pulp_domain_example' # str | 
    relative_path = 'relative_path_example' # str | 
    name = 'name_example' # str | 
    version = 'version_example' # str | 
    x_task_diagnostics = ['x_task_diagnostics_example'] # List[str] | List of profilers to use on tasks. (optional)
    repository = 'repository_example' # str | A URI of a repository the new content unit should be associated with. (optional)
    pulp_labels = None # Dict[str, Optional[str]] | A dictionary of arbitrary key/value pairs used to describe a specific Content instance. (optional)
    artifact = 'artifact_example' # str | Artifact file representing the physical content (optional)
    file = None # bytearray | An uploaded file that may be turned into the content unit. (optional)
    upload = 'upload_example' # str | An uncommitted upload that may be turned into the content unit. (optional)
    file_url = 'file_url_example' # str | A url that Pulp can download and turn into the content unit. (optional)

    try:
        # Create a package
        api_response = api_instance.create(pulp_domain, relative_path, name, version, x_task_diagnostics=x_task_diagnostics, repository=repository, pulp_labels=pulp_labels, artifact=artifact, file=file, upload=upload, file_url=file_url)
        print("The response of ContentPackagesApi->create:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentPackagesApi->create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://env-ephemeral-wwwdq2.apps.crc-eph.r9lp.p1.openshiftapps.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentPackagesApi* | [**create**](docs/ContentPackagesApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/content/npm/packages/ | Create a package
*ContentPackagesApi* | [**list**](docs/ContentPackagesApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/content/npm/packages/ | List packages
*ContentPackagesApi* | [**read**](docs/ContentPackagesApi.md#read) | **GET** {npm_package_href} | Inspect a package
*ContentPackagesApi* | [**set_label**](docs/ContentPackagesApi.md#set_label) | **POST** {npm_package_href}set_label/ | Set a label
*ContentPackagesApi* | [**unset_label**](docs/ContentPackagesApi.md#unset_label) | **POST** {npm_package_href}unset_label/ | Unset a label
*DistributionsNpmApi* | [**create**](docs/DistributionsNpmApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/distributions/npm/npm/ | Create a npm distribution
*DistributionsNpmApi* | [**delete**](docs/DistributionsNpmApi.md#delete) | **DELETE** {npm_npm_distribution_href} | Delete a npm distribution
*DistributionsNpmApi* | [**list**](docs/DistributionsNpmApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/distributions/npm/npm/ | List npm distributions
*DistributionsNpmApi* | [**partial_update**](docs/DistributionsNpmApi.md#partial_update) | **PATCH** {npm_npm_distribution_href} | Update a npm distribution
*DistributionsNpmApi* | [**read**](docs/DistributionsNpmApi.md#read) | **GET** {npm_npm_distribution_href} | Inspect a npm distribution
*DistributionsNpmApi* | [**set_label**](docs/DistributionsNpmApi.md#set_label) | **POST** {npm_npm_distribution_href}set_label/ | Set a label
*DistributionsNpmApi* | [**unset_label**](docs/DistributionsNpmApi.md#unset_label) | **POST** {npm_npm_distribution_href}unset_label/ | Unset a label
*DistributionsNpmApi* | [**update**](docs/DistributionsNpmApi.md#update) | **PUT** {npm_npm_distribution_href} | Update a npm distribution
*RemotesNpmApi* | [**create**](docs/RemotesNpmApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/remotes/npm/npm/ | Create a npm remote
*RemotesNpmApi* | [**delete**](docs/RemotesNpmApi.md#delete) | **DELETE** {npm_npm_remote_href} | Delete a npm remote
*RemotesNpmApi* | [**list**](docs/RemotesNpmApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/remotes/npm/npm/ | List npm remotes
*RemotesNpmApi* | [**partial_update**](docs/RemotesNpmApi.md#partial_update) | **PATCH** {npm_npm_remote_href} | Update a npm remote
*RemotesNpmApi* | [**read**](docs/RemotesNpmApi.md#read) | **GET** {npm_npm_remote_href} | Inspect a npm remote
*RemotesNpmApi* | [**set_label**](docs/RemotesNpmApi.md#set_label) | **POST** {npm_npm_remote_href}set_label/ | Set a label
*RemotesNpmApi* | [**unset_label**](docs/RemotesNpmApi.md#unset_label) | **POST** {npm_npm_remote_href}unset_label/ | Unset a label
*RemotesNpmApi* | [**update**](docs/RemotesNpmApi.md#update) | **PUT** {npm_npm_remote_href} | Update a npm remote
*RepositoriesNpmApi* | [**create**](docs/RepositoriesNpmApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/repositories/npm/npm/ | Create a npm repository
*RepositoriesNpmApi* | [**delete**](docs/RepositoriesNpmApi.md#delete) | **DELETE** {npm_npm_repository_href} | Delete a npm repository
*RepositoriesNpmApi* | [**list**](docs/RepositoriesNpmApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/repositories/npm/npm/ | List npm repositorys
*RepositoriesNpmApi* | [**modify**](docs/RepositoriesNpmApi.md#modify) | **POST** {npm_npm_repository_href}modify/ | Modify Repository Content
*RepositoriesNpmApi* | [**partial_update**](docs/RepositoriesNpmApi.md#partial_update) | **PATCH** {npm_npm_repository_href} | Update a npm repository
*RepositoriesNpmApi* | [**read**](docs/RepositoriesNpmApi.md#read) | **GET** {npm_npm_repository_href} | Inspect a npm repository
*RepositoriesNpmApi* | [**set_label**](docs/RepositoriesNpmApi.md#set_label) | **POST** {npm_npm_repository_href}set_label/ | Set a label
*RepositoriesNpmApi* | [**sync**](docs/RepositoriesNpmApi.md#sync) | **POST** {npm_npm_repository_href}sync/ | Sync from remote
*RepositoriesNpmApi* | [**unset_label**](docs/RepositoriesNpmApi.md#unset_label) | **POST** {npm_npm_repository_href}unset_label/ | Unset a label
*RepositoriesNpmApi* | [**update**](docs/RepositoriesNpmApi.md#update) | **PUT** {npm_npm_repository_href} | Update a npm repository
*RepositoriesNpmVersionsApi* | [**delete**](docs/RepositoriesNpmVersionsApi.md#delete) | **DELETE** {npm_npm_repository_version_href} | Delete a repository version
*RepositoriesNpmVersionsApi* | [**list**](docs/RepositoriesNpmVersionsApi.md#list) | **GET** {npm_npm_repository_href}versions/ | List repository versions
*RepositoriesNpmVersionsApi* | [**read**](docs/RepositoriesNpmVersionsApi.md#read) | **GET** {npm_npm_repository_version_href} | Inspect a repository version
*RepositoriesNpmVersionsApi* | [**repair**](docs/RepositoriesNpmVersionsApi.md#repair) | **POST** {npm_npm_repository_version_href}repair/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [NpmNpmDistribution](docs/NpmNpmDistribution.md)
 - [NpmNpmDistributionResponse](docs/NpmNpmDistributionResponse.md)
 - [NpmNpmRemote](docs/NpmNpmRemote.md)
 - [NpmNpmRemoteResponse](docs/NpmNpmRemoteResponse.md)
 - [NpmNpmRemoteResponseHiddenFieldsInner](docs/NpmNpmRemoteResponseHiddenFieldsInner.md)
 - [NpmNpmRepository](docs/NpmNpmRepository.md)
 - [NpmNpmRepositoryResponse](docs/NpmNpmRepositoryResponse.md)
 - [NpmPackageResponse](docs/NpmPackageResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatednpmNpmDistributionResponseList](docs/PaginatednpmNpmDistributionResponseList.md)
 - [PaginatednpmNpmRemoteResponseList](docs/PaginatednpmNpmRemoteResponseList.md)
 - [PaginatednpmNpmRepositoryResponseList](docs/PaginatednpmNpmRepositoryResponseList.md)
 - [PaginatednpmPackageResponseList](docs/PaginatednpmPackageResponseList.md)
 - [PatchednpmNpmDistribution](docs/PatchednpmNpmDistribution.md)
 - [PatchednpmNpmRemote](docs/PatchednpmNpmRemote.md)
 - [PatchednpmNpmRepository](docs/PatchednpmNpmRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [Repair](docs/Repair.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [SetLabel](docs/SetLabel.md)
 - [SetLabelResponse](docs/SetLabelResponse.md)
 - [UnsetLabel](docs/UnsetLabel.md)
 - [UnsetLabelResponse](docs/UnsetLabelResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication

<a id="cookieAuth"></a>
### cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 

<a id="json_header_remote_authentication"></a>
### json_header_remote_authentication

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **api.console**: grant_access_to_pulp


## Author

pulp-list@redhat.com


