"""Tool call model for ATIF trajectories."""

from typing import Any

from pydantic import BaseModel, Field


class ToolCall(BaseModel):
    """A tool call within a step."""

    tool_call_id: str = Field(
        default=...,
        description="Unique identifier for this specific tool call",
    )
    function_name: str = Field(
        default=...,
        description="The name of the function or tool being invoked",
    )
    arguments: dict[str, Any] = Field(
        default=...,
        description="Arguments passed to the function (can be empty dict)",
    )

    model_config = {"extra": "forbid"}
