"""Subagent trajectory reference model for ATIF trajectories."""

from typing import Any

from pydantic import BaseModel, Field


class SubagentTrajectoryRef(BaseModel):
    """Reference to a delegated subagent trajectory."""

    session_id: str = Field(
        default=...,
        description="The session ID of the delegated subagent trajectory",
    )
    trajectory_path: str | None = Field(
        default=None,
        description="Reference to the complete subagent trajectory file",
    )
    extra: dict[str, Any] | None = Field(
        default=None,
        description="Custom metadata about the subagent execution",
    )

    model_config = {"extra": "forbid"}
