"""Observation result model for ATIF trajectories."""

from pydantic import BaseModel, Field

from harbor.models.trajectories.subagent_trajectory_ref import SubagentTrajectoryRef


class ObservationResult(BaseModel):
    """A single result within an observation."""

    source_call_id: str | None = Field(
        default=None,
        description=(
            "The `tool_call_id` from the _tool_calls_ array in _StepObject_ that this "
            "result corresponds to. If null or omitted, the result comes from an "
            "action that doesn't use the standard tool calling format (e.g., agent "
            "actions without tool calls or system-initiated operations)."
        ),
    )
    content: str | None = Field(
        default=None,
        description="The textual output or result from the tool execution",
    )
    subagent_trajectory_ref: list[SubagentTrajectoryRef] | None = Field(
        default=None,
        description="Array of references to delegated subagent trajectories",
    )

    model_config = {"extra": "forbid"}
