"""Agent configuration model for ATIF trajectories."""

from typing import Any

from pydantic import BaseModel, Field


class Agent(BaseModel):
    """Agent configuration."""

    name: str = Field(
        default=...,
        description="The name of the agent system",
    )
    version: str = Field(
        default=...,
        description="The version identifier of the agent system",
    )
    model_name: str | None = Field(
        default=None,
        description="Default LLM model used for this trajectory",
    )
    extra: dict[str, Any] | None = Field(
        default=None,
        description="Custom agent configuration details",
    )

    model_config = {"extra": "forbid"}
