from pathlib import Path

from pydantic import BaseModel, ConfigDict


class GitTaskId(BaseModel):
    model_config = ConfigDict(frozen=True)

    git_url: str
    git_commit_id: str | None = None
    path: Path

    def get_name(self) -> str:
        return self.path.name


class LocalTaskId(BaseModel):
    model_config = ConfigDict(frozen=True)

    path: Path

    def get_name(self) -> str:
        return self.path.name
