"""Token usage and cost information from an LLM call."""

from pydantic import BaseModel, Field


class UsageInfo(BaseModel):
    """Token usage and cost information from an LLM call.

    This model is used internally by the LLM layer to track token usage
    and costs for individual API calls.
    """

    prompt_tokens: int = Field(
        ...,
        description="Total input tokens for this LLM call, including cached tokens",
        ge=0,
    )
    completion_tokens: int = Field(
        ...,
        description="Total output tokens generated by this LLM call",
        ge=0,
    )
    cache_tokens: int = Field(
        ...,
        description="Subset of prompt tokens that were cache hits",
        ge=0,
    )
    cost_usd: float = Field(
        ...,
        description="Monetary cost of this API call in USD",
        ge=0.0,
    )

    model_config = {"extra": "forbid"}
