from typing import TypedDict


class RolloutDetail(TypedDict, total=False):
    """Details about a complete linear chat history.

    This represents the full conversation sequence, allowing downstream
    applications to recover the entire conversation using token IDs and logprobs.

    For agents with subagents, summarization, or other non-linear chat histories,
    multiple RolloutDetail objects can be stored in the list to represent
    different segments.
    """
    completion_token_ids: list[list[int]]  # Each element contains response token IDs for that turn
    logprobs: list[list[float]]  # Each element contains logprobs corresponding to completion_token_ids for that turn
