# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RegisteredModelFromLeaderboardArgs', 'RegisteredModelFromLeaderboard']

@pulumi.input_type
class RegisteredModelFromLeaderboardArgs:
    def __init__(__self__, *,
                 model_id: pulumi.Input[str],
                 compute_all_ts_intervals: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 distribution_prediction_model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RegisteredModelFromLeaderboard resource.
        :param pulumi.Input[str] model_id: The ID of the DataRobot model for this Registered Model.
        :param pulumi.Input[bool] compute_all_ts_intervals: Whether to compute all time series intervals (1-100 percentiles).
        :param pulumi.Input[str] description: The description of the Registered Model.
        :param pulumi.Input[str] distribution_prediction_model_id: The ID of the DataRobot distribution prediction model trained on predictions from the DataRobot model.
        :param pulumi.Input[str] name: The name of the Registered Model.
        :param pulumi.Input[float] prediction_threshold: The prediction threshold for the model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Registered Model version to.
        :param pulumi.Input[str] version_name: The name of the Registered Model Version.
        """
        pulumi.set(__self__, "model_id", model_id)
        if compute_all_ts_intervals is not None:
            pulumi.set(__self__, "compute_all_ts_intervals", compute_all_ts_intervals)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if distribution_prediction_model_id is not None:
            pulumi.set(__self__, "distribution_prediction_model_id", distribution_prediction_model_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prediction_threshold is not None:
            pulumi.set(__self__, "prediction_threshold", prediction_threshold)
        if use_case_ids is not None:
            pulumi.set(__self__, "use_case_ids", use_case_ids)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Input[str]:
        """
        The ID of the DataRobot model for this Registered Model.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="computeAllTsIntervals")
    def compute_all_ts_intervals(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to compute all time series intervals (1-100 percentiles).
        """
        return pulumi.get(self, "compute_all_ts_intervals")

    @compute_all_ts_intervals.setter
    def compute_all_ts_intervals(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compute_all_ts_intervals", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Registered Model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="distributionPredictionModelId")
    def distribution_prediction_model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the DataRobot distribution prediction model trained on predictions from the DataRobot model.
        """
        return pulumi.get(self, "distribution_prediction_model_id")

    @distribution_prediction_model_id.setter
    def distribution_prediction_model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distribution_prediction_model_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Registered Model.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The prediction threshold for the model.
        """
        return pulumi.get(self, "prediction_threshold")

    @prediction_threshold.setter
    def prediction_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "prediction_threshold", value)

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Use Case IDs to add the Registered Model version to.
        """
        return pulumi.get(self, "use_case_ids")

    @use_case_ids.setter
    def use_case_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "use_case_ids", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Registered Model Version.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name", value)


@pulumi.input_type
class _RegisteredModelFromLeaderboardState:
    def __init__(__self__, *,
                 compute_all_ts_intervals: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 distribution_prediction_model_id: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 version_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RegisteredModelFromLeaderboard resources.
        :param pulumi.Input[bool] compute_all_ts_intervals: Whether to compute all time series intervals (1-100 percentiles).
        :param pulumi.Input[str] description: The description of the Registered Model.
        :param pulumi.Input[str] distribution_prediction_model_id: The ID of the DataRobot distribution prediction model trained on predictions from the DataRobot model.
        :param pulumi.Input[str] model_id: The ID of the DataRobot model for this Registered Model.
        :param pulumi.Input[str] name: The name of the Registered Model.
        :param pulumi.Input[float] prediction_threshold: The prediction threshold for the model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Registered Model version to.
        :param pulumi.Input[str] version_id: The ID of the Registered Model Version.
        :param pulumi.Input[str] version_name: The name of the Registered Model Version.
        """
        if compute_all_ts_intervals is not None:
            pulumi.set(__self__, "compute_all_ts_intervals", compute_all_ts_intervals)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if distribution_prediction_model_id is not None:
            pulumi.set(__self__, "distribution_prediction_model_id", distribution_prediction_model_id)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prediction_threshold is not None:
            pulumi.set(__self__, "prediction_threshold", prediction_threshold)
        if use_case_ids is not None:
            pulumi.set(__self__, "use_case_ids", use_case_ids)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter(name="computeAllTsIntervals")
    def compute_all_ts_intervals(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to compute all time series intervals (1-100 percentiles).
        """
        return pulumi.get(self, "compute_all_ts_intervals")

    @compute_all_ts_intervals.setter
    def compute_all_ts_intervals(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compute_all_ts_intervals", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Registered Model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="distributionPredictionModelId")
    def distribution_prediction_model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the DataRobot distribution prediction model trained on predictions from the DataRobot model.
        """
        return pulumi.get(self, "distribution_prediction_model_id")

    @distribution_prediction_model_id.setter
    def distribution_prediction_model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distribution_prediction_model_id", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the DataRobot model for this Registered Model.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Registered Model.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The prediction threshold for the model.
        """
        return pulumi.get(self, "prediction_threshold")

    @prediction_threshold.setter
    def prediction_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "prediction_threshold", value)

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Use Case IDs to add the Registered Model version to.
        """
        return pulumi.get(self, "use_case_ids")

    @use_case_ids.setter
    def use_case_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "use_case_ids", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Registered Model Version.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Registered Model Version.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name", value)


class RegisteredModelFromLeaderboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_all_ts_intervals: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 distribution_prediction_model_id: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        registered model from leaderboard

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] compute_all_ts_intervals: Whether to compute all time series intervals (1-100 percentiles).
        :param pulumi.Input[str] description: The description of the Registered Model.
        :param pulumi.Input[str] distribution_prediction_model_id: The ID of the DataRobot distribution prediction model trained on predictions from the DataRobot model.
        :param pulumi.Input[str] model_id: The ID of the DataRobot model for this Registered Model.
        :param pulumi.Input[str] name: The name of the Registered Model.
        :param pulumi.Input[float] prediction_threshold: The prediction threshold for the model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Registered Model version to.
        :param pulumi.Input[str] version_name: The name of the Registered Model Version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegisteredModelFromLeaderboardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        registered model from leaderboard

        :param str resource_name: The name of the resource.
        :param RegisteredModelFromLeaderboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegisteredModelFromLeaderboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_all_ts_intervals: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 distribution_prediction_model_id: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegisteredModelFromLeaderboardArgs.__new__(RegisteredModelFromLeaderboardArgs)

            __props__.__dict__["compute_all_ts_intervals"] = compute_all_ts_intervals
            __props__.__dict__["description"] = description
            __props__.__dict__["distribution_prediction_model_id"] = distribution_prediction_model_id
            if model_id is None and not opts.urn:
                raise TypeError("Missing required property 'model_id'")
            __props__.__dict__["model_id"] = model_id
            __props__.__dict__["name"] = name
            __props__.__dict__["prediction_threshold"] = prediction_threshold
            __props__.__dict__["use_case_ids"] = use_case_ids
            __props__.__dict__["version_name"] = version_name
            __props__.__dict__["version_id"] = None
        super(RegisteredModelFromLeaderboard, __self__).__init__(
            'datarobot:index/registeredModelFromLeaderboard:RegisteredModelFromLeaderboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute_all_ts_intervals: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            distribution_prediction_model_id: Optional[pulumi.Input[str]] = None,
            model_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            prediction_threshold: Optional[pulumi.Input[float]] = None,
            use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            version_id: Optional[pulumi.Input[str]] = None,
            version_name: Optional[pulumi.Input[str]] = None) -> 'RegisteredModelFromLeaderboard':
        """
        Get an existing RegisteredModelFromLeaderboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] compute_all_ts_intervals: Whether to compute all time series intervals (1-100 percentiles).
        :param pulumi.Input[str] description: The description of the Registered Model.
        :param pulumi.Input[str] distribution_prediction_model_id: The ID of the DataRobot distribution prediction model trained on predictions from the DataRobot model.
        :param pulumi.Input[str] model_id: The ID of the DataRobot model for this Registered Model.
        :param pulumi.Input[str] name: The name of the Registered Model.
        :param pulumi.Input[float] prediction_threshold: The prediction threshold for the model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Registered Model version to.
        :param pulumi.Input[str] version_id: The ID of the Registered Model Version.
        :param pulumi.Input[str] version_name: The name of the Registered Model Version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegisteredModelFromLeaderboardState.__new__(_RegisteredModelFromLeaderboardState)

        __props__.__dict__["compute_all_ts_intervals"] = compute_all_ts_intervals
        __props__.__dict__["description"] = description
        __props__.__dict__["distribution_prediction_model_id"] = distribution_prediction_model_id
        __props__.__dict__["model_id"] = model_id
        __props__.__dict__["name"] = name
        __props__.__dict__["prediction_threshold"] = prediction_threshold
        __props__.__dict__["use_case_ids"] = use_case_ids
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["version_name"] = version_name
        return RegisteredModelFromLeaderboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="computeAllTsIntervals")
    def compute_all_ts_intervals(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to compute all time series intervals (1-100 percentiles).
        """
        return pulumi.get(self, "compute_all_ts_intervals")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Registered Model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="distributionPredictionModelId")
    def distribution_prediction_model_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the DataRobot distribution prediction model trained on predictions from the DataRobot model.
        """
        return pulumi.get(self, "distribution_prediction_model_id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[str]:
        """
        The ID of the DataRobot model for this Registered Model.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Registered Model.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> pulumi.Output[Optional[float]]:
        """
        The prediction threshold for the model.
        """
        return pulumi.get(self, "prediction_threshold")

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of Use Case IDs to add the Registered Model version to.
        """
        return pulumi.get(self, "use_case_ids")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        The ID of the Registered Model Version.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[str]:
        """
        The name of the Registered Model Version.
        """
        return pulumi.get(self, "version_name")

