# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'ApplicationSourceFromTemplateResources',
    'ApplicationSourceFromTemplateRuntimeParameterValue',
    'ApplicationSourceResources',
    'ApplicationSourceRuntimeParameterValue',
    'BatchPredictionJobDefinitionCsvSettings',
    'BatchPredictionJobDefinitionIntakeSettings',
    'BatchPredictionJobDefinitionOutputSettings',
    'BatchPredictionJobDefinitionPredictionInstance',
    'BatchPredictionJobDefinitionSchedule',
    'BatchPredictionJobDefinitionTimeseriesSettings',
    'CustomJobRuntimeParameterValue',
    'CustomMetricBatch',
    'CustomMetricFromJobBatch',
    'CustomMetricFromJobParameterOverride',
    'CustomMetricFromJobSampleCount',
    'CustomMetricFromJobSchedule',
    'CustomMetricFromJobTimestamp',
    'CustomMetricFromJobValue',
    'CustomMetricJobRuntimeParameterValue',
    'CustomMetricSampleCount',
    'CustomMetricTimestamp',
    'CustomMetricValue',
    'CustomModelGuardConfiguration',
    'CustomModelGuardConfigurationIntervention',
    'CustomModelGuardConfigurationNemoInfo',
    'CustomModelOverallModerationConfiguration',
    'CustomModelRuntimeParameterValue',
    'CustomModelSourceRemoteRepository',
    'DatasourceParams',
    'DeploymentAssociationIdSettings',
    'DeploymentBatchMonitoringSettings',
    'DeploymentBiasAndFairnessSettings',
    'DeploymentChallengerModelsSettings',
    'DeploymentChallengerReplaySettings',
    'DeploymentDriftTrackingSettings',
    'DeploymentFeatureCacheSettings',
    'DeploymentFeatureCacheSettingsSchedule',
    'DeploymentHealthSettings',
    'DeploymentHealthSettingsAccuracy',
    'DeploymentHealthSettingsActualsTimeliness',
    'DeploymentHealthSettingsCustomMetrics',
    'DeploymentHealthSettingsCustomMetricsFailingCondition',
    'DeploymentHealthSettingsCustomMetricsWarningCondition',
    'DeploymentHealthSettingsDataDrift',
    'DeploymentHealthSettingsFairness',
    'DeploymentHealthSettingsPredictionsTimeliness',
    'DeploymentHealthSettingsService',
    'DeploymentPredictionIntervalsSettings',
    'DeploymentPredictionWarningSettings',
    'DeploymentPredictionWarningSettingsCustomBoundaries',
    'DeploymentPredictionsByForecastDateSettings',
    'DeploymentPredictionsDataCollectionSettings',
    'DeploymentPredictionsSettings',
    'DeploymentRetrainingPolicyAutopilotOptions',
    'DeploymentRetrainingPolicyProjectOptions',
    'DeploymentRetrainingPolicyTimeSeriesOptions',
    'DeploymentRetrainingPolicyTimeSeriesOptionsPeriodicity',
    'DeploymentRetrainingPolicyTrigger',
    'DeploymentRetrainingPolicyTriggerSchedule',
    'DeploymentRuntimeParameterValue',
    'DeploymentSegmentAnalysisSettings',
    'LlmBlueprintCustomModelLlmSettings',
    'LlmBlueprintLlmSettings',
    'LlmBlueprintVectorDatabaseSettings',
    'NotificationChannelCustomHeader',
    'NotificationChannelDrEntity',
    'VectorDatabaseChunkingParameters',
]

@pulumi.output_type
class ApplicationSourceFromTemplateResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceLabel":
            suggest = "resource_label"
        elif key == "sessionAffinity":
            suggest = "session_affinity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationSourceFromTemplateResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationSourceFromTemplateResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationSourceFromTemplateResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replicas: Optional[int] = None,
                 resource_label: Optional[str] = None,
                 session_affinity: Optional[bool] = None):
        """
        :param int replicas: The replicas for the Application Source.
        :param str resource_label: The resource label for the Application Source.
        :param bool session_affinity: The session affinity for the Application Source.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        """
        The replicas for the Application Source.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        """
        The resource label for the Application Source.
        """
        return pulumi.get(self, "resource_label")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[bool]:
        """
        The session affinity for the Application Source.
        """
        return pulumi.get(self, "session_affinity")


@pulumi.output_type
class ApplicationSourceFromTemplateRuntimeParameterValue(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 value: str):
        """
        :param str key: The name of the runtime parameter.
        :param str type: The type of the runtime parameter.
        :param str value: The value of the runtime parameter (type conversion is handled internally).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the runtime parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runtime parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the runtime parameter (type conversion is handled internally).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApplicationSourceResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceLabel":
            suggest = "resource_label"
        elif key == "sessionAffinity":
            suggest = "session_affinity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationSourceResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationSourceResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationSourceResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replicas: Optional[int] = None,
                 resource_label: Optional[str] = None,
                 session_affinity: Optional[bool] = None):
        """
        :param int replicas: The replicas for the Application Source.
        :param str resource_label: The resource label for the Application Source.
        :param bool session_affinity: The session affinity for the Application Source.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        """
        The replicas for the Application Source.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        """
        The resource label for the Application Source.
        """
        return pulumi.get(self, "resource_label")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[bool]:
        """
        The session affinity for the Application Source.
        """
        return pulumi.get(self, "session_affinity")


@pulumi.output_type
class ApplicationSourceRuntimeParameterValue(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 value: str):
        """
        :param str key: The name of the runtime parameter.
        :param str type: The type of the runtime parameter.
        :param str value: The value of the runtime parameter (type conversion is handled internally).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the runtime parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runtime parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the runtime parameter (type conversion is handled internally).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BatchPredictionJobDefinitionCsvSettings(dict):
    def __init__(__self__, *,
                 delimiter: Optional[str] = None,
                 encoding: Optional[str] = None,
                 quotechar: Optional[str] = None):
        """
        :param str delimiter: Fields are delimited by this character. Use the string tab to denote TSV (TAB separated values). Must be either a one-character string or the string tab.
        :param str encoding: Encoding for the CSV files.
        :param str quotechar: Fields containing the delimiter must be quoted using this character.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if quotechar is not None:
            pulumi.set(__self__, "quotechar", quotechar)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        Fields are delimited by this character. Use the string tab to denote TSV (TAB separated values). Must be either a one-character string or the string tab.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Encoding for the CSV files.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def quotechar(self) -> Optional[str]:
        """
        Fields containing the delimiter must be quoted using this character.
        """
        return pulumi.get(self, "quotechar")


@pulumi.output_type
class BatchPredictionJobDefinitionIntakeSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialId":
            suggest = "credential_id"
        elif key == "dataStoreId":
            suggest = "data_store_id"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "endpointUrl":
            suggest = "endpoint_url"
        elif key == "fetchSize":
            suggest = "fetch_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchPredictionJobDefinitionIntakeSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchPredictionJobDefinitionIntakeSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchPredictionJobDefinitionIntakeSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 catalog: Optional[str] = None,
                 credential_id: Optional[str] = None,
                 data_store_id: Optional[str] = None,
                 dataset_id: Optional[str] = None,
                 endpoint_url: Optional[str] = None,
                 fetch_size: Optional[int] = None,
                 file: Optional[str] = None,
                 query: Optional[str] = None,
                 schema: Optional[str] = None,
                 table: Optional[str] = None,
                 url: Optional[str] = None):
        """
        :param str type: Type of data source.
        :param str catalog: The name of specified database catalog for JDBC type.
        :param str credential_id: The ID of the credentials for S3 or JDBC data source.
        :param str data_store_id: The ID of the external data store connected to the JDBC data source.
        :param str dataset_id: The ID of the dataset to score for dataset type.
        :param str endpoint_url: Any non-default endpoint URL for S3 access.
        :param int fetch_size: Changing the fetchSize can be used to balance throughput and memory usage for JDBC type.
        :param str file: String path to file of scoring data for localFile type.
        :param str query: A self-supplied SELECT statement of the data set you wish to predict for JDBC type.
        :param str schema: The name of specified database schema for JDBC type.
        :param str table: The name of specified database table for JDBC type.
        :param str url: The URL to score (e.g.: s3://bucket/key) for S3 type.
        """
        pulumi.set(__self__, "type", type)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if data_store_id is not None:
            pulumi.set(__self__, "data_store_id", data_store_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if fetch_size is not None:
            pulumi.set(__self__, "fetch_size", fetch_size)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of data source.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def catalog(self) -> Optional[str]:
        """
        The name of specified database catalog for JDBC type.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[str]:
        """
        The ID of the credentials for S3 or JDBC data source.
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> Optional[str]:
        """
        The ID of the external data store connected to the JDBC data source.
        """
        return pulumi.get(self, "data_store_id")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        The ID of the dataset to score for dataset type.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[str]:
        """
        Any non-default endpoint URL for S3 access.
        """
        return pulumi.get(self, "endpoint_url")

    @property
    @pulumi.getter(name="fetchSize")
    def fetch_size(self) -> Optional[int]:
        """
        Changing the fetchSize can be used to balance throughput and memory usage for JDBC type.
        """
        return pulumi.get(self, "fetch_size")

    @property
    @pulumi.getter
    def file(self) -> Optional[str]:
        """
        String path to file of scoring data for localFile type.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        A self-supplied SELECT statement of the data set you wish to predict for JDBC type.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        The name of specified database schema for JDBC type.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def table(self) -> Optional[str]:
        """
        The name of specified database table for JDBC type.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL to score (e.g.: s3://bucket/key) for S3 type.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class BatchPredictionJobDefinitionOutputSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTableIfNotExists":
            suggest = "create_table_if_not_exists"
        elif key == "credentialId":
            suggest = "credential_id"
        elif key == "dataStoreId":
            suggest = "data_store_id"
        elif key == "endpointUrl":
            suggest = "endpoint_url"
        elif key == "statementType":
            suggest = "statement_type"
        elif key == "updateColumns":
            suggest = "update_columns"
        elif key == "whereColumns":
            suggest = "where_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchPredictionJobDefinitionOutputSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchPredictionJobDefinitionOutputSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchPredictionJobDefinitionOutputSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog: Optional[str] = None,
                 create_table_if_not_exists: Optional[bool] = None,
                 credential_id: Optional[str] = None,
                 data_store_id: Optional[str] = None,
                 endpoint_url: Optional[str] = None,
                 path: Optional[str] = None,
                 schema: Optional[str] = None,
                 statement_type: Optional[str] = None,
                 table: Optional[str] = None,
                 type: Optional[str] = None,
                 update_columns: Optional[Sequence[str]] = None,
                 url: Optional[str] = None,
                 where_columns: Optional[Sequence[str]] = None):
        """
        :param str catalog: The name of specified database catalog for JDBC type.
        :param bool create_table_if_not_exists: If no existing table is detected, attempt to create it before writing data for JDBC type.
        :param str credential_id: The ID of the credentials for S3 or JDBC data source.
        :param str data_store_id: The ID of the external data store connected to the JDBC data source.
        :param str endpoint_url: Any non-default endpoint URL for S3 access.
        :param str path: Path to save the scored data as CSV for localFile type.
        :param str schema: The name of specified database schema for JDBC type.
        :param str statement_type: The type of insertion statement to create for JDBC type.
        :param str table: The name of specified database table for JDBC type.
        :param str type: Type of output.
        :param Sequence[str] update_columns: A list of strings containing those column names to be updated for JDBC type.
        :param str url: The URL for storing the results (e.g.: s3://bucket/key) for S3 type.
        :param Sequence[str] where_columns: A list of strings containing those column names to be selected for JDBC type.
        """
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if create_table_if_not_exists is not None:
            pulumi.set(__self__, "create_table_if_not_exists", create_table_if_not_exists)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if data_store_id is not None:
            pulumi.set(__self__, "data_store_id", data_store_id)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if statement_type is not None:
            pulumi.set(__self__, "statement_type", statement_type)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_columns is not None:
            pulumi.set(__self__, "update_columns", update_columns)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if where_columns is not None:
            pulumi.set(__self__, "where_columns", where_columns)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[str]:
        """
        The name of specified database catalog for JDBC type.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter(name="createTableIfNotExists")
    def create_table_if_not_exists(self) -> Optional[bool]:
        """
        If no existing table is detected, attempt to create it before writing data for JDBC type.
        """
        return pulumi.get(self, "create_table_if_not_exists")

    @property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[str]:
        """
        The ID of the credentials for S3 or JDBC data source.
        """
        return pulumi.get(self, "credential_id")

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> Optional[str]:
        """
        The ID of the external data store connected to the JDBC data source.
        """
        return pulumi.get(self, "data_store_id")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[str]:
        """
        Any non-default endpoint URL for S3 access.
        """
        return pulumi.get(self, "endpoint_url")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to save the scored data as CSV for localFile type.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        The name of specified database schema for JDBC type.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="statementType")
    def statement_type(self) -> Optional[str]:
        """
        The type of insertion statement to create for JDBC type.
        """
        return pulumi.get(self, "statement_type")

    @property
    @pulumi.getter
    def table(self) -> Optional[str]:
        """
        The name of specified database table for JDBC type.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of output.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateColumns")
    def update_columns(self) -> Optional[Sequence[str]]:
        """
        A list of strings containing those column names to be updated for JDBC type.
        """
        return pulumi.get(self, "update_columns")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL for storing the results (e.g.: s3://bucket/key) for S3 type.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="whereColumns")
    def where_columns(self) -> Optional[Sequence[str]]:
        """
        A list of strings containing those column names to be selected for JDBC type.
        """
        return pulumi.get(self, "where_columns")


@pulumi.output_type
class BatchPredictionJobDefinitionPredictionInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "apiKey":
            suggest = "api_key"
        elif key == "datarobotKey":
            suggest = "datarobot_key"
        elif key == "sslEnabled":
            suggest = "ssl_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchPredictionJobDefinitionPredictionInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchPredictionJobDefinitionPredictionInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchPredictionJobDefinitionPredictionInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 api_key: Optional[str] = None,
                 datarobot_key: Optional[str] = None,
                 ssl_enabled: Optional[bool] = None):
        """
        :param str host_name: Hostname of the prediction instance.
        :param str api_key: By default, prediction requests will use the API key of the user that created the job. This allows you to make requests on behalf of other users.
        :param str datarobot_key: If running a job against a prediction instance in the Managed AI Cloud, you must provide the organization level DataRobot-Key.
        :param bool ssl_enabled: Set to false to run prediction requests from the batch prediction job without SSL. Defaults to true.
        """
        pulumi.set(__self__, "host_name", host_name)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if datarobot_key is not None:
            pulumi.set(__self__, "datarobot_key", datarobot_key)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        Hostname of the prediction instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        By default, prediction requests will use the API key of the user that created the job. This allows you to make requests on behalf of other users.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="datarobotKey")
    def datarobot_key(self) -> Optional[str]:
        """
        If running a job against a prediction instance in the Managed AI Cloud, you must provide the organization level DataRobot-Key.
        """
        return pulumi.get(self, "datarobot_key")

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[bool]:
        """
        Set to false to run prediction requests from the batch prediction job without SSL. Defaults to true.
        """
        return pulumi.get(self, "ssl_enabled")


@pulumi.output_type
class BatchPredictionJobDefinitionSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfMonths":
            suggest = "day_of_months"
        elif key == "dayOfWeeks":
            suggest = "day_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchPredictionJobDefinitionSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchPredictionJobDefinitionSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchPredictionJobDefinitionSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_months: Sequence[str],
                 day_of_weeks: Sequence[str],
                 hours: Sequence[str],
                 minutes: Sequence[str],
                 months: Sequence[str]):
        """
        :param Sequence[str] day_of_months: Days of the month when the job will run.
        :param Sequence[str] day_of_weeks: Days of the week when the job will run.
        :param Sequence[str] hours: Hours of the day when the job will run.
        :param Sequence[str] minutes: Minutes of the day when the job will run.
        :param Sequence[str] months: Months of the year when the job will run.
        """
        pulumi.set(__self__, "day_of_months", day_of_months)
        pulumi.set(__self__, "day_of_weeks", day_of_weeks)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "months", months)

    @property
    @pulumi.getter(name="dayOfMonths")
    def day_of_months(self) -> Sequence[str]:
        """
        Days of the month when the job will run.
        """
        return pulumi.get(self, "day_of_months")

    @property
    @pulumi.getter(name="dayOfWeeks")
    def day_of_weeks(self) -> Sequence[str]:
        """
        Days of the week when the job will run.
        """
        return pulumi.get(self, "day_of_weeks")

    @property
    @pulumi.getter
    def hours(self) -> Sequence[str]:
        """
        Hours of the day when the job will run.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Sequence[str]:
        """
        Minutes of the day when the job will run.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def months(self) -> Sequence[str]:
        """
        Months of the year when the job will run.
        """
        return pulumi.get(self, "months")


@pulumi.output_type
class BatchPredictionJobDefinitionTimeseriesSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forecastPoint":
            suggest = "forecast_point"
        elif key == "predictionsEndDate":
            suggest = "predictions_end_date"
        elif key == "predictionsStartDate":
            suggest = "predictions_start_date"
        elif key == "relaxKnownInAdvanceFeaturesCheck":
            suggest = "relax_known_in_advance_features_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchPredictionJobDefinitionTimeseriesSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchPredictionJobDefinitionTimeseriesSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchPredictionJobDefinitionTimeseriesSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forecast_point: Optional[str] = None,
                 predictions_end_date: Optional[str] = None,
                 predictions_start_date: Optional[str] = None,
                 relax_known_in_advance_features_check: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param str forecast_point: Forecast point for the dataset, used for the forecast predictions. May be passed if timeseries_settings.type=forecast.
        :param str predictions_end_date: End date for historical predictions. May be passed if timeseries_settings.type=historical.
        :param str predictions_start_date: Start date for historical predictions. May be passed if timeseries_settings.type=historical.
        :param bool relax_known_in_advance_features_check: If True, missing values in the known in advance features are allowed in the forecast window at the prediction time. Default is False.
        :param str type: Type of time-series prediction. Must be 'forecast' or 'historical'. Default is 'forecast'.
        """
        if forecast_point is not None:
            pulumi.set(__self__, "forecast_point", forecast_point)
        if predictions_end_date is not None:
            pulumi.set(__self__, "predictions_end_date", predictions_end_date)
        if predictions_start_date is not None:
            pulumi.set(__self__, "predictions_start_date", predictions_start_date)
        if relax_known_in_advance_features_check is not None:
            pulumi.set(__self__, "relax_known_in_advance_features_check", relax_known_in_advance_features_check)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="forecastPoint")
    def forecast_point(self) -> Optional[str]:
        """
        Forecast point for the dataset, used for the forecast predictions. May be passed if timeseries_settings.type=forecast.
        """
        return pulumi.get(self, "forecast_point")

    @property
    @pulumi.getter(name="predictionsEndDate")
    def predictions_end_date(self) -> Optional[str]:
        """
        End date for historical predictions. May be passed if timeseries_settings.type=historical.
        """
        return pulumi.get(self, "predictions_end_date")

    @property
    @pulumi.getter(name="predictionsStartDate")
    def predictions_start_date(self) -> Optional[str]:
        """
        Start date for historical predictions. May be passed if timeseries_settings.type=historical.
        """
        return pulumi.get(self, "predictions_start_date")

    @property
    @pulumi.getter(name="relaxKnownInAdvanceFeaturesCheck")
    def relax_known_in_advance_features_check(self) -> Optional[bool]:
        """
        If True, missing values in the known in advance features are allowed in the forecast window at the prediction time. Default is False.
        """
        return pulumi.get(self, "relax_known_in_advance_features_check")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of time-series prediction. Must be 'forecast' or 'historical'. Default is 'forecast'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomJobRuntimeParameterValue(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 value: str):
        """
        :param str key: The name of the runtime parameter.
        :param str type: The type of the runtime parameter.
        :param str value: The value of the runtime parameter (type conversion is handled internally).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the runtime parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runtime parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the runtime parameter (type conversion is handled internally).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CustomMetricBatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricBatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricBatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricBatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None):
        """
        :param str column_name: Column name.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column_name")


@pulumi.output_type
class CustomMetricFromJobBatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricFromJobBatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricFromJobBatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricFromJobBatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None):
        """
        :param str column_name: Column name.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column_name")


@pulumi.output_type
class CustomMetricFromJobParameterOverride(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 value: str):
        """
        :param str key: The name of the runtime parameter.
        :param str type: The type of the runtime parameter.
        :param str value: The value of the runtime parameter (type conversion is handled internally).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the runtime parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runtime parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the runtime parameter (type conversion is handled internally).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CustomMetricFromJobSampleCount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricFromJobSampleCount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricFromJobSampleCount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricFromJobSampleCount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: str):
        """
        :param str column_name: Column name.
        """
        pulumi.set(__self__, "column_name", column_name)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> str:
        """
        Column name.
        """
        return pulumi.get(self, "column_name")


@pulumi.output_type
class CustomMetricFromJobSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfMonths":
            suggest = "day_of_months"
        elif key == "dayOfWeeks":
            suggest = "day_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricFromJobSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricFromJobSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricFromJobSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_months: Sequence[str],
                 day_of_weeks: Sequence[str],
                 hours: Sequence[str],
                 minutes: Sequence[str],
                 months: Sequence[str]):
        """
        :param Sequence[str] day_of_months: Days of the month when the metric job will run.
        :param Sequence[str] day_of_weeks: Days of the week when the metric job will run.
        :param Sequence[str] hours: Hours of the day when the metric job will run.
        :param Sequence[str] minutes: Minutes of the day when the metric job will run.
        :param Sequence[str] months: Months of the year when the metric job will run.
        """
        pulumi.set(__self__, "day_of_months", day_of_months)
        pulumi.set(__self__, "day_of_weeks", day_of_weeks)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "months", months)

    @property
    @pulumi.getter(name="dayOfMonths")
    def day_of_months(self) -> Sequence[str]:
        """
        Days of the month when the metric job will run.
        """
        return pulumi.get(self, "day_of_months")

    @property
    @pulumi.getter(name="dayOfWeeks")
    def day_of_weeks(self) -> Sequence[str]:
        """
        Days of the week when the metric job will run.
        """
        return pulumi.get(self, "day_of_weeks")

    @property
    @pulumi.getter
    def hours(self) -> Sequence[str]:
        """
        Hours of the day when the metric job will run.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Sequence[str]:
        """
        Minutes of the day when the metric job will run.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def months(self) -> Sequence[str]:
        """
        Months of the year when the metric job will run.
        """
        return pulumi.get(self, "months")


@pulumi.output_type
class CustomMetricFromJobTimestamp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"
        elif key == "timeFormat":
            suggest = "time_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricFromJobTimestamp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricFromJobTimestamp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricFromJobTimestamp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None,
                 time_format: Optional[str] = None):
        """
        :param str column_name: Column name.
        :param str time_format: Format.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        Format.
        """
        return pulumi.get(self, "time_format")


@pulumi.output_type
class CustomMetricFromJobValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricFromJobValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricFromJobValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricFromJobValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None):
        """
        :param str column_name: Column name.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column_name")


@pulumi.output_type
class CustomMetricJobRuntimeParameterValue(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 value: str):
        """
        :param str key: The name of the runtime parameter.
        :param str type: The type of the runtime parameter.
        :param str value: The value of the runtime parameter (type conversion is handled internally).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the runtime parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runtime parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the runtime parameter (type conversion is handled internally).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CustomMetricSampleCount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricSampleCount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricSampleCount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricSampleCount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None):
        """
        :param str column_name: Column name.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column_name")


@pulumi.output_type
class CustomMetricTimestamp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"
        elif key == "timeFormat":
            suggest = "time_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricTimestamp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricTimestamp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricTimestamp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None,
                 time_format: Optional[str] = None):
        """
        :param str column_name: Column name.
        :param str time_format: Format.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        Format.
        """
        return pulumi.get(self, "time_format")


@pulumi.output_type
class CustomMetricValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomMetricValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomMetricValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomMetricValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None):
        """
        :param str column_name: Column name.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column_name")


@pulumi.output_type
class CustomModelGuardConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateName":
            suggest = "template_name"
        elif key == "deploymentId":
            suggest = "deployment_id"
        elif key == "inputColumnName":
            suggest = "input_column_name"
        elif key == "llmType":
            suggest = "llm_type"
        elif key == "nemoInfo":
            suggest = "nemo_info"
        elif key == "openaiApiBase":
            suggest = "openai_api_base"
        elif key == "openaiCredential":
            suggest = "openai_credential"
        elif key == "openaiDeploymentId":
            suggest = "openai_deployment_id"
        elif key == "outputColumnName":
            suggest = "output_column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomModelGuardConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomModelGuardConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomModelGuardConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intervention: 'outputs.CustomModelGuardConfigurationIntervention',
                 name: str,
                 stages: Sequence[str],
                 template_name: str,
                 deployment_id: Optional[str] = None,
                 input_column_name: Optional[str] = None,
                 llm_type: Optional[str] = None,
                 nemo_info: Optional['outputs.CustomModelGuardConfigurationNemoInfo'] = None,
                 openai_api_base: Optional[str] = None,
                 openai_credential: Optional[str] = None,
                 openai_deployment_id: Optional[str] = None,
                 output_column_name: Optional[str] = None):
        """
        :param 'CustomModelGuardConfigurationInterventionArgs' intervention: The intervention for the guard configuration.
        :param str name: The name of the guard configuration.
        :param Sequence[str] stages: The list of stages for the guard configuration.
        :param str template_name: The template name of the guard configuration.
        :param str deployment_id: The deployment ID of this guard.
        :param str input_column_name: The input column name of this guard.
        :param str llm_type: The LLM type for this guard.
        :param 'CustomModelGuardConfigurationNemoInfoArgs' nemo_info: Configuration info for NeMo guards.
        :param str openai_api_base: The OpenAI API base URL for this guard.
        :param str openai_credential: The ID of an OpenAI credential for this guard.
        :param str openai_deployment_id: The ID of an OpenAI deployment for this guard.
        :param str output_column_name: The output column name of this guard.
        """
        pulumi.set(__self__, "intervention", intervention)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "stages", stages)
        pulumi.set(__self__, "template_name", template_name)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if input_column_name is not None:
            pulumi.set(__self__, "input_column_name", input_column_name)
        if llm_type is not None:
            pulumi.set(__self__, "llm_type", llm_type)
        if nemo_info is not None:
            pulumi.set(__self__, "nemo_info", nemo_info)
        if openai_api_base is not None:
            pulumi.set(__self__, "openai_api_base", openai_api_base)
        if openai_credential is not None:
            pulumi.set(__self__, "openai_credential", openai_credential)
        if openai_deployment_id is not None:
            pulumi.set(__self__, "openai_deployment_id", openai_deployment_id)
        if output_column_name is not None:
            pulumi.set(__self__, "output_column_name", output_column_name)

    @property
    @pulumi.getter
    def intervention(self) -> 'outputs.CustomModelGuardConfigurationIntervention':
        """
        The intervention for the guard configuration.
        """
        return pulumi.get(self, "intervention")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the guard configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stages(self) -> Sequence[str]:
        """
        The list of stages for the guard configuration.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> str:
        """
        The template name of the guard configuration.
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[str]:
        """
        The deployment ID of this guard.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="inputColumnName")
    def input_column_name(self) -> Optional[str]:
        """
        The input column name of this guard.
        """
        return pulumi.get(self, "input_column_name")

    @property
    @pulumi.getter(name="llmType")
    def llm_type(self) -> Optional[str]:
        """
        The LLM type for this guard.
        """
        return pulumi.get(self, "llm_type")

    @property
    @pulumi.getter(name="nemoInfo")
    def nemo_info(self) -> Optional['outputs.CustomModelGuardConfigurationNemoInfo']:
        """
        Configuration info for NeMo guards.
        """
        return pulumi.get(self, "nemo_info")

    @property
    @pulumi.getter(name="openaiApiBase")
    def openai_api_base(self) -> Optional[str]:
        """
        The OpenAI API base URL for this guard.
        """
        return pulumi.get(self, "openai_api_base")

    @property
    @pulumi.getter(name="openaiCredential")
    def openai_credential(self) -> Optional[str]:
        """
        The ID of an OpenAI credential for this guard.
        """
        return pulumi.get(self, "openai_credential")

    @property
    @pulumi.getter(name="openaiDeploymentId")
    def openai_deployment_id(self) -> Optional[str]:
        """
        The ID of an OpenAI deployment for this guard.
        """
        return pulumi.get(self, "openai_deployment_id")

    @property
    @pulumi.getter(name="outputColumnName")
    def output_column_name(self) -> Optional[str]:
        """
        The output column name of this guard.
        """
        return pulumi.get(self, "output_column_name")


@pulumi.output_type
class CustomModelGuardConfigurationIntervention(dict):
    def __init__(__self__, *,
                 action: str,
                 condition: str,
                 message: Optional[str] = None):
        """
        :param str action: The action of the guard intervention.
        :param str condition: The JSON-encoded condition of the guard intervention. e.g. `{"comparand": 0.5, "comparator": "lessThan"}`
        :param str message: The message of the guard intervention.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action of the guard intervention.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        The JSON-encoded condition of the guard intervention. e.g. `{"comparand": 0.5, "comparator": "lessThan"}`
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The message of the guard intervention.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class CustomModelGuardConfigurationNemoInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockedTerms":
            suggest = "blocked_terms"
        elif key == "llmPrompts":
            suggest = "llm_prompts"
        elif key == "mainConfig":
            suggest = "main_config"
        elif key == "railsConfig":
            suggest = "rails_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomModelGuardConfigurationNemoInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomModelGuardConfigurationNemoInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomModelGuardConfigurationNemoInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Optional[str] = None,
                 blocked_terms: Optional[str] = None,
                 llm_prompts: Optional[str] = None,
                 main_config: Optional[str] = None,
                 rails_config: Optional[str] = None):
        """
        :param str actions: The actions for the NeMo information.
        :param str blocked_terms: NeMo guardrails blocked terms list.
        :param str llm_prompts: NeMo guardrails prompts.
        :param str main_config: Overall NeMo configuration YAML.
        :param str rails_config: NeMo guardrails configuration Colang.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if blocked_terms is not None:
            pulumi.set(__self__, "blocked_terms", blocked_terms)
        if llm_prompts is not None:
            pulumi.set(__self__, "llm_prompts", llm_prompts)
        if main_config is not None:
            pulumi.set(__self__, "main_config", main_config)
        if rails_config is not None:
            pulumi.set(__self__, "rails_config", rails_config)

    @property
    @pulumi.getter
    def actions(self) -> Optional[str]:
        """
        The actions for the NeMo information.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="blockedTerms")
    def blocked_terms(self) -> Optional[str]:
        """
        NeMo guardrails blocked terms list.
        """
        return pulumi.get(self, "blocked_terms")

    @property
    @pulumi.getter(name="llmPrompts")
    def llm_prompts(self) -> Optional[str]:
        """
        NeMo guardrails prompts.
        """
        return pulumi.get(self, "llm_prompts")

    @property
    @pulumi.getter(name="mainConfig")
    def main_config(self) -> Optional[str]:
        """
        Overall NeMo configuration YAML.
        """
        return pulumi.get(self, "main_config")

    @property
    @pulumi.getter(name="railsConfig")
    def rails_config(self) -> Optional[str]:
        """
        NeMo guardrails configuration Colang.
        """
        return pulumi.get(self, "rails_config")


@pulumi.output_type
class CustomModelOverallModerationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeoutAction":
            suggest = "timeout_action"
        elif key == "timeoutSec":
            suggest = "timeout_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomModelOverallModerationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomModelOverallModerationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomModelOverallModerationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeout_action: Optional[str] = None,
                 timeout_sec: Optional[int] = None):
        """
        :param str timeout_action: The timeout action of the overall moderation configuration.
        :param int timeout_sec: The timeout in seconds of the overall moderation configuration.
        """
        if timeout_action is not None:
            pulumi.set(__self__, "timeout_action", timeout_action)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> Optional[str]:
        """
        The timeout action of the overall moderation configuration.
        """
        return pulumi.get(self, "timeout_action")

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[int]:
        """
        The timeout in seconds of the overall moderation configuration.
        """
        return pulumi.get(self, "timeout_sec")


@pulumi.output_type
class CustomModelRuntimeParameterValue(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 value: str):
        """
        :param str key: The name of the runtime parameter.
        :param str type: The type of the runtime parameter.
        :param str value: The value of the runtime parameter (type conversion is handled internally).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the runtime parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runtime parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the runtime parameter (type conversion is handled internally).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CustomModelSourceRemoteRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourcePaths":
            suggest = "source_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomModelSourceRemoteRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomModelSourceRemoteRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomModelSourceRemoteRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 ref: str,
                 source_paths: Sequence[str]):
        """
        :param str id: The ID of the source remote repository.
        :param str ref: The reference of the source remote repository.
        :param Sequence[str] source_paths: The list of source paths in the source remote repository.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ref", ref)
        pulumi.set(__self__, "source_paths", source_paths)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the source remote repository.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ref(self) -> str:
        """
        The reference of the source remote repository.
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter(name="sourcePaths")
    def source_paths(self) -> Sequence[str]:
        """
        The list of source paths in the source remote repository.
        """
        return pulumi.get(self, "source_paths")


@pulumi.output_type
class DatasourceParams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreId":
            suggest = "data_store_id"
        elif key == "fetchSize":
            suggest = "fetch_size"
        elif key == "partitionColumn":
            suggest = "partition_column"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasourceParams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasourceParams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasourceParams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_id: str,
                 catalog: Optional[str] = None,
                 fetch_size: Optional[int] = None,
                 partition_column: Optional[str] = None,
                 path: Optional[str] = None,
                 query: Optional[str] = None,
                 schema: Optional[str] = None,
                 table: Optional[str] = None):
        """
        :param str data_store_id: The id of the DataStore.
        :param str catalog: The Catalog name in the database if supported.
        :param int fetch_size: A user specified fetch size in the range [1, 20000]. By default a fetchSize will be assigned to balance throughput and memory usage.
        :param str partition_column: The name of the partition column.
        :param str path: The user-specified path for BLOB storage.
        :param str query: The user specified SQL query.
        :param str schema: The name of the schema associated with the table.
        :param str table: The name of specified database table.
        """
        pulumi.set(__self__, "data_store_id", data_store_id)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if fetch_size is not None:
            pulumi.set(__self__, "fetch_size", fetch_size)
        if partition_column is not None:
            pulumi.set(__self__, "partition_column", partition_column)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> str:
        """
        The id of the DataStore.
        """
        return pulumi.get(self, "data_store_id")

    @property
    @pulumi.getter
    def catalog(self) -> Optional[str]:
        """
        The Catalog name in the database if supported.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter(name="fetchSize")
    def fetch_size(self) -> Optional[int]:
        """
        A user specified fetch size in the range [1, 20000]. By default a fetchSize will be assigned to balance throughput and memory usage.
        """
        return pulumi.get(self, "fetch_size")

    @property
    @pulumi.getter(name="partitionColumn")
    def partition_column(self) -> Optional[str]:
        """
        The name of the partition column.
        """
        return pulumi.get(self, "partition_column")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The user-specified path for BLOB storage.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        The user specified SQL query.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        The name of the schema associated with the table.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def table(self) -> Optional[str]:
        """
        The name of specified database table.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class DeploymentAssociationIdSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoGenerateId":
            suggest = "auto_generate_id"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "requiredInPredictionRequests":
            suggest = "required_in_prediction_requests"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentAssociationIdSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentAssociationIdSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentAssociationIdSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_generate_id: Optional[bool] = None,
                 column_names: Optional[Sequence[str]] = None,
                 required_in_prediction_requests: Optional[bool] = None):
        """
        :param bool auto_generate_id: Whether to auto generate ID.
        :param Sequence[str] column_names: Name of the columns to be used as association ID, currently only support a list of one string.
        :param bool required_in_prediction_requests: Whether the association ID column is required in prediction requests.
        """
        if auto_generate_id is not None:
            pulumi.set(__self__, "auto_generate_id", auto_generate_id)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if required_in_prediction_requests is not None:
            pulumi.set(__self__, "required_in_prediction_requests", required_in_prediction_requests)

    @property
    @pulumi.getter(name="autoGenerateId")
    def auto_generate_id(self) -> Optional[bool]:
        """
        Whether to auto generate ID.
        """
        return pulumi.get(self, "auto_generate_id")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[str]]:
        """
        Name of the columns to be used as association ID, currently only support a list of one string.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="requiredInPredictionRequests")
    def required_in_prediction_requests(self) -> Optional[bool]:
        """
        Whether the association ID column is required in prediction requests.
        """
        return pulumi.get(self, "required_in_prediction_requests")


@pulumi.output_type
class DeploymentBatchMonitoringSettings(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: If batch monitoring is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If batch monitoring is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DeploymentBiasAndFairnessSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fairnessMetricSet":
            suggest = "fairness_metric_set"
        elif key == "fairnessThreshold":
            suggest = "fairness_threshold"
        elif key == "preferableTargetValue":
            suggest = "preferable_target_value"
        elif key == "protectedFeatures":
            suggest = "protected_features"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentBiasAndFairnessSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentBiasAndFairnessSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentBiasAndFairnessSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fairness_metric_set: str,
                 fairness_threshold: float,
                 preferable_target_value: bool,
                 protected_features: Sequence[str]):
        """
        :param str fairness_metric_set: A set of fairness metrics to use for calculating fairness.
        :param float fairness_threshold: Threshold value of the fairness metric. Cannot be less than 0 or greater than 1.
        :param bool preferable_target_value: A target value that should be treated as a positive outcome for the prediction.
        :param Sequence[str] protected_features: A list of features to mark as protected.
        """
        pulumi.set(__self__, "fairness_metric_set", fairness_metric_set)
        pulumi.set(__self__, "fairness_threshold", fairness_threshold)
        pulumi.set(__self__, "preferable_target_value", preferable_target_value)
        pulumi.set(__self__, "protected_features", protected_features)

    @property
    @pulumi.getter(name="fairnessMetricSet")
    def fairness_metric_set(self) -> str:
        """
        A set of fairness metrics to use for calculating fairness.
        """
        return pulumi.get(self, "fairness_metric_set")

    @property
    @pulumi.getter(name="fairnessThreshold")
    def fairness_threshold(self) -> float:
        """
        Threshold value of the fairness metric. Cannot be less than 0 or greater than 1.
        """
        return pulumi.get(self, "fairness_threshold")

    @property
    @pulumi.getter(name="preferableTargetValue")
    def preferable_target_value(self) -> bool:
        """
        A target value that should be treated as a positive outcome for the prediction.
        """
        return pulumi.get(self, "preferable_target_value")

    @property
    @pulumi.getter(name="protectedFeatures")
    def protected_features(self) -> Sequence[str]:
        """
        A list of features to mark as protected.
        """
        return pulumi.get(self, "protected_features")


@pulumi.output_type
class DeploymentChallengerModelsSettings(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Is 'True' if challenger models is enabled for this deployment.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Is 'True' if challenger models is enabled for this deployment.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DeploymentChallengerReplaySettings(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: If challenger replay is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If challenger replay is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DeploymentDriftTrackingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureDriftEnabled":
            suggest = "feature_drift_enabled"
        elif key == "featureSelection":
            suggest = "feature_selection"
        elif key == "targetDriftEnabled":
            suggest = "target_drift_enabled"
        elif key == "trackedFeatures":
            suggest = "tracked_features"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentDriftTrackingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentDriftTrackingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentDriftTrackingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_drift_enabled: Optional[bool] = None,
                 feature_selection: Optional[str] = None,
                 target_drift_enabled: Optional[bool] = None,
                 tracked_features: Optional[Sequence[str]] = None):
        """
        :param bool feature_drift_enabled: If feature drift tracking is to be turned on.
        :param str feature_selection: The feature selection method to be used for drift tracking.
        :param bool target_drift_enabled: If target drift tracking is to be turned on.
        :param Sequence[str] tracked_features: List of features to be tracked for drift.
        """
        if feature_drift_enabled is not None:
            pulumi.set(__self__, "feature_drift_enabled", feature_drift_enabled)
        if feature_selection is not None:
            pulumi.set(__self__, "feature_selection", feature_selection)
        if target_drift_enabled is not None:
            pulumi.set(__self__, "target_drift_enabled", target_drift_enabled)
        if tracked_features is not None:
            pulumi.set(__self__, "tracked_features", tracked_features)

    @property
    @pulumi.getter(name="featureDriftEnabled")
    def feature_drift_enabled(self) -> Optional[bool]:
        """
        If feature drift tracking is to be turned on.
        """
        return pulumi.get(self, "feature_drift_enabled")

    @property
    @pulumi.getter(name="featureSelection")
    def feature_selection(self) -> Optional[str]:
        """
        The feature selection method to be used for drift tracking.
        """
        return pulumi.get(self, "feature_selection")

    @property
    @pulumi.getter(name="targetDriftEnabled")
    def target_drift_enabled(self) -> Optional[bool]:
        """
        If target drift tracking is to be turned on.
        """
        return pulumi.get(self, "target_drift_enabled")

    @property
    @pulumi.getter(name="trackedFeatures")
    def tracked_features(self) -> Optional[Sequence[str]]:
        """
        List of features to be tracked for drift.
        """
        return pulumi.get(self, "tracked_features")


@pulumi.output_type
class DeploymentFeatureCacheSettings(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 fetching: Optional[bool] = None,
                 schedule: Optional['outputs.DeploymentFeatureCacheSettingsSchedule'] = None):
        """
        :param bool enabled: If feature cache is enabled for this Deployment.
        :param bool fetching: If feature cache fetching is enabled.
        :param 'DeploymentFeatureCacheSettingsScheduleArgs' schedule: Defines the feature cache schedule.
        """
        pulumi.set(__self__, "enabled", enabled)
        if fetching is not None:
            pulumi.set(__self__, "fetching", fetching)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If feature cache is enabled for this Deployment.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def fetching(self) -> Optional[bool]:
        """
        If feature cache fetching is enabled.
        """
        return pulumi.get(self, "fetching")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.DeploymentFeatureCacheSettingsSchedule']:
        """
        Defines the feature cache schedule.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class DeploymentFeatureCacheSettingsSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfMonths":
            suggest = "day_of_months"
        elif key == "dayOfWeeks":
            suggest = "day_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentFeatureCacheSettingsSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentFeatureCacheSettingsSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentFeatureCacheSettingsSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_months: Sequence[str],
                 day_of_weeks: Sequence[str],
                 hours: Sequence[str],
                 minutes: Sequence[str],
                 months: Sequence[str]):
        """
        :param Sequence[str] day_of_months: Days of the month.
        :param Sequence[str] day_of_weeks: Days of the week.
        :param Sequence[str] hours: Hours of the day.
        :param Sequence[str] minutes: Minutes of the day.
        :param Sequence[str] months: Months of the year.
        """
        pulumi.set(__self__, "day_of_months", day_of_months)
        pulumi.set(__self__, "day_of_weeks", day_of_weeks)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "months", months)

    @property
    @pulumi.getter(name="dayOfMonths")
    def day_of_months(self) -> Sequence[str]:
        """
        Days of the month.
        """
        return pulumi.get(self, "day_of_months")

    @property
    @pulumi.getter(name="dayOfWeeks")
    def day_of_weeks(self) -> Sequence[str]:
        """
        Days of the week.
        """
        return pulumi.get(self, "day_of_weeks")

    @property
    @pulumi.getter
    def hours(self) -> Sequence[str]:
        """
        Hours of the day.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Sequence[str]:
        """
        Minutes of the day.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def months(self) -> Sequence[str]:
        """
        Months of the year.
        """
        return pulumi.get(self, "months")


@pulumi.output_type
class DeploymentHealthSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actualsTimeliness":
            suggest = "actuals_timeliness"
        elif key == "customMetrics":
            suggest = "custom_metrics"
        elif key == "dataDrift":
            suggest = "data_drift"
        elif key == "predictionsTimeliness":
            suggest = "predictions_timeliness"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accuracy: Optional['outputs.DeploymentHealthSettingsAccuracy'] = None,
                 actuals_timeliness: Optional['outputs.DeploymentHealthSettingsActualsTimeliness'] = None,
                 custom_metrics: Optional['outputs.DeploymentHealthSettingsCustomMetrics'] = None,
                 data_drift: Optional['outputs.DeploymentHealthSettingsDataDrift'] = None,
                 fairness: Optional['outputs.DeploymentHealthSettingsFairness'] = None,
                 predictions_timeliness: Optional['outputs.DeploymentHealthSettingsPredictionsTimeliness'] = None,
                 service: Optional['outputs.DeploymentHealthSettingsService'] = None):
        """
        :param 'DeploymentHealthSettingsAccuracyArgs' accuracy: The accuracy health settings for this Deployment.
        :param 'DeploymentHealthSettingsActualsTimelinessArgs' actuals_timeliness: The actuals timeliness health settings for this Deployment.
        :param 'DeploymentHealthSettingsCustomMetricsArgs' custom_metrics: The custom metrics health settings for this Deployment.
        :param 'DeploymentHealthSettingsDataDriftArgs' data_drift: The data drift health settings for this Deployment.
        :param 'DeploymentHealthSettingsFairnessArgs' fairness: The fairness health settings for this Deployment.
        :param 'DeploymentHealthSettingsPredictionsTimelinessArgs' predictions_timeliness: The predictions timeliness health settings for this Deployment.
        :param 'DeploymentHealthSettingsServiceArgs' service: The service health settings for this Deployment.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if actuals_timeliness is not None:
            pulumi.set(__self__, "actuals_timeliness", actuals_timeliness)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if data_drift is not None:
            pulumi.set(__self__, "data_drift", data_drift)
        if fairness is not None:
            pulumi.set(__self__, "fairness", fairness)
        if predictions_timeliness is not None:
            pulumi.set(__self__, "predictions_timeliness", predictions_timeliness)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional['outputs.DeploymentHealthSettingsAccuracy']:
        """
        The accuracy health settings for this Deployment.
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter(name="actualsTimeliness")
    def actuals_timeliness(self) -> Optional['outputs.DeploymentHealthSettingsActualsTimeliness']:
        """
        The actuals timeliness health settings for this Deployment.
        """
        return pulumi.get(self, "actuals_timeliness")

    @property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional['outputs.DeploymentHealthSettingsCustomMetrics']:
        """
        The custom metrics health settings for this Deployment.
        """
        return pulumi.get(self, "custom_metrics")

    @property
    @pulumi.getter(name="dataDrift")
    def data_drift(self) -> Optional['outputs.DeploymentHealthSettingsDataDrift']:
        """
        The data drift health settings for this Deployment.
        """
        return pulumi.get(self, "data_drift")

    @property
    @pulumi.getter
    def fairness(self) -> Optional['outputs.DeploymentHealthSettingsFairness']:
        """
        The fairness health settings for this Deployment.
        """
        return pulumi.get(self, "fairness")

    @property
    @pulumi.getter(name="predictionsTimeliness")
    def predictions_timeliness(self) -> Optional['outputs.DeploymentHealthSettingsPredictionsTimeliness']:
        """
        The predictions timeliness health settings for this Deployment.
        """
        return pulumi.get(self, "predictions_timeliness")

    @property
    @pulumi.getter
    def service(self) -> Optional['outputs.DeploymentHealthSettingsService']:
        """
        The service health settings for this Deployment.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class DeploymentHealthSettingsAccuracy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchCount":
            suggest = "batch_count"
        elif key == "failingThreshold":
            suggest = "failing_threshold"
        elif key == "warningThreshold":
            suggest = "warning_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsAccuracy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsAccuracy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsAccuracy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_count: Optional[int] = None,
                 failing_threshold: Optional[float] = None,
                 measurement: Optional[str] = None,
                 metric: Optional[str] = None,
                 warning_threshold: Optional[float] = None):
        """
        :param int batch_count: The batch count for the accuracy health settings.
        :param float failing_threshold: The failing threshold for the accuracy health settings.
        :param str measurement: The measurement for the accuracy health settings.
        :param str metric: The metric for the accuracy health settings.
        :param float warning_threshold: The warning threshold for the accuracy health settings.
        """
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if failing_threshold is not None:
            pulumi.set(__self__, "failing_threshold", failing_threshold)
        if measurement is not None:
            pulumi.set(__self__, "measurement", measurement)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if warning_threshold is not None:
            pulumi.set(__self__, "warning_threshold", warning_threshold)

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        """
        The batch count for the accuracy health settings.
        """
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="failingThreshold")
    def failing_threshold(self) -> Optional[float]:
        """
        The failing threshold for the accuracy health settings.
        """
        return pulumi.get(self, "failing_threshold")

    @property
    @pulumi.getter
    def measurement(self) -> Optional[str]:
        """
        The measurement for the accuracy health settings.
        """
        return pulumi.get(self, "measurement")

    @property
    @pulumi.getter
    def metric(self) -> Optional[str]:
        """
        The metric for the accuracy health settings.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> Optional[float]:
        """
        The warning threshold for the accuracy health settings.
        """
        return pulumi.get(self, "warning_threshold")


@pulumi.output_type
class DeploymentHealthSettingsActualsTimeliness(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedFrequency":
            suggest = "expected_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsActualsTimeliness. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsActualsTimeliness.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsActualsTimeliness.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 expected_frequency: Optional[str] = None):
        """
        :param bool enabled: If acutals timeliness is enabled for this Deployment.
        :param str expected_frequency: The expected frequency for the actuals timeliness health settings.
        """
        pulumi.set(__self__, "enabled", enabled)
        if expected_frequency is not None:
            pulumi.set(__self__, "expected_frequency", expected_frequency)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If acutals timeliness is enabled for this Deployment.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expectedFrequency")
    def expected_frequency(self) -> Optional[str]:
        """
        The expected frequency for the actuals timeliness health settings.
        """
        return pulumi.get(self, "expected_frequency")


@pulumi.output_type
class DeploymentHealthSettingsCustomMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failingConditions":
            suggest = "failing_conditions"
        elif key == "warningConditions":
            suggest = "warning_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsCustomMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsCustomMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsCustomMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failing_conditions: Optional[Sequence['outputs.DeploymentHealthSettingsCustomMetricsFailingCondition']] = None,
                 warning_conditions: Optional[Sequence['outputs.DeploymentHealthSettingsCustomMetricsWarningCondition']] = None):
        """
        :param Sequence['DeploymentHealthSettingsCustomMetricsFailingConditionArgs'] failing_conditions: The failing conditions for the custom metrics health settings.
        :param Sequence['DeploymentHealthSettingsCustomMetricsWarningConditionArgs'] warning_conditions: The warning conditions for the custom metrics health settings.
        """
        if failing_conditions is not None:
            pulumi.set(__self__, "failing_conditions", failing_conditions)
        if warning_conditions is not None:
            pulumi.set(__self__, "warning_conditions", warning_conditions)

    @property
    @pulumi.getter(name="failingConditions")
    def failing_conditions(self) -> Optional[Sequence['outputs.DeploymentHealthSettingsCustomMetricsFailingCondition']]:
        """
        The failing conditions for the custom metrics health settings.
        """
        return pulumi.get(self, "failing_conditions")

    @property
    @pulumi.getter(name="warningConditions")
    def warning_conditions(self) -> Optional[Sequence['outputs.DeploymentHealthSettingsCustomMetricsWarningCondition']]:
        """
        The warning conditions for the custom metrics health settings.
        """
        return pulumi.get(self, "warning_conditions")


@pulumi.output_type
class DeploymentHealthSettingsCustomMetricsFailingCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compareOperator":
            suggest = "compare_operator"
        elif key == "metricId":
            suggest = "metric_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsCustomMetricsFailingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsCustomMetricsFailingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsCustomMetricsFailingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compare_operator: str,
                 metric_id: str,
                 threshold: float):
        """
        :param str compare_operator: The compare operator for the failing condition of the custom metrics health settings.
        :param str metric_id: The metric ID for the failing condition of the custom metrics health settings.
        :param float threshold: The threshold for the failing condition of the custom metrics health settings.
        """
        pulumi.set(__self__, "compare_operator", compare_operator)
        pulumi.set(__self__, "metric_id", metric_id)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="compareOperator")
    def compare_operator(self) -> str:
        """
        The compare operator for the failing condition of the custom metrics health settings.
        """
        return pulumi.get(self, "compare_operator")

    @property
    @pulumi.getter(name="metricId")
    def metric_id(self) -> str:
        """
        The metric ID for the failing condition of the custom metrics health settings.
        """
        return pulumi.get(self, "metric_id")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The threshold for the failing condition of the custom metrics health settings.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class DeploymentHealthSettingsCustomMetricsWarningCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compareOperator":
            suggest = "compare_operator"
        elif key == "metricId":
            suggest = "metric_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsCustomMetricsWarningCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsCustomMetricsWarningCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsCustomMetricsWarningCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compare_operator: str,
                 metric_id: str,
                 threshold: float):
        """
        :param str compare_operator: The compare operator for the warning condition of the custom metrics health settings.
        :param str metric_id: The metric ID for the warning condition of the custom metrics health settings.
        :param float threshold: The threshold for the warning condition of the custom metrics health settings.
        """
        pulumi.set(__self__, "compare_operator", compare_operator)
        pulumi.set(__self__, "metric_id", metric_id)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="compareOperator")
    def compare_operator(self) -> str:
        """
        The compare operator for the warning condition of the custom metrics health settings.
        """
        return pulumi.get(self, "compare_operator")

    @property
    @pulumi.getter(name="metricId")
    def metric_id(self) -> str:
        """
        The metric ID for the warning condition of the custom metrics health settings.
        """
        return pulumi.get(self, "metric_id")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The threshold for the warning condition of the custom metrics health settings.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class DeploymentHealthSettingsDataDrift(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchCount":
            suggest = "batch_count"
        elif key == "driftThreshold":
            suggest = "drift_threshold"
        elif key == "excludeFeatures":
            suggest = "exclude_features"
        elif key == "highImportanceFailingCount":
            suggest = "high_importance_failing_count"
        elif key == "highImportanceWarningCount":
            suggest = "high_importance_warning_count"
        elif key == "importanceThreshold":
            suggest = "importance_threshold"
        elif key == "lowImportanceFailingCount":
            suggest = "low_importance_failing_count"
        elif key == "lowImportanceWarningCount":
            suggest = "low_importance_warning_count"
        elif key == "starredFeatures":
            suggest = "starred_features"
        elif key == "timeInterval":
            suggest = "time_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsDataDrift. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsDataDrift.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsDataDrift.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_count: Optional[int] = None,
                 drift_threshold: Optional[float] = None,
                 exclude_features: Optional[Sequence[str]] = None,
                 high_importance_failing_count: Optional[int] = None,
                 high_importance_warning_count: Optional[int] = None,
                 importance_threshold: Optional[float] = None,
                 low_importance_failing_count: Optional[int] = None,
                 low_importance_warning_count: Optional[int] = None,
                 starred_features: Optional[Sequence[str]] = None,
                 time_interval: Optional[str] = None):
        """
        :param int batch_count: The batch count for the data drift health settings.
        :param float drift_threshold: The drift threshold for the data drift health settings.
        :param Sequence[str] exclude_features: The exclude features for the data drift health settings.
        :param int high_importance_failing_count: The high importance failing count for the data drift health settings.
        :param int high_importance_warning_count: The high importance warning count for the data drift health settings.
        :param float importance_threshold: The importance threshold for the data drift health settings.
        :param int low_importance_failing_count: The low importance failing count for the data drift health settings.
        :param int low_importance_warning_count: The low importance warning count for the data drift health settings.
        :param Sequence[str] starred_features: The starred features for the data drift health settings.
        :param str time_interval: The time interval for the data drift health settings.
        """
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if drift_threshold is not None:
            pulumi.set(__self__, "drift_threshold", drift_threshold)
        if exclude_features is not None:
            pulumi.set(__self__, "exclude_features", exclude_features)
        if high_importance_failing_count is not None:
            pulumi.set(__self__, "high_importance_failing_count", high_importance_failing_count)
        if high_importance_warning_count is not None:
            pulumi.set(__self__, "high_importance_warning_count", high_importance_warning_count)
        if importance_threshold is not None:
            pulumi.set(__self__, "importance_threshold", importance_threshold)
        if low_importance_failing_count is not None:
            pulumi.set(__self__, "low_importance_failing_count", low_importance_failing_count)
        if low_importance_warning_count is not None:
            pulumi.set(__self__, "low_importance_warning_count", low_importance_warning_count)
        if starred_features is not None:
            pulumi.set(__self__, "starred_features", starred_features)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        """
        The batch count for the data drift health settings.
        """
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="driftThreshold")
    def drift_threshold(self) -> Optional[float]:
        """
        The drift threshold for the data drift health settings.
        """
        return pulumi.get(self, "drift_threshold")

    @property
    @pulumi.getter(name="excludeFeatures")
    def exclude_features(self) -> Optional[Sequence[str]]:
        """
        The exclude features for the data drift health settings.
        """
        return pulumi.get(self, "exclude_features")

    @property
    @pulumi.getter(name="highImportanceFailingCount")
    def high_importance_failing_count(self) -> Optional[int]:
        """
        The high importance failing count for the data drift health settings.
        """
        return pulumi.get(self, "high_importance_failing_count")

    @property
    @pulumi.getter(name="highImportanceWarningCount")
    def high_importance_warning_count(self) -> Optional[int]:
        """
        The high importance warning count for the data drift health settings.
        """
        return pulumi.get(self, "high_importance_warning_count")

    @property
    @pulumi.getter(name="importanceThreshold")
    def importance_threshold(self) -> Optional[float]:
        """
        The importance threshold for the data drift health settings.
        """
        return pulumi.get(self, "importance_threshold")

    @property
    @pulumi.getter(name="lowImportanceFailingCount")
    def low_importance_failing_count(self) -> Optional[int]:
        """
        The low importance failing count for the data drift health settings.
        """
        return pulumi.get(self, "low_importance_failing_count")

    @property
    @pulumi.getter(name="lowImportanceWarningCount")
    def low_importance_warning_count(self) -> Optional[int]:
        """
        The low importance warning count for the data drift health settings.
        """
        return pulumi.get(self, "low_importance_warning_count")

    @property
    @pulumi.getter(name="starredFeatures")
    def starred_features(self) -> Optional[Sequence[str]]:
        """
        The starred features for the data drift health settings.
        """
        return pulumi.get(self, "starred_features")

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[str]:
        """
        The time interval for the data drift health settings.
        """
        return pulumi.get(self, "time_interval")


@pulumi.output_type
class DeploymentHealthSettingsFairness(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protectedClassFailingCount":
            suggest = "protected_class_failing_count"
        elif key == "protectedClassWarningCount":
            suggest = "protected_class_warning_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsFairness. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsFairness.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsFairness.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protected_class_failing_count: Optional[int] = None,
                 protected_class_warning_count: Optional[int] = None):
        """
        :param int protected_class_failing_count: The protected class failing count for the fairness health settings.
        :param int protected_class_warning_count: The protected class warning count for the fairness health settings.
        """
        if protected_class_failing_count is not None:
            pulumi.set(__self__, "protected_class_failing_count", protected_class_failing_count)
        if protected_class_warning_count is not None:
            pulumi.set(__self__, "protected_class_warning_count", protected_class_warning_count)

    @property
    @pulumi.getter(name="protectedClassFailingCount")
    def protected_class_failing_count(self) -> Optional[int]:
        """
        The protected class failing count for the fairness health settings.
        """
        return pulumi.get(self, "protected_class_failing_count")

    @property
    @pulumi.getter(name="protectedClassWarningCount")
    def protected_class_warning_count(self) -> Optional[int]:
        """
        The protected class warning count for the fairness health settings.
        """
        return pulumi.get(self, "protected_class_warning_count")


@pulumi.output_type
class DeploymentHealthSettingsPredictionsTimeliness(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedFrequency":
            suggest = "expected_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsPredictionsTimeliness. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsPredictionsTimeliness.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsPredictionsTimeliness.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 expected_frequency: Optional[str] = None):
        """
        :param bool enabled: If predictions timeliness is enabled for this Deployment.
        :param str expected_frequency: The expected frequency for the predictions timeliness health settings.
        """
        pulumi.set(__self__, "enabled", enabled)
        if expected_frequency is not None:
            pulumi.set(__self__, "expected_frequency", expected_frequency)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If predictions timeliness is enabled for this Deployment.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expectedFrequency")
    def expected_frequency(self) -> Optional[str]:
        """
        The expected frequency for the predictions timeliness health settings.
        """
        return pulumi.get(self, "expected_frequency")


@pulumi.output_type
class DeploymentHealthSettingsService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchCount":
            suggest = "batch_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentHealthSettingsService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentHealthSettingsService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentHealthSettingsService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_count: int):
        """
        :param int batch_count: The batch count for the service health settings.
        """
        pulumi.set(__self__, "batch_count", batch_count)

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> int:
        """
        The batch count for the service health settings.
        """
        return pulumi.get(self, "batch_count")


@pulumi.output_type
class DeploymentPredictionIntervalsSettings(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 percentiles: Optional[Sequence[int]] = None):
        """
        :param bool enabled: Whether prediction intervals are enabled for this deployment.
        :param Sequence[int] percentiles: List of enabled prediction intervals’ sizes for this deployment.
        """
        pulumi.set(__self__, "enabled", enabled)
        if percentiles is not None:
            pulumi.set(__self__, "percentiles", percentiles)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether prediction intervals are enabled for this deployment.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def percentiles(self) -> Optional[Sequence[int]]:
        """
        List of enabled prediction intervals’ sizes for this deployment.
        """
        return pulumi.get(self, "percentiles")


@pulumi.output_type
class DeploymentPredictionWarningSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customBoundaries":
            suggest = "custom_boundaries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPredictionWarningSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPredictionWarningSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPredictionWarningSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 custom_boundaries: Optional['outputs.DeploymentPredictionWarningSettingsCustomBoundaries'] = None):
        """
        :param bool enabled: If target prediction warning is enabled for this Deployment.
        :param 'DeploymentPredictionWarningSettingsCustomBoundariesArgs' custom_boundaries: The custom boundaries for prediction warnings.
        """
        pulumi.set(__self__, "enabled", enabled)
        if custom_boundaries is not None:
            pulumi.set(__self__, "custom_boundaries", custom_boundaries)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If target prediction warning is enabled for this Deployment.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="customBoundaries")
    def custom_boundaries(self) -> Optional['outputs.DeploymentPredictionWarningSettingsCustomBoundaries']:
        """
        The custom boundaries for prediction warnings.
        """
        return pulumi.get(self, "custom_boundaries")


@pulumi.output_type
class DeploymentPredictionWarningSettingsCustomBoundaries(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lowerBoundary":
            suggest = "lower_boundary"
        elif key == "upperBoundary":
            suggest = "upper_boundary"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPredictionWarningSettingsCustomBoundaries. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPredictionWarningSettingsCustomBoundaries.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPredictionWarningSettingsCustomBoundaries.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lower_boundary: Optional[float] = None,
                 upper_boundary: Optional[float] = None):
        """
        :param float lower_boundary: All predictions less than provided value will be considered anomalous.
        :param float upper_boundary: All predictions greater than provided value will be considered anomalous.
        """
        if lower_boundary is not None:
            pulumi.set(__self__, "lower_boundary", lower_boundary)
        if upper_boundary is not None:
            pulumi.set(__self__, "upper_boundary", upper_boundary)

    @property
    @pulumi.getter(name="lowerBoundary")
    def lower_boundary(self) -> Optional[float]:
        """
        All predictions less than provided value will be considered anomalous.
        """
        return pulumi.get(self, "lower_boundary")

    @property
    @pulumi.getter(name="upperBoundary")
    def upper_boundary(self) -> Optional[float]:
        """
        All predictions greater than provided value will be considered anomalous.
        """
        return pulumi.get(self, "upper_boundary")


@pulumi.output_type
class DeploymentPredictionsByForecastDateSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"
        elif key == "datetimeFormat":
            suggest = "datetime_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPredictionsByForecastDateSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPredictionsByForecastDateSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPredictionsByForecastDateSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 column_name: Optional[str] = None,
                 datetime_format: Optional[str] = None):
        """
        :param bool enabled: Is ’True’ if predictions by forecast date is enabled for this deployment.
        :param str column_name: The column name in prediction datasets to be used as forecast date.
        :param str datetime_format: The datetime format of the forecast date column in prediction datasets.
        """
        pulumi.set(__self__, "enabled", enabled)
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Is ’True’ if predictions by forecast date is enabled for this deployment.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        The column name in prediction datasets to be used as forecast date.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        """
        The datetime format of the forecast date column in prediction datasets.
        """
        return pulumi.get(self, "datetime_format")


@pulumi.output_type
class DeploymentPredictionsDataCollectionSettings(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: If predictions data collections is enabled for this Deployment.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If predictions data collections is enabled for this Deployment.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DeploymentPredictionsSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxComputes":
            suggest = "max_computes"
        elif key == "minComputes":
            suggest = "min_computes"
        elif key == "resourceBundleId":
            suggest = "resource_bundle_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPredictionsSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPredictionsSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPredictionsSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_computes: Optional[int] = None,
                 min_computes: Optional[int] = None,
                 resource_bundle_id: Optional[str] = None):
        """
        :param int max_computes: The maximum number of computes to use for predictions.
        :param int min_computes: The minimum number of computes to use for predictions.
        :param str resource_bundle_id: The resource bundle ID to use for predictions.
        """
        if max_computes is not None:
            pulumi.set(__self__, "max_computes", max_computes)
        if min_computes is not None:
            pulumi.set(__self__, "min_computes", min_computes)
        if resource_bundle_id is not None:
            pulumi.set(__self__, "resource_bundle_id", resource_bundle_id)

    @property
    @pulumi.getter(name="maxComputes")
    def max_computes(self) -> Optional[int]:
        """
        The maximum number of computes to use for predictions.
        """
        return pulumi.get(self, "max_computes")

    @property
    @pulumi.getter(name="minComputes")
    def min_computes(self) -> Optional[int]:
        """
        The minimum number of computes to use for predictions.
        """
        return pulumi.get(self, "min_computes")

    @property
    @pulumi.getter(name="resourceBundleId")
    def resource_bundle_id(self) -> Optional[str]:
        """
        The resource bundle ID to use for predictions.
        """
        return pulumi.get(self, "resource_bundle_id")


@pulumi.output_type
class DeploymentRetrainingPolicyAutopilotOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blendBestModels":
            suggest = "blend_best_models"
        elif key == "runLeakageRemovedFeatureList":
            suggest = "run_leakage_removed_feature_list"
        elif key == "scoringCodeOnly":
            suggest = "scoring_code_only"
        elif key == "shapOnlyMode":
            suggest = "shap_only_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentRetrainingPolicyAutopilotOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentRetrainingPolicyAutopilotOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentRetrainingPolicyAutopilotOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blend_best_models: Optional[bool] = None,
                 mode: Optional[str] = None,
                 run_leakage_removed_feature_list: Optional[bool] = None,
                 scoring_code_only: Optional[bool] = None,
                 shap_only_mode: Optional[bool] = None):
        """
        :param bool blend_best_models: Blend best models during Autopilot run. This option is not supported in SHAP-only mode.
        :param str mode: The autopiltot mode.
        :param bool run_leakage_removed_feature_list: Run Autopilot on Leakage Removed feature list (if exists).
        :param bool scoring_code_only: Keep only models that can be converted to scorable java code during Autopilot run.
        :param bool shap_only_mode: Include only models with SHAP value support.
        """
        if blend_best_models is not None:
            pulumi.set(__self__, "blend_best_models", blend_best_models)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if run_leakage_removed_feature_list is not None:
            pulumi.set(__self__, "run_leakage_removed_feature_list", run_leakage_removed_feature_list)
        if scoring_code_only is not None:
            pulumi.set(__self__, "scoring_code_only", scoring_code_only)
        if shap_only_mode is not None:
            pulumi.set(__self__, "shap_only_mode", shap_only_mode)

    @property
    @pulumi.getter(name="blendBestModels")
    def blend_best_models(self) -> Optional[bool]:
        """
        Blend best models during Autopilot run. This option is not supported in SHAP-only mode.
        """
        return pulumi.get(self, "blend_best_models")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The autopiltot mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="runLeakageRemovedFeatureList")
    def run_leakage_removed_feature_list(self) -> Optional[bool]:
        """
        Run Autopilot on Leakage Removed feature list (if exists).
        """
        return pulumi.get(self, "run_leakage_removed_feature_list")

    @property
    @pulumi.getter(name="scoringCodeOnly")
    def scoring_code_only(self) -> Optional[bool]:
        """
        Keep only models that can be converted to scorable java code during Autopilot run.
        """
        return pulumi.get(self, "scoring_code_only")

    @property
    @pulumi.getter(name="shapOnlyMode")
    def shap_only_mode(self) -> Optional[bool]:
        """
        Include only models with SHAP value support.
        """
        return pulumi.get(self, "shap_only_mode")


@pulumi.output_type
class DeploymentRetrainingPolicyProjectOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvMethod":
            suggest = "cv_method"
        elif key == "holdoutPct":
            suggest = "holdout_pct"
        elif key == "validationPct":
            suggest = "validation_pct"
        elif key == "validationType":
            suggest = "validation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentRetrainingPolicyProjectOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentRetrainingPolicyProjectOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentRetrainingPolicyProjectOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cv_method: Optional[str] = None,
                 holdout_pct: Optional[float] = None,
                 metric: Optional[str] = None,
                 reps: Optional[float] = None,
                 validation_pct: Optional[float] = None,
                 validation_type: Optional[str] = None):
        """
        :param str cv_method: The partitioning method for projects used to build new models.
        :param float holdout_pct: The percentage of dataset to assign to holdout set in projects used to build new models.
        :param str metric: The model selection metric in projects used to build new models.
        :param float reps: The number of cross validation folds to use for projects used to build new models.
        :param float validation_pct: The percentage of dataset to assign to validation set in projects used to build new models.
        :param str validation_type: The validation type for projects used to build new models.
        """
        if cv_method is not None:
            pulumi.set(__self__, "cv_method", cv_method)
        if holdout_pct is not None:
            pulumi.set(__self__, "holdout_pct", holdout_pct)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if reps is not None:
            pulumi.set(__self__, "reps", reps)
        if validation_pct is not None:
            pulumi.set(__self__, "validation_pct", validation_pct)
        if validation_type is not None:
            pulumi.set(__self__, "validation_type", validation_type)

    @property
    @pulumi.getter(name="cvMethod")
    def cv_method(self) -> Optional[str]:
        """
        The partitioning method for projects used to build new models.
        """
        return pulumi.get(self, "cv_method")

    @property
    @pulumi.getter(name="holdoutPct")
    def holdout_pct(self) -> Optional[float]:
        """
        The percentage of dataset to assign to holdout set in projects used to build new models.
        """
        return pulumi.get(self, "holdout_pct")

    @property
    @pulumi.getter
    def metric(self) -> Optional[str]:
        """
        The model selection metric in projects used to build new models.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def reps(self) -> Optional[float]:
        """
        The number of cross validation folds to use for projects used to build new models.
        """
        return pulumi.get(self, "reps")

    @property
    @pulumi.getter(name="validationPct")
    def validation_pct(self) -> Optional[float]:
        """
        The percentage of dataset to assign to validation set in projects used to build new models.
        """
        return pulumi.get(self, "validation_pct")

    @property
    @pulumi.getter(name="validationType")
    def validation_type(self) -> Optional[str]:
        """
        The validation type for projects used to build new models.
        """
        return pulumi.get(self, "validation_type")


@pulumi.output_type
class DeploymentRetrainingPolicyTimeSeriesOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "calendarId":
            suggest = "calendar_id"
        elif key == "differencingMethod":
            suggest = "differencing_method"
        elif key == "exponentiallyWeightedMovingAlpha":
            suggest = "exponentially_weighted_moving_alpha"
        elif key == "treatAsExponential":
            suggest = "treat_as_exponential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentRetrainingPolicyTimeSeriesOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentRetrainingPolicyTimeSeriesOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentRetrainingPolicyTimeSeriesOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 calendar_id: Optional[str] = None,
                 differencing_method: Optional[str] = None,
                 exponentially_weighted_moving_alpha: Optional[float] = None,
                 periodicities: Optional[Sequence['outputs.DeploymentRetrainingPolicyTimeSeriesOptionsPeriodicity']] = None,
                 treat_as_exponential: Optional[str] = None):
        """
        :param str calendar_id: The ID of the calendar to be used in this project.
        :param str differencing_method: For time series projects only. Used to specify which differencing method to apply if the data is stationary. For classification problems simple and seasonal are not allowed. Parameter periodicities must be specified if seasonal is chosen. Defaults to auto.
        :param float exponentially_weighted_moving_alpha: Discount factor (alpha) used for exponentially weighted moving features.
        :param Sequence['DeploymentRetrainingPolicyTimeSeriesOptionsPeriodicityArgs'] periodicities: A list of periodicities for time series projects only. For classification problems periodicities are not allowed. If this is provided, parameter 'differencing*method' will default to 'seasonal' if not provided or 'auto'.
        :param str treat_as_exponential: For time series projects only. Used to specify whether to treat data as exponential trend and apply transformations like log-transform. For classification problems always is not allowed. Defaults to auto.
        """
        if calendar_id is not None:
            pulumi.set(__self__, "calendar_id", calendar_id)
        if differencing_method is not None:
            pulumi.set(__self__, "differencing_method", differencing_method)
        if exponentially_weighted_moving_alpha is not None:
            pulumi.set(__self__, "exponentially_weighted_moving_alpha", exponentially_weighted_moving_alpha)
        if periodicities is not None:
            pulumi.set(__self__, "periodicities", periodicities)
        if treat_as_exponential is not None:
            pulumi.set(__self__, "treat_as_exponential", treat_as_exponential)

    @property
    @pulumi.getter(name="calendarId")
    def calendar_id(self) -> Optional[str]:
        """
        The ID of the calendar to be used in this project.
        """
        return pulumi.get(self, "calendar_id")

    @property
    @pulumi.getter(name="differencingMethod")
    def differencing_method(self) -> Optional[str]:
        """
        For time series projects only. Used to specify which differencing method to apply if the data is stationary. For classification problems simple and seasonal are not allowed. Parameter periodicities must be specified if seasonal is chosen. Defaults to auto.
        """
        return pulumi.get(self, "differencing_method")

    @property
    @pulumi.getter(name="exponentiallyWeightedMovingAlpha")
    def exponentially_weighted_moving_alpha(self) -> Optional[float]:
        """
        Discount factor (alpha) used for exponentially weighted moving features.
        """
        return pulumi.get(self, "exponentially_weighted_moving_alpha")

    @property
    @pulumi.getter
    def periodicities(self) -> Optional[Sequence['outputs.DeploymentRetrainingPolicyTimeSeriesOptionsPeriodicity']]:
        """
        A list of periodicities for time series projects only. For classification problems periodicities are not allowed. If this is provided, parameter 'differencing*method' will default to 'seasonal' if not provided or 'auto'.
        """
        return pulumi.get(self, "periodicities")

    @property
    @pulumi.getter(name="treatAsExponential")
    def treat_as_exponential(self) -> Optional[str]:
        """
        For time series projects only. Used to specify whether to treat data as exponential trend and apply transformations like log-transform. For classification problems always is not allowed. Defaults to auto.
        """
        return pulumi.get(self, "treat_as_exponential")


@pulumi.output_type
class DeploymentRetrainingPolicyTimeSeriesOptionsPeriodicity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeSteps":
            suggest = "time_steps"
        elif key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentRetrainingPolicyTimeSeriesOptionsPeriodicity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentRetrainingPolicyTimeSeriesOptionsPeriodicity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentRetrainingPolicyTimeSeriesOptionsPeriodicity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_steps: int,
                 time_unit: str):
        """
        :param int time_steps: The number of time steps.
        :param str time_unit: The time unit or ROW if windowsBasisUnit is ROW
        """
        pulumi.set(__self__, "time_steps", time_steps)
        pulumi.set(__self__, "time_unit", time_unit)

    @property
    @pulumi.getter(name="timeSteps")
    def time_steps(self) -> int:
        """
        The number of time steps.
        """
        return pulumi.get(self, "time_steps")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        """
        The time unit or ROW if windowsBasisUnit is ROW
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class DeploymentRetrainingPolicyTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customJobId":
            suggest = "custom_job_id"
        elif key == "minIntervalBetweenRuns":
            suggest = "min_interval_between_runs"
        elif key == "statusDeclinesToFailing":
            suggest = "status_declines_to_failing"
        elif key == "statusDeclinesToWarning":
            suggest = "status_declines_to_warning"
        elif key == "statusStillInDecline":
            suggest = "status_still_in_decline"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentRetrainingPolicyTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentRetrainingPolicyTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentRetrainingPolicyTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_job_id: Optional[str] = None,
                 min_interval_between_runs: Optional[str] = None,
                 schedule: Optional['outputs.DeploymentRetrainingPolicyTriggerSchedule'] = None,
                 status_declines_to_failing: Optional[bool] = None,
                 status_declines_to_warning: Optional[bool] = None,
                 status_still_in_decline: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param str custom_job_id: Custom job ID for the retraining policy.
        :param str min_interval_between_runs: Minimal interval between policy runs in ISO 8601 duration string.
        :param 'DeploymentRetrainingPolicyTriggerScheduleArgs' schedule: Schedule for the retraining policy.
        :param bool status_declines_to_failing: Identifies when trigger type is based on deployment a health status, whether the policy will run when health status declines to failing.
        :param bool status_declines_to_warning: Identifies when trigger type is based on deployment a health status, whether the policy will run when health status declines to warning.
        :param bool status_still_in_decline: Identifies when trigger type is based on deployment a health status, whether the policy will run when health status still in decline.
        :param str type: Type of retraining policy trigger.
        """
        if custom_job_id is not None:
            pulumi.set(__self__, "custom_job_id", custom_job_id)
        if min_interval_between_runs is not None:
            pulumi.set(__self__, "min_interval_between_runs", min_interval_between_runs)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if status_declines_to_failing is not None:
            pulumi.set(__self__, "status_declines_to_failing", status_declines_to_failing)
        if status_declines_to_warning is not None:
            pulumi.set(__self__, "status_declines_to_warning", status_declines_to_warning)
        if status_still_in_decline is not None:
            pulumi.set(__self__, "status_still_in_decline", status_still_in_decline)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customJobId")
    def custom_job_id(self) -> Optional[str]:
        """
        Custom job ID for the retraining policy.
        """
        return pulumi.get(self, "custom_job_id")

    @property
    @pulumi.getter(name="minIntervalBetweenRuns")
    def min_interval_between_runs(self) -> Optional[str]:
        """
        Minimal interval between policy runs in ISO 8601 duration string.
        """
        return pulumi.get(self, "min_interval_between_runs")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.DeploymentRetrainingPolicyTriggerSchedule']:
        """
        Schedule for the retraining policy.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="statusDeclinesToFailing")
    def status_declines_to_failing(self) -> Optional[bool]:
        """
        Identifies when trigger type is based on deployment a health status, whether the policy will run when health status declines to failing.
        """
        return pulumi.get(self, "status_declines_to_failing")

    @property
    @pulumi.getter(name="statusDeclinesToWarning")
    def status_declines_to_warning(self) -> Optional[bool]:
        """
        Identifies when trigger type is based on deployment a health status, whether the policy will run when health status declines to warning.
        """
        return pulumi.get(self, "status_declines_to_warning")

    @property
    @pulumi.getter(name="statusStillInDecline")
    def status_still_in_decline(self) -> Optional[bool]:
        """
        Identifies when trigger type is based on deployment a health status, whether the policy will run when health status still in decline.
        """
        return pulumi.get(self, "status_still_in_decline")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of retraining policy trigger.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DeploymentRetrainingPolicyTriggerSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfMonths":
            suggest = "day_of_months"
        elif key == "dayOfWeeks":
            suggest = "day_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentRetrainingPolicyTriggerSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentRetrainingPolicyTriggerSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentRetrainingPolicyTriggerSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_months: Sequence[str],
                 day_of_weeks: Sequence[str],
                 hours: Sequence[str],
                 minutes: Sequence[str],
                 months: Sequence[str]):
        """
        :param Sequence[str] day_of_months: Days of the month when the job will run.
        :param Sequence[str] day_of_weeks: Days of the week when the job will run.
        :param Sequence[str] hours: Hours of the day when the job will run.
        :param Sequence[str] minutes: Minutes of the day when the job will run.
        :param Sequence[str] months: Months of the year when the job will run.
        """
        pulumi.set(__self__, "day_of_months", day_of_months)
        pulumi.set(__self__, "day_of_weeks", day_of_weeks)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "months", months)

    @property
    @pulumi.getter(name="dayOfMonths")
    def day_of_months(self) -> Sequence[str]:
        """
        Days of the month when the job will run.
        """
        return pulumi.get(self, "day_of_months")

    @property
    @pulumi.getter(name="dayOfWeeks")
    def day_of_weeks(self) -> Sequence[str]:
        """
        Days of the week when the job will run.
        """
        return pulumi.get(self, "day_of_weeks")

    @property
    @pulumi.getter
    def hours(self) -> Sequence[str]:
        """
        Hours of the day when the job will run.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Sequence[str]:
        """
        Minutes of the day when the job will run.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def months(self) -> Sequence[str]:
        """
        Months of the year when the job will run.
        """
        return pulumi.get(self, "months")


@pulumi.output_type
class DeploymentRuntimeParameterValue(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 value: str):
        """
        :param str key: The name of the runtime parameter.
        :param str type: The type of the runtime parameter.
        :param str value: The value of the runtime parameter (type conversion is handled internally).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the runtime parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the runtime parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the runtime parameter (type conversion is handled internally).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DeploymentSegmentAnalysisSettings(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 attributes: Optional[Sequence[str]] = None):
        """
        :param bool enabled: Set to 'True' if segment analysis is enabled for this deployment.
        :param Sequence[str] attributes: A list of strings that gives the segment attributes selected for tracking.
        """
        pulumi.set(__self__, "enabled", enabled)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Set to 'True' if segment analysis is enabled for this deployment.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Sequence[str]]:
        """
        A list of strings that gives the segment attributes selected for tracking.
        """
        return pulumi.get(self, "attributes")


@pulumi.output_type
class LlmBlueprintCustomModelLlmSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalLlmContextSize":
            suggest = "external_llm_context_size"
        elif key == "systemPrompt":
            suggest = "system_prompt"
        elif key == "validationId":
            suggest = "validation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LlmBlueprintCustomModelLlmSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LlmBlueprintCustomModelLlmSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LlmBlueprintCustomModelLlmSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_llm_context_size: Optional[int] = None,
                 system_prompt: Optional[str] = None,
                 validation_id: Optional[str] = None):
        """
        :param int external_llm_context_size: The external LLM's context size, in tokens. This value is only used for pruning documents supplied to the LLM when a vector database is associated with the LLM blueprint. It does not affect the external LLM's actual context size in any way and is not supplied to the LLM.
        :param str system_prompt: System prompt guides the style of the LLM response. It is a 'universal' prompt, prepended to all individual prompts.
        :param str validation_id: The validation ID of the custom model LLM.
        """
        if external_llm_context_size is not None:
            pulumi.set(__self__, "external_llm_context_size", external_llm_context_size)
        if system_prompt is not None:
            pulumi.set(__self__, "system_prompt", system_prompt)
        if validation_id is not None:
            pulumi.set(__self__, "validation_id", validation_id)

    @property
    @pulumi.getter(name="externalLlmContextSize")
    def external_llm_context_size(self) -> Optional[int]:
        """
        The external LLM's context size, in tokens. This value is only used for pruning documents supplied to the LLM when a vector database is associated with the LLM blueprint. It does not affect the external LLM's actual context size in any way and is not supplied to the LLM.
        """
        return pulumi.get(self, "external_llm_context_size")

    @property
    @pulumi.getter(name="systemPrompt")
    def system_prompt(self) -> Optional[str]:
        """
        System prompt guides the style of the LLM response. It is a 'universal' prompt, prepended to all individual prompts.
        """
        return pulumi.get(self, "system_prompt")

    @property
    @pulumi.getter(name="validationId")
    def validation_id(self) -> Optional[str]:
        """
        The validation ID of the custom model LLM.
        """
        return pulumi.get(self, "validation_id")


@pulumi.output_type
class LlmBlueprintLlmSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCompletionLength":
            suggest = "max_completion_length"
        elif key == "systemPrompt":
            suggest = "system_prompt"
        elif key == "topP":
            suggest = "top_p"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LlmBlueprintLlmSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LlmBlueprintLlmSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LlmBlueprintLlmSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_completion_length: Optional[int] = None,
                 system_prompt: Optional[str] = None,
                 temperature: Optional[float] = None,
                 top_p: Optional[float] = None):
        """
        :param int max_completion_length: The maximum number of tokens allowed in the completion. The combined count of this value and prompt tokens must be below the model's maximum context size, where prompt token count is comprised of system prompt, user prompt, recent chat history, and vector database citations.
        :param str system_prompt: Guides the style of the LLM response. It is a 'universal' prompt, prepended to all individual prompts.
        :param float temperature: Controls the randomness of model output, where higher values return more diverse output and lower values return more deterministic results.
        :param float top_p: Threshold that controls the selection of words included in the response, based on a cumulative probability cutoff for token selection. Higher numbers return more diverse options for outputs.
        """
        if max_completion_length is not None:
            pulumi.set(__self__, "max_completion_length", max_completion_length)
        if system_prompt is not None:
            pulumi.set(__self__, "system_prompt", system_prompt)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)

    @property
    @pulumi.getter(name="maxCompletionLength")
    def max_completion_length(self) -> Optional[int]:
        """
        The maximum number of tokens allowed in the completion. The combined count of this value and prompt tokens must be below the model's maximum context size, where prompt token count is comprised of system prompt, user prompt, recent chat history, and vector database citations.
        """
        return pulumi.get(self, "max_completion_length")

    @property
    @pulumi.getter(name="systemPrompt")
    def system_prompt(self) -> Optional[str]:
        """
        Guides the style of the LLM response. It is a 'universal' prompt, prepended to all individual prompts.
        """
        return pulumi.get(self, "system_prompt")

    @property
    @pulumi.getter
    def temperature(self) -> Optional[float]:
        """
        Controls the randomness of model output, where higher values return more diverse output and lower values return more deterministic results.
        """
        return pulumi.get(self, "temperature")

    @property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[float]:
        """
        Threshold that controls the selection of words included in the response, based on a cumulative probability cutoff for token selection. Higher numbers return more diverse options for outputs.
        """
        return pulumi.get(self, "top_p")


@pulumi.output_type
class LlmBlueprintVectorDatabaseSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxDocumentsRetrievedPerPrompt":
            suggest = "max_documents_retrieved_per_prompt"
        elif key == "maxTokens":
            suggest = "max_tokens"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LlmBlueprintVectorDatabaseSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LlmBlueprintVectorDatabaseSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LlmBlueprintVectorDatabaseSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_documents_retrieved_per_prompt: Optional[int] = None,
                 max_tokens: Optional[int] = None):
        """
        :param int max_documents_retrieved_per_prompt: The maximum number of documents to retrieve from the Vector Database.
        :param int max_tokens: The maximum number of tokens to retrieve from the Vector Database.
        """
        if max_documents_retrieved_per_prompt is not None:
            pulumi.set(__self__, "max_documents_retrieved_per_prompt", max_documents_retrieved_per_prompt)
        if max_tokens is not None:
            pulumi.set(__self__, "max_tokens", max_tokens)

    @property
    @pulumi.getter(name="maxDocumentsRetrievedPerPrompt")
    def max_documents_retrieved_per_prompt(self) -> Optional[int]:
        """
        The maximum number of documents to retrieve from the Vector Database.
        """
        return pulumi.get(self, "max_documents_retrieved_per_prompt")

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> Optional[int]:
        """
        The maximum number of tokens to retrieve from the Vector Database.
        """
        return pulumi.get(self, "max_tokens")


@pulumi.output_type
class NotificationChannelCustomHeader(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the header.
        :param str value: The value of the header.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the header.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the header.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NotificationChannelDrEntity(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str id: The ID of the DataRobot entity.
        :param str name: The name of the entity.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the DataRobot entity.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the entity.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VectorDatabaseChunkingParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkOverlapPercentage":
            suggest = "chunk_overlap_percentage"
        elif key == "chunkSize":
            suggest = "chunk_size"
        elif key == "chunkingMethod":
            suggest = "chunking_method"
        elif key == "embeddingModel":
            suggest = "embedding_model"
        elif key == "isSeparatorRegex":
            suggest = "is_separator_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VectorDatabaseChunkingParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VectorDatabaseChunkingParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VectorDatabaseChunkingParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chunk_overlap_percentage: Optional[int] = None,
                 chunk_size: Optional[int] = None,
                 chunking_method: Optional[str] = None,
                 embedding_model: Optional[str] = None,
                 is_separator_regex: Optional[bool] = None,
                 separators: Optional[Sequence[str]] = None):
        """
        :param int chunk_overlap_percentage: The percentage of overlap between chunks.
        :param int chunk_size: The size of the chunks.
        :param str chunking_method: The method used to chunk the data.
        :param str embedding_model: The id of the Embedding Model.
        :param bool is_separator_regex: Whether the separator is a regex.
        :param Sequence[str] separators: The separators used to split the data.
        """
        if chunk_overlap_percentage is not None:
            pulumi.set(__self__, "chunk_overlap_percentage", chunk_overlap_percentage)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if chunking_method is not None:
            pulumi.set(__self__, "chunking_method", chunking_method)
        if embedding_model is not None:
            pulumi.set(__self__, "embedding_model", embedding_model)
        if is_separator_regex is not None:
            pulumi.set(__self__, "is_separator_regex", is_separator_regex)
        if separators is not None:
            pulumi.set(__self__, "separators", separators)

    @property
    @pulumi.getter(name="chunkOverlapPercentage")
    def chunk_overlap_percentage(self) -> Optional[int]:
        """
        The percentage of overlap between chunks.
        """
        return pulumi.get(self, "chunk_overlap_percentage")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[int]:
        """
        The size of the chunks.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter(name="chunkingMethod")
    def chunking_method(self) -> Optional[str]:
        """
        The method used to chunk the data.
        """
        return pulumi.get(self, "chunking_method")

    @property
    @pulumi.getter(name="embeddingModel")
    def embedding_model(self) -> Optional[str]:
        """
        The id of the Embedding Model.
        """
        return pulumi.get(self, "embedding_model")

    @property
    @pulumi.getter(name="isSeparatorRegex")
    def is_separator_regex(self) -> Optional[bool]:
        """
        Whether the separator is a regex.
        """
        return pulumi.get(self, "is_separator_regex")

    @property
    @pulumi.getter
    def separators(self) -> Optional[Sequence[str]]:
        """
        The separators used to split the data.
        """
        return pulumi.get(self, "separators")


