# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LlmBlueprintArgs', 'LlmBlueprint']

@pulumi.input_type
class LlmBlueprintArgs:
    def __init__(__self__, *,
                 playground_id: pulumi.Input[str],
                 custom_model_llm_settings: Optional[pulumi.Input['LlmBlueprintCustomModelLlmSettingsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 llm_id: Optional[pulumi.Input[str]] = None,
                 llm_settings: Optional[pulumi.Input['LlmBlueprintLlmSettingsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prompt_type: Optional[pulumi.Input[str]] = None,
                 vector_database_id: Optional[pulumi.Input[str]] = None,
                 vector_database_settings: Optional[pulumi.Input['LlmBlueprintVectorDatabaseSettingsArgs']] = None):
        """
        The set of arguments for constructing a LlmBlueprint resource.
        :param pulumi.Input[str] playground_id: The id of the Playground for the LLM Blueprint.
        :param pulumi.Input['LlmBlueprintCustomModelLlmSettingsArgs'] custom_model_llm_settings: The custom model LLM settings for the LLM Blueprint.
        :param pulumi.Input[str] description: The description of the LLM Blueprint.
        :param pulumi.Input[str] llm_id: The id of the LLM for the LLM Blueprint. If custom*model*llm_settings is set, this value must be 'custom-model'.
        :param pulumi.Input['LlmBlueprintLlmSettingsArgs'] llm_settings: The LLM settings for the LLM Blueprint.
        :param pulumi.Input[str] name: The name of the LLM Blueprint.
        :param pulumi.Input[str] prompt_type: The prompt type for the LLM Blueprint.
        :param pulumi.Input[str] vector_database_id: The id of the Vector Database for the LLM Blueprint.
        :param pulumi.Input['LlmBlueprintVectorDatabaseSettingsArgs'] vector_database_settings: The Vector Database settings for the LLM Blueprint.
        """
        pulumi.set(__self__, "playground_id", playground_id)
        if custom_model_llm_settings is not None:
            pulumi.set(__self__, "custom_model_llm_settings", custom_model_llm_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if llm_id is not None:
            pulumi.set(__self__, "llm_id", llm_id)
        if llm_settings is not None:
            pulumi.set(__self__, "llm_settings", llm_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prompt_type is not None:
            pulumi.set(__self__, "prompt_type", prompt_type)
        if vector_database_id is not None:
            pulumi.set(__self__, "vector_database_id", vector_database_id)
        if vector_database_settings is not None:
            pulumi.set(__self__, "vector_database_settings", vector_database_settings)

    @property
    @pulumi.getter(name="playgroundId")
    def playground_id(self) -> pulumi.Input[str]:
        """
        The id of the Playground for the LLM Blueprint.
        """
        return pulumi.get(self, "playground_id")

    @playground_id.setter
    def playground_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "playground_id", value)

    @property
    @pulumi.getter(name="customModelLlmSettings")
    def custom_model_llm_settings(self) -> Optional[pulumi.Input['LlmBlueprintCustomModelLlmSettingsArgs']]:
        """
        The custom model LLM settings for the LLM Blueprint.
        """
        return pulumi.get(self, "custom_model_llm_settings")

    @custom_model_llm_settings.setter
    def custom_model_llm_settings(self, value: Optional[pulumi.Input['LlmBlueprintCustomModelLlmSettingsArgs']]):
        pulumi.set(self, "custom_model_llm_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the LLM Blueprint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="llmId")
    def llm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the LLM for the LLM Blueprint. If custom*model*llm_settings is set, this value must be 'custom-model'.
        """
        return pulumi.get(self, "llm_id")

    @llm_id.setter
    def llm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "llm_id", value)

    @property
    @pulumi.getter(name="llmSettings")
    def llm_settings(self) -> Optional[pulumi.Input['LlmBlueprintLlmSettingsArgs']]:
        """
        The LLM settings for the LLM Blueprint.
        """
        return pulumi.get(self, "llm_settings")

    @llm_settings.setter
    def llm_settings(self, value: Optional[pulumi.Input['LlmBlueprintLlmSettingsArgs']]):
        pulumi.set(self, "llm_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the LLM Blueprint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="promptType")
    def prompt_type(self) -> Optional[pulumi.Input[str]]:
        """
        The prompt type for the LLM Blueprint.
        """
        return pulumi.get(self, "prompt_type")

    @prompt_type.setter
    def prompt_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prompt_type", value)

    @property
    @pulumi.getter(name="vectorDatabaseId")
    def vector_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Vector Database for the LLM Blueprint.
        """
        return pulumi.get(self, "vector_database_id")

    @vector_database_id.setter
    def vector_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vector_database_id", value)

    @property
    @pulumi.getter(name="vectorDatabaseSettings")
    def vector_database_settings(self) -> Optional[pulumi.Input['LlmBlueprintVectorDatabaseSettingsArgs']]:
        """
        The Vector Database settings for the LLM Blueprint.
        """
        return pulumi.get(self, "vector_database_settings")

    @vector_database_settings.setter
    def vector_database_settings(self, value: Optional[pulumi.Input['LlmBlueprintVectorDatabaseSettingsArgs']]):
        pulumi.set(self, "vector_database_settings", value)


@pulumi.input_type
class _LlmBlueprintState:
    def __init__(__self__, *,
                 custom_model_llm_settings: Optional[pulumi.Input['LlmBlueprintCustomModelLlmSettingsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 llm_id: Optional[pulumi.Input[str]] = None,
                 llm_settings: Optional[pulumi.Input['LlmBlueprintLlmSettingsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 playground_id: Optional[pulumi.Input[str]] = None,
                 prompt_type: Optional[pulumi.Input[str]] = None,
                 vector_database_id: Optional[pulumi.Input[str]] = None,
                 vector_database_settings: Optional[pulumi.Input['LlmBlueprintVectorDatabaseSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering LlmBlueprint resources.
        :param pulumi.Input['LlmBlueprintCustomModelLlmSettingsArgs'] custom_model_llm_settings: The custom model LLM settings for the LLM Blueprint.
        :param pulumi.Input[str] description: The description of the LLM Blueprint.
        :param pulumi.Input[str] llm_id: The id of the LLM for the LLM Blueprint. If custom*model*llm_settings is set, this value must be 'custom-model'.
        :param pulumi.Input['LlmBlueprintLlmSettingsArgs'] llm_settings: The LLM settings for the LLM Blueprint.
        :param pulumi.Input[str] name: The name of the LLM Blueprint.
        :param pulumi.Input[str] playground_id: The id of the Playground for the LLM Blueprint.
        :param pulumi.Input[str] prompt_type: The prompt type for the LLM Blueprint.
        :param pulumi.Input[str] vector_database_id: The id of the Vector Database for the LLM Blueprint.
        :param pulumi.Input['LlmBlueprintVectorDatabaseSettingsArgs'] vector_database_settings: The Vector Database settings for the LLM Blueprint.
        """
        if custom_model_llm_settings is not None:
            pulumi.set(__self__, "custom_model_llm_settings", custom_model_llm_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if llm_id is not None:
            pulumi.set(__self__, "llm_id", llm_id)
        if llm_settings is not None:
            pulumi.set(__self__, "llm_settings", llm_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if playground_id is not None:
            pulumi.set(__self__, "playground_id", playground_id)
        if prompt_type is not None:
            pulumi.set(__self__, "prompt_type", prompt_type)
        if vector_database_id is not None:
            pulumi.set(__self__, "vector_database_id", vector_database_id)
        if vector_database_settings is not None:
            pulumi.set(__self__, "vector_database_settings", vector_database_settings)

    @property
    @pulumi.getter(name="customModelLlmSettings")
    def custom_model_llm_settings(self) -> Optional[pulumi.Input['LlmBlueprintCustomModelLlmSettingsArgs']]:
        """
        The custom model LLM settings for the LLM Blueprint.
        """
        return pulumi.get(self, "custom_model_llm_settings")

    @custom_model_llm_settings.setter
    def custom_model_llm_settings(self, value: Optional[pulumi.Input['LlmBlueprintCustomModelLlmSettingsArgs']]):
        pulumi.set(self, "custom_model_llm_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the LLM Blueprint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="llmId")
    def llm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the LLM for the LLM Blueprint. If custom*model*llm_settings is set, this value must be 'custom-model'.
        """
        return pulumi.get(self, "llm_id")

    @llm_id.setter
    def llm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "llm_id", value)

    @property
    @pulumi.getter(name="llmSettings")
    def llm_settings(self) -> Optional[pulumi.Input['LlmBlueprintLlmSettingsArgs']]:
        """
        The LLM settings for the LLM Blueprint.
        """
        return pulumi.get(self, "llm_settings")

    @llm_settings.setter
    def llm_settings(self, value: Optional[pulumi.Input['LlmBlueprintLlmSettingsArgs']]):
        pulumi.set(self, "llm_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the LLM Blueprint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="playgroundId")
    def playground_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Playground for the LLM Blueprint.
        """
        return pulumi.get(self, "playground_id")

    @playground_id.setter
    def playground_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "playground_id", value)

    @property
    @pulumi.getter(name="promptType")
    def prompt_type(self) -> Optional[pulumi.Input[str]]:
        """
        The prompt type for the LLM Blueprint.
        """
        return pulumi.get(self, "prompt_type")

    @prompt_type.setter
    def prompt_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prompt_type", value)

    @property
    @pulumi.getter(name="vectorDatabaseId")
    def vector_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Vector Database for the LLM Blueprint.
        """
        return pulumi.get(self, "vector_database_id")

    @vector_database_id.setter
    def vector_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vector_database_id", value)

    @property
    @pulumi.getter(name="vectorDatabaseSettings")
    def vector_database_settings(self) -> Optional[pulumi.Input['LlmBlueprintVectorDatabaseSettingsArgs']]:
        """
        The Vector Database settings for the LLM Blueprint.
        """
        return pulumi.get(self, "vector_database_settings")

    @vector_database_settings.setter
    def vector_database_settings(self, value: Optional[pulumi.Input['LlmBlueprintVectorDatabaseSettingsArgs']]):
        pulumi.set(self, "vector_database_settings", value)


class LlmBlueprint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_model_llm_settings: Optional[pulumi.Input[Union['LlmBlueprintCustomModelLlmSettingsArgs', 'LlmBlueprintCustomModelLlmSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 llm_id: Optional[pulumi.Input[str]] = None,
                 llm_settings: Optional[pulumi.Input[Union['LlmBlueprintLlmSettingsArgs', 'LlmBlueprintLlmSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 playground_id: Optional[pulumi.Input[str]] = None,
                 prompt_type: Optional[pulumi.Input[str]] = None,
                 vector_database_id: Optional[pulumi.Input[str]] = None,
                 vector_database_settings: Optional[pulumi.Input[Union['LlmBlueprintVectorDatabaseSettingsArgs', 'LlmBlueprintVectorDatabaseSettingsArgsDict']]] = None,
                 __props__=None):
        """
        LLMBlueprint

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LlmBlueprintCustomModelLlmSettingsArgs', 'LlmBlueprintCustomModelLlmSettingsArgsDict']] custom_model_llm_settings: The custom model LLM settings for the LLM Blueprint.
        :param pulumi.Input[str] description: The description of the LLM Blueprint.
        :param pulumi.Input[str] llm_id: The id of the LLM for the LLM Blueprint. If custom*model*llm_settings is set, this value must be 'custom-model'.
        :param pulumi.Input[Union['LlmBlueprintLlmSettingsArgs', 'LlmBlueprintLlmSettingsArgsDict']] llm_settings: The LLM settings for the LLM Blueprint.
        :param pulumi.Input[str] name: The name of the LLM Blueprint.
        :param pulumi.Input[str] playground_id: The id of the Playground for the LLM Blueprint.
        :param pulumi.Input[str] prompt_type: The prompt type for the LLM Blueprint.
        :param pulumi.Input[str] vector_database_id: The id of the Vector Database for the LLM Blueprint.
        :param pulumi.Input[Union['LlmBlueprintVectorDatabaseSettingsArgs', 'LlmBlueprintVectorDatabaseSettingsArgsDict']] vector_database_settings: The Vector Database settings for the LLM Blueprint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LlmBlueprintArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        LLMBlueprint

        :param str resource_name: The name of the resource.
        :param LlmBlueprintArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LlmBlueprintArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_model_llm_settings: Optional[pulumi.Input[Union['LlmBlueprintCustomModelLlmSettingsArgs', 'LlmBlueprintCustomModelLlmSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 llm_id: Optional[pulumi.Input[str]] = None,
                 llm_settings: Optional[pulumi.Input[Union['LlmBlueprintLlmSettingsArgs', 'LlmBlueprintLlmSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 playground_id: Optional[pulumi.Input[str]] = None,
                 prompt_type: Optional[pulumi.Input[str]] = None,
                 vector_database_id: Optional[pulumi.Input[str]] = None,
                 vector_database_settings: Optional[pulumi.Input[Union['LlmBlueprintVectorDatabaseSettingsArgs', 'LlmBlueprintVectorDatabaseSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LlmBlueprintArgs.__new__(LlmBlueprintArgs)

            __props__.__dict__["custom_model_llm_settings"] = custom_model_llm_settings
            __props__.__dict__["description"] = description
            __props__.__dict__["llm_id"] = llm_id
            __props__.__dict__["llm_settings"] = llm_settings
            __props__.__dict__["name"] = name
            if playground_id is None and not opts.urn:
                raise TypeError("Missing required property 'playground_id'")
            __props__.__dict__["playground_id"] = playground_id
            __props__.__dict__["prompt_type"] = prompt_type
            __props__.__dict__["vector_database_id"] = vector_database_id
            __props__.__dict__["vector_database_settings"] = vector_database_settings
        super(LlmBlueprint, __self__).__init__(
            'datarobot:index/llmBlueprint:LlmBlueprint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_model_llm_settings: Optional[pulumi.Input[Union['LlmBlueprintCustomModelLlmSettingsArgs', 'LlmBlueprintCustomModelLlmSettingsArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            llm_id: Optional[pulumi.Input[str]] = None,
            llm_settings: Optional[pulumi.Input[Union['LlmBlueprintLlmSettingsArgs', 'LlmBlueprintLlmSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            playground_id: Optional[pulumi.Input[str]] = None,
            prompt_type: Optional[pulumi.Input[str]] = None,
            vector_database_id: Optional[pulumi.Input[str]] = None,
            vector_database_settings: Optional[pulumi.Input[Union['LlmBlueprintVectorDatabaseSettingsArgs', 'LlmBlueprintVectorDatabaseSettingsArgsDict']]] = None) -> 'LlmBlueprint':
        """
        Get an existing LlmBlueprint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LlmBlueprintCustomModelLlmSettingsArgs', 'LlmBlueprintCustomModelLlmSettingsArgsDict']] custom_model_llm_settings: The custom model LLM settings for the LLM Blueprint.
        :param pulumi.Input[str] description: The description of the LLM Blueprint.
        :param pulumi.Input[str] llm_id: The id of the LLM for the LLM Blueprint. If custom*model*llm_settings is set, this value must be 'custom-model'.
        :param pulumi.Input[Union['LlmBlueprintLlmSettingsArgs', 'LlmBlueprintLlmSettingsArgsDict']] llm_settings: The LLM settings for the LLM Blueprint.
        :param pulumi.Input[str] name: The name of the LLM Blueprint.
        :param pulumi.Input[str] playground_id: The id of the Playground for the LLM Blueprint.
        :param pulumi.Input[str] prompt_type: The prompt type for the LLM Blueprint.
        :param pulumi.Input[str] vector_database_id: The id of the Vector Database for the LLM Blueprint.
        :param pulumi.Input[Union['LlmBlueprintVectorDatabaseSettingsArgs', 'LlmBlueprintVectorDatabaseSettingsArgsDict']] vector_database_settings: The Vector Database settings for the LLM Blueprint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LlmBlueprintState.__new__(_LlmBlueprintState)

        __props__.__dict__["custom_model_llm_settings"] = custom_model_llm_settings
        __props__.__dict__["description"] = description
        __props__.__dict__["llm_id"] = llm_id
        __props__.__dict__["llm_settings"] = llm_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["playground_id"] = playground_id
        __props__.__dict__["prompt_type"] = prompt_type
        __props__.__dict__["vector_database_id"] = vector_database_id
        __props__.__dict__["vector_database_settings"] = vector_database_settings
        return LlmBlueprint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customModelLlmSettings")
    def custom_model_llm_settings(self) -> pulumi.Output[Optional['outputs.LlmBlueprintCustomModelLlmSettings']]:
        """
        The custom model LLM settings for the LLM Blueprint.
        """
        return pulumi.get(self, "custom_model_llm_settings")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the LLM Blueprint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="llmId")
    def llm_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the LLM for the LLM Blueprint. If custom*model*llm_settings is set, this value must be 'custom-model'.
        """
        return pulumi.get(self, "llm_id")

    @property
    @pulumi.getter(name="llmSettings")
    def llm_settings(self) -> pulumi.Output[Optional['outputs.LlmBlueprintLlmSettings']]:
        """
        The LLM settings for the LLM Blueprint.
        """
        return pulumi.get(self, "llm_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the LLM Blueprint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="playgroundId")
    def playground_id(self) -> pulumi.Output[str]:
        """
        The id of the Playground for the LLM Blueprint.
        """
        return pulumi.get(self, "playground_id")

    @property
    @pulumi.getter(name="promptType")
    def prompt_type(self) -> pulumi.Output[str]:
        """
        The prompt type for the LLM Blueprint.
        """
        return pulumi.get(self, "prompt_type")

    @property
    @pulumi.getter(name="vectorDatabaseId")
    def vector_database_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the Vector Database for the LLM Blueprint.
        """
        return pulumi.get(self, "vector_database_id")

    @property
    @pulumi.getter(name="vectorDatabaseSettings")
    def vector_database_settings(self) -> pulumi.Output[Optional['outputs.LlmBlueprintVectorDatabaseSettings']]:
        """
        The Vector Database settings for the LLM Blueprint.
        """
        return pulumi.get(self, "vector_database_settings")

