# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetExecutionEnvironmentResult',
    'AwaitableGetExecutionEnvironmentResult',
    'get_execution_environment',
    'get_execution_environment_output',
]

@pulumi.output_type
class GetExecutionEnvironmentResult:
    """
    A collection of values returned by getExecutionEnvironment.
    """
    def __init__(__self__, description=None, id=None, name=None, programming_language=None, version_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if programming_language and not isinstance(programming_language, str):
            raise TypeError("Expected argument 'programming_language' to be a str")
        pulumi.set(__self__, "programming_language", programming_language)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Execution Environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Execution Environment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Execution Environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="programmingLanguage")
    def programming_language(self) -> str:
        """
        The programming language of the Execution Environment.
        """
        return pulumi.get(self, "programming_language")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> str:
        """
        The ID of the Execution Environment Version.
        """
        return pulumi.get(self, "version_id")


class AwaitableGetExecutionEnvironmentResult(GetExecutionEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExecutionEnvironmentResult(
            description=self.description,
            id=self.id,
            name=self.name,
            programming_language=self.programming_language,
            version_id=self.version_id)


def get_execution_environment(name: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExecutionEnvironmentResult:
    """
    Execution Environment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datarobot as datarobot

    example = datarobot.get_execution_environment(name="DataRobot] Python 3.12")
    ```


    :param str name: The name of the Execution Environment.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datarobot:index/getExecutionEnvironment:getExecutionEnvironment', __args__, opts=opts, typ=GetExecutionEnvironmentResult).value

    return AwaitableGetExecutionEnvironmentResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        programming_language=pulumi.get(__ret__, 'programming_language'),
        version_id=pulumi.get(__ret__, 'version_id'))
def get_execution_environment_output(name: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExecutionEnvironmentResult]:
    """
    Execution Environment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datarobot as datarobot

    example = datarobot.get_execution_environment(name="DataRobot] Python 3.12")
    ```


    :param str name: The name of the Execution Environment.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datarobot:index/getExecutionEnvironment:getExecutionEnvironment', __args__, opts=opts, typ=GetExecutionEnvironmentResult)
    return __ret__.apply(lambda __response__: GetExecutionEnvironmentResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        programming_language=pulumi.get(__response__, 'programming_language'),
        version_id=pulumi.get(__response__, 'version_id')))
