# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentRetrainingPolicyArgs', 'DeploymentRetrainingPolicy']

@pulumi.input_type
class DeploymentRetrainingPolicyArgs:
    def __init__(__self__, *,
                 deployment_id: pulumi.Input[str],
                 description: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 autopilot_options: Optional[pulumi.Input['DeploymentRetrainingPolicyAutopilotOptionsArgs']] = None,
                 feature_list_strategy: Optional[pulumi.Input[str]] = None,
                 model_selection_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_options: Optional[pulumi.Input['DeploymentRetrainingPolicyProjectOptionsArgs']] = None,
                 project_options_strategy: Optional[pulumi.Input[str]] = None,
                 time_series_options: Optional[pulumi.Input['DeploymentRetrainingPolicyTimeSeriesOptionsArgs']] = None,
                 trigger: Optional[pulumi.Input['DeploymentRetrainingPolicyTriggerArgs']] = None):
        """
        The set of arguments for constructing a DeploymentRetrainingPolicy resource.
        :param pulumi.Input[str] deployment_id: The ID of the Deployment for the Retraining Policy.
        :param pulumi.Input[str] description: The description of the Retraining Policy.
        :param pulumi.Input[str] action: The the action to take on the resultant new model.
        :param pulumi.Input['DeploymentRetrainingPolicyAutopilotOptionsArgs'] autopilot_options: Options for projects used to build new models.
        :param pulumi.Input[str] feature_list_strategy: The feature list strategy used for modeling.
        :param pulumi.Input[str] model_selection_strategy: Determines how the new model is selected when the retraining policy runs.
        :param pulumi.Input[str] name: The name of the Retraining Policy.
        :param pulumi.Input['DeploymentRetrainingPolicyProjectOptionsArgs'] project_options: Options for projects used to build new models.
        :param pulumi.Input[str] project_options_strategy: The project option strategy used for modeling.
        :param pulumi.Input['DeploymentRetrainingPolicyTimeSeriesOptionsArgs'] time_series_options: Time Series project options used to build new models.
        :param pulumi.Input['DeploymentRetrainingPolicyTriggerArgs'] trigger: Retraining policy trigger.
        """
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "description", description)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if autopilot_options is not None:
            pulumi.set(__self__, "autopilot_options", autopilot_options)
        if feature_list_strategy is not None:
            pulumi.set(__self__, "feature_list_strategy", feature_list_strategy)
        if model_selection_strategy is not None:
            pulumi.set(__self__, "model_selection_strategy", model_selection_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_options is not None:
            pulumi.set(__self__, "project_options", project_options)
        if project_options_strategy is not None:
            pulumi.set(__self__, "project_options_strategy", project_options_strategy)
        if time_series_options is not None:
            pulumi.set(__self__, "time_series_options", time_series_options)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        """
        The ID of the Deployment for the Retraining Policy.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the Retraining Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The the action to take on the resultant new model.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="autopilotOptions")
    def autopilot_options(self) -> Optional[pulumi.Input['DeploymentRetrainingPolicyAutopilotOptionsArgs']]:
        """
        Options for projects used to build new models.
        """
        return pulumi.get(self, "autopilot_options")

    @autopilot_options.setter
    def autopilot_options(self, value: Optional[pulumi.Input['DeploymentRetrainingPolicyAutopilotOptionsArgs']]):
        pulumi.set(self, "autopilot_options", value)

    @property
    @pulumi.getter(name="featureListStrategy")
    def feature_list_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The feature list strategy used for modeling.
        """
        return pulumi.get(self, "feature_list_strategy")

    @feature_list_strategy.setter
    def feature_list_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_list_strategy", value)

    @property
    @pulumi.getter(name="modelSelectionStrategy")
    def model_selection_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the new model is selected when the retraining policy runs.
        """
        return pulumi.get(self, "model_selection_strategy")

    @model_selection_strategy.setter
    def model_selection_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_selection_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Retraining Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectOptions")
    def project_options(self) -> Optional[pulumi.Input['DeploymentRetrainingPolicyProjectOptionsArgs']]:
        """
        Options for projects used to build new models.
        """
        return pulumi.get(self, "project_options")

    @project_options.setter
    def project_options(self, value: Optional[pulumi.Input['DeploymentRetrainingPolicyProjectOptionsArgs']]):
        pulumi.set(self, "project_options", value)

    @property
    @pulumi.getter(name="projectOptionsStrategy")
    def project_options_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The project option strategy used for modeling.
        """
        return pulumi.get(self, "project_options_strategy")

    @project_options_strategy.setter
    def project_options_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_options_strategy", value)

    @property
    @pulumi.getter(name="timeSeriesOptions")
    def time_series_options(self) -> Optional[pulumi.Input['DeploymentRetrainingPolicyTimeSeriesOptionsArgs']]:
        """
        Time Series project options used to build new models.
        """
        return pulumi.get(self, "time_series_options")

    @time_series_options.setter
    def time_series_options(self, value: Optional[pulumi.Input['DeploymentRetrainingPolicyTimeSeriesOptionsArgs']]):
        pulumi.set(self, "time_series_options", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['DeploymentRetrainingPolicyTriggerArgs']]:
        """
        Retraining policy trigger.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['DeploymentRetrainingPolicyTriggerArgs']]):
        pulumi.set(self, "trigger", value)


@pulumi.input_type
class _DeploymentRetrainingPolicyState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 autopilot_options: Optional[pulumi.Input['DeploymentRetrainingPolicyAutopilotOptionsArgs']] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_list_strategy: Optional[pulumi.Input[str]] = None,
                 model_selection_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_options: Optional[pulumi.Input['DeploymentRetrainingPolicyProjectOptionsArgs']] = None,
                 project_options_strategy: Optional[pulumi.Input[str]] = None,
                 time_series_options: Optional[pulumi.Input['DeploymentRetrainingPolicyTimeSeriesOptionsArgs']] = None,
                 trigger: Optional[pulumi.Input['DeploymentRetrainingPolicyTriggerArgs']] = None):
        """
        Input properties used for looking up and filtering DeploymentRetrainingPolicy resources.
        :param pulumi.Input[str] action: The the action to take on the resultant new model.
        :param pulumi.Input['DeploymentRetrainingPolicyAutopilotOptionsArgs'] autopilot_options: Options for projects used to build new models.
        :param pulumi.Input[str] deployment_id: The ID of the Deployment for the Retraining Policy.
        :param pulumi.Input[str] description: The description of the Retraining Policy.
        :param pulumi.Input[str] feature_list_strategy: The feature list strategy used for modeling.
        :param pulumi.Input[str] model_selection_strategy: Determines how the new model is selected when the retraining policy runs.
        :param pulumi.Input[str] name: The name of the Retraining Policy.
        :param pulumi.Input['DeploymentRetrainingPolicyProjectOptionsArgs'] project_options: Options for projects used to build new models.
        :param pulumi.Input[str] project_options_strategy: The project option strategy used for modeling.
        :param pulumi.Input['DeploymentRetrainingPolicyTimeSeriesOptionsArgs'] time_series_options: Time Series project options used to build new models.
        :param pulumi.Input['DeploymentRetrainingPolicyTriggerArgs'] trigger: Retraining policy trigger.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if autopilot_options is not None:
            pulumi.set(__self__, "autopilot_options", autopilot_options)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_list_strategy is not None:
            pulumi.set(__self__, "feature_list_strategy", feature_list_strategy)
        if model_selection_strategy is not None:
            pulumi.set(__self__, "model_selection_strategy", model_selection_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_options is not None:
            pulumi.set(__self__, "project_options", project_options)
        if project_options_strategy is not None:
            pulumi.set(__self__, "project_options_strategy", project_options_strategy)
        if time_series_options is not None:
            pulumi.set(__self__, "time_series_options", time_series_options)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The the action to take on the resultant new model.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="autopilotOptions")
    def autopilot_options(self) -> Optional[pulumi.Input['DeploymentRetrainingPolicyAutopilotOptionsArgs']]:
        """
        Options for projects used to build new models.
        """
        return pulumi.get(self, "autopilot_options")

    @autopilot_options.setter
    def autopilot_options(self, value: Optional[pulumi.Input['DeploymentRetrainingPolicyAutopilotOptionsArgs']]):
        pulumi.set(self, "autopilot_options", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Deployment for the Retraining Policy.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Retraining Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureListStrategy")
    def feature_list_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The feature list strategy used for modeling.
        """
        return pulumi.get(self, "feature_list_strategy")

    @feature_list_strategy.setter
    def feature_list_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_list_strategy", value)

    @property
    @pulumi.getter(name="modelSelectionStrategy")
    def model_selection_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the new model is selected when the retraining policy runs.
        """
        return pulumi.get(self, "model_selection_strategy")

    @model_selection_strategy.setter
    def model_selection_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_selection_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Retraining Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectOptions")
    def project_options(self) -> Optional[pulumi.Input['DeploymentRetrainingPolicyProjectOptionsArgs']]:
        """
        Options for projects used to build new models.
        """
        return pulumi.get(self, "project_options")

    @project_options.setter
    def project_options(self, value: Optional[pulumi.Input['DeploymentRetrainingPolicyProjectOptionsArgs']]):
        pulumi.set(self, "project_options", value)

    @property
    @pulumi.getter(name="projectOptionsStrategy")
    def project_options_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The project option strategy used for modeling.
        """
        return pulumi.get(self, "project_options_strategy")

    @project_options_strategy.setter
    def project_options_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_options_strategy", value)

    @property
    @pulumi.getter(name="timeSeriesOptions")
    def time_series_options(self) -> Optional[pulumi.Input['DeploymentRetrainingPolicyTimeSeriesOptionsArgs']]:
        """
        Time Series project options used to build new models.
        """
        return pulumi.get(self, "time_series_options")

    @time_series_options.setter
    def time_series_options(self, value: Optional[pulumi.Input['DeploymentRetrainingPolicyTimeSeriesOptionsArgs']]):
        pulumi.set(self, "time_series_options", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['DeploymentRetrainingPolicyTriggerArgs']]:
        """
        Retraining policy trigger.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['DeploymentRetrainingPolicyTriggerArgs']]):
        pulumi.set(self, "trigger", value)


class DeploymentRetrainingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 autopilot_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyAutopilotOptionsArgs', 'DeploymentRetrainingPolicyAutopilotOptionsArgsDict']]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_list_strategy: Optional[pulumi.Input[str]] = None,
                 model_selection_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyProjectOptionsArgs', 'DeploymentRetrainingPolicyProjectOptionsArgsDict']]] = None,
                 project_options_strategy: Optional[pulumi.Input[str]] = None,
                 time_series_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyTimeSeriesOptionsArgs', 'DeploymentRetrainingPolicyTimeSeriesOptionsArgsDict']]] = None,
                 trigger: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyTriggerArgs', 'DeploymentRetrainingPolicyTriggerArgsDict']]] = None,
                 __props__=None):
        """
        Deployment Retraining Policy

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The the action to take on the resultant new model.
        :param pulumi.Input[Union['DeploymentRetrainingPolicyAutopilotOptionsArgs', 'DeploymentRetrainingPolicyAutopilotOptionsArgsDict']] autopilot_options: Options for projects used to build new models.
        :param pulumi.Input[str] deployment_id: The ID of the Deployment for the Retraining Policy.
        :param pulumi.Input[str] description: The description of the Retraining Policy.
        :param pulumi.Input[str] feature_list_strategy: The feature list strategy used for modeling.
        :param pulumi.Input[str] model_selection_strategy: Determines how the new model is selected when the retraining policy runs.
        :param pulumi.Input[str] name: The name of the Retraining Policy.
        :param pulumi.Input[Union['DeploymentRetrainingPolicyProjectOptionsArgs', 'DeploymentRetrainingPolicyProjectOptionsArgsDict']] project_options: Options for projects used to build new models.
        :param pulumi.Input[str] project_options_strategy: The project option strategy used for modeling.
        :param pulumi.Input[Union['DeploymentRetrainingPolicyTimeSeriesOptionsArgs', 'DeploymentRetrainingPolicyTimeSeriesOptionsArgsDict']] time_series_options: Time Series project options used to build new models.
        :param pulumi.Input[Union['DeploymentRetrainingPolicyTriggerArgs', 'DeploymentRetrainingPolicyTriggerArgsDict']] trigger: Retraining policy trigger.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentRetrainingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Deployment Retraining Policy

        :param str resource_name: The name of the resource.
        :param DeploymentRetrainingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentRetrainingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 autopilot_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyAutopilotOptionsArgs', 'DeploymentRetrainingPolicyAutopilotOptionsArgsDict']]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_list_strategy: Optional[pulumi.Input[str]] = None,
                 model_selection_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyProjectOptionsArgs', 'DeploymentRetrainingPolicyProjectOptionsArgsDict']]] = None,
                 project_options_strategy: Optional[pulumi.Input[str]] = None,
                 time_series_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyTimeSeriesOptionsArgs', 'DeploymentRetrainingPolicyTimeSeriesOptionsArgsDict']]] = None,
                 trigger: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyTriggerArgs', 'DeploymentRetrainingPolicyTriggerArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentRetrainingPolicyArgs.__new__(DeploymentRetrainingPolicyArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["autopilot_options"] = autopilot_options
            if deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_id'")
            __props__.__dict__["deployment_id"] = deployment_id
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["feature_list_strategy"] = feature_list_strategy
            __props__.__dict__["model_selection_strategy"] = model_selection_strategy
            __props__.__dict__["name"] = name
            __props__.__dict__["project_options"] = project_options
            __props__.__dict__["project_options_strategy"] = project_options_strategy
            __props__.__dict__["time_series_options"] = time_series_options
            __props__.__dict__["trigger"] = trigger
        super(DeploymentRetrainingPolicy, __self__).__init__(
            'datarobot:index/deploymentRetrainingPolicy:DeploymentRetrainingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            autopilot_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyAutopilotOptionsArgs', 'DeploymentRetrainingPolicyAutopilotOptionsArgsDict']]] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_list_strategy: Optional[pulumi.Input[str]] = None,
            model_selection_strategy: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyProjectOptionsArgs', 'DeploymentRetrainingPolicyProjectOptionsArgsDict']]] = None,
            project_options_strategy: Optional[pulumi.Input[str]] = None,
            time_series_options: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyTimeSeriesOptionsArgs', 'DeploymentRetrainingPolicyTimeSeriesOptionsArgsDict']]] = None,
            trigger: Optional[pulumi.Input[Union['DeploymentRetrainingPolicyTriggerArgs', 'DeploymentRetrainingPolicyTriggerArgsDict']]] = None) -> 'DeploymentRetrainingPolicy':
        """
        Get an existing DeploymentRetrainingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The the action to take on the resultant new model.
        :param pulumi.Input[Union['DeploymentRetrainingPolicyAutopilotOptionsArgs', 'DeploymentRetrainingPolicyAutopilotOptionsArgsDict']] autopilot_options: Options for projects used to build new models.
        :param pulumi.Input[str] deployment_id: The ID of the Deployment for the Retraining Policy.
        :param pulumi.Input[str] description: The description of the Retraining Policy.
        :param pulumi.Input[str] feature_list_strategy: The feature list strategy used for modeling.
        :param pulumi.Input[str] model_selection_strategy: Determines how the new model is selected when the retraining policy runs.
        :param pulumi.Input[str] name: The name of the Retraining Policy.
        :param pulumi.Input[Union['DeploymentRetrainingPolicyProjectOptionsArgs', 'DeploymentRetrainingPolicyProjectOptionsArgsDict']] project_options: Options for projects used to build new models.
        :param pulumi.Input[str] project_options_strategy: The project option strategy used for modeling.
        :param pulumi.Input[Union['DeploymentRetrainingPolicyTimeSeriesOptionsArgs', 'DeploymentRetrainingPolicyTimeSeriesOptionsArgsDict']] time_series_options: Time Series project options used to build new models.
        :param pulumi.Input[Union['DeploymentRetrainingPolicyTriggerArgs', 'DeploymentRetrainingPolicyTriggerArgsDict']] trigger: Retraining policy trigger.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentRetrainingPolicyState.__new__(_DeploymentRetrainingPolicyState)

        __props__.__dict__["action"] = action
        __props__.__dict__["autopilot_options"] = autopilot_options
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_list_strategy"] = feature_list_strategy
        __props__.__dict__["model_selection_strategy"] = model_selection_strategy
        __props__.__dict__["name"] = name
        __props__.__dict__["project_options"] = project_options
        __props__.__dict__["project_options_strategy"] = project_options_strategy
        __props__.__dict__["time_series_options"] = time_series_options
        __props__.__dict__["trigger"] = trigger
        return DeploymentRetrainingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The the action to take on the resultant new model.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="autopilotOptions")
    def autopilot_options(self) -> pulumi.Output['outputs.DeploymentRetrainingPolicyAutopilotOptions']:
        """
        Options for projects used to build new models.
        """
        return pulumi.get(self, "autopilot_options")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        The ID of the Deployment for the Retraining Policy.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the Retraining Policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureListStrategy")
    def feature_list_strategy(self) -> pulumi.Output[str]:
        """
        The feature list strategy used for modeling.
        """
        return pulumi.get(self, "feature_list_strategy")

    @property
    @pulumi.getter(name="modelSelectionStrategy")
    def model_selection_strategy(self) -> pulumi.Output[str]:
        """
        Determines how the new model is selected when the retraining policy runs.
        """
        return pulumi.get(self, "model_selection_strategy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Retraining Policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectOptions")
    def project_options(self) -> pulumi.Output['outputs.DeploymentRetrainingPolicyProjectOptions']:
        """
        Options for projects used to build new models.
        """
        return pulumi.get(self, "project_options")

    @property
    @pulumi.getter(name="projectOptionsStrategy")
    def project_options_strategy(self) -> pulumi.Output[str]:
        """
        The project option strategy used for modeling.
        """
        return pulumi.get(self, "project_options_strategy")

    @property
    @pulumi.getter(name="timeSeriesOptions")
    def time_series_options(self) -> pulumi.Output[Optional['outputs.DeploymentRetrainingPolicyTimeSeriesOptions']]:
        """
        Time Series project options used to build new models.
        """
        return pulumi.get(self, "time_series_options")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[Optional['outputs.DeploymentRetrainingPolicyTrigger']]:
        """
        Retraining policy trigger.
        """
        return pulumi.get(self, "trigger")

