# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 prediction_environment_id: pulumi.Input[str],
                 registered_model_version_id: pulumi.Input[str],
                 association_id_settings: Optional[pulumi.Input['DeploymentAssociationIdSettingsArgs']] = None,
                 batch_monitoring_settings: Optional[pulumi.Input['DeploymentBatchMonitoringSettingsArgs']] = None,
                 bias_and_fairness_settings: Optional[pulumi.Input['DeploymentBiasAndFairnessSettingsArgs']] = None,
                 challenger_models_settings: Optional[pulumi.Input['DeploymentChallengerModelsSettingsArgs']] = None,
                 challenger_replay_settings: Optional[pulumi.Input['DeploymentChallengerReplaySettingsArgs']] = None,
                 drift_tracking_settings: Optional[pulumi.Input['DeploymentDriftTrackingSettingsArgs']] = None,
                 feature_cache_settings: Optional[pulumi.Input['DeploymentFeatureCacheSettingsArgs']] = None,
                 health_settings: Optional[pulumi.Input['DeploymentHealthSettingsArgs']] = None,
                 importance: Optional[pulumi.Input[str]] = None,
                 prediction_intervals_settings: Optional[pulumi.Input['DeploymentPredictionIntervalsSettingsArgs']] = None,
                 prediction_warning_settings: Optional[pulumi.Input['DeploymentPredictionWarningSettingsArgs']] = None,
                 predictions_by_forecast_date_settings: Optional[pulumi.Input['DeploymentPredictionsByForecastDateSettingsArgs']] = None,
                 predictions_data_collection_settings: Optional[pulumi.Input['DeploymentPredictionsDataCollectionSettingsArgs']] = None,
                 predictions_settings: Optional[pulumi.Input['DeploymentPredictionsSettingsArgs']] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentRuntimeParameterValueArgs']]]] = None,
                 segment_analysis_settings: Optional[pulumi.Input['DeploymentSegmentAnalysisSettingsArgs']] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[str] label: The label of the Deployment.
        :param pulumi.Input[str] prediction_environment_id: The ID of the predication environment for this Deployment.
        :param pulumi.Input[str] registered_model_version_id: The ID of the registered model version for this Deployment.
        :param pulumi.Input['DeploymentAssociationIdSettingsArgs'] association_id_settings: Association ID settings for this Deployment.
        :param pulumi.Input['DeploymentBatchMonitoringSettingsArgs'] batch_monitoring_settings: The batch monitoring settings for the Deployment.
        :param pulumi.Input['DeploymentBiasAndFairnessSettingsArgs'] bias_and_fairness_settings: Bias and fairness settings for the Deployment.
        :param pulumi.Input['DeploymentChallengerModelsSettingsArgs'] challenger_models_settings: The challenger models settings for the Deployment.
        :param pulumi.Input['DeploymentChallengerReplaySettingsArgs'] challenger_replay_settings: The challenger replay settings for the Deployment.
        :param pulumi.Input['DeploymentDriftTrackingSettingsArgs'] drift_tracking_settings: The drift tracking settings for the Deployment.
        :param pulumi.Input['DeploymentFeatureCacheSettingsArgs'] feature_cache_settings: The feature cache settings for this Deployment.
        :param pulumi.Input['DeploymentHealthSettingsArgs'] health_settings: The health settings for this Deployment.
        :param pulumi.Input[str] importance: The importance of the Deployment.
        :param pulumi.Input['DeploymentPredictionIntervalsSettingsArgs'] prediction_intervals_settings: The prediction intervals settings for this Deployment.
        :param pulumi.Input['DeploymentPredictionWarningSettingsArgs'] prediction_warning_settings: The prediction warning settings for the Deployment.
        :param pulumi.Input['DeploymentPredictionsByForecastDateSettingsArgs'] predictions_by_forecast_date_settings: The predictions by forecase date settings for the Deployment.
        :param pulumi.Input['DeploymentPredictionsDataCollectionSettingsArgs'] predictions_data_collection_settings: The predictions data collection settings for the Deployment.
        :param pulumi.Input['DeploymentPredictionsSettingsArgs'] predictions_settings: Settings for the predictions.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentRuntimeParameterValueArgs']]] runtime_parameter_values: The runtime parameter values for the Deployment.
        :param pulumi.Input['DeploymentSegmentAnalysisSettingsArgs'] segment_analysis_settings: The segment analysis settings for the Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Deployment to.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "prediction_environment_id", prediction_environment_id)
        pulumi.set(__self__, "registered_model_version_id", registered_model_version_id)
        if association_id_settings is not None:
            pulumi.set(__self__, "association_id_settings", association_id_settings)
        if batch_monitoring_settings is not None:
            pulumi.set(__self__, "batch_monitoring_settings", batch_monitoring_settings)
        if bias_and_fairness_settings is not None:
            pulumi.set(__self__, "bias_and_fairness_settings", bias_and_fairness_settings)
        if challenger_models_settings is not None:
            pulumi.set(__self__, "challenger_models_settings", challenger_models_settings)
        if challenger_replay_settings is not None:
            pulumi.set(__self__, "challenger_replay_settings", challenger_replay_settings)
        if drift_tracking_settings is not None:
            pulumi.set(__self__, "drift_tracking_settings", drift_tracking_settings)
        if feature_cache_settings is not None:
            pulumi.set(__self__, "feature_cache_settings", feature_cache_settings)
        if health_settings is not None:
            pulumi.set(__self__, "health_settings", health_settings)
        if importance is not None:
            pulumi.set(__self__, "importance", importance)
        if prediction_intervals_settings is not None:
            pulumi.set(__self__, "prediction_intervals_settings", prediction_intervals_settings)
        if prediction_warning_settings is not None:
            pulumi.set(__self__, "prediction_warning_settings", prediction_warning_settings)
        if predictions_by_forecast_date_settings is not None:
            pulumi.set(__self__, "predictions_by_forecast_date_settings", predictions_by_forecast_date_settings)
        if predictions_data_collection_settings is not None:
            pulumi.set(__self__, "predictions_data_collection_settings", predictions_data_collection_settings)
        if predictions_settings is not None:
            pulumi.set(__self__, "predictions_settings", predictions_settings)
        if runtime_parameter_values is not None:
            pulumi.set(__self__, "runtime_parameter_values", runtime_parameter_values)
        if segment_analysis_settings is not None:
            pulumi.set(__self__, "segment_analysis_settings", segment_analysis_settings)
        if use_case_ids is not None:
            pulumi.set(__self__, "use_case_ids", use_case_ids)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        The label of the Deployment.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="predictionEnvironmentId")
    def prediction_environment_id(self) -> pulumi.Input[str]:
        """
        The ID of the predication environment for this Deployment.
        """
        return pulumi.get(self, "prediction_environment_id")

    @prediction_environment_id.setter
    def prediction_environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "prediction_environment_id", value)

    @property
    @pulumi.getter(name="registeredModelVersionId")
    def registered_model_version_id(self) -> pulumi.Input[str]:
        """
        The ID of the registered model version for this Deployment.
        """
        return pulumi.get(self, "registered_model_version_id")

    @registered_model_version_id.setter
    def registered_model_version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "registered_model_version_id", value)

    @property
    @pulumi.getter(name="associationIdSettings")
    def association_id_settings(self) -> Optional[pulumi.Input['DeploymentAssociationIdSettingsArgs']]:
        """
        Association ID settings for this Deployment.
        """
        return pulumi.get(self, "association_id_settings")

    @association_id_settings.setter
    def association_id_settings(self, value: Optional[pulumi.Input['DeploymentAssociationIdSettingsArgs']]):
        pulumi.set(self, "association_id_settings", value)

    @property
    @pulumi.getter(name="batchMonitoringSettings")
    def batch_monitoring_settings(self) -> Optional[pulumi.Input['DeploymentBatchMonitoringSettingsArgs']]:
        """
        The batch monitoring settings for the Deployment.
        """
        return pulumi.get(self, "batch_monitoring_settings")

    @batch_monitoring_settings.setter
    def batch_monitoring_settings(self, value: Optional[pulumi.Input['DeploymentBatchMonitoringSettingsArgs']]):
        pulumi.set(self, "batch_monitoring_settings", value)

    @property
    @pulumi.getter(name="biasAndFairnessSettings")
    def bias_and_fairness_settings(self) -> Optional[pulumi.Input['DeploymentBiasAndFairnessSettingsArgs']]:
        """
        Bias and fairness settings for the Deployment.
        """
        return pulumi.get(self, "bias_and_fairness_settings")

    @bias_and_fairness_settings.setter
    def bias_and_fairness_settings(self, value: Optional[pulumi.Input['DeploymentBiasAndFairnessSettingsArgs']]):
        pulumi.set(self, "bias_and_fairness_settings", value)

    @property
    @pulumi.getter(name="challengerModelsSettings")
    def challenger_models_settings(self) -> Optional[pulumi.Input['DeploymentChallengerModelsSettingsArgs']]:
        """
        The challenger models settings for the Deployment.
        """
        return pulumi.get(self, "challenger_models_settings")

    @challenger_models_settings.setter
    def challenger_models_settings(self, value: Optional[pulumi.Input['DeploymentChallengerModelsSettingsArgs']]):
        pulumi.set(self, "challenger_models_settings", value)

    @property
    @pulumi.getter(name="challengerReplaySettings")
    def challenger_replay_settings(self) -> Optional[pulumi.Input['DeploymentChallengerReplaySettingsArgs']]:
        """
        The challenger replay settings for the Deployment.
        """
        return pulumi.get(self, "challenger_replay_settings")

    @challenger_replay_settings.setter
    def challenger_replay_settings(self, value: Optional[pulumi.Input['DeploymentChallengerReplaySettingsArgs']]):
        pulumi.set(self, "challenger_replay_settings", value)

    @property
    @pulumi.getter(name="driftTrackingSettings")
    def drift_tracking_settings(self) -> Optional[pulumi.Input['DeploymentDriftTrackingSettingsArgs']]:
        """
        The drift tracking settings for the Deployment.
        """
        return pulumi.get(self, "drift_tracking_settings")

    @drift_tracking_settings.setter
    def drift_tracking_settings(self, value: Optional[pulumi.Input['DeploymentDriftTrackingSettingsArgs']]):
        pulumi.set(self, "drift_tracking_settings", value)

    @property
    @pulumi.getter(name="featureCacheSettings")
    def feature_cache_settings(self) -> Optional[pulumi.Input['DeploymentFeatureCacheSettingsArgs']]:
        """
        The feature cache settings for this Deployment.
        """
        return pulumi.get(self, "feature_cache_settings")

    @feature_cache_settings.setter
    def feature_cache_settings(self, value: Optional[pulumi.Input['DeploymentFeatureCacheSettingsArgs']]):
        pulumi.set(self, "feature_cache_settings", value)

    @property
    @pulumi.getter(name="healthSettings")
    def health_settings(self) -> Optional[pulumi.Input['DeploymentHealthSettingsArgs']]:
        """
        The health settings for this Deployment.
        """
        return pulumi.get(self, "health_settings")

    @health_settings.setter
    def health_settings(self, value: Optional[pulumi.Input['DeploymentHealthSettingsArgs']]):
        pulumi.set(self, "health_settings", value)

    @property
    @pulumi.getter
    def importance(self) -> Optional[pulumi.Input[str]]:
        """
        The importance of the Deployment.
        """
        return pulumi.get(self, "importance")

    @importance.setter
    def importance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "importance", value)

    @property
    @pulumi.getter(name="predictionIntervalsSettings")
    def prediction_intervals_settings(self) -> Optional[pulumi.Input['DeploymentPredictionIntervalsSettingsArgs']]:
        """
        The prediction intervals settings for this Deployment.
        """
        return pulumi.get(self, "prediction_intervals_settings")

    @prediction_intervals_settings.setter
    def prediction_intervals_settings(self, value: Optional[pulumi.Input['DeploymentPredictionIntervalsSettingsArgs']]):
        pulumi.set(self, "prediction_intervals_settings", value)

    @property
    @pulumi.getter(name="predictionWarningSettings")
    def prediction_warning_settings(self) -> Optional[pulumi.Input['DeploymentPredictionWarningSettingsArgs']]:
        """
        The prediction warning settings for the Deployment.
        """
        return pulumi.get(self, "prediction_warning_settings")

    @prediction_warning_settings.setter
    def prediction_warning_settings(self, value: Optional[pulumi.Input['DeploymentPredictionWarningSettingsArgs']]):
        pulumi.set(self, "prediction_warning_settings", value)

    @property
    @pulumi.getter(name="predictionsByForecastDateSettings")
    def predictions_by_forecast_date_settings(self) -> Optional[pulumi.Input['DeploymentPredictionsByForecastDateSettingsArgs']]:
        """
        The predictions by forecase date settings for the Deployment.
        """
        return pulumi.get(self, "predictions_by_forecast_date_settings")

    @predictions_by_forecast_date_settings.setter
    def predictions_by_forecast_date_settings(self, value: Optional[pulumi.Input['DeploymentPredictionsByForecastDateSettingsArgs']]):
        pulumi.set(self, "predictions_by_forecast_date_settings", value)

    @property
    @pulumi.getter(name="predictionsDataCollectionSettings")
    def predictions_data_collection_settings(self) -> Optional[pulumi.Input['DeploymentPredictionsDataCollectionSettingsArgs']]:
        """
        The predictions data collection settings for the Deployment.
        """
        return pulumi.get(self, "predictions_data_collection_settings")

    @predictions_data_collection_settings.setter
    def predictions_data_collection_settings(self, value: Optional[pulumi.Input['DeploymentPredictionsDataCollectionSettingsArgs']]):
        pulumi.set(self, "predictions_data_collection_settings", value)

    @property
    @pulumi.getter(name="predictionsSettings")
    def predictions_settings(self) -> Optional[pulumi.Input['DeploymentPredictionsSettingsArgs']]:
        """
        Settings for the predictions.
        """
        return pulumi.get(self, "predictions_settings")

    @predictions_settings.setter
    def predictions_settings(self, value: Optional[pulumi.Input['DeploymentPredictionsSettingsArgs']]):
        pulumi.set(self, "predictions_settings", value)

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentRuntimeParameterValueArgs']]]]:
        """
        The runtime parameter values for the Deployment.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @runtime_parameter_values.setter
    def runtime_parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentRuntimeParameterValueArgs']]]]):
        pulumi.set(self, "runtime_parameter_values", value)

    @property
    @pulumi.getter(name="segmentAnalysisSettings")
    def segment_analysis_settings(self) -> Optional[pulumi.Input['DeploymentSegmentAnalysisSettingsArgs']]:
        """
        The segment analysis settings for the Deployment.
        """
        return pulumi.get(self, "segment_analysis_settings")

    @segment_analysis_settings.setter
    def segment_analysis_settings(self, value: Optional[pulumi.Input['DeploymentSegmentAnalysisSettingsArgs']]):
        pulumi.set(self, "segment_analysis_settings", value)

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Use Case IDs to add the Deployment to.
        """
        return pulumi.get(self, "use_case_ids")

    @use_case_ids.setter
    def use_case_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "use_case_ids", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 association_id_settings: Optional[pulumi.Input['DeploymentAssociationIdSettingsArgs']] = None,
                 batch_monitoring_settings: Optional[pulumi.Input['DeploymentBatchMonitoringSettingsArgs']] = None,
                 bias_and_fairness_settings: Optional[pulumi.Input['DeploymentBiasAndFairnessSettingsArgs']] = None,
                 challenger_models_settings: Optional[pulumi.Input['DeploymentChallengerModelsSettingsArgs']] = None,
                 challenger_replay_settings: Optional[pulumi.Input['DeploymentChallengerReplaySettingsArgs']] = None,
                 drift_tracking_settings: Optional[pulumi.Input['DeploymentDriftTrackingSettingsArgs']] = None,
                 feature_cache_settings: Optional[pulumi.Input['DeploymentFeatureCacheSettingsArgs']] = None,
                 health_settings: Optional[pulumi.Input['DeploymentHealthSettingsArgs']] = None,
                 importance: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 prediction_environment_id: Optional[pulumi.Input[str]] = None,
                 prediction_intervals_settings: Optional[pulumi.Input['DeploymentPredictionIntervalsSettingsArgs']] = None,
                 prediction_warning_settings: Optional[pulumi.Input['DeploymentPredictionWarningSettingsArgs']] = None,
                 predictions_by_forecast_date_settings: Optional[pulumi.Input['DeploymentPredictionsByForecastDateSettingsArgs']] = None,
                 predictions_data_collection_settings: Optional[pulumi.Input['DeploymentPredictionsDataCollectionSettingsArgs']] = None,
                 predictions_settings: Optional[pulumi.Input['DeploymentPredictionsSettingsArgs']] = None,
                 registered_model_version_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentRuntimeParameterValueArgs']]]] = None,
                 segment_analysis_settings: Optional[pulumi.Input['DeploymentSegmentAnalysisSettingsArgs']] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input['DeploymentAssociationIdSettingsArgs'] association_id_settings: Association ID settings for this Deployment.
        :param pulumi.Input['DeploymentBatchMonitoringSettingsArgs'] batch_monitoring_settings: The batch monitoring settings for the Deployment.
        :param pulumi.Input['DeploymentBiasAndFairnessSettingsArgs'] bias_and_fairness_settings: Bias and fairness settings for the Deployment.
        :param pulumi.Input['DeploymentChallengerModelsSettingsArgs'] challenger_models_settings: The challenger models settings for the Deployment.
        :param pulumi.Input['DeploymentChallengerReplaySettingsArgs'] challenger_replay_settings: The challenger replay settings for the Deployment.
        :param pulumi.Input['DeploymentDriftTrackingSettingsArgs'] drift_tracking_settings: The drift tracking settings for the Deployment.
        :param pulumi.Input['DeploymentFeatureCacheSettingsArgs'] feature_cache_settings: The feature cache settings for this Deployment.
        :param pulumi.Input['DeploymentHealthSettingsArgs'] health_settings: The health settings for this Deployment.
        :param pulumi.Input[str] importance: The importance of the Deployment.
        :param pulumi.Input[str] label: The label of the Deployment.
        :param pulumi.Input[str] prediction_environment_id: The ID of the predication environment for this Deployment.
        :param pulumi.Input['DeploymentPredictionIntervalsSettingsArgs'] prediction_intervals_settings: The prediction intervals settings for this Deployment.
        :param pulumi.Input['DeploymentPredictionWarningSettingsArgs'] prediction_warning_settings: The prediction warning settings for the Deployment.
        :param pulumi.Input['DeploymentPredictionsByForecastDateSettingsArgs'] predictions_by_forecast_date_settings: The predictions by forecase date settings for the Deployment.
        :param pulumi.Input['DeploymentPredictionsDataCollectionSettingsArgs'] predictions_data_collection_settings: The predictions data collection settings for the Deployment.
        :param pulumi.Input['DeploymentPredictionsSettingsArgs'] predictions_settings: Settings for the predictions.
        :param pulumi.Input[str] registered_model_version_id: The ID of the registered model version for this Deployment.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentRuntimeParameterValueArgs']]] runtime_parameter_values: The runtime parameter values for the Deployment.
        :param pulumi.Input['DeploymentSegmentAnalysisSettingsArgs'] segment_analysis_settings: The segment analysis settings for the Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Deployment to.
        """
        if association_id_settings is not None:
            pulumi.set(__self__, "association_id_settings", association_id_settings)
        if batch_monitoring_settings is not None:
            pulumi.set(__self__, "batch_monitoring_settings", batch_monitoring_settings)
        if bias_and_fairness_settings is not None:
            pulumi.set(__self__, "bias_and_fairness_settings", bias_and_fairness_settings)
        if challenger_models_settings is not None:
            pulumi.set(__self__, "challenger_models_settings", challenger_models_settings)
        if challenger_replay_settings is not None:
            pulumi.set(__self__, "challenger_replay_settings", challenger_replay_settings)
        if drift_tracking_settings is not None:
            pulumi.set(__self__, "drift_tracking_settings", drift_tracking_settings)
        if feature_cache_settings is not None:
            pulumi.set(__self__, "feature_cache_settings", feature_cache_settings)
        if health_settings is not None:
            pulumi.set(__self__, "health_settings", health_settings)
        if importance is not None:
            pulumi.set(__self__, "importance", importance)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if prediction_environment_id is not None:
            pulumi.set(__self__, "prediction_environment_id", prediction_environment_id)
        if prediction_intervals_settings is not None:
            pulumi.set(__self__, "prediction_intervals_settings", prediction_intervals_settings)
        if prediction_warning_settings is not None:
            pulumi.set(__self__, "prediction_warning_settings", prediction_warning_settings)
        if predictions_by_forecast_date_settings is not None:
            pulumi.set(__self__, "predictions_by_forecast_date_settings", predictions_by_forecast_date_settings)
        if predictions_data_collection_settings is not None:
            pulumi.set(__self__, "predictions_data_collection_settings", predictions_data_collection_settings)
        if predictions_settings is not None:
            pulumi.set(__self__, "predictions_settings", predictions_settings)
        if registered_model_version_id is not None:
            pulumi.set(__self__, "registered_model_version_id", registered_model_version_id)
        if runtime_parameter_values is not None:
            pulumi.set(__self__, "runtime_parameter_values", runtime_parameter_values)
        if segment_analysis_settings is not None:
            pulumi.set(__self__, "segment_analysis_settings", segment_analysis_settings)
        if use_case_ids is not None:
            pulumi.set(__self__, "use_case_ids", use_case_ids)

    @property
    @pulumi.getter(name="associationIdSettings")
    def association_id_settings(self) -> Optional[pulumi.Input['DeploymentAssociationIdSettingsArgs']]:
        """
        Association ID settings for this Deployment.
        """
        return pulumi.get(self, "association_id_settings")

    @association_id_settings.setter
    def association_id_settings(self, value: Optional[pulumi.Input['DeploymentAssociationIdSettingsArgs']]):
        pulumi.set(self, "association_id_settings", value)

    @property
    @pulumi.getter(name="batchMonitoringSettings")
    def batch_monitoring_settings(self) -> Optional[pulumi.Input['DeploymentBatchMonitoringSettingsArgs']]:
        """
        The batch monitoring settings for the Deployment.
        """
        return pulumi.get(self, "batch_monitoring_settings")

    @batch_monitoring_settings.setter
    def batch_monitoring_settings(self, value: Optional[pulumi.Input['DeploymentBatchMonitoringSettingsArgs']]):
        pulumi.set(self, "batch_monitoring_settings", value)

    @property
    @pulumi.getter(name="biasAndFairnessSettings")
    def bias_and_fairness_settings(self) -> Optional[pulumi.Input['DeploymentBiasAndFairnessSettingsArgs']]:
        """
        Bias and fairness settings for the Deployment.
        """
        return pulumi.get(self, "bias_and_fairness_settings")

    @bias_and_fairness_settings.setter
    def bias_and_fairness_settings(self, value: Optional[pulumi.Input['DeploymentBiasAndFairnessSettingsArgs']]):
        pulumi.set(self, "bias_and_fairness_settings", value)

    @property
    @pulumi.getter(name="challengerModelsSettings")
    def challenger_models_settings(self) -> Optional[pulumi.Input['DeploymentChallengerModelsSettingsArgs']]:
        """
        The challenger models settings for the Deployment.
        """
        return pulumi.get(self, "challenger_models_settings")

    @challenger_models_settings.setter
    def challenger_models_settings(self, value: Optional[pulumi.Input['DeploymentChallengerModelsSettingsArgs']]):
        pulumi.set(self, "challenger_models_settings", value)

    @property
    @pulumi.getter(name="challengerReplaySettings")
    def challenger_replay_settings(self) -> Optional[pulumi.Input['DeploymentChallengerReplaySettingsArgs']]:
        """
        The challenger replay settings for the Deployment.
        """
        return pulumi.get(self, "challenger_replay_settings")

    @challenger_replay_settings.setter
    def challenger_replay_settings(self, value: Optional[pulumi.Input['DeploymentChallengerReplaySettingsArgs']]):
        pulumi.set(self, "challenger_replay_settings", value)

    @property
    @pulumi.getter(name="driftTrackingSettings")
    def drift_tracking_settings(self) -> Optional[pulumi.Input['DeploymentDriftTrackingSettingsArgs']]:
        """
        The drift tracking settings for the Deployment.
        """
        return pulumi.get(self, "drift_tracking_settings")

    @drift_tracking_settings.setter
    def drift_tracking_settings(self, value: Optional[pulumi.Input['DeploymentDriftTrackingSettingsArgs']]):
        pulumi.set(self, "drift_tracking_settings", value)

    @property
    @pulumi.getter(name="featureCacheSettings")
    def feature_cache_settings(self) -> Optional[pulumi.Input['DeploymentFeatureCacheSettingsArgs']]:
        """
        The feature cache settings for this Deployment.
        """
        return pulumi.get(self, "feature_cache_settings")

    @feature_cache_settings.setter
    def feature_cache_settings(self, value: Optional[pulumi.Input['DeploymentFeatureCacheSettingsArgs']]):
        pulumi.set(self, "feature_cache_settings", value)

    @property
    @pulumi.getter(name="healthSettings")
    def health_settings(self) -> Optional[pulumi.Input['DeploymentHealthSettingsArgs']]:
        """
        The health settings for this Deployment.
        """
        return pulumi.get(self, "health_settings")

    @health_settings.setter
    def health_settings(self, value: Optional[pulumi.Input['DeploymentHealthSettingsArgs']]):
        pulumi.set(self, "health_settings", value)

    @property
    @pulumi.getter
    def importance(self) -> Optional[pulumi.Input[str]]:
        """
        The importance of the Deployment.
        """
        return pulumi.get(self, "importance")

    @importance.setter
    def importance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "importance", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The label of the Deployment.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="predictionEnvironmentId")
    def prediction_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the predication environment for this Deployment.
        """
        return pulumi.get(self, "prediction_environment_id")

    @prediction_environment_id.setter
    def prediction_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prediction_environment_id", value)

    @property
    @pulumi.getter(name="predictionIntervalsSettings")
    def prediction_intervals_settings(self) -> Optional[pulumi.Input['DeploymentPredictionIntervalsSettingsArgs']]:
        """
        The prediction intervals settings for this Deployment.
        """
        return pulumi.get(self, "prediction_intervals_settings")

    @prediction_intervals_settings.setter
    def prediction_intervals_settings(self, value: Optional[pulumi.Input['DeploymentPredictionIntervalsSettingsArgs']]):
        pulumi.set(self, "prediction_intervals_settings", value)

    @property
    @pulumi.getter(name="predictionWarningSettings")
    def prediction_warning_settings(self) -> Optional[pulumi.Input['DeploymentPredictionWarningSettingsArgs']]:
        """
        The prediction warning settings for the Deployment.
        """
        return pulumi.get(self, "prediction_warning_settings")

    @prediction_warning_settings.setter
    def prediction_warning_settings(self, value: Optional[pulumi.Input['DeploymentPredictionWarningSettingsArgs']]):
        pulumi.set(self, "prediction_warning_settings", value)

    @property
    @pulumi.getter(name="predictionsByForecastDateSettings")
    def predictions_by_forecast_date_settings(self) -> Optional[pulumi.Input['DeploymentPredictionsByForecastDateSettingsArgs']]:
        """
        The predictions by forecase date settings for the Deployment.
        """
        return pulumi.get(self, "predictions_by_forecast_date_settings")

    @predictions_by_forecast_date_settings.setter
    def predictions_by_forecast_date_settings(self, value: Optional[pulumi.Input['DeploymentPredictionsByForecastDateSettingsArgs']]):
        pulumi.set(self, "predictions_by_forecast_date_settings", value)

    @property
    @pulumi.getter(name="predictionsDataCollectionSettings")
    def predictions_data_collection_settings(self) -> Optional[pulumi.Input['DeploymentPredictionsDataCollectionSettingsArgs']]:
        """
        The predictions data collection settings for the Deployment.
        """
        return pulumi.get(self, "predictions_data_collection_settings")

    @predictions_data_collection_settings.setter
    def predictions_data_collection_settings(self, value: Optional[pulumi.Input['DeploymentPredictionsDataCollectionSettingsArgs']]):
        pulumi.set(self, "predictions_data_collection_settings", value)

    @property
    @pulumi.getter(name="predictionsSettings")
    def predictions_settings(self) -> Optional[pulumi.Input['DeploymentPredictionsSettingsArgs']]:
        """
        Settings for the predictions.
        """
        return pulumi.get(self, "predictions_settings")

    @predictions_settings.setter
    def predictions_settings(self, value: Optional[pulumi.Input['DeploymentPredictionsSettingsArgs']]):
        pulumi.set(self, "predictions_settings", value)

    @property
    @pulumi.getter(name="registeredModelVersionId")
    def registered_model_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the registered model version for this Deployment.
        """
        return pulumi.get(self, "registered_model_version_id")

    @registered_model_version_id.setter
    def registered_model_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registered_model_version_id", value)

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentRuntimeParameterValueArgs']]]]:
        """
        The runtime parameter values for the Deployment.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @runtime_parameter_values.setter
    def runtime_parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentRuntimeParameterValueArgs']]]]):
        pulumi.set(self, "runtime_parameter_values", value)

    @property
    @pulumi.getter(name="segmentAnalysisSettings")
    def segment_analysis_settings(self) -> Optional[pulumi.Input['DeploymentSegmentAnalysisSettingsArgs']]:
        """
        The segment analysis settings for the Deployment.
        """
        return pulumi.get(self, "segment_analysis_settings")

    @segment_analysis_settings.setter
    def segment_analysis_settings(self, value: Optional[pulumi.Input['DeploymentSegmentAnalysisSettingsArgs']]):
        pulumi.set(self, "segment_analysis_settings", value)

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Use Case IDs to add the Deployment to.
        """
        return pulumi.get(self, "use_case_ids")

    @use_case_ids.setter
    def use_case_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "use_case_ids", value)


class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 association_id_settings: Optional[pulumi.Input[Union['DeploymentAssociationIdSettingsArgs', 'DeploymentAssociationIdSettingsArgsDict']]] = None,
                 batch_monitoring_settings: Optional[pulumi.Input[Union['DeploymentBatchMonitoringSettingsArgs', 'DeploymentBatchMonitoringSettingsArgsDict']]] = None,
                 bias_and_fairness_settings: Optional[pulumi.Input[Union['DeploymentBiasAndFairnessSettingsArgs', 'DeploymentBiasAndFairnessSettingsArgsDict']]] = None,
                 challenger_models_settings: Optional[pulumi.Input[Union['DeploymentChallengerModelsSettingsArgs', 'DeploymentChallengerModelsSettingsArgsDict']]] = None,
                 challenger_replay_settings: Optional[pulumi.Input[Union['DeploymentChallengerReplaySettingsArgs', 'DeploymentChallengerReplaySettingsArgsDict']]] = None,
                 drift_tracking_settings: Optional[pulumi.Input[Union['DeploymentDriftTrackingSettingsArgs', 'DeploymentDriftTrackingSettingsArgsDict']]] = None,
                 feature_cache_settings: Optional[pulumi.Input[Union['DeploymentFeatureCacheSettingsArgs', 'DeploymentFeatureCacheSettingsArgsDict']]] = None,
                 health_settings: Optional[pulumi.Input[Union['DeploymentHealthSettingsArgs', 'DeploymentHealthSettingsArgsDict']]] = None,
                 importance: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 prediction_environment_id: Optional[pulumi.Input[str]] = None,
                 prediction_intervals_settings: Optional[pulumi.Input[Union['DeploymentPredictionIntervalsSettingsArgs', 'DeploymentPredictionIntervalsSettingsArgsDict']]] = None,
                 prediction_warning_settings: Optional[pulumi.Input[Union['DeploymentPredictionWarningSettingsArgs', 'DeploymentPredictionWarningSettingsArgsDict']]] = None,
                 predictions_by_forecast_date_settings: Optional[pulumi.Input[Union['DeploymentPredictionsByForecastDateSettingsArgs', 'DeploymentPredictionsByForecastDateSettingsArgsDict']]] = None,
                 predictions_data_collection_settings: Optional[pulumi.Input[Union['DeploymentPredictionsDataCollectionSettingsArgs', 'DeploymentPredictionsDataCollectionSettingsArgsDict']]] = None,
                 predictions_settings: Optional[pulumi.Input[Union['DeploymentPredictionsSettingsArgs', 'DeploymentPredictionsSettingsArgsDict']]] = None,
                 registered_model_version_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentRuntimeParameterValueArgs', 'DeploymentRuntimeParameterValueArgsDict']]]]] = None,
                 segment_analysis_settings: Optional[pulumi.Input[Union['DeploymentSegmentAnalysisSettingsArgs', 'DeploymentSegmentAnalysisSettingsArgsDict']]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Deployment

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example_custom_model = datarobot.CustomModel("exampleCustomModel",
            description="Description for the example custom model",
            target_type="Binary",
            target_name="my_label",
            base_environment_id="65f9b27eab986d30d4c64268",
            files=["example.py"])
        example_registered_model = datarobot.RegisteredModel("exampleRegisteredModel",
            custom_model_version_id=example_custom_model.version_id,
            description="Description for the example registered model")
        example_prediction_environment = datarobot.PredictionEnvironment("examplePredictionEnvironment",
            description="Description for the example prediction environment",
            platform="datarobotServerless")
        example_deployment = datarobot.Deployment("exampleDeployment",
            label="An example deployment",
            prediction_environment_id=example_prediction_environment.id,
            registered_model_version_id=example_registered_model.version_id,
            challenger_models_settings={},
            challenger_replay_settings={},
            segment_analysis_settings={},
            bias_and_fairness_settings={},
            predictions_by_forecast_date_settings={},
            drift_tracking_settings={},
            association_id_settings={},
            predictions_data_collection_settings={},
            prediction_warning_settings={},
            prediction_intervals_settings={},
            predictions_settings={},
            feature_cache_settings={},
            health_settings={},
            runtime_parameter_values=[{
                "key": "EXAMPLE_PARAM",
                "type": "string",
                "value": "val",
            }])
        pulumi.export("datarobotDeploymentId", example_deployment.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DeploymentAssociationIdSettingsArgs', 'DeploymentAssociationIdSettingsArgsDict']] association_id_settings: Association ID settings for this Deployment.
        :param pulumi.Input[Union['DeploymentBatchMonitoringSettingsArgs', 'DeploymentBatchMonitoringSettingsArgsDict']] batch_monitoring_settings: The batch monitoring settings for the Deployment.
        :param pulumi.Input[Union['DeploymentBiasAndFairnessSettingsArgs', 'DeploymentBiasAndFairnessSettingsArgsDict']] bias_and_fairness_settings: Bias and fairness settings for the Deployment.
        :param pulumi.Input[Union['DeploymentChallengerModelsSettingsArgs', 'DeploymentChallengerModelsSettingsArgsDict']] challenger_models_settings: The challenger models settings for the Deployment.
        :param pulumi.Input[Union['DeploymentChallengerReplaySettingsArgs', 'DeploymentChallengerReplaySettingsArgsDict']] challenger_replay_settings: The challenger replay settings for the Deployment.
        :param pulumi.Input[Union['DeploymentDriftTrackingSettingsArgs', 'DeploymentDriftTrackingSettingsArgsDict']] drift_tracking_settings: The drift tracking settings for the Deployment.
        :param pulumi.Input[Union['DeploymentFeatureCacheSettingsArgs', 'DeploymentFeatureCacheSettingsArgsDict']] feature_cache_settings: The feature cache settings for this Deployment.
        :param pulumi.Input[Union['DeploymentHealthSettingsArgs', 'DeploymentHealthSettingsArgsDict']] health_settings: The health settings for this Deployment.
        :param pulumi.Input[str] importance: The importance of the Deployment.
        :param pulumi.Input[str] label: The label of the Deployment.
        :param pulumi.Input[str] prediction_environment_id: The ID of the predication environment for this Deployment.
        :param pulumi.Input[Union['DeploymentPredictionIntervalsSettingsArgs', 'DeploymentPredictionIntervalsSettingsArgsDict']] prediction_intervals_settings: The prediction intervals settings for this Deployment.
        :param pulumi.Input[Union['DeploymentPredictionWarningSettingsArgs', 'DeploymentPredictionWarningSettingsArgsDict']] prediction_warning_settings: The prediction warning settings for the Deployment.
        :param pulumi.Input[Union['DeploymentPredictionsByForecastDateSettingsArgs', 'DeploymentPredictionsByForecastDateSettingsArgsDict']] predictions_by_forecast_date_settings: The predictions by forecase date settings for the Deployment.
        :param pulumi.Input[Union['DeploymentPredictionsDataCollectionSettingsArgs', 'DeploymentPredictionsDataCollectionSettingsArgsDict']] predictions_data_collection_settings: The predictions data collection settings for the Deployment.
        :param pulumi.Input[Union['DeploymentPredictionsSettingsArgs', 'DeploymentPredictionsSettingsArgsDict']] predictions_settings: Settings for the predictions.
        :param pulumi.Input[str] registered_model_version_id: The ID of the registered model version for this Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentRuntimeParameterValueArgs', 'DeploymentRuntimeParameterValueArgsDict']]]] runtime_parameter_values: The runtime parameter values for the Deployment.
        :param pulumi.Input[Union['DeploymentSegmentAnalysisSettingsArgs', 'DeploymentSegmentAnalysisSettingsArgsDict']] segment_analysis_settings: The segment analysis settings for the Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Deployment to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Deployment

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example_custom_model = datarobot.CustomModel("exampleCustomModel",
            description="Description for the example custom model",
            target_type="Binary",
            target_name="my_label",
            base_environment_id="65f9b27eab986d30d4c64268",
            files=["example.py"])
        example_registered_model = datarobot.RegisteredModel("exampleRegisteredModel",
            custom_model_version_id=example_custom_model.version_id,
            description="Description for the example registered model")
        example_prediction_environment = datarobot.PredictionEnvironment("examplePredictionEnvironment",
            description="Description for the example prediction environment",
            platform="datarobotServerless")
        example_deployment = datarobot.Deployment("exampleDeployment",
            label="An example deployment",
            prediction_environment_id=example_prediction_environment.id,
            registered_model_version_id=example_registered_model.version_id,
            challenger_models_settings={},
            challenger_replay_settings={},
            segment_analysis_settings={},
            bias_and_fairness_settings={},
            predictions_by_forecast_date_settings={},
            drift_tracking_settings={},
            association_id_settings={},
            predictions_data_collection_settings={},
            prediction_warning_settings={},
            prediction_intervals_settings={},
            predictions_settings={},
            feature_cache_settings={},
            health_settings={},
            runtime_parameter_values=[{
                "key": "EXAMPLE_PARAM",
                "type": "string",
                "value": "val",
            }])
        pulumi.export("datarobotDeploymentId", example_deployment.id)
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 association_id_settings: Optional[pulumi.Input[Union['DeploymentAssociationIdSettingsArgs', 'DeploymentAssociationIdSettingsArgsDict']]] = None,
                 batch_monitoring_settings: Optional[pulumi.Input[Union['DeploymentBatchMonitoringSettingsArgs', 'DeploymentBatchMonitoringSettingsArgsDict']]] = None,
                 bias_and_fairness_settings: Optional[pulumi.Input[Union['DeploymentBiasAndFairnessSettingsArgs', 'DeploymentBiasAndFairnessSettingsArgsDict']]] = None,
                 challenger_models_settings: Optional[pulumi.Input[Union['DeploymentChallengerModelsSettingsArgs', 'DeploymentChallengerModelsSettingsArgsDict']]] = None,
                 challenger_replay_settings: Optional[pulumi.Input[Union['DeploymentChallengerReplaySettingsArgs', 'DeploymentChallengerReplaySettingsArgsDict']]] = None,
                 drift_tracking_settings: Optional[pulumi.Input[Union['DeploymentDriftTrackingSettingsArgs', 'DeploymentDriftTrackingSettingsArgsDict']]] = None,
                 feature_cache_settings: Optional[pulumi.Input[Union['DeploymentFeatureCacheSettingsArgs', 'DeploymentFeatureCacheSettingsArgsDict']]] = None,
                 health_settings: Optional[pulumi.Input[Union['DeploymentHealthSettingsArgs', 'DeploymentHealthSettingsArgsDict']]] = None,
                 importance: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 prediction_environment_id: Optional[pulumi.Input[str]] = None,
                 prediction_intervals_settings: Optional[pulumi.Input[Union['DeploymentPredictionIntervalsSettingsArgs', 'DeploymentPredictionIntervalsSettingsArgsDict']]] = None,
                 prediction_warning_settings: Optional[pulumi.Input[Union['DeploymentPredictionWarningSettingsArgs', 'DeploymentPredictionWarningSettingsArgsDict']]] = None,
                 predictions_by_forecast_date_settings: Optional[pulumi.Input[Union['DeploymentPredictionsByForecastDateSettingsArgs', 'DeploymentPredictionsByForecastDateSettingsArgsDict']]] = None,
                 predictions_data_collection_settings: Optional[pulumi.Input[Union['DeploymentPredictionsDataCollectionSettingsArgs', 'DeploymentPredictionsDataCollectionSettingsArgsDict']]] = None,
                 predictions_settings: Optional[pulumi.Input[Union['DeploymentPredictionsSettingsArgs', 'DeploymentPredictionsSettingsArgsDict']]] = None,
                 registered_model_version_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentRuntimeParameterValueArgs', 'DeploymentRuntimeParameterValueArgsDict']]]]] = None,
                 segment_analysis_settings: Optional[pulumi.Input[Union['DeploymentSegmentAnalysisSettingsArgs', 'DeploymentSegmentAnalysisSettingsArgsDict']]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            __props__.__dict__["association_id_settings"] = association_id_settings
            __props__.__dict__["batch_monitoring_settings"] = batch_monitoring_settings
            __props__.__dict__["bias_and_fairness_settings"] = bias_and_fairness_settings
            __props__.__dict__["challenger_models_settings"] = challenger_models_settings
            __props__.__dict__["challenger_replay_settings"] = challenger_replay_settings
            __props__.__dict__["drift_tracking_settings"] = drift_tracking_settings
            __props__.__dict__["feature_cache_settings"] = feature_cache_settings
            __props__.__dict__["health_settings"] = health_settings
            __props__.__dict__["importance"] = importance
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if prediction_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'prediction_environment_id'")
            __props__.__dict__["prediction_environment_id"] = prediction_environment_id
            __props__.__dict__["prediction_intervals_settings"] = prediction_intervals_settings
            __props__.__dict__["prediction_warning_settings"] = prediction_warning_settings
            __props__.__dict__["predictions_by_forecast_date_settings"] = predictions_by_forecast_date_settings
            __props__.__dict__["predictions_data_collection_settings"] = predictions_data_collection_settings
            __props__.__dict__["predictions_settings"] = predictions_settings
            if registered_model_version_id is None and not opts.urn:
                raise TypeError("Missing required property 'registered_model_version_id'")
            __props__.__dict__["registered_model_version_id"] = registered_model_version_id
            __props__.__dict__["runtime_parameter_values"] = runtime_parameter_values
            __props__.__dict__["segment_analysis_settings"] = segment_analysis_settings
            __props__.__dict__["use_case_ids"] = use_case_ids
        super(Deployment, __self__).__init__(
            'datarobot:index/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            association_id_settings: Optional[pulumi.Input[Union['DeploymentAssociationIdSettingsArgs', 'DeploymentAssociationIdSettingsArgsDict']]] = None,
            batch_monitoring_settings: Optional[pulumi.Input[Union['DeploymentBatchMonitoringSettingsArgs', 'DeploymentBatchMonitoringSettingsArgsDict']]] = None,
            bias_and_fairness_settings: Optional[pulumi.Input[Union['DeploymentBiasAndFairnessSettingsArgs', 'DeploymentBiasAndFairnessSettingsArgsDict']]] = None,
            challenger_models_settings: Optional[pulumi.Input[Union['DeploymentChallengerModelsSettingsArgs', 'DeploymentChallengerModelsSettingsArgsDict']]] = None,
            challenger_replay_settings: Optional[pulumi.Input[Union['DeploymentChallengerReplaySettingsArgs', 'DeploymentChallengerReplaySettingsArgsDict']]] = None,
            drift_tracking_settings: Optional[pulumi.Input[Union['DeploymentDriftTrackingSettingsArgs', 'DeploymentDriftTrackingSettingsArgsDict']]] = None,
            feature_cache_settings: Optional[pulumi.Input[Union['DeploymentFeatureCacheSettingsArgs', 'DeploymentFeatureCacheSettingsArgsDict']]] = None,
            health_settings: Optional[pulumi.Input[Union['DeploymentHealthSettingsArgs', 'DeploymentHealthSettingsArgsDict']]] = None,
            importance: Optional[pulumi.Input[str]] = None,
            label: Optional[pulumi.Input[str]] = None,
            prediction_environment_id: Optional[pulumi.Input[str]] = None,
            prediction_intervals_settings: Optional[pulumi.Input[Union['DeploymentPredictionIntervalsSettingsArgs', 'DeploymentPredictionIntervalsSettingsArgsDict']]] = None,
            prediction_warning_settings: Optional[pulumi.Input[Union['DeploymentPredictionWarningSettingsArgs', 'DeploymentPredictionWarningSettingsArgsDict']]] = None,
            predictions_by_forecast_date_settings: Optional[pulumi.Input[Union['DeploymentPredictionsByForecastDateSettingsArgs', 'DeploymentPredictionsByForecastDateSettingsArgsDict']]] = None,
            predictions_data_collection_settings: Optional[pulumi.Input[Union['DeploymentPredictionsDataCollectionSettingsArgs', 'DeploymentPredictionsDataCollectionSettingsArgsDict']]] = None,
            predictions_settings: Optional[pulumi.Input[Union['DeploymentPredictionsSettingsArgs', 'DeploymentPredictionsSettingsArgsDict']]] = None,
            registered_model_version_id: Optional[pulumi.Input[str]] = None,
            runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentRuntimeParameterValueArgs', 'DeploymentRuntimeParameterValueArgsDict']]]]] = None,
            segment_analysis_settings: Optional[pulumi.Input[Union['DeploymentSegmentAnalysisSettingsArgs', 'DeploymentSegmentAnalysisSettingsArgsDict']]] = None,
            use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DeploymentAssociationIdSettingsArgs', 'DeploymentAssociationIdSettingsArgsDict']] association_id_settings: Association ID settings for this Deployment.
        :param pulumi.Input[Union['DeploymentBatchMonitoringSettingsArgs', 'DeploymentBatchMonitoringSettingsArgsDict']] batch_monitoring_settings: The batch monitoring settings for the Deployment.
        :param pulumi.Input[Union['DeploymentBiasAndFairnessSettingsArgs', 'DeploymentBiasAndFairnessSettingsArgsDict']] bias_and_fairness_settings: Bias and fairness settings for the Deployment.
        :param pulumi.Input[Union['DeploymentChallengerModelsSettingsArgs', 'DeploymentChallengerModelsSettingsArgsDict']] challenger_models_settings: The challenger models settings for the Deployment.
        :param pulumi.Input[Union['DeploymentChallengerReplaySettingsArgs', 'DeploymentChallengerReplaySettingsArgsDict']] challenger_replay_settings: The challenger replay settings for the Deployment.
        :param pulumi.Input[Union['DeploymentDriftTrackingSettingsArgs', 'DeploymentDriftTrackingSettingsArgsDict']] drift_tracking_settings: The drift tracking settings for the Deployment.
        :param pulumi.Input[Union['DeploymentFeatureCacheSettingsArgs', 'DeploymentFeatureCacheSettingsArgsDict']] feature_cache_settings: The feature cache settings for this Deployment.
        :param pulumi.Input[Union['DeploymentHealthSettingsArgs', 'DeploymentHealthSettingsArgsDict']] health_settings: The health settings for this Deployment.
        :param pulumi.Input[str] importance: The importance of the Deployment.
        :param pulumi.Input[str] label: The label of the Deployment.
        :param pulumi.Input[str] prediction_environment_id: The ID of the predication environment for this Deployment.
        :param pulumi.Input[Union['DeploymentPredictionIntervalsSettingsArgs', 'DeploymentPredictionIntervalsSettingsArgsDict']] prediction_intervals_settings: The prediction intervals settings for this Deployment.
        :param pulumi.Input[Union['DeploymentPredictionWarningSettingsArgs', 'DeploymentPredictionWarningSettingsArgsDict']] prediction_warning_settings: The prediction warning settings for the Deployment.
        :param pulumi.Input[Union['DeploymentPredictionsByForecastDateSettingsArgs', 'DeploymentPredictionsByForecastDateSettingsArgsDict']] predictions_by_forecast_date_settings: The predictions by forecase date settings for the Deployment.
        :param pulumi.Input[Union['DeploymentPredictionsDataCollectionSettingsArgs', 'DeploymentPredictionsDataCollectionSettingsArgsDict']] predictions_data_collection_settings: The predictions data collection settings for the Deployment.
        :param pulumi.Input[Union['DeploymentPredictionsSettingsArgs', 'DeploymentPredictionsSettingsArgsDict']] predictions_settings: Settings for the predictions.
        :param pulumi.Input[str] registered_model_version_id: The ID of the registered model version for this Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentRuntimeParameterValueArgs', 'DeploymentRuntimeParameterValueArgsDict']]]] runtime_parameter_values: The runtime parameter values for the Deployment.
        :param pulumi.Input[Union['DeploymentSegmentAnalysisSettingsArgs', 'DeploymentSegmentAnalysisSettingsArgsDict']] segment_analysis_settings: The segment analysis settings for the Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Deployment to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["association_id_settings"] = association_id_settings
        __props__.__dict__["batch_monitoring_settings"] = batch_monitoring_settings
        __props__.__dict__["bias_and_fairness_settings"] = bias_and_fairness_settings
        __props__.__dict__["challenger_models_settings"] = challenger_models_settings
        __props__.__dict__["challenger_replay_settings"] = challenger_replay_settings
        __props__.__dict__["drift_tracking_settings"] = drift_tracking_settings
        __props__.__dict__["feature_cache_settings"] = feature_cache_settings
        __props__.__dict__["health_settings"] = health_settings
        __props__.__dict__["importance"] = importance
        __props__.__dict__["label"] = label
        __props__.__dict__["prediction_environment_id"] = prediction_environment_id
        __props__.__dict__["prediction_intervals_settings"] = prediction_intervals_settings
        __props__.__dict__["prediction_warning_settings"] = prediction_warning_settings
        __props__.__dict__["predictions_by_forecast_date_settings"] = predictions_by_forecast_date_settings
        __props__.__dict__["predictions_data_collection_settings"] = predictions_data_collection_settings
        __props__.__dict__["predictions_settings"] = predictions_settings
        __props__.__dict__["registered_model_version_id"] = registered_model_version_id
        __props__.__dict__["runtime_parameter_values"] = runtime_parameter_values
        __props__.__dict__["segment_analysis_settings"] = segment_analysis_settings
        __props__.__dict__["use_case_ids"] = use_case_ids
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associationIdSettings")
    def association_id_settings(self) -> pulumi.Output[Optional['outputs.DeploymentAssociationIdSettings']]:
        """
        Association ID settings for this Deployment.
        """
        return pulumi.get(self, "association_id_settings")

    @property
    @pulumi.getter(name="batchMonitoringSettings")
    def batch_monitoring_settings(self) -> pulumi.Output[Optional['outputs.DeploymentBatchMonitoringSettings']]:
        """
        The batch monitoring settings for the Deployment.
        """
        return pulumi.get(self, "batch_monitoring_settings")

    @property
    @pulumi.getter(name="biasAndFairnessSettings")
    def bias_and_fairness_settings(self) -> pulumi.Output[Optional['outputs.DeploymentBiasAndFairnessSettings']]:
        """
        Bias and fairness settings for the Deployment.
        """
        return pulumi.get(self, "bias_and_fairness_settings")

    @property
    @pulumi.getter(name="challengerModelsSettings")
    def challenger_models_settings(self) -> pulumi.Output[Optional['outputs.DeploymentChallengerModelsSettings']]:
        """
        The challenger models settings for the Deployment.
        """
        return pulumi.get(self, "challenger_models_settings")

    @property
    @pulumi.getter(name="challengerReplaySettings")
    def challenger_replay_settings(self) -> pulumi.Output[Optional['outputs.DeploymentChallengerReplaySettings']]:
        """
        The challenger replay settings for the Deployment.
        """
        return pulumi.get(self, "challenger_replay_settings")

    @property
    @pulumi.getter(name="driftTrackingSettings")
    def drift_tracking_settings(self) -> pulumi.Output[Optional['outputs.DeploymentDriftTrackingSettings']]:
        """
        The drift tracking settings for the Deployment.
        """
        return pulumi.get(self, "drift_tracking_settings")

    @property
    @pulumi.getter(name="featureCacheSettings")
    def feature_cache_settings(self) -> pulumi.Output[Optional['outputs.DeploymentFeatureCacheSettings']]:
        """
        The feature cache settings for this Deployment.
        """
        return pulumi.get(self, "feature_cache_settings")

    @property
    @pulumi.getter(name="healthSettings")
    def health_settings(self) -> pulumi.Output[Optional['outputs.DeploymentHealthSettings']]:
        """
        The health settings for this Deployment.
        """
        return pulumi.get(self, "health_settings")

    @property
    @pulumi.getter
    def importance(self) -> pulumi.Output[str]:
        """
        The importance of the Deployment.
        """
        return pulumi.get(self, "importance")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        The label of the Deployment.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="predictionEnvironmentId")
    def prediction_environment_id(self) -> pulumi.Output[str]:
        """
        The ID of the predication environment for this Deployment.
        """
        return pulumi.get(self, "prediction_environment_id")

    @property
    @pulumi.getter(name="predictionIntervalsSettings")
    def prediction_intervals_settings(self) -> pulumi.Output[Optional['outputs.DeploymentPredictionIntervalsSettings']]:
        """
        The prediction intervals settings for this Deployment.
        """
        return pulumi.get(self, "prediction_intervals_settings")

    @property
    @pulumi.getter(name="predictionWarningSettings")
    def prediction_warning_settings(self) -> pulumi.Output[Optional['outputs.DeploymentPredictionWarningSettings']]:
        """
        The prediction warning settings for the Deployment.
        """
        return pulumi.get(self, "prediction_warning_settings")

    @property
    @pulumi.getter(name="predictionsByForecastDateSettings")
    def predictions_by_forecast_date_settings(self) -> pulumi.Output[Optional['outputs.DeploymentPredictionsByForecastDateSettings']]:
        """
        The predictions by forecase date settings for the Deployment.
        """
        return pulumi.get(self, "predictions_by_forecast_date_settings")

    @property
    @pulumi.getter(name="predictionsDataCollectionSettings")
    def predictions_data_collection_settings(self) -> pulumi.Output[Optional['outputs.DeploymentPredictionsDataCollectionSettings']]:
        """
        The predictions data collection settings for the Deployment.
        """
        return pulumi.get(self, "predictions_data_collection_settings")

    @property
    @pulumi.getter(name="predictionsSettings")
    def predictions_settings(self) -> pulumi.Output[Optional['outputs.DeploymentPredictionsSettings']]:
        """
        Settings for the predictions.
        """
        return pulumi.get(self, "predictions_settings")

    @property
    @pulumi.getter(name="registeredModelVersionId")
    def registered_model_version_id(self) -> pulumi.Output[str]:
        """
        The ID of the registered model version for this Deployment.
        """
        return pulumi.get(self, "registered_model_version_id")

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentRuntimeParameterValue']]]:
        """
        The runtime parameter values for the Deployment.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @property
    @pulumi.getter(name="segmentAnalysisSettings")
    def segment_analysis_settings(self) -> pulumi.Output[Optional['outputs.DeploymentSegmentAnalysisSettings']]:
        """
        The segment analysis settings for the Deployment.
        """
        return pulumi.get(self, "segment_analysis_settings")

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of Use Case IDs to add the Deployment to.
        """
        return pulumi.get(self, "use_case_ids")

