# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatastoreArgs', 'Datastore']

@pulumi.input_type
class DatastoreArgs:
    def __init__(__self__, *,
                 canonical_name: pulumi.Input[str],
                 data_store_type: pulumi.Input[str],
                 connector_id: Optional[pulumi.Input[str]] = None,
                 driver_id: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 jdbc_url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Datastore resource.
        :param pulumi.Input[str] canonical_name: The user-friendly name of the data store.
        :param pulumi.Input[str] data_store_type: The type of data store.
        :param pulumi.Input[str] connector_id: The identifier of the Connector if data*store*type is DR*CONNECTOR*V1
        :param pulumi.Input[str] driver_id: The identifier of the DataDriver if data*store*type is JDBC or DR*DATABASE*V1
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] fields: If the type is dr-database-v1, then the fields specify the configuration.
        :param pulumi.Input[str] jdbc_url: The full JDBC URL (for example: jdbc:postgresql://my.dbaddress.org:5432/my_db).
        """
        pulumi.set(__self__, "canonical_name", canonical_name)
        pulumi.set(__self__, "data_store_type", data_store_type)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if driver_id is not None:
            pulumi.set(__self__, "driver_id", driver_id)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)

    @property
    @pulumi.getter(name="canonicalName")
    def canonical_name(self) -> pulumi.Input[str]:
        """
        The user-friendly name of the data store.
        """
        return pulumi.get(self, "canonical_name")

    @canonical_name.setter
    def canonical_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "canonical_name", value)

    @property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> pulumi.Input[str]:
        """
        The type of data store.
        """
        return pulumi.get(self, "data_store_type")

    @data_store_type.setter
    def data_store_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_store_type", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the Connector if data*store*type is DR*CONNECTOR*V1
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter(name="driverId")
    def driver_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the DataDriver if data*store*type is JDBC or DR*DATABASE*V1
        """
        return pulumi.get(self, "driver_id")

    @driver_id.setter
    def driver_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_id", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        If the type is dr-database-v1, then the fields specify the configuration.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[pulumi.Input[str]]:
        """
        The full JDBC URL (for example: jdbc:postgresql://my.dbaddress.org:5432/my_db).
        """
        return pulumi.get(self, "jdbc_url")

    @jdbc_url.setter
    def jdbc_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdbc_url", value)


@pulumi.input_type
class _DatastoreState:
    def __init__(__self__, *,
                 canonical_name: Optional[pulumi.Input[str]] = None,
                 connector_id: Optional[pulumi.Input[str]] = None,
                 data_store_type: Optional[pulumi.Input[str]] = None,
                 driver_id: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 jdbc_url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Datastore resources.
        :param pulumi.Input[str] canonical_name: The user-friendly name of the data store.
        :param pulumi.Input[str] connector_id: The identifier of the Connector if data*store*type is DR*CONNECTOR*V1
        :param pulumi.Input[str] data_store_type: The type of data store.
        :param pulumi.Input[str] driver_id: The identifier of the DataDriver if data*store*type is JDBC or DR*DATABASE*V1
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] fields: If the type is dr-database-v1, then the fields specify the configuration.
        :param pulumi.Input[str] jdbc_url: The full JDBC URL (for example: jdbc:postgresql://my.dbaddress.org:5432/my_db).
        """
        if canonical_name is not None:
            pulumi.set(__self__, "canonical_name", canonical_name)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if data_store_type is not None:
            pulumi.set(__self__, "data_store_type", data_store_type)
        if driver_id is not None:
            pulumi.set(__self__, "driver_id", driver_id)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)

    @property
    @pulumi.getter(name="canonicalName")
    def canonical_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name of the data store.
        """
        return pulumi.get(self, "canonical_name")

    @canonical_name.setter
    def canonical_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "canonical_name", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the Connector if data*store*type is DR*CONNECTOR*V1
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of data store.
        """
        return pulumi.get(self, "data_store_type")

    @data_store_type.setter
    def data_store_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_store_type", value)

    @property
    @pulumi.getter(name="driverId")
    def driver_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the DataDriver if data*store*type is JDBC or DR*DATABASE*V1
        """
        return pulumi.get(self, "driver_id")

    @driver_id.setter
    def driver_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_id", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        If the type is dr-database-v1, then the fields specify the configuration.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[pulumi.Input[str]]:
        """
        The full JDBC URL (for example: jdbc:postgresql://my.dbaddress.org:5432/my_db).
        """
        return pulumi.get(self, "jdbc_url")

    @jdbc_url.setter
    def jdbc_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdbc_url", value)


class Datastore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 canonical_name: Optional[pulumi.Input[str]] = None,
                 connector_id: Optional[pulumi.Input[str]] = None,
                 data_store_type: Optional[pulumi.Input[str]] = None,
                 driver_id: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 jdbc_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Data store

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example_connector = datarobot.Datastore("exampleConnector",
            canonical_name="Example Connector Datastore",
            data_store_type="dr-connector-v1",
            connector_id="65538041dde6a1d664d0b2ec",
            fields=[{
                "id": "fs.defaultFS",
                "name": "Bucket Name",
                "value": "my-bucket",
            }])
        example_jdbc = datarobot.Datastore("exampleJdbc",
            canonical_name="Example JDBC Datastore",
            data_store_type="jdbc",
            driver_id="5b4752844bf542000175dbea",
            fields=[
                {
                    "name": "address",
                    "value": "my-address",
                },
                {
                    "name": "database",
                    "value": "my-database",
                },
            ])
        example_database = datarobot.Datastore("exampleDatabase",
            canonical_name="Example Database Datastore",
            data_store_type="dr-database-v1",
            driver_id="64a288a50636598d75df7f82",
            fields=[{
                "id": "bq.project_id",
                "name": "Project Id",
                "value": "project-id",
            }])
        pulumi.export("exampleConnectorId", example_connector.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] canonical_name: The user-friendly name of the data store.
        :param pulumi.Input[str] connector_id: The identifier of the Connector if data*store*type is DR*CONNECTOR*V1
        :param pulumi.Input[str] data_store_type: The type of data store.
        :param pulumi.Input[str] driver_id: The identifier of the DataDriver if data*store*type is JDBC or DR*DATABASE*V1
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] fields: If the type is dr-database-v1, then the fields specify the configuration.
        :param pulumi.Input[str] jdbc_url: The full JDBC URL (for example: jdbc:postgresql://my.dbaddress.org:5432/my_db).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatastoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Data store

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example_connector = datarobot.Datastore("exampleConnector",
            canonical_name="Example Connector Datastore",
            data_store_type="dr-connector-v1",
            connector_id="65538041dde6a1d664d0b2ec",
            fields=[{
                "id": "fs.defaultFS",
                "name": "Bucket Name",
                "value": "my-bucket",
            }])
        example_jdbc = datarobot.Datastore("exampleJdbc",
            canonical_name="Example JDBC Datastore",
            data_store_type="jdbc",
            driver_id="5b4752844bf542000175dbea",
            fields=[
                {
                    "name": "address",
                    "value": "my-address",
                },
                {
                    "name": "database",
                    "value": "my-database",
                },
            ])
        example_database = datarobot.Datastore("exampleDatabase",
            canonical_name="Example Database Datastore",
            data_store_type="dr-database-v1",
            driver_id="64a288a50636598d75df7f82",
            fields=[{
                "id": "bq.project_id",
                "name": "Project Id",
                "value": "project-id",
            }])
        pulumi.export("exampleConnectorId", example_connector.id)
        ```

        :param str resource_name: The name of the resource.
        :param DatastoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatastoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 canonical_name: Optional[pulumi.Input[str]] = None,
                 connector_id: Optional[pulumi.Input[str]] = None,
                 data_store_type: Optional[pulumi.Input[str]] = None,
                 driver_id: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 jdbc_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatastoreArgs.__new__(DatastoreArgs)

            if canonical_name is None and not opts.urn:
                raise TypeError("Missing required property 'canonical_name'")
            __props__.__dict__["canonical_name"] = canonical_name
            __props__.__dict__["connector_id"] = connector_id
            if data_store_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_store_type'")
            __props__.__dict__["data_store_type"] = data_store_type
            __props__.__dict__["driver_id"] = driver_id
            __props__.__dict__["fields"] = fields
            __props__.__dict__["jdbc_url"] = jdbc_url
        super(Datastore, __self__).__init__(
            'datarobot:index/datastore:Datastore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            canonical_name: Optional[pulumi.Input[str]] = None,
            connector_id: Optional[pulumi.Input[str]] = None,
            data_store_type: Optional[pulumi.Input[str]] = None,
            driver_id: Optional[pulumi.Input[str]] = None,
            fields: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
            jdbc_url: Optional[pulumi.Input[str]] = None) -> 'Datastore':
        """
        Get an existing Datastore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] canonical_name: The user-friendly name of the data store.
        :param pulumi.Input[str] connector_id: The identifier of the Connector if data*store*type is DR*CONNECTOR*V1
        :param pulumi.Input[str] data_store_type: The type of data store.
        :param pulumi.Input[str] driver_id: The identifier of the DataDriver if data*store*type is JDBC or DR*DATABASE*V1
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] fields: If the type is dr-database-v1, then the fields specify the configuration.
        :param pulumi.Input[str] jdbc_url: The full JDBC URL (for example: jdbc:postgresql://my.dbaddress.org:5432/my_db).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatastoreState.__new__(_DatastoreState)

        __props__.__dict__["canonical_name"] = canonical_name
        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["data_store_type"] = data_store_type
        __props__.__dict__["driver_id"] = driver_id
        __props__.__dict__["fields"] = fields
        __props__.__dict__["jdbc_url"] = jdbc_url
        return Datastore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="canonicalName")
    def canonical_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name of the data store.
        """
        return pulumi.get(self, "canonical_name")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of the Connector if data*store*type is DR*CONNECTOR*V1
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> pulumi.Output[str]:
        """
        The type of data store.
        """
        return pulumi.get(self, "data_store_type")

    @property
    @pulumi.getter(name="driverId")
    def driver_id(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of the DataDriver if data*store*type is JDBC or DR*DATABASE*V1
        """
        return pulumi.get(self, "driver_id")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Optional[Sequence[Mapping[str, str]]]]:
        """
        If the type is dr-database-v1, then the fields specify the configuration.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> pulumi.Output[Optional[str]]:
        """
        The full JDBC URL (for example: jdbc:postgresql://my.dbaddress.org:5432/my_db).
        """
        return pulumi.get(self, "jdbc_url")

