# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CustomModelLlmValidationArgs', 'CustomModelLlmValidation']

@pulumi.input_type
class CustomModelLlmValidationArgs:
    def __init__(__self__, *,
                 deployment_id: pulumi.Input[str],
                 prompt_column_name: pulumi.Input[str],
                 target_column_name: pulumi.Input[str],
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prediction_timeout: Optional[pulumi.Input[int]] = None,
                 use_case_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomModelLlmValidation resource.
        :param pulumi.Input[str] deployment_id: The ID of the custom model deployment.
        :param pulumi.Input[str] prompt_column_name: The name of the column the custom model uses for prompt text input.
        :param pulumi.Input[str] target_column_name: The name of the column the custom model uses for prediction output.
        :param pulumi.Input[str] model_id: The ID of the model used in the deployment.
        :param pulumi.Input[str] name: The name to use for the validated custom model.
        :param pulumi.Input[int] prediction_timeout: The timeout in seconds for the prediction when validating a custom model. Defaults to 300.
        :param pulumi.Input[str] use_case_id: The ID of the use case to associate with the validated custom model.
        """
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "prompt_column_name", prompt_column_name)
        pulumi.set(__self__, "target_column_name", target_column_name)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prediction_timeout is not None:
            pulumi.set(__self__, "prediction_timeout", prediction_timeout)
        if use_case_id is not None:
            pulumi.set(__self__, "use_case_id", use_case_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        """
        The ID of the custom model deployment.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="promptColumnName")
    def prompt_column_name(self) -> pulumi.Input[str]:
        """
        The name of the column the custom model uses for prompt text input.
        """
        return pulumi.get(self, "prompt_column_name")

    @prompt_column_name.setter
    def prompt_column_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "prompt_column_name", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> pulumi.Input[str]:
        """
        The name of the column the custom model uses for prediction output.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the model used in the deployment.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to use for the validated custom model.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="predictionTimeout")
    def prediction_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout in seconds for the prediction when validating a custom model. Defaults to 300.
        """
        return pulumi.get(self, "prediction_timeout")

    @prediction_timeout.setter
    def prediction_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prediction_timeout", value)

    @property
    @pulumi.getter(name="useCaseId")
    def use_case_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the use case to associate with the validated custom model.
        """
        return pulumi.get(self, "use_case_id")

    @use_case_id.setter
    def use_case_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_case_id", value)


@pulumi.input_type
class _CustomModelLlmValidationState:
    def __init__(__self__, *,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prediction_timeout: Optional[pulumi.Input[int]] = None,
                 prompt_column_name: Optional[pulumi.Input[str]] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 use_case_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomModelLlmValidation resources.
        :param pulumi.Input[str] deployment_id: The ID of the custom model deployment.
        :param pulumi.Input[str] model_id: The ID of the model used in the deployment.
        :param pulumi.Input[str] name: The name to use for the validated custom model.
        :param pulumi.Input[int] prediction_timeout: The timeout in seconds for the prediction when validating a custom model. Defaults to 300.
        :param pulumi.Input[str] prompt_column_name: The name of the column the custom model uses for prompt text input.
        :param pulumi.Input[str] target_column_name: The name of the column the custom model uses for prediction output.
        :param pulumi.Input[str] use_case_id: The ID of the use case to associate with the validated custom model.
        """
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prediction_timeout is not None:
            pulumi.set(__self__, "prediction_timeout", prediction_timeout)
        if prompt_column_name is not None:
            pulumi.set(__self__, "prompt_column_name", prompt_column_name)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if use_case_id is not None:
            pulumi.set(__self__, "use_case_id", use_case_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the custom model deployment.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the model used in the deployment.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to use for the validated custom model.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="predictionTimeout")
    def prediction_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout in seconds for the prediction when validating a custom model. Defaults to 300.
        """
        return pulumi.get(self, "prediction_timeout")

    @prediction_timeout.setter
    def prediction_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prediction_timeout", value)

    @property
    @pulumi.getter(name="promptColumnName")
    def prompt_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the column the custom model uses for prompt text input.
        """
        return pulumi.get(self, "prompt_column_name")

    @prompt_column_name.setter
    def prompt_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prompt_column_name", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the column the custom model uses for prediction output.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="useCaseId")
    def use_case_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the use case to associate with the validated custom model.
        """
        return pulumi.get(self, "use_case_id")

    @use_case_id.setter
    def use_case_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_case_id", value)


class CustomModelLlmValidation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prediction_timeout: Optional[pulumi.Input[int]] = None,
                 prompt_column_name: Optional[pulumi.Input[str]] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 use_case_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Custom Model LLM Validation

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example = datarobot.CustomModelLlmValidation("example",
            deployment_id=datarobot_deployment["example"]["id"],
            prompt_column_name="promptText",
            target_column_name="resultText",
            prediction_timeout=100,
            use_case_id=datarobot["use_case"]["example"]["id"])
        pulumi.export("exampleId", example.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deployment_id: The ID of the custom model deployment.
        :param pulumi.Input[str] model_id: The ID of the model used in the deployment.
        :param pulumi.Input[str] name: The name to use for the validated custom model.
        :param pulumi.Input[int] prediction_timeout: The timeout in seconds for the prediction when validating a custom model. Defaults to 300.
        :param pulumi.Input[str] prompt_column_name: The name of the column the custom model uses for prompt text input.
        :param pulumi.Input[str] target_column_name: The name of the column the custom model uses for prediction output.
        :param pulumi.Input[str] use_case_id: The ID of the use case to associate with the validated custom model.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomModelLlmValidationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Custom Model LLM Validation

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example = datarobot.CustomModelLlmValidation("example",
            deployment_id=datarobot_deployment["example"]["id"],
            prompt_column_name="promptText",
            target_column_name="resultText",
            prediction_timeout=100,
            use_case_id=datarobot["use_case"]["example"]["id"])
        pulumi.export("exampleId", example.id)
        ```

        :param str resource_name: The name of the resource.
        :param CustomModelLlmValidationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomModelLlmValidationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prediction_timeout: Optional[pulumi.Input[int]] = None,
                 prompt_column_name: Optional[pulumi.Input[str]] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 use_case_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomModelLlmValidationArgs.__new__(CustomModelLlmValidationArgs)

            if deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_id'")
            __props__.__dict__["deployment_id"] = deployment_id
            __props__.__dict__["model_id"] = model_id
            __props__.__dict__["name"] = name
            __props__.__dict__["prediction_timeout"] = prediction_timeout
            if prompt_column_name is None and not opts.urn:
                raise TypeError("Missing required property 'prompt_column_name'")
            __props__.__dict__["prompt_column_name"] = prompt_column_name
            if target_column_name is None and not opts.urn:
                raise TypeError("Missing required property 'target_column_name'")
            __props__.__dict__["target_column_name"] = target_column_name
            __props__.__dict__["use_case_id"] = use_case_id
        super(CustomModelLlmValidation, __self__).__init__(
            'datarobot:index/customModelLlmValidation:CustomModelLlmValidation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            model_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            prediction_timeout: Optional[pulumi.Input[int]] = None,
            prompt_column_name: Optional[pulumi.Input[str]] = None,
            target_column_name: Optional[pulumi.Input[str]] = None,
            use_case_id: Optional[pulumi.Input[str]] = None) -> 'CustomModelLlmValidation':
        """
        Get an existing CustomModelLlmValidation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deployment_id: The ID of the custom model deployment.
        :param pulumi.Input[str] model_id: The ID of the model used in the deployment.
        :param pulumi.Input[str] name: The name to use for the validated custom model.
        :param pulumi.Input[int] prediction_timeout: The timeout in seconds for the prediction when validating a custom model. Defaults to 300.
        :param pulumi.Input[str] prompt_column_name: The name of the column the custom model uses for prompt text input.
        :param pulumi.Input[str] target_column_name: The name of the column the custom model uses for prediction output.
        :param pulumi.Input[str] use_case_id: The ID of the use case to associate with the validated custom model.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomModelLlmValidationState.__new__(_CustomModelLlmValidationState)

        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["model_id"] = model_id
        __props__.__dict__["name"] = name
        __props__.__dict__["prediction_timeout"] = prediction_timeout
        __props__.__dict__["prompt_column_name"] = prompt_column_name
        __props__.__dict__["target_column_name"] = target_column_name
        __props__.__dict__["use_case_id"] = use_case_id
        return CustomModelLlmValidation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        The ID of the custom model deployment.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[str]:
        """
        The ID of the model used in the deployment.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name to use for the validated custom model.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="predictionTimeout")
    def prediction_timeout(self) -> pulumi.Output[int]:
        """
        The timeout in seconds for the prediction when validating a custom model. Defaults to 300.
        """
        return pulumi.get(self, "prediction_timeout")

    @property
    @pulumi.getter(name="promptColumnName")
    def prompt_column_name(self) -> pulumi.Output[str]:
        """
        The name of the column the custom model uses for prompt text input.
        """
        return pulumi.get(self, "prompt_column_name")

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> pulumi.Output[str]:
        """
        The name of the column the custom model uses for prediction output.
        """
        return pulumi.get(self, "target_column_name")

    @property
    @pulumi.getter(name="useCaseId")
    def use_case_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the use case to associate with the validated custom model.
        """
        return pulumi.get(self, "use_case_id")

